/* You may find the license in the LICENSE file */

function DTA_regToRegExp(str) {
	var mod = '';
	str = str.replace(/^\s+|\s+$/g, '');

	var m = str.match(/^\w?\/(.*)\/(i?)/);
	if (m) {
		mod = m[2];
		str = m[1];
	}
	return new RegExp(str, mod);
}

function DTA_strToRegExp(str) {
	return new RegExp(
		str
			.replace(/^\s+|\s+$/g, '')
			.replace(/([/{}()\[\]\\^$.])/g, "\\$1")
			.replace(/\*/g, ".*")
			.replace(/\?/g, '.')
	);
}