/* You may find the license in the LICENSE file */
 var FileHandling = {
 	get _uniqueList() {
 		let u = {};
 		for (d in Tree.selected) {
 			if (d.is(COMPLETE)) {
 				let f = d.destinationFile;
 				if (SYSTEMSLASH == "\\") {
 					f = f.toLowerCase();	
 				}
 				if (!(f in u)) {
 					u[f] = null;
 					yield d;
 				}
 			}
 		}
 	},
	openFolder: function() {
		for (d in this._uniqueList) {
			try {
				OpenExternal.reveal(d.destinationFile);
			} catch (ex) {
				Debug.dump('reveal', ex);
			}
		}
	},
	openFile: function() {
		var cur = Tree.current;
		if (cur && cur.is(COMPLETE)) {
			try {
				OpenExternal.launch(cur.destinationFile);
			}
			catch (ex) {
				Debug.dump('launch', ex);
			}
		}
	},
	deleteFile: function() {
		var list = [];
		
		for (d in this._uniqueList) {
			var file = new FileFactory(d.destinationFile);
			if (file.exists()) {
				list.push(d);
			}
		}
		var msg = '';
		if (list.length < 25) {
			msg = _('deletetexts');
			list.forEach(
				function(d) {
					msg += "\n" + (new FileFactory(d.destinationFile)).leafName;
				}
			);				
		}
		else {
			msg = _('deletetextl', [list.length]);
		}
		if (list.length && DTA_confirm(_('deletetitle'), msg, _('delete'), DTA_confirm.CANCEL, null, 1)) {
			return;
		}
		list.forEach(
			function(d) {
				try {
					var file = new FileFactory(d.destinationFile);
					if (file.exists()) {
						file.remove(false);
					}
				}
				catch (ex) {
					// no-op
				}
			}
		);
		Tree.remove();
	}
};