/* You may find the license in the LICENSE file */


var Dialog = {
	get isFullyDisabled() {
		return $('directory', 'renaming', 'hash').every(
			function(e) {
				return e.hasAttribute('disabled');
			}
		);
	},
	load: function DTA_load() {
		try {
			// d is an Array of Downloads
			var downloads = window.arguments[0];
			if (downloads.length == 1) {
				var d = downloads[0];
				$("infoIcon").src = d.largeIcon;
				$("infoURL").value = d.urlManager.url;
				$("infoDest").value = d.destinationFile;
				document.title = d.destinationName;
			
				if (d.referrer) {
					$('sourcePage')._value = $("sourcePage").value = d.referrer.spec;
				}
				if (!d.is(FINISHING, COMPLETE)) {
					$('sourcePage').removeAttribute('readonly');
				}
				
				$('renaming').value = d.mask;
				$('directory').value = d.pathName;
				$('hash').value = d.hash;
				this.item = d;
				Tooltip.start(d);
			}
			else {
				// more than just one download
				$('infoDest').value = document.title;
				$('infoURL', 'infoSize', 'sourcePage').forEach(
					function(e) {
						e.value = "---";
					}
				);
				$("hash").setAttribute('readonly', 'true');
				$("hash").setAttribute('disabled', 'true');
	
				var mask = downloads[0].mask;
				$('renaming').value = 
					downloads.every(function(e, i, a) { return e.mask == mask; })
					? mask
					: '';
	
				var dir = String(downloads[0].pathName);
				$('directory').value = 
					downloads.every(function(e) { return e.pathName == dir; })
					? dir
					: '';
				$('canvasGrid').hidden = true;
			}				
			if (downloads.every(function(d) { return d.is(COMPLETE, FINISHING); })) {
				$('directory', 'renaming', 'mask', 'browsedir').forEach(
					function(e) {
						e.setAttribute('readonly', 'true');
						e.setAttribute('disabled', 'true');
					}
				);
			}
			if (this.isFullyDisabled) {
				$('dTaDownloadInfo').buttons = 'accept';
			}			
		} catch(ex) {
			Debug.dump('load', ex);
		}
		window.setTimeout('window.sizeToContent()', 0);
	},
	accept: function DTA_accept() {
		if (this.isFullyDisabled) {
			return true;
		}		
		if (!this.check()) {
			return false;
		}
		
		var t = window.arguments[0];
		var win = window.arguments[1];

		var directory = $('directory').value.trim();
		directory = directory.length ? directory.addFinalSlash() : null;
		
		var mask = $('renaming').value;
		mask = mask.length ? mask : null;
		
		var sp = $('sourcePage');
		var newRef = null;
		if (!sp.hasAttribute('readonly') && sp._value != sp.value) {
			newRef = sp.value;
		}
		
		if (t.length == 1) {
			var d = t[0];
			if ($('hash').isValid) {
				var h = $('hash').value;
				if (!h || !d.hash || h.sum != d.hash.sum) {
					d.hash = h;
					if (h && d.is(COMPLETE)) {
						// have to manually start this guy ;)
						d.verifyHash();
					}
				}
			}
		}
				
		t.forEach(
			function(d) {
				if (d.is(COMPLETE, FINISHING)) {
					return;
				}
				if (directory) {
					d.pathName = directory;
				}
				if (mask) {
					d.mask = mask;
				}
				if (newRef) {
					try {
						d.referrer.spec = newRef;
					}
					catch (ex) {
						Debug.dump("failed to set referrer to", newRef);
					}
				}
				d.save();
			}
		);
		
		Tooltip.stop();
		return true;
	},
	browseDir: function DTA_browseDir() {
		// let's check and create the directory
		var newDir = Utils.askForDir(
			$('directory').value,
			_("validdestination")
		);
		if (newDir) {
			$('directory').value = newDir;
		}
	},
	check: function DTA_check() {
		var dir = $('directory').value.trim();
		if (!dir.length || !$('renaming').value.trim().length) {
			return false;
		}
		if (!Utils.validateDir(dir)) {
			alert(_("alertfolder"));
			var newDir = Utils.askForDir(null, _("validdestination"));
			$('directory').value = newDir ? newDir : '';
			return false;
		}
		if (!$('hash').isValid) {
			alert(_('alertinfo'));
			return false;
		}
		return true;
	}
};
