/* You may find the license in the LICENSE file */
 
function NSResolver(prefix) {
  if(prefix == 'html') {
    return 'http://www.w3.org/1999/xhtml';
  }
 	return 'http://www.metalinker.org/';
}
 
 var Metalinker = {
 	_getNodes: function ML__getNodes(elem, query) {
		var rv = [];
		var nodeSet = elem.ownerDocument.evaluate(
			query,
			elem,
			function() { return 'http://www.metalinker.org/'; },
			XPathResult.ORDERED_NODE_SNAPSHOT_TYPE,
			null
		);
		for (var j = 0; j < nodeSet.snapshotLength; ++j) {
			rv.push(nodeSet.snapshotItem(j));
		}
		return rv;
	},
	_getNode: function ML_getNode(elem, query) {
		var r = this._getNodes(elem, query);
		if (r.length) {
			return r.shift();
		}
		return null;
	},
 	_getSingle: function ML__getSingle(elem, query) {
 		var rv = this._getNode(elem, 'ml:' + query);
 		return rv ? rv.textContent.trim() : '';
 	},
 	_getLinkRes: function(elem, query) {
 		var rv = this._getNode(elem, 'ml:' + query);
 		if (rv) {
 			var n = this._getSingle(rv, "name"), l = this._checkURL(this._getSingle(rv, "url"));
 			if (n && l) {
 				return [n, l];
 			}
 		}
 		return null;
 	},
 	_checkURL: function ML__checkURL(url, allowed) {
 		try {
			url = url.toURI();
			if (url.scheme == 'file') {
				throw new Components.Exception("file protocol invalid");
			}
			// check for some popular bad links :p
			if (['http', 'https', 'ftp'].indexOf(url.scheme) != -1 && url.host.indexOf('.') == -1) {
				throw new Components.Exception("bad link!");
			}
			if (allowed instanceof Array && allowed.indexOf(url.scheme) == -1) {
				throw new Components.Exception("not allowed");
			}
			return url.spec;
 		}
 		catch (ex) {
 			// no-op
 		}
		return null; 		
 	},
 	get locale() {
 		return Preferences.get('general.useragent.locale', 'en-US');
 	},
 	handleDownload: function ML_handleDownload(download) {
 		try {
 			download.state = CANCELED;
			Tree.remove(download);
			var file = new FileFactory(download.destinationFile);

			var fiStream = new FileInputStream(file, 1, 0, false);
			var domParser = new DOMParser();
			var doc = domParser.parseFromStream(fiStream, null, file.fileSize, "application/xml");
			var root = doc.documentElement;
			fiStream.close();
			
			try {
				file.remove(false);
			} catch (ex) {
				Debug.dump("failed to remove metalink file!", ex);
			}
			
			
			if (root.nodeName != 'metalink' || root.getAttribute('version') != '3.0') {
				throw new Error(_('mlinvalid'));
			}
			var locale = this.locale.split('-').map(function(l) { return l.slice(0, 2).toLowerCase(); }).reverse();
			var downloads = [];
			var files = root.getElementsByTagName('file');
			for (var i = 0; i < files.length; ++i) {
				var file = files[i];
				var urls = [];
				var urlNodes = this._getNodes(file, 'ml:resources/ml:url');
				for (var j = 0; j < urlNodes.length; ++j) {
					var url = urlNodes[j];
					var type = url.getAttribute('type');
					var preference = 1;
					if (url.hasAttribute('preference')) {
						var a = new Number(url.getAttribute('preference'));
						if (isFinite(a) && a > 0 && a < 101) {
							preference = a;
						}
					}
					if (url.hasAttribute('location')) {
						var a = url.getAttribute('location').slice(0,2).toLowerCase();
						if (locale.indexOf(a) != -1) {
							preference = 100 + preference;
						}
					}
					if (['http', 'https'].indexOf(type) != -1) {
						url = this._checkURL(url.textContent.trim())
						if (url) {
							urls.push(new DTA_URL(url, doc.characterSet, null, preference));
						}
					}
				}
				if (!urls.length) {
					continue;
				}
				var hash = null; 
				var hashes = this._getNodes(file, 'ml:verification/ml:hash');
				for (var j = 0; j < hashes.length; ++j) {
					var h = hashes[j].textContent.trim();
					try {
						h = new DTA_Hash(h, hashes[j].getAttribute('type'));
						hash = h;
						Debug.dump(h, "ok");						
					}
					catch (ex) {
						Debug.dump(h, ex);
						// ignore
					}
				}
				var desc = this._getSingle(file, 'description');
				if (!desc) {
					desc = this._getSingle(root, 'description');
				}
				var size = this._getSingle(file, 'size');
				size = parseInt(size);
				if (isFinite(size)) {
					size = Utils.formatBytes(size);
				}
				else {
					size = '';
				}
				downloads.push({
					'url': new UrlManager(urls),
					'referrer': download.referrer ? download.referrer.spec : null,
					'numIstance': 0,
					'mask': download.mask,
					'dirSave': download.pathName,
					'description': desc,
					'ultDescription': '',
					'hash': hash,
					'license': this._getLinkRes(file, "license"),
					'publisher': this._getLinkRes(file, "publisher"),
					'identity': this._getSingle(file, 'identity'),
					'copyright': this._getSingle(file, 'copyright'),
					'size': size,
					'version': this._getSingle(file, 'version'),
					'logo': this._checkURL(this._getSingle(file, 'logo')),
					'lang': this._getSingle(file, 'language'),
					'sys': this._getSingle(file, 'os'),
					'mirrors': urls.length, 
					'selected': true
				});
			}
			if (!downloads.length) {
				throw new Error(_('mlnodownloads'));
			}
			if (downloads.length) {
				var info = {
					'identity': this._getSingle(root, 'identity'),
					'description': this._getSingle(root, 'description'),
					'logo': this._checkURL(this._getSingle(root, 'logo')),
					'license': this._getLinkRes(root, "license"),
					'publisher': this._getLinkRes(root, "publisher")
				};
				window.openDialog(
					'chrome://dta/content/dta/manager/metaselect.xul',
					'_blank',
					'chrome,centerscreen,dialog=yes,modal',
					downloads,
					info
				);
				downloads = downloads.filter(function(d) { return d.selected; });
			}
			if (downloads.length) {
				startDownloads(true, downloads);
			}
		}
		catch (ex) {
			if (!(ex instanceof Error)) {
				ex = new Error(_('mlerror', [ex.error]));
			}
			if (ex instanceof Error) {
				AlertService.show(_('mlerrortitle'), ex.message, false);
			}
			Debug.dump("Metalinker::handleDownload", ex);
		}
 	},
 	_insertDownload: function(d) {
 		if (d.lang && d.lang.search(/^\w{2}(?:-\w{2})?$/) != -1) {
 			var locale = this.locale;
 			d.selected = locale.slice(0,2) == d.lang.slice(0,2);
 		}
 		var e = document.createElement('richlistitem');
 		e.setAttribute("class", "item");
 		e.download = d;
 		$('downloads').appendChild(e); 		
 	},
 	load: function ML_load() {
 		try {
 			var downloads = window.arguments[0];
 			if (downloads.length) {
 				downloads.forEach(this._insertDownload, this);
 			}
 		}
 		catch(ex) {
 			// no-op
 		}
 		var info = {
 			'identity': _('mlidentity'),
 			'description': _('mldescription'),
 			'logo': 'chrome://dta/skin/icons/metalink_big.png',
 			'publisher': null,
 			'license': null
 		}
 		try {
 			var oi = window.arguments[1];
 			for (x in info) {
 				if (x in oi && oi[x]) {
 					info[x] = oi[x];
 				}
 			}
 		}
 		catch (ex) {
 			// no-op
 		}
 		$('identity').value = info.identity;
 		$('desc').appendChild(document.createTextNode(info.description));
 		$('icon').src = info.logo;
 		if (info.publisher) {
 			var e = $('publisher');
 			e.value = info.publisher[0];
 			e.link = info.publisher[1]; 			
 		}
 		else {
 			$('boxPublisher').hidden = true;
 		}
 		if (info.license) {
 			var e = $('license');
 			e.value = info.license[0];
 			e.link = info.license[1]; 			
 		}
 		else {
 			$('boxLicense').hidden = true;
 		} 		
 	},
	accept: function ML_accept() {
		var nodes = document.getElementsByTagName('richlistitem');
		for (var i = 0; i < nodes.length; ++i) {
			nodes[i].download.selected = nodes[i].checked;
		}
	},
	cancel: function ML_cancel() {
		var nodes = document.getElementsByTagName('richlistitem');
		for (var i = 0; i < nodes.length; ++i) {
			nodes[i].download.selected = false;
		}
	},
	openLink: function(e) {
		DTA_Mediator.openTab(e.link);
	},
	selectAll: function() {
		var nodes = document.getElementsByTagName('richlistitem');
		for (var i = 0; i < nodes.length; ++i) {
			nodes[i].checked = true;
		}
	},
	selectNone: function() {
		var nodes = document.getElementsByTagName('richlistitem');
		for (var i = 0; i < nodes.length; ++i) {
			nodes[i].checked = false;
		}
	},
	invertSelection: function() {
		var nodes = document.getElementsByTagName('richlistitem');
		for (var i = 0; i < nodes.length; ++i) {
			nodes[i].checked = !nodes[i].checked;
		}
	}
};