/* You may find the license in the LICENSE file */
 
 var Prefs = {
	tempLocation: null,
	
	mappings: [
		['removeCompleted', true],
		['removeAborted', false],
		['removeCanceled', false],
		['autoClose', 'closedta', false],
		['timeout', 300],
		['maxInProgress', 'ntask', 4],
		['maxChunks', 4],
		['setTime', true],
		['showOnlyFilenames', true],
		['conflictResolution', 3],
		['alertingSystem', 'alertbox', (SYSTEMSLASH == '\\') ? 1 : 0],
		['finishEvent', ''],
		['showTooltip', true]
	],

	// nsIObserver
	observe: function(subject, topic, prefName) {
		this._refreshPrefs();
	},

	init: function() {
		makeObserver(this);

		try {
			this._refreshPrefs();
			Preferences.addObserver('extensions.dta.', this);
			Preferences.addObserver('network.', this);
		}
		catch (ex) {
			Debug.dump("failed to add pref-observer", ex);
		}
	},

	_refreshPrefs: function() {
		Debug.dump("pref reload");
		this.mappings.forEach(
			function(e) {
				let key, pref, def;
				if (!e) {
					return;
				}
				else if (e.length == 3) {
					key = e[0];
					pref = e[1];
					def = e[2];
				}
				else {
					key = e[0];
					pref = key.toLowerCase();
					def = e[1];
				}
				this[key] = Preferences.getDTA(pref, def);
			},
			this
		);

		if (Preferences.getDTA("saveTemp", true)) {
			try {
				this.tempLocation = Preferences.getMultiByteDTA("tempLocation", '');
				if (this.tempLocation == '') {
					// #44: generate a default tmp dir on per-profile basis
					// hash the profD, as it would be otherwise a minor information leak
					var dsp = Serv('@mozilla.org/file/directory_service;1', 'nsIProperties');
					this.tempLocation = dsp.get("TmpD", Ci.nsIFile);
					var profD = hash(dsp.get("ProfD", Ci.nsIFile).leafName);
					this.tempLocation.append("dtatmp-" + profD);
					Debug.dump(this.tempLocation.path);
				}
				else {
					this.tempLocation = new FileFactory(this.tempLocation);
				}
			} catch (ex) {
				this.tempLocation = null;
				// XXX: error handling
			}
		}
		else {
			this.tempLocation = null;
		}
		var conns = (this.maxInProgress * this.maxChunks) + 2;
		if (conns > Preferences.get('network.http.max-persistent-connections-per-server', conns)) {
			Preferences.set('network.http.max-persistent-connections-per-server', conns);
		}
	}
}
Prefs.init();