/* You may find the license in the LICENSE file */
 
const Hash = Components.Constructor('@mozilla.org/security/hash;1', 'nsICryptoHash', 'init');
const InputStreamPump = Components.Constructor('@mozilla.org/network/input-stream-pump;1', 'nsIInputStreamPump', 'init');

function Verificator(download) {
	this.download = download;
	this.file = new FileFactory(download.destinationFile);
	this._pending = this.file.fileSize;
	this.CH = Ci.nsICryptoHash;

	download.state = FINISHING;
	download.status = _("verify");
	try {
		if (!(download.hash.type in this.CH)) {
			throw new Components.Exception("hash method unsupported!");
		}
		this.type = this.CH[download.hash.type];
		
		this.hash = new Hash(this.type);
		
		this.stream = new FileInputStream(this.file, 0x01, 0766, 0);
		this.download.partialSize = 0;
		this._readNextChunk();
	
		var thisp = this;
		this._timer = new Timer(function() { thisp.download.invalidate(); }, STREAMS_FREQ, true);
	}
	catch (ex) {
		try {
			if (this.stream) {
				this.stream.close();
			}
		}
		catch (ex) {
		}
		alert("Failed to verify the file!\n" + ex);
		download.complete();
	}
}
Verificator.prototype = {
	_delete: function() {
		try {
			if (this.file.exists()) {
				this.file.remove(false);
			}
		}
		catch (ex) {
			alert("Failed to remove file\n" + ex);
		}
	},
	_finish: function() {			
			this.download.partialSize = this.download.totalSize;
			this.download.invalidate();
			
			this.hash = hexdigest(this.hash.finish(false));
			if (this.hash != this.download.hash.sum) {
				Debug.dump("hash mismatch, actual: " + this.hash + " expected: " + this.download.hash.sum);
				var act = DTA_confirm(_('verifyerrortitle'), _('verifyerrortext'), _('retry'), _('delete'), _('keep'));
				switch (act) {
					case 0: this._delete(); this.download.safeRetry(); return;
					case 1: this._delete(); this.download.cancel(); return;
				}
			}
			this.download.complete();
	},
	_readNextChunk: function() {
		if (this._pending <= 0) {
			this.stream.close();
			this._timer.kill();
			var thisp = this;
			setTimeout(function() { thisp._finish(); }, 100);
			return;
		}
		var nextChunk = Math.min(this._pending, 1024 /* 2GB */);
		this._pending -= nextChunk;
		new InputStreamPump(this.stream, -1, nextChunk, 0, 0, false).asyncRead(this, null);		
	},
	_invalidate: function() {
		this.download.invalidate();
	},
	QueryInterface: function(iid) {
		if (iid.equals(Ci.nsISupports) || iid.equals(Ci.nsIStreamListener) || iid.equals(cI.nsIRequestObserver)) {
			return this;
		}
		throw Components.results.NS_ERROR_NO_INTERFACE;
	},
	onStartRequest: function(r, c) {
	},
	onStopRequest: function(request, c) {
		this._readNextChunk();
	},
	onDataAvailable: function(request, c, stream, offset, count) {
		try {
			this.hash.updateFromStream(stream, count);
			this.download.partialSize += count;
		}
		catch (ex) {
			Debug.dump("hash update failed!", ex);
			var reason = 0x804b0002; // NS_BINDING_ABORTED;
			request.cancel(reason);
		}
	}
};