/* You may find the license in the LICENSE file */

var DTA_SaveAs = {
	init: function dd_init() {

		var basicBox = document.getElementById('basicBox');
		var normalBox = document.getElementById('normalBox');
		const doRevert = basicBox && (!basicBox.collapsed || (normalBox && normalBox.collapsed));
		const doOverlay = DTA_preferences.getDTA("downloadWin", true);
		if (
			!doOverlay
			&& typeof(gFlashGotDMDialog) == 'undefined'
		) {
			// we do not actually overlay!
			return;
		}
		if (doRevert) {
			this.revertUI();
		}
		
		if (!doOverlay) {
			// we do not actually overlay!
			// but we revert to help FlashGot ;)
			return;
		}
		
		this.normal = document.getElementById('downthemall');
		this.turbo = document.getElementById('turbodta');
		this.mode = document.getElementById('mode');
		this.remember = document.getElementById("rememberChoice");
		this.settingsChange = document.getElementById("settingsChange");
		
		document.getElementById('downthemallcontainer').collapsed = false;
		this.normal.disabled = false;
		
		this.dialog = dialog;
		this.url = dialog.mLauncher.source.spec;
		try {
			this.referrer = dialog.mContext.QueryInterface(Components.interfaces.nsIWebNavigation).currentURI.spec;
  	}
		catch(ex) {
			this.referrer = this.url;
		}
		var ml = DTA_getLinkPrintMetalink(this.url);
		this.url = new DTA_URL(ml ? ml : this.url);

		this.ddDirectory = document.getElementById('tdtalist');
		var mask = DTA_AddingFunctions.getDropDownValue('renaming');
		if (!(document.getElementById("tdta").collapsed = (!DTA_AddingFunctions.getDropDownValue('directory') || !mask))) {
			this.turbo.disabled = false;
		}
		
		try {
			switch (DTA_preferences.getDTA('saveasmode', 0)) {
				case 1:
					this.mode.selectedItem = this.normal;
					break;
				case 2:
					this.mode.selectedItem = this.turbo.disabled ? this.normal : this.turbo;
					break;
			}
			if (DTA_preferences.getDTA('saveasmode', 0)) {
				this.remember.checked = true;
				this.remember.disabled = false;
			}
		}
		catch (ex) {}

		document.documentElement.setAttribute(
			'ondialogaccept',
			'if(DTA_SaveAs.dialogAccepted()) { '
			+ document.documentElement.getAttribute('ondialogaccept')
			+ '}'
		);
		this.mode.addEventListener(
			'select',
			function(evt) {
				DTA_SaveAs.select(evt);
			},
			false
		);
	},
	
	revertUI: function dd_revertUI() {
		['open'].forEach(
			function(e) {
				e = document.getElementById(e);
				e.parentNode.collapsed = true;		
				e.disabled = true;
			}
		);
		document.getElementById('normalBox').collapsed = false;
		var nodes = document.getElementById('normalBox')
			.getElementsByTagName('separator');
		
		for (var i = 0; i < nodes.length; ++i) {
			nodes[i].collapsed = true;
		} 

		document.getElementById('basicBox').collapsed = true;
		document.getElementById('normalBox').collapsed = false;
		
		// take care of FlashGot... for now.
		// need to negotiate with the author (and possible other extension authors)
		try {
			gFlashGotDMDialog.init();
			document.getElementById("flashgot-basic").collapsed = true;
		}
		catch (ex) {
			// no op
		}
		this.sizeToContent();
				
	},
	
	// Workaround for bug 371508
	sizeToContent: function() {
		try {
			window.sizeToContent();	
		}
		catch (ex) {
			DTA_debug.dump("sizeToContent Bug: 371508", ex);
			try {
				var btn = document.documentElement.getButton('accept');
				window.innerHeight = btn.boxObject.y + 10; 
			}
			catch (ex) {
				DTA_debug.dump("setting height failed");
			}		
		}
	},	
	select: function dd_select(evt) {
		var mode = this.mode.selectedItem;
		this.remember.checked = false;
		if (this.normal == mode || this.turbo == mode) {
			this.remember.disabled = false;
		}
	},
	
	selectTurbo: function dd_selectTurbo(event) {
		document.getElementById("mode").selectedItem = document.getElementById("turbodta");
		return true;
	},

	dialogAccepted: function dd_accept() {
		var mode = this.mode.selectedItem;
		if (mode == this.normal || mode == this.turbo) {
			if (this.remember.checked) {
				DTA_preferences.setDTA("saveasmode", mode == this.normal ? 1 : 2);
			}
			else {
				DTA_preferences.setDTA("saveasmode", 0);
			}
			this.download(mode == this.turbo);			
			return false;
		}
		DTA_preferences.setDTA("saveasmode", 0);		
	  return true;
	},
	
	download: function(turbo) {
		this.ddDirectory.save();
		DTA_AddingFunctions.saveSingleLink(turbo, this.url, this.referrer, "");
		document.documentElement.removeAttribute('ondialogaccept');
		document.documentElement.cancelDialog();
	}
}
addEventListener(
	"load",
	function(){ DTA_SaveAs.init(); },
	false
);