/* You may find the license in the LICENSE file */
 
var DTA_TBB = {
	init: function() {
		this._items = ['dta-button', 'dta-turbo-button', 'dta-manager-button'].map(
			function(e) {
				return document.getElementById(e);
			}
		);
		DTA_makeObserver(this);
		DTA_preferences.addObserver("extensions.dta.sm.", this);
		this._refresh();
	},
	observe: function(subject, topic, prefName) {
		this._refresh();
	},
	_refresh: function() {
		DTA_preferences
			.getDTA('sm.buttons')
			.split(',')
			.forEach(
				function(v, i) {
					this._items[i].hidden = v != '1';
				},
				this
			);
	}
};
window.addEventListener("load", function() {DTA_TBB.init();}, false);