
function copyplaintext(){
	try{
		// Get String
		var str = copyplaintext_getSelection() + "";
		
		// Format
			var oPrefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
			
			// Trim
			if(oPrefs.prefHasUserValue("copyplaintext.formatting.trim") && oPrefs.getBoolPref("copyplaintext.formatting.trim"))
				str = str.replace(/^\s*|\s*$/g, "");
			
			// Extra Lines
			if(oPrefs.prefHasUserValue("copyplaintext.formatting.extra.newline") && oPrefs.getBoolPref("copyplaintext.formatting.extra.newline"))
				str = str.replace(/[\n\r]+/g, "\n");
			
			// Extra Space
			if(oPrefs.prefHasUserValue("copyplaintext.formatting.extra.space") && oPrefs.getBoolPref("copyplaintext.formatting.extra.space"))
				str = str.replace(/[ \t]+/g, " ");
		
		
		// Copy
		if(str != null && str.length > 0){
			var oClipBoard = Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);
				oClipBoard.copyString(str);
		}
				
	}catch(err) { alert("An unknown error occurred\n"+ err) }
}

function copyplaintext_init(){
	var oContext = document.getElementById('contentAreaContextMenu');
	
	if(oContext){
		oContext.setAttribute("onpopupshowing", "copyplaintext_showContextMenu(); "+ oContext.getAttribute("onpopupshowing"));
	}
	
	// Set as defalt
	var oPrefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
	if(oPrefs.prefHasUserValue("copyplaintext.default") && oPrefs.getBoolPref("copyplaintext.default")){
		document.getElementById("key_copyPlainText").setAttribute("disabled", true);
		
		// Remove copy plain text menu items
		var cpt_node = document.getElementById("copyplaintext-context-menu")
		cpt_node.parentNode.removeChild(cpt_node);
		
		cpt_node = document.getElementById("copyplaintext-edit-menu")
		cpt_node.parentNode.removeChild(cpt_node);
		
		// Hijax menus
		document.getElementById("cmd_copy").setAttribute("oncommand", "copyplaintext()");
		document.getElementById("key_copy").setAttribute("oncommand", "copyplaintext()");
		
	}
}

function copyplaintext_showMenu(){

	// Is Text Select
	try{		
		var str = copyplaintext_getSelection();
		if(str != null && str.length > 0) {
			return true;
		}
				
	}catch(err) { }
	
	return false;
}

function copyplaintext_getSelection() {
	var focusedWindow = document.commandDispatcher.focusedWindow;
	var searchStr 		= focusedWindow.getSelection.call(focusedWindow);
	searchStr 			= searchStr.toString();
	
	return searchStr;
}

function copyplaintext_showEditMenu(){
	if(document.getElementById('copyplaintext-edit-menu') != null)
		document.getElementById('copyplaintext-edit-menu').setAttribute("disabled", !copyplaintext_showMenu());
}

function copyplaintext_showContextMenu(){
	if(document.getElementById('copyplaintext-context-menu') != null)
		document.getElementById('copyplaintext-context-menu').setAttribute("collapsed", !copyplaintext_showMenu());
}