/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures (Component loader).
 *
 * The Initial Developer of the Original Code is Jochen Schlehuber.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

//----------------------
//-- component status --
//----------------------

var mgMouseService = false;
var mgNativeTrails = false;
var mgNativeTrailsOpacity = false;
var mgMouseEvents = false;

var mgComponentLoader =
{
  init : false,
  CI   : Components.interfaces,

  initMouseService : function()
  {
     if (this.init)
        return;

     this.init = true;

     if (!("@mousegestures.org/mgMouseService;1" in Components.classes) &&
          ("mgIMouseService" in Components.interfaces))
        this.installMouseService();

     if (("@mousegestures.org/mgMouseService;1" in Components.classes))
     {
        try {
          mgMouseService = Components.classes["@mousegestures.org/mgMouseService;1"]
                           .getService().QueryInterface(this.CI.mgIMouseService);

          mgNativeTrails = mgMouseService.supports("nativeTrails")
          mgNativeTrailsOpacity = mgMouseService.supports("trailOpacity")
          mgMouseEvents = mgMouseService.supports("mouseEvents")
        }
        catch (e) {}
     }
  },

  installMouseService : function()
  {
     try
     {
        this.win32 = Components.classes['@mozilla.org/file/directory_service;1']
                     .getService(this.CI.nsIProperties).get('WinD', this.CI.nsILocalFile);

        this.win32 = true
     }
     catch (e)
     {
        this.win32 = false
     }

     if (this.win32)
     {
        this.compPath = "\\extensions\\{FFA36170-80B1-4535-B0E3-A4569E497DD0}\\platform\\WINNT_x86-msvc\\components\\mgMouseService.dll"
        this.fileDIR = Components.classes['@mozilla.org/file/directory_service;1']
                       .getService(this.CI.nsIProperties);

        this.compFile = this.fileDIR.get('ProfD', this.CI.nsILocalFile)
        this.compFile.initWithPath(this.compFile.path + this.compPath)

        if (!this.compFile.exists())
        {
           this.compFile = this.fileDIR.get('CurProcD', this.CI.nsILocalFile);
           this.compFile.initWithPath(this.compFile.path + this.compPath);
        }

        Components.manager.QueryInterface(this.CI.nsIComponentRegistrar)
                                          .autoRegister(this.compFile);
     }
  }
}







