/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Andy Edmonds <aedmonds@mindspring.com>
 *  Ben Williams <benw@webmedia.com.au>
 *  Benjamin K. Stuhl <tiriath@yahoo.com>
 *  Jeremy Wrinkle (Exotrip)        FIXME  email
 *  Jochen <bugs@krickelkrackel.de>
 *  Pavol Vaskovic <pali@pali.sk>
 *  Scurrie                         FIXME whole name, email
 *  Steve Kangas <bookmarklets.com> FIXME  email
 *  Squarefree.com                  FIXME who exactly: whole name, email
 *  David Illsley <illsleydc@bigfoot.com>
 *  Jens Bannmann <jens.b@web.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

function mgB_Back() {
  BrowserBack(); // mozilla function
  resetRocker();
}

function mgB_Forward() {
  BrowserForward(); // mozilla function
  resetRocker();
}

function mgB_Reload() {
  BrowserReload(); // mozilla function
  resetRocker();
}

function mgB_ReloadFrame() {
  try {
    if (globalSrcEvent.target.ownerDocument != document) {
      globalSrcEvent.target.ownerDocument.location.reload();
    }
  } catch (e) {
    if (e.message.indexOf("(NS_ERROR_FAILURE)") == -1) {
      throw e;
    }
  }
  resetRocker();
}

function mgB_ReloadSkipCache() {
  BrowserReloadSkipCache(); // mozilla function
  resetRocker();
}

function mgB_Stop() {
  BrowserStop(); // mozilla function
}

function mgB_Home() {
  BrowserHome(); // mozilla function
  resetRocker();
}

function mgB_ZoomIn_DoubleImage() {
  if (globalOnImage) {
    mgB_DoubleImageSize();
    return "mgB_DoubleImageSize";
  } else {
    mgB_ZoomIn();
    return "mgB_ZoomIn";
  }
}

function mgB_ZoomOut_HalveImage() {
  if (globalOnImage) {
    mgB_HalveImageSize();
    return "mgB_HalveImageSize";
  } else {
    mgB_ZoomOut();
    return "mgB_ZoomOut";
  }
}

function mgB_ZoomIn() {
  ZoomManager.prototype.getInstance().enlarge();
}

function mgB_ZoomOut() {
  ZoomManager.prototype.getInstance().reduce();
}

function mgB_ResetZoom() {
  var mgResetDoc = globalSrcEvent.view.document;
  ZoomManager.prototype.getInstance().reset();
  // the following code will not work with all gecko_1.8b versions!
  // https://bugzilla.mozilla.org/show_bug.cgi?id=300325
  if (mgResetDoc.images && mgResetDoc.images.length > 0) {
     for (y=0; y<mgResetDoc.images.length; y++) {
         var mgResetImg = mgResetDoc.images[y];

         if (mgResetImg.mgOriginalWidth &&
             !isNaN(mgResetImg.mgOriginalWidth) &&
             !isNaN(mgResetImg.mgOriginalHeight)) {
            mgResetImg.style.width = mgResetImg.mgOriginalWidth +"px";
            mgResetImg.style.height = mgResetImg.mgOriginalHeight +"px";
            mgResetImg.mgImageRatio =
                       mgResetImg.mgOriginalWidth =
                       mgResetImg.mgOriginalHeight = false;
         }
     }
  }
}

function mgB_HalveImageSize() {
  mgSetImageSize(.5);
}

function mgB_DoubleImageSize() {
  mgSetImageSize(2);
}

function mgB_HideImage() {
  mgSetImageSize(0);
}

function mgSetImageSize(aSize) {
  if (!globalOnImage)
     return;

  // the following code will not work with all gecko_1.8b versions!
  // https://bugzilla.mozilla.org/show_bug.cgi?id=300325
  if (!globalOnImage.mgImageRatio) {
      globalOnImage.mgImageRatio = globalOnImage.width/globalOnImage.height;
      globalOnImage.mgOriginalWidth = globalOnImage.width;
      globalOnImage.mgOriginalHeight = globalOnImage.height;
  }
  if(!isNaN(globalOnImage.mgImageRatio)) {
    // image.width will always return an int, but the real width can be a float
    // if style.width is not set, just take image.width
    // use mgImageRatio for resize
    var w = parseFloat(globalOnImage.style.width);
    if (isNaN(w))
       w = globalOnImage.width;

    globalOnImage.style.width = (w * aSize) + "px";
    w = parseFloat(globalOnImage.style.width);
    globalOnImage.style.height = (w / globalOnImage.mgImageRatio) + "px";
  }
}

function mgB_OpenTab() {
  return mgOpenTab(true);
}

function mgB_OpenBlankOrLinkTab() {
  return mgOpenTab(false);
}

function mgOpenTab(bUseSel) {
  if(globalOnLink && globalOnLink.length > 0) {
    mgLinkInTab(globalOnLink[0].href);
    mgMarkLinkVisited(globalOnLink[0]);
  } else {
    var sel = mgGetSelection().toString();
    if (bUseSel && sel.match(/^(http)|(ftp):/)) {
      mgLinkInTab(sel);
    } else {
      BrowserOpenTab(); // mozilla function
    }
  }
}

function mgGetSelection() {
  return (globalSrcEvent.view != null) ? globalSrcEvent.view.getSelection() : "";
}

function mgGetReferrer() {
  try {
    var mgRefURL = globalSrcEvent.target.ownerDocument.location.href;

    if (mgRefURL) {
      var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                      .getService(Components.interfaces.nsIIOService);
      return ioService.newURI(mgRefURL, null, null);
    }
  }
  catch (e) { }
  return null;
}

function mgLoadSideBar(aUrl, aPostData) {
  var mgSidebar = document.getElementById("sidebar");
  if (!mgSidebar.contentDocument ||
      !mgSidebar.contentDocument.getElementById('web-panels-browser')) {
    setTimeout(mgLoadSideBar, 100, aUrl, aPostData);
    return;
  }
  mgSidebar.contentDocument.getElementById('web-panels-browser')
           .loadURIWithFlags(aUrl, null, null, null, aPostData);
}

function mgB_DuplicateTab() {
  mgLinkInTab(window._content.document.location);
}

function mgLinkInTab(url){
  var browser = getBrowser();
  var tab = browser.addTab(url, mgGetReferrer());
  if (!mgPrefRoot.getBoolPref("browser.tabs.loadInBackground"))
    browser.selectedTab = tab;
}

function mgB_LinksInTabs(){
  var browser = getBrowser();
  for(i = 0; i < globalOnLink.length; i++) {
    tab = browser.addTab(globalOnLink[i].href, mgGetReferrer());
    mgMarkLinkVisited(globalOnLink[i]);
  }
}

function mgB_NextTab() {
  getBrowser().mTabBox._tabs.advanceSelectedTab(+1, true);
}

function mgB_PreviousTab() {
  getBrowser().mTabBox._tabs.advanceSelectedTab(-1, true);
}

function mgB_ViewPageSource() {
  BrowserViewSourceOfDocument(content.document);
}

function mgB_ViewFrameSource() {
  BrowserViewSourceOfDocument(globalSrcEvent.originalTarget.ownerDocument);
}

function mgB_ViewFrameOrPartialSource() {
  return mgB_ViewPartialSource() || mgB_ViewFrameSource();
}

function mgB_ViewPartialSource() {
  if (mgGetSelection().toString() != "") {
    mgViewPartialSource();
  } else {
    return false;
  }
  return true;
}

function mgViewPartialSource() {
    var docCharset = null;
    docCharset = "charset=" + globalSrcEvent.view.document.characterSet;
    var reference = mgGetSelection();
    var mgPartial;

    if (document.getElementById("viewMozgestSidebar"))
       mgPartial = "chrome://global/content/viewPartialSource.xul";
    else
       mgPartial = "chrome://navigator/content/viewPartialSource.xul";

    window.openDialog(mgPartial, "_blank",
                      "scrollbars,resizable,chrome,dialog=no",
                      null, docCharset, reference, "selection");
}

function mgNewBrowserWindow() {
  window.open();
  return mgkWindowMediator.getMostRecentWindow("navigator:browser");
}

function mgB_LinksInWindows(){
  for(i = 0; i < globalOnLink.length; i++) {
    mgNewBrowserWindow().loadURI(globalOnLink[i].href, mgGetReferrer());
    mgMarkLinkVisited(globalOnLink[i]);
  }
}

function mgB_OpenNewDocument(){
  if(globalOnLink) { // open link in new window
    mgNewBrowserWindow().loadURI(globalOnLink[0].href, mgGetReferrer());
    mgMarkLinkVisited(globalOnLink[0]);
  } else {
    if (globalOnImage) {     // Open image in new window
      window.open(globalOnImage.src);
    } else { // open blank window
      OpenBrowserWindow();
    }
  }
}

function mgB_DuplicateWindow(){
  mgNewBrowserWindow().loadURI(window._content.document.location,
      mgGetReferrer());
}

function mgB_AddBookmark() {
  addBookmarkAs(document.getElementById('content'));
}

function mgB_CloseDoc() {
  BrowserCloseTabOrWindow();
}

function mgB_CloseTab() {
  getBrowser().removeCurrentTab();
}

function mgB_UpDir(){ //from bookmarklets.com
  if (window._content.document.location.protocol != "about:") {
    var aUrl = window._content.document.location.href;
    aUrl = aUrl.substring(0, aUrl.substring(0, aUrl.length-1).lastIndexOf('/')+1);
    aUrl = mgBMService.makeURI(aUrl);

    if (aUrl.spec != (aUrl.scheme + ":///"))
      window._content.document.location.href = aUrl.spec;
  }
}

function mgB_ViewSiteCookies(){ //Contributed by Squarefree.com
  if (window._content.document.cookie)
    alert(mgBundle.getString("cookies") + "\n\n"
      + window._content.document.cookie.replace(/; /g,"\n"));
  else alert(mgBundle.getString("noCookies"));
}

function mgB_MetaInfo(){
  var metas = window._content.document.getElementsByTagName("meta");
  if (metas.length != 0){
    var metastr = mgBundle.getString("meta") + "\n\n";
    for(var ameta = 0; ameta < metas.length; ameta++) {
      var mymeta = metas.item(ameta);
      metastr += "<META ";
      if (mymeta.name) metastr += "name=\"" + mymeta.name + "\" ";
      if (mymeta.httpEquiv) metastr+= "http-equiv=\"" + mymeta.httpEquiv + "\" ";
      if (mymeta.content) metastr += "content=\"" + mymeta.content + "\" ";
      if (mymeta.scheme) metastr += "scheme=\"" + mymeta.scheme + "\" ";
      metastr += '>\n';
    }
    alert(metastr);
  }
  else alert(mgBundle.getString("noMeta"));
}

function mgB_ViewPageInfo() {
  BrowserPageInfo();
}

function mgB_ViewFrameInfo() {
  BrowserPageInfo(globalSrcEvent.target.ownerDocument);
}

function mgB_DoubleStackWin() {
  var tempW;
  if(globalOnLink) {
    window.moveTo(screen.availLeft, screen.availTop);
    window.resizeTo(screen.availWidth/2, screen.availHeight);
    tempW = mgNewBrowserWindow();
    tempW.loadURI(globalOnLink[0].href, mgGetReferrer());
    tempW.moveTo(screen.availWidth/2 + (screen.width - screen.availWidth),
                 screen.availTop);
    tempW.resizeTo(screen.availWidth/2, screen.availHeight);
    mgMarkLinkVisited(globalOnLink[0]);
  }
}

function mgB_W3cValidate() {
  window._content.document.location='http://validator.w3.org/check?uri='+window._content.document.location;
}

/*** PRINT PREVIEW FUNCTIONS ***/

function mgBP_ExitPrintPreview() {
  if (document.getElementById("print-preview-toolbar") != null) {
    window.setTimeout(BrowserExitPrintPreview, 100); // mozilla function
  }
}