/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Benjamin K. Stuhl <tiriath@yahoo.com>
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *  Pavol Vaskovic <pali@pali.sk>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var gBrowserWindow; // needed in case a browser isn't open and we need to make one
var gBrowserAttempts;
var gBrowserOpened;

function mgW_RestMaxWin(){
  if(window.maximize != 'undefined') {
   if (window.windowState == STATE_MAXIMIZED)
     window.restore();
   else window.maximize();
  }
}

function mgW_MinWin(){
  if(window.minimize != 'undefined') {
    window.minimize();
  }
}

function mgW_LinksInTabs() {
  gBrowserOpened = false;
  //check for an existing browser window
  gBrowserWindow = mgkWindowMediator.getMostRecentWindow("navigator:browser");
  if (gBrowserWindow == null) {
    gBrowserWindow = window.open(globalOnLink[0].href);
    mgMarkLinkVisited(globalOnLink[0]);
    gBrowserOpened = true;
  } else {
    gBrowserWindow.focus();
  }
  gBrowserAttempts = 0;
  grabBrowserAndAddTabs();
}

function grabBrowserAndAddTabs() {
  try {
    gBrowserWindow = mgkWindowMediator.getMostRecentWindow("navigator:browser");
    var b = gBrowserWindow.getBrowser();
    for(i = (gBrowserOpened ? 1 : 0); i < globalOnLink.length; i++) {
      tab = b.addTab(globalOnLink[i].href, mgGetReferrer());
      mgMarkLinkVisited(globalOnLink[i]);
    }
  } catch(e) {
    if (gBrowserAttempts < 20) {
      window.setTimeout("grabBrowserAndAddTabs();", 500);
      gBrowserAttempts++;
    } else {
      alert("Error: Could not grab browser window. " + e);
    }
  }
}

function mgMarkLinkVisited(link) {
   if (parseFloat(mgAppInfo.geckoVersion) >= 1.8)
      return;   //https://bugzilla.mozilla.org/show_bug.cgi?id=78510

   var globalHistory = Components.classes["@mozilla.org/browser/global-history;1"]
                               .getService(Components.interfaces.nsIGlobalHistory);
   var href = link.href;
   if (!globalHistory.isVisited(href)) {
     globalHistory.addPage(href);
     // re-setting href causes the link to be re-painted
     link.href = "";
     link.href = href;
   }
}

function mgW_CloseWin() {
  if ("BrowserTryToCloseWindow" in window)
    window.setTimeout("BrowserTryToCloseWindow()", 10);
  else
    window.setTimeout("window.close()", 10);
}

function mgW_Cut() {
  goDoCommand('cmd_cut');
}

function mgW_Copy() {
  goDoCommand('cmd_copy');
}

function mgW_Paste() {
  goDoCommand('cmd_paste');
}

function mgW_ScrollDown() {
  globalSrcEvent.view.scrollBy(0,200);
}

function mgW_ScrollUp() {
  globalSrcEvent.view.scrollBy(0,-200);
}

function mgW_ScrollRight() {
  globalSrcEvent.view.scrollBy(200,0);
}

function mgW_ScrollLeft() {
  globalSrcEvent.view.scrollBy(-200,0);
}