/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Andy Edmonds <aedmonds@mindspring.com>
 *  Ben Williams <benw@webmedia.com.au>
 *  David Illsley <illsleydc@bigfoot.com>
 *  Jens Bannmann <jens.b@web.de>
 *  Jeremy Wrinkle (Exotrip)        FIXME  email
 *  Jochen <bugs@krickelkrackel.de>
 *  Pavol Vaskovic <pali@pali.sk>
 *  Scurrie            FIXME whole name, email
 *  Steve Kangas <bookmarklets.com> FIXME  email
 *  Squarefree.com     FIXME who exactly: whole name, email
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/**
7   U   9  Function processCoordinates returns in global variable 'gesture'
  \ | /    list of 8-directional movements made in gesture. Function fireGesture
R---x---L  takes compacted 8dir chain code and fires the desired action.
  / | \    Ex. "DL" means that user has moved mouse down, then left
1   D   3      "LRL" was gesture right-left-right etc.
 globalOnLink is an array that holds a list of all the links traversed during
 the active gesture.  It's defined in mozgestOverlay.js.
*/

var gesturesTable = new Array();
var gestureHistory = new Array();
var gestureHistoryMSG = new Array();
var rockerCode = "";
var wheelTurns = 0;


function Mapping() {
  this.name = null;       // mapping name
  this.code = null;       // movement code to invoke the gesture
  this.appearance = null; // data for dynamic drawings
  this.func = null;       // builtin function to call
  this.custom = null;     // alternative: custom JS code
  this.countBase = 0;     // previous usage count
  this.countCur = 0;      // current counter, when saving, this is added to
                          // whatever value is found in userStore (could be
                          // different from original countBase!)
  this.resource = null;   // RDF resource uri, used when saving usage counts
}

/* This function attempts to fire the gesture, initially with the unmodified
   gesture it has been passed. If that fails, it fires the case with an onLink
   where the ending of the gesture matches a specific pattern. */
function fireGesture(aGesture){
  if(!fireGestureFromTable(aGesture)) {
    if(!fireOnLinkGesture()) {
      mgMsg(mgBundle.getString("g.unknown") + " " + localizedGesture);
      mgCommon.dump("MozGest: Unknown Gesture: " + aGesture + "\n");
    }
  }
  // clear global variables
  globalOnLink = false;
  globalOnImage = false;
  globalSrcEvent = false;
}

function fireGestureFromTable(aGesture){
  var mapping = ( aGesture in gesturesTable ) ? gesturesTable[aGesture] : null;
  if (mapping != null) {
    if (mgButton == 0 && mgPreviousSelection && globalSrcEvent)
    {
      mgGetSelection().removeAllRanges();
      mgGetSelection().addRange(mgPreviousSelection);
      mgPreviousSelection = null;
    }

    mgGestureDone = true;
    mgCommon.dump("MozGest: Invoking '" + mapping.name + "'\n");
    var mgFeedback = "";
    try {
      if (mapping.func) {
        eval("mgFeedback = " + mapping.func + "();");
        if (!mgFeedback) mgFeedback = mapping.func;
      }

      else if (mapping.bmOpenIn && mgBMService.enabled) {
        var mgLocation = mgBMService.Book.GetTarget(mgBMService.RDFS
                                    .GetResource(mapping.custom), mgBMService.Href, true);
        var mgPostData = { };

        if (mgLocation) {
           mgLocation = mgLocation.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
           var mgLoadIn = parseInt(mapping.bmOpenIn);

           if (mgBMService.makeURI(mgLocation).scheme == "javascript")
             mgLoadIn = 0;
           else {
             var selString = mgGetSelection().toString().replace(/\s$/, "");

             mgKeyW = mgBMService.Book.GetTarget(mgBMService.RDFS
                                 .GetResource(mapping.custom), mgBMService.KeyW, true);

             if (mgKeyW) { // if bookmark has a keyword, use browser-function to replace %s
               mgKeyW = mgKeyW.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
               mgLocation = getShortcutOrURI(mgKeyW + " " + selString, mgPostData);
             }
             else if (mgLocation.match(/%s/))
               mgLocation = mgLocation.replace(/%s/g, encodeURIComponent(selString));
           }

           if (mgLoadIn == 4 && mgAppInfo.name != "Firefox")
             mgLoadIn = 0;

           switch (mgLoadIn) {
           case 4:
             var mgPanelTitle = mgBMService.Book.GetTarget(mgBMService.RDFS
                                .GetResource(mapping.custom), mgBMService.Name, true)
             if (mgPanelTitle)
                mgPanelTitle = mgPanelTitle.QueryInterface(
                                            Components.interfaces.nsIRDFLiteral).Value;
             else
                mgPanelTitle = "";

             openWebPanel(mgPanelTitle, mgLocation);
             if (mgPostData.value)
               setTimeout(mgLoadSideBar, 100, mgLocation, mgPostData.value);
             break;

           case 3:
             getBrowser().selectedTab = getBrowser().addTab(mgLocation, null, null, mgPostData.value);
             break;

           case 2:
             getBrowser().addTab(mgLocation, null, null, mgPostData.value);
             break;

           case 1:
             mgNewBrowserWindow().loadURI(mgLocation, null, mgPostData.value);
             break;

           case 0:
             loadURI(mgLocation, null, mgPostData.value);
             break;
           }
        }
        else {
           alert(mgBundle.getString("unknownBookmark"))
           return true;
        }
      }

      else {
        eval(mapping.custom);
      }
    } catch(e) {
      var errorMessage = "";
      var source = null;
      if (typeof e == "object" && "message" in e) {
        errorMessage = e.message;
        if ("filename" in e) {
          source = e.filename;
        } else if ("fileName" in e) {
          source = e.fileName;
        }
      } else {
        errorMessage = String(e);
      }
      if (source == null || source.indexOf("chrome://mozgest/") == 0) {
         var msg = mgBundle.getString("errorInGestureFunction");
         msg = msg.replace(/%MESSAGE%/, errorMessage);
         alert(msg);
         mgMsg("");
      }
      return true;
    }
    var message;  // feedback message to display
    if (mgFeedback) {
      try {
        message = mgBundle.getString(mgFeedback);
      } catch(e) {
        // use plaintext value if not a valid stringbundle-identifier
        message = mgFeedback;
      }
    } else {
      // default to description from table
      message = mapping.name;
    }
    mgMsg(message);

    // gestureHistory
    if (gestureHistory.length == 10)      // max length
    {  gestureHistory.pop();
       gestureHistoryMSG.pop();
    }
    gestureHistory.unshift(mgMappingLocalizer.localize(aGesture))
    gestureHistoryMSG.unshift(message)
    // gestureHistory

    mapping.countCur++;
    return true;
  } else if (aGesture == "RLDUR" && mgWindowType == "browser") {
    var myBod = window._content.document.body;
    var im = "http://www.surfmind.com/images/explode.gif";
    myBod.background = im;
    myBod.setAttribute("style", "background:url(" + im + ")");
    mgMsg(mgBundle.getString("explodeBackground"));
    return true;
  } else {
    return false;
  }
}

function fireOnLinkGesture(){
  if(globalOnLink) {
    lastgesture = gesture.join("");
    var twoStroke = lastgesture.substr(lastgesture.length-2,2);
    var threeStroke = lastgesture.substr(lastgesture.length-3,3);
    mgCommon.dump("MozGest: Multiple link spawn: " + lastgesture
      + ' spotted... \n  ...Looking for Finishing Move\n');
    if(!fireGestureFromTable("*"+twoStroke))
      return fireGestureFromTable("*"+threeStroke);
    else return true;
  }
  return false;
}

function checkForRocker(event) {
  if (!rockersEnabled) { return false; }
  if (mgRockerAborted) {
     rockerCode = "";
     mgRockerAborted = false;
  }
  if (rockerCode == "")
    rockerCode = ":";

  var mgRockerButton = event.button;
  if (mgLeftHanded)
     mgRockerButton = Math.abs(event.button - 2);

  rockerCode += "" + mgRockerButton;
  return fireRocker(rockerCode, event);
}

function fireRocker(code, event) {
  clearInterval(mgRockerInterval);
  if(gesturesTable[code] != null) {
    gestureInProgress = false;
    gestureStartTime = false;
    mgTrails.endTrail();
    window.clearTimeout(mgGestureTimeout);

    if ( ("isScrolling" in window) && isScrolling)  // autoscroll by skidooer
       stopScroll();
    if (eval(mgGetAutoScroll).autoscrollEnabled) {  // Firefox autoscroll
        eval(mgGetAutoScroll).stopScroll();
    }

    if (event) {
       event.preventDefault();
       if (mgMouseEvents) { //really kill it. event.target can survive for a little moment
         event.target.removeEventListener("click", mgOnClickHandler, true);
         event.target.addEventListener("click", mgOnClickHandler, true);
       }
    }

    fireGestureFromTable(code);

    if (mgStaticRockers && mgMouseEvents) {
      if ((code.indexOf("+") == -1 && code.indexOf("-") == -1))
        mgRockerInterval = setInterval(fireRocker, mgStaticRockersDelay, code, false);
      else if (mgWheelRockersAutoRepeat)
        mgRockerInterval = setInterval(fireRocker, mgStaticRockersDelay, code, false);
    }

    return true;
  } else {
    return false;
  }
}

function releaseRocker(event) {
  clearInterval(mgRockerInterval);
  if (event) {
    eval("rockerCode = rockerCode.replace(/" + event.button + "/g, '');");
    wheelTurns = 0;
  }
}

function resetRocker() {
  if (!mgMouseEvents) {
    rockerCode = "";
    wheelTurns = 0;
  }
}

function mgMousewheelHandler(e) {
  if (mgRockerAborted) return;
  if (rockerCode
      && (gesturesTable[rockerCode+"-"] || gesturesTable[rockerCode+"+"])) {
    wheelTurns += (e.detail > 0) ? 1 : (-1);
    e.preventDefault();
  }
  if (Math.abs(wheelTurns) >= mgWheelSensitivity){
    fireRocker(rockerCode + (wheelTurns > 0 ? "+" : "-"));
    wheelTurns = 0;
  }
}

function resetGesturesTable() {
  gesturesTable = new Array();
}

function addGesture(entry) {
  gesturesTable[entry.code] = entry;
}