/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Jochen Schlehuber.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

// Please keep this file clean!
// Only things that have a chance to be reused often should go here!

var mgPrefRoot = null;
var mgPref;

var mgCommon =
{
  initPrefService : function()
  {
    var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                                .getService(Components.interfaces.nsIPrefService);
    mgPrefRoot = prefService.getBranch(null);   // root preferences branch
    mgPref = prefService.getBranch("mozgest."); // mozgest preferences branch
  },

  dump : function(aText)
  {
    try {
      if (mgPref.getBoolPref("enableDump"))
        dump(aText);
    }
    catch (e) {}
  },

  showWebPage : function(pageUrl) {
    // determine locale
    var locale = null;
    try {
      locale = Components.classes["@mozilla.org/chrome/chrome-registry;1"]
                         .getService(Components.interfaces.nsIXULChromeRegistry)
                         .getSelectedLocale("global");
    } catch (e) {
    }
    if (locale != null) {
      pageUrl = pageUrl + "?language=" + locale;
    }
  
    //Thunderbird
    if (mgAppInfo.name == "Thunderbird") {
      var uri = Components.classes["@mozilla.org/network/standard-url;1"]
                        .createInstance(Components.interfaces.nsIURI);
      uri.spec = pageUrl;
  
      var protocolSvc = Components.classes["@mozilla.org/uriloader/external-protocol-service;1"]
                        .getService(Components.interfaces.nsIExternalProtocolService);
      protocolSvc.loadUrl(uri);
      return;
    }
  
    //check for an existing browser window
    const kWindowMediatorContractID = "@mozilla.org/appshell/window-mediator;1";
    const kWindowMediatorIID = Components.interfaces.nsIWindowMediator;
    const kWindowMediator = Components.classes[kWindowMediatorContractID].getService(kWindowMediatorIID);
    var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
    if (browserWindow) {
      try {
        browserWindow.delayedOpenTab(pageUrl);
      }
      catch(e) {
        browserWindow.loadURI(pageUrl);
      }
    }
    else {
      window.open(pageUrl);
    }
  }

}


var mgAppInfo =
{
   getAppInfo : function()
   {
      var pHandler = Components.classes['@mozilla.org/network/io-service;1']
                    .getService(Components.interfaces.nsIIOService)
                    .getProtocolHandler('http')
                    .QueryInterface(Components.interfaces.nsIHttpProtocolHandler);

      this.geckoVersion = pHandler.misc.substring(3);
      this.oscpu = pHandler.oscpu;
      this.platform = pHandler.platform;

      if ("@mozilla.org/xre/app-info;1" in Components.classes)
      {
         var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                       .getService(Components.interfaces.nsIXULAppInfo);

         this.appBuildID = appInfo.appBuildID;
         this.ID = appInfo.ID;
         this.name = appInfo.name;
         try { // there is no nsIXULRuntime in SM
           this.os = appInfo.QueryInterface(Components.interfaces.nsIXULRuntime).OS;
         }
         catch (e) {
           this.os = false;
         }
         this.platformBuildID = appInfo.platformBuildID;
         this.vendor = appInfo.vendor;
         this.version = appInfo.version;
      }
      else // for gecko < 1.8
      {
         if ("@mozilla.org/extensions/manager;1" in Components.classes)
         {
            this.name = "Firefox";
            if ("nsIPop3Service" in Components.interfaces)
               this.name = "Thunderbird";
         }
         else
            this.name = "SeaMonkey";
      }
   }
}

mgAppInfo.getAppInfo();
mgCommon.initPrefService();
