/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures (Locale Switcher module).
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var mgLS_JarBasePath = null;
var mgLS_InProfile;

window.addEventListener("load", mgLS_Startup, false);

function mgLS_Startup() {
  // Determine base jar path. We cannot use resource:///chrome/mozgest.jar as it
  // wouldn't work with profile installs. Therefore, ask the chrome registry...
  var oRdf = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);

  try {
     var oDs = oRdf.GetDataSourceBlocking("rdf:chrome");
  }
  catch (e) {
     return;
  }
  var oBasePath = oDs.GetTarget(oRdf.GetResource("urn:mozilla:package:mozgest"),
                                oRdf.GetResource("http://www.mozilla.org/rdf/chrome#baseURL"),
                                true);
  if(oBasePath instanceof Components.interfaces.nsIRDFLiteral){
    mgLS_JarBasePath = oBasePath.Value;
    mgLS_JarBasePath = mgLS_JarBasePath.substring(0, mgLS_JarBasePath.lastIndexOf("!") + 1);
    setTimeout(mgLS_CheckLocale, 1000); // seems to be neccessary to avoid startup freeze
  } else {
    dump("MozGest: Could not determine jar base path - skipping locale check.\n");
  }

  // Determine whether mozgest is installed into the user profile
  // (needed for locale registration)
  mgLS_InProfile = true;
  var inProfile = oDs.GetTarget(oRdf.GetResource("urn:mozilla:package:mozgest"),
                                oRdf.GetResource("http://www.mozilla.org/rdf/chrome#locType"),
                                true);
  if (inProfile instanceof Components.interfaces.nsIRDFLiteral
      && inProfile.Value == "install") {
    mgLS_InProfile = false;
  }
}

function mgLS_CheckLocale() {
  const promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                        .getService(Components.interfaces.nsIPromptService);
  const mozgestPreferences = Components.classes["@mozilla.org/preferences-service;1"]
                             .getService(Components.interfaces.nsIPrefService)
                             .getBranch("mozgest.");
  var properties = mgLS_GetBundle("chrome://mozgest/content/mgbuild.properties");
  var bundle;


  var keepNonAppLocale;
  try {
    keepNonAppLocale = mozgestPreferences.getBoolPref("keepNonAppLocale");
  } catch (e) {
    keepNonAppLocale = false;
  }

  // Determine package locales
  const chromeRegistry = Components.classes["@mozilla.org/chrome/chrome-registry;1"]
                                   .getService(Components.interfaces.nsIXULChromeRegistry);
  var mozgestLocale = chromeRegistry.getSelectedLocale("mozgest");
  var defaultLocale = properties.GetStringFromName("mozgest.defaultLocale");
  var appLocale = chromeRegistry.getSelectedLocale("global");

  var supportedLocales = properties.GetStringFromName("mozgest.supportedLocales");
  var appLocaleSupported = (","+supportedLocales+",").indexOf( (","+appLocale+",") ) > -1;

  // Ensure we *can* change locales
  if ( !("selectLocaleForPackage" in chromeRegistry) ) {
    // If Firefox selected the wrong locale (bug #258725), explain the workaround
    if (mozgestLocale != appLocale
        && mozgestLocale != defaultLocale
        && appLocaleSupported) {
      alert(navigator.vendor + " selected the wrong language for Mouse Gestures. To work around this\n" +
            "bug, edit your " + navigator.vendor + " shortcut and add the following command line option:\n\n" +
            "\t\t-UILocale " + appLocale + "\n\n" +
            "You have to keep this option until a newer " + navigator.vendor + " release fixes this bug.");
    }
    return;
  }

  // Revert to default (or app locale) if mozgestLocale is not supported
  if ( (","+supportedLocales+",").indexOf( (","+mozgestLocale+",") ) == -1) {
    var revertTo = appLocaleSupported ? appLocale : defaultLocale;
    chromeRegistry.selectLocaleForPackage(revertTo, "mozgest", true);

    if (keepNonAppLocale) {
      mozgestPreferences.setBoolPref("keepNonAppLocale", false);
    }

    bundle = mgLS_LoadLocale(revertTo);
    var message = bundle.GetStringFromName("locale.autoSwitch")
                  + "\n\n"
                  + bundle.GetStringFromName("locale.onRestart");
    promptService.alert(window,
                        bundle.GetStringFromName("mozgest"),
                        message);
    return;
  }

  // Is mozgest not on the app locale, but supports it?
  if (mozgestLocale != appLocale
      && appLocaleSupported
      && !keepNonAppLocale) {
    var doSwitch = true;
    try {
      bundle = mgLS_LoadLocale(appLocale);
    } catch (e) {
      // if an exception occurs, the locale files may be corrupt; do not switch.
      dump("MozGest: Could not load " + appLocale + " texts to offer locale switching.\n");
      doSwitch = false;
    }
    if (doSwitch) {
      var buttonFlags = promptService.BUTTON_POS_0 * promptService.BUTTON_TITLE_YES
                        + promptService.BUTTON_POS_1 * promptService.BUTTON_TITLE_NO;
      var checkbox = {};
      var button = promptService.confirmEx(window,
                                           bundle.GetStringFromName("mozgest"),
                                           bundle.GetStringFromName("locale.offerSwitch"),
                                           buttonFlags,
                                           null,
                                           null,
                                           null,
                                           null,
                                           checkbox);
      if (button == 0) {
        doSwitch = true;
      } else {
        doSwitch = false;
        mozgestPreferences.setBoolPref("keepNonAppLocale", true);
      }
    }
    if (doSwitch) {
      chromeRegistry.installLocale(mgLS_JarBasePath+"/locale/"+appLocale+"/mozgest/", mgLS_InProfile);
      chromeRegistry.selectLocaleForPackage(appLocale, "mozgest", true);
      promptService.alert(window,
                          bundle.GetStringFromName("mozgest"),
                          bundle.GetStringFromName("locale.onRestart"));
      return;
    }
  }
}

function mgLS_LoadLocale(locale) {
  return mgLS_GetBundle(mgLS_JarBasePath
                     + "/locale/"
                     + locale
                     + "/mozgest/mozgest.properties");
}

function mgLS_GetBundle(url) {
  return Components.classes["@mozilla.org/intl/stringbundle;1"].getService()
                   .QueryInterface(Components.interfaces.nsIStringBundleService)
                   .createBundle(url);
}