/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *                                                                                                             ion
 * 1.1 (the "License"); you may not use this file except in compliance with

 * The contents of this file are subject to the Mozilla Public License Vers * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Andy Edmonds <aedmonds@mindspring.com>
 *  Benjamin K. Stuhl <tiriath@yahoo.com>
 *  Brent Schartung <bschartung@gmail.com>
 *  David Illsley <illsleydc@bigfoot.com>
 *  Dorando <mozilla@dorando.at>
 *  HJ van Rantwijk <bugs4HJ@netscape.net>
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *  Martin.T.Kutschker <Martin.T.Kutschker@blackbox.net>
 *  Pavol Vaskovic <pali@pali.sk>
 *  Pekka Aleksi Knuutila <aleksi.knuutila@edu.lahti.fi>
 *  Scott R. Turner <srt@aero.org>
 *  Tim Williamson <chsman@hotmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

//----------------------
//-- Global variables --
//----------------------

var mgContext = null;
var mgContent = null;
var mgGetAutoScroll;
var mgPopupBox;
var mgContextVis = false;

//-----------------
//-- Preferences --
//-----------------

var mgButton = -1;
var mgLeftHanded = false;
var mgContextOnMouseDown = false;
// mouse gesture condition (to be evaluated on event) for more details see mozgestReadPref()
var mgGestureCondition = new String;
var grid; // grid size; minimal gesture has to be 'grid' pixels long
var delay; // delay before aborting gesture
var lmbGestureLimit;
var dragdropDelay;
var rockersEnabled;
var mgWheelRockers;
var mgWheelSensitivity;
var mgWheelRockersAutoRepeat;
var mgStaticRockers;
var mgStaticRockersDelay;
var dTolerance; // tolerance for diagonal movement. see processCoordinates()

// trail settings
var drawTrail;

//---------------------
//-- State variables --
//---------------------

var gestureStartTime;
var gestureInProgress = false;
var mgGestureDone = false;
var mgRockerAborted = false;
var mgRockerInterval;
var mgPreviousSelection = null;
// old coordinates from previous gesture stroke used in processCoordinates()
var mgOldX;
var mgOldY;
var mgStartX = 0;
var mgStartY = 0;
var gridMoves = new Array();
var gesture = new Array();
var localizedGesture = new Array();
var mgString; // array holding localized stroke names
var lastgesture;
// lastGestureTime is time of last gesture stroke, compared with delay and current time
var lastGestureTime;
var lastMoveTime;
// timer used to abort gestures after delay, see processCoordinates()
var mgGestureTimeout;
var mgAllowContextMenu = false;
var mgAutoScrollAborted = false;

var globalOnLink = false; // array that holds a list of all the links traversed during gesture
var globalOnImage = false; // string containing an image href or false
var globalSrcEvent = false; // event which started the active gesture.
var mgLastHoveredElement = null;


//----------------
//-- Components --
//----------------

// used by gesture implementations
const mgkWindowMediator = Components
      .classes["@mozilla.org/appshell/window-mediator;1"]
      .getService(Components.interfaces.nsIWindowMediator);

const mgWWatcher = Components
      .classes["@mozilla.org/embedcomp/window-watcher;1"]
      .getService().QueryInterface(Components.interfaces.nsIWindowWatcher);

// other components
var mgBundle = null; // String bundle for localized strings


//--------------------
//-- Observer class --
//--------------------

function mgObserver()
{
  this.register();
}
mgObserver.prototype = {
  mgPrefTimeout : null,
  observe: function(subject, topic, data) {
    // when MozGest pref was changed, we reinitialize (except sidebar)
    // use a timeout to avoid multiple inits if more than
    // one pref was changed. Not bullet proof, but good enough.
    if (topic.indexOf("nsPref") == 0) {
      if (data == "sideBarSort" ||
          data == "sideBarToolTip" ||
          data == "classicSideBar")
        return;

      clearTimeout(mgObserver.mgPrefTimeout);
      if (data == "enableRockers" || data == "wheelRockers")
        mgObserver.mgPrefTimeout = setTimeout(mozgestInit, 200, true);
      else
        mgObserver.mgPrefTimeout = setTimeout(mozgestInit, 200, false);
    }
    if (topic == "mozgestControl") {
      if (data == "shutdown") {
        window.setTimeout(mgShutdown, 0);
      } else if (data == "wasUninstalled") {
        // If we're in firefox and our sidebar is open, close it. Otherwise,
        // a phantom sidebar will always stay open.
        var sidebarBox = document.getElementById("sidebar-box");
        if (sidebarBox != null
            && sidebarBox.getAttribute("sidebarcommand") == "viewMozgestSidebar") {
          toggleSidebar();
          // re-focus the EM window
          BrowserOpenExtensions("extensions");
        }
      }
    }
    if (topic == "mozgestButtonUp") {

      if (mgWWatcher.activeWindow != window)
          return;

      var oButton = data.substring(0,1)
      var event = document.createEvent("MouseEvents")
      event.initMouseEvent("mouseup", 1, 1, window,
                           1, 0, 0, 0, 0, 0, 0, 0, 0, oButton, window);
      try {
        endGesture(event);
      }
      catch (e) {}
    }
  },
  register: function() {
    try {
      mgPref.QueryInterface(Components.interfaces.nsIPrefBranchInternal)
            .addObserver("", this, false);

      var observerService = Components.classes["@mozilla.org/observer-service;1"]
                            .getService(Components.interfaces.nsIObserverService);
      observerService.addObserver(this, "mozgestControl", false);
      if (mgMouseEvents) {
        observerService.addObserver(this, "mozgestButtonUp", false)
      }
    } catch(ex) {
      mgCommon.dump("MozGest: Failed to initialize observer: " + ex + "\n");
    }
  },
  unregister: function() {
    mgPref.QueryInterface(Components.interfaces.nsIPrefBranchInternal)
          .removeObserver("", this);

    var observerService = Components.classes["@mozilla.org/observer-service;1"]
                          .getService(Components.interfaces.nsIObserverService);
    observerService.removeObserver(this, "mozgestControl");
    try {
      observerService.removeObserver(this, "mozgestButtonUp", false)
    }
    catch (e) {}
  }
}


//--------------------------------
//-- Startup/shutdown functions --
//--------------------------------

function mgStartup(e) {
  // Delay the removal of our handler, so it occurs after this event phase.
  // This avoids a bug that skips other listeners, see
  // http://bugzilla.mozilla.org/show_bug.cgi?id=174320
  setTimeout("window.removeEventListener('load', mgStartup, false);",0);

  mgComponentLoader.initMouseService();

  determineWindowType();
  if (mgWindowType) {
    mgCommon.dump("MozGest: ---- Startup ----\n");
    dockElement("stringbundleset", "stringbundle", "mozgestbundle",
        new Array("src"),
        new Array("chrome://mozgest/locale/mozgest.properties"));
    dockElement("keyset", "key", "mgPrefKey",
        new Array("modifiers",   "key", "command"  ),
        new Array("accel shift", "M",   "mgPrefCmd"));
    dockElement("commandset", "command", "mgPrefCmd",
        new Array("oncommand"),
        new Array("showMgPrefPanel();"));

    // init our observer
    window.mozgestObserver = new mgObserver();

    window.addEventListener("unload", mgShutdown, false);
    mozgestLoadStrings();
    mozgestInit();
  }
}

function mgShutdown(e) {
  mgCommon.dump("MozGest: ---- Shutdown ----\n");
  window.mozgestObserver.unregister();
  removeWindowWatch();
  if (!e) { //http://bugzilla.mozdev.org/show_bug.cgi?id=11567
    undockElement("mozgestbundle");
    undockElement("mgPrefKey");
    undockElement("mgPrefCmd");
  }
  mgStorage.shutdown();

  // Remove this event listener after all other listeners have completed
  window.setTimeout("window.removeEventListener(\"unload\", mgShutdown, false);", 0);
}

function mozgestInit(aBool) {
  // read prefs (or set default for each missing setting)
  mozgestReadPref();

  // turn gestures recognition on/off
  if (mgIsEnabled()) {
    addWindowWatch();
    loadGestureTable(aBool);
  } else {
    removeWindowWatch();
  }
}

function loadGestureTable(aBool) {
  mgCommon.dump("Loading gesture table\n");
  resetGesturesTable();
  mgStorage.initUserRDF();
  mgStorage.readRDFGestureTable("window");
  mgStorage.readRDFGestureTable(mgWindowType);

  // notify the sidebar(s), do this only once if there is more than one window
  if (aBool && mgkWindowMediator.getMostRecentWindow("navigator:browser") == window) {
     Components.classes["@mozilla.org/observer-service;1"]
               .getService(Components.interfaces.nsIObserverService)
               .notifyObservers(null, "mozgestControl", "mappingsUpdated");
  }
}

function mozgestLoadStrings() {
  // load localized string bundle and cache often used strings
  mgBundle = document.getElementById("mozgestbundle");
  mgString = new Array();
  mgString["R"] = mgBundle.getString("abbreviation.right");
  mgString["L"] = mgBundle.getString("abbreviation.left");
  mgString["U"] = mgBundle.getString("abbreviation.up");
  mgString["D"] = mgBundle.getString("abbreviation.down");
  mgString["1"] = mgBundle.getString("abbreviation.d1");
  mgString["3"] = mgBundle.getString("abbreviation.d3");
  mgString["7"] = mgBundle.getString("abbreviation.d7");
  mgString["9"] = mgBundle.getString("abbreviation.d9");
  mgString["gesture"] = mgBundle.getString("g.gesture");
}

function addWindowWatch() {
  mgCommon.dump("MozGest: ---- Get Contentarea ---\n");
  if (document.documentElement.getAttribute("windowtype")=="navigator:browser")
  {  mgContent = mgGetContentArea().mPanelContainer;
     mgGetAutoScroll = "getBrowser().mCurrentBrowser"
  }
  else
  {  mgContent = mgGetContentArea();
     mgGetAutoScroll = "mgGetContentArea()"
  }

  removeWindowWatch();
  mgCommon.dump("MozGest: Adding Listeners\n");
  if (mgContextOnMouseDown &&
      navigator.platform != "Win32" &&
      navigator.platform != "OS/2") {
     window.addEventListener("mousedown", mg_X_ContextDismissal, true);
     window.addEventListener("blur", mg_X_ContextDismissal, true);
  }
  mgContent.addEventListener("mousedown", startGesture, false);
  mgContent.addEventListener("draggesture", onDragGestureEvent, true);
  if (mgWheelRockers && rockersEnabled) {
    mgContent.addEventListener("DOMMouseScroll", mgMousewheelHandler, false);
  }
  window.addEventListener("mouseup", endGesture, false);
  window.addEventListener("keydown", mgAllowContextByKeyPress, true);
  window.addEventListener("mousemove", processCoordinates, true);
  mgContent.addEventListener("contextmenu", mgContextMenuListener, true);
  mgContent.addEventListener("click", mgOnClickHandler, true);
  mgContent.addEventListener("dblclick", mgOnClickHandler, true);
}

function removeWindowWatch() {
  mgCommon.dump("MozGest: Removing Listeners\n");
  window.removeEventListener("mousedown", mg_X_ContextDismissal, true);
  window.removeEventListener("blur", mg_X_ContextDismissal, true);
  mgContent.removeEventListener("mousedown", startGesture, false);
  mgContent.removeEventListener("draggesture", onDragGestureEvent, true);
  mgContent.removeEventListener("DOMMouseScroll", mgMousewheelHandler, false)
  mgContent.removeEventListener("contextmenu", mgContextMenuListener, true)
  window.removeEventListener("mouseup", endGesture, false);
  window.removeEventListener("keydown", mgAllowContextByKeyPress, true);
  window.removeEventListener("mousemove", processCoordinates, true);
  mgContent.removeEventListener("click", mgOnClickHandler, true);
  mgContent.removeEventListener("dblclick", mgOnClickHandler, true);
}


//-----------------------
//-- Integration hooks --
//-----------------------
// (everything needed for co-existing with or disabling regular app functions)

function mgContextMenuListener() {
    addEventListener("popupshowing", mgDisableContextMenu, true);
    setTimeout("removeEventListener('popupshowing', mgDisableContextMenu, true)",0);
}

function mgDisableContextMenu(e) {
    mgContext=e.originalTarget;
    if (!mgAllowContextMenu)
       e.preventDefault();
}

function mgAllowContextByKeyPress(e) {
    mgAllowContextMenu = true;
    mgGestureDone = false;
}

function mg_X_ContextDismissal(e) {
  if (!mgContextVis)
    return;

  try {
    nName = e.originalTarget.nodeName;
    if (nName == "menuitem" || nName == "xul:menuitem" ||
        nName == "menu" || nName == "xul:menu") {
      var mgMnode = e.originalTarget;

      for (mgMnode; mgMnode; mgMnode = mgMnode.parentNode) {
        if (mgMnode == mgContext) {
          mgGestureDone = true;
          return;
          break;
        }
      }
    }
  }
  catch (e) {}
  if (mgPopupBox) {
    mgPopupBox.hidePopup();
    mgGestureDone = true;
  }
  mgContextVis = false;
}

function mgOnClickHandler(e) {
  if (mgGestureDone) {
    mgCommon.dump("MozGest: Stopping " + e.type + " event caused by last gesture.\n");
    e.preventDefault();
    e.stopPropagation();
    return false;
  }

  var node = e.originalTarget;
  if (!node.getAttribute) return null;
  if (!node.hasAttribute("href")) return null;
  var tagname = node.nodeName.toLowerCase();
  var href = node.getAttribute("href");
  if (tagname == "a" && href.indexOf("mozgest://") == 0 && e.button < 2) {
    mgCommon.dump("MozGest: Link click " + href + "\n");
    mgStorage.processURL(href, node.ownerDocument.location);
    e.stopPropagation();
    e.preventDefault();
  }
  return null;
}

function onDragGestureEvent(e) {
  var draggedElement = e.originalTarget.nodeName.toUpperCase();
  if (gestureInProgress && draggedElement != "HTML") {
    if (lastMoveTime-gestureStartTime > dragdropDelay) {
      mgCommon.dump("MozGest: '" + draggedElement
           + "' drag encountered, canceling gesture\n");
      endGesture("drag");
    } else {
      mgCommon.dump("MozGest: canceling '" + draggedElement
           + "' drag event, continuing gesture\n");
      e.stopPropagation();
    }
  }
  if (mgGestureDone)
     e.stopPropagation();
}

//---------------------------------
//-- The gesture recognizer core --
//---------------------------------

function processCoordinates(e){ // e is browser's event object
  if (e.screenX < mgStartX -25 || e.screenX > mgStartX +25 ||
      e.screenY < mgStartY -25 || e.screenY > mgStartY +25) {
    mgRockerAborted = true;
    clearInterval(mgRockerInterval);
  }

  if (!gestureInProgress) return;

  var now = (new Date).getTime();

  if (mgButton == 1 && !mgAutoScrollAborted &&
      (e.screenX != mgStartX || e.screenY != mgStartY)) {
     mgAutoScrollAborted = true;
     if (eval(mgGetAutoScroll).autoscrollEnabled) {
        eval(mgGetAutoScroll).stopScroll();
        return;
     }
     if ( ("isScrolling" in window) ) {
        stopScroll();
        globalOnImage = false;
        return;
     }
  }

  if (drawTrail && !mgNativeTrails && !mgTrails.noContent && mgTrails.trailLength < mgTrails.limit)
     mgTrails.draw(e.screenX, e.screenY, e);

  var g = gesture.join("");
  if (mgGestureCondition == "e.button==0" && (g == "L" || g == "R")
      && (now - gestureStartTime) > lmbGestureLimit) {
    endGesture(null);
  }

  var x_dir = e.clientX - mgOldX;
  var y_dir = e.clientY - mgOldY;
  var x = Math.abs(x_dir);
  var y = Math.abs(y_dir);

  if ( (x >= grid/2 || y >= grid/2) ) { // process each half-grid
    // diagonal movement:
    // dTolerance = 75 means that a movement is recognized as diagonal when
    // x/y or y/x is between 0.25 and 1
    if ( dTolerance != 0 && ( (x/y >= (1-dTolerance/100) && x/y <= 1)
        || (y/x >= (1-dTolerance/100) && y/x <= 1) ) ) {

      if (x_dir < 0 && y_dir > 0) {
        gPush("1");
      } else if (x_dir > 0 && y_dir > 0) {
        gPush("3");
      } else if (x_dir < 0 && y_dir < 0) {
        gPush("7");
      } else if (x_dir > 0 && y_dir < 0) {
        gPush("9");
      }

    }
    // horizontal movement:
    else if (x > y) {
      if (x_dir > 0) {
        gPush("R");
      } else if (x_dir < 0) {
        gPush("L");
      }
    }
    // vertical movement:
    else if (x < y) {
      if (y_dir > 0){
        gPush("D");
      } else if (y_dir < 0){
        gPush("U");
      }
    }
    var statusText = mgString["gesture"] + " " + localizedGesture;
    var mapping = gesturesTable[gesture.join('')];
    if(mapping != null) {
        statusText += " (" + mapping.name + ")";
    }
    mgMsg(statusText);
    lastGestureTime = now;
    if (mgGestureTimeout) { window.clearTimeout(mgGestureTimeout); }
    mgGestureTimeout = window.setTimeout("endGesture(null);", delay);

    mgOldX = e.clientX;
    mgOldY = e.clientY;
  }
  lastMoveTime = now;

  mgExamineHoveredElement(e.originalTarget);
}

function gPush(code) {
  gridMoves.push(code);
  if (gridMoves.length == 2) {
    if (gridMoves[0] == gridMoves[1] || gesture.length == 0) {
      doPush(gridMoves.pop());
    }
    gridMoves.length = 0;
  }
}

function doPush(code) {
  if (gesture[gesture.length-1] != code) {
    gesture.push(code);
    localizedGesture.push(mgString[code]);
  }
  if (gesture.length == 1) resetRocker();
}

function mgExamineHoveredElement(node, inContentCheck) {
  var imgNode = node;
  var CI = Components.interfaces;

  if (inContentCheck) {
    if (mgMouseEvents && rockerCode.length > 1)
      return true;

    globalOnLink = globalOnImage = false;
    var checkNode = node;

    for (checkNode; checkNode; checkNode = checkNode.parentNode)
    {
        var cName = checkNode.nodeName.toLowerCase();

        if (cName == "scrollbar" || cName == "select" ||
            cName == "input" || cName == "textarea" ||
            cName == "textbox" || cName == "object")
          return false;
    }
  }

  for (node; node; node = node.parentNode)
  {
     if (node instanceof CI.nsIDOMHTMLAnchorElement ||
         node instanceof CI.nsIDOMHTMLAreaElement ||
         node instanceof CI.nsIDOMHTMLLinkElement) {
       if (!globalOnLink) {
         globalOnLink = new Array();
         globalOnLinkTemp = new Array();
       }
       if (!(node.href in globalOnLinkTemp)) {
         globalOnLinkTemp[node.href] = node.href;
         globalOnLink.push(node);
         mgCommon.dump("Mozgest: hovered link '" + node.href + "'\n");
       }
       break;
     }
  }

  for (imgNode; imgNode; imgNode = imgNode.parentNode)
  {
     if (!globalOnImage && imgNode instanceof CI.nsIDOMHTMLImageElement) {
       globalOnImage = imgNode;
       mgCommon.dump("Mozgest: found image.\n");
       break;
     }
  }
  return true;
}

// startGesture is called from event listener in bubble phase
function startGesture(e){
  clearInterval(mgRockerInterval);
  var now = (new Date).getTime();
  mgAllowContextMenu = false;
  mgGestureDone = false;
  mgStartX = e.screenX;
  mgStartY = e.screenY;

  // for Autoscroll by skidooer
  if (e.button == 1 && ("_autoScrollMarkerImage" in window) && _autoScrollMarkerImage)
     _autoScrollMarkerImage.addEventListener("mousedown", startGesture, false);

  if (mgExamineHoveredElement(e.originalTarget, true) && !checkForRocker(e)) {
    globalSrcEvent = e;

    if (!gestureInProgress && eval(mgGestureCondition)) {
      // check if it's possible to draw trails
      if (drawTrail)
         mgTrails.shouldDrawTrail(e);

      gestureInProgress = true;
      gestureStartTime = now;
      lastMoveTime = 0;
      mgOldX = e.clientX;
      mgOldY = e.clientY;

      var sel = mgGetSelection();
      if (mgButton == 0 && sel.rangeCount > 0)
        mgPreviousSelection = sel.getRangeAt(0);

      gesture.length = 0; // clear gesture array
      localizedGesture.length = 0; // clear localized gesture array
      lastGestureTime = now;
    }
  }
}

function endGesture(e) {
  releaseRocker(e);
  mgRockerAborted = false;
  mgAutoScrollAborted = false;

  if (gestureInProgress) {
    if (!mgNativeTrails && mgButton == 0)
       window.setTimeout("mgTrails.endTrail()", 1);
    else
       mgTrails.endTrail();
    window.clearTimeout(mgGestureTimeout);
    lastgesture = gesture.join("");

    // check if we've been called via a timeout; see processCoordinates()
    if (e == null) {
      mgCommon.dump("gesture timeouted\n");
      mgMsg(mgBundle.getString("g.aborted"));
      mgGestureDone = true;
    } else if (e == "drag") {
    } else if (lastgesture != ""){
      mgGestureDone = true;
      window.setTimeout(fireGesture, 1, lastgesture);
    } else {
      mgCommon.dump("MozGest: Gesture was too small\n");
    }

    gestureInProgress = false;
    gestureStartTime = false;
  }

  if (e && !mgGestureDone && (e.button == 2 || (navigator.platform.indexOf("Mac") == 0
                                               && e.button == 0 && e.ctrlKey)))
  {
     mgAllowContextMenu = true;

     // ==================== contextmenu on mousedown ============================ //
     if (navigator.platform != "Win32" && navigator.platform != "OS/2") {          //
        var mgContentBox = mgContent.boxObject;                                    //
                                                                                   //
        if (e.screenY >= mgContentBox.screenY &&                                   //
            e.screenY <= mgContentBox.screenY + mgContentBox.height &&             //
            e.screenX >= mgContentBox.screenX &&                                   //
            e.screenX <= mgContentBox.screenX + mgContentBox.width) {              //
                                                                                   //
          document.popupNode = e.target;                                           //
          mgPopupBox = mgContext.boxObject                                         //
                       .QueryInterface(Components.interfaces.nsIPopupBoxObject);   //
                                                                                   //
          if (mgContextOnMouseDown) {                                              //
            if (mgContextVis)                                                      //
              return;                                                              //
                                                                                   //
            if (!mgContext.hasAttribute("mozgestWasHere")) {                       //
              mgContext.addEventListener("popupshown", mgChangeRollup, true);      //
              mgContext.addEventListener("popuphidden", mgChangeRollup, true);     //
              mgContext.setAttribute("mozgestWasHere", true);                      //
            }                                                                      //
          }                                                                        //
                                                                                   //
          mgPopupBox.showPopup(mgContext.ownerDocument.documentElement, mgContext, //
                     e.clientX, e.clientY, "context", "bottomleft", "topleft");    //
                                                                                   //
          mgContextVis = true;                                                     //
        }                                                                          //
     }                                                                             //
     // ========================================================================== //
  }
}

function mgChangeRollup(e) {
  if (e.type == "popupshown") {
    mgTemp = e.target.boxObject
             .QueryInterface(Components.interfaces.nsIPopupBoxObject);

    mgTemp.enableRollup(false);

    if (e.target == mgContext)
      mgContextVis = true;
  }
  else if (e.target == mgContext)
    mgContextVis = false;
}

//---------------------------
//-- Preferences interface --
//---------------------------

function mozgestReadPref(){ // read settings from Preferences interface
  grid = mgGetPref("grid", "Int");
  delay = mgGetPref("delay", "Int");
  lmbGestureLimit = mgGetPref("lmbGestureLimit", "Int");
  dragdropDelay = mgGetPref("dragdropDelay", "Int");
  rockersEnabled = mgGetPref("enableRockers", "Bool");
  mgWheelRockers = mgGetPref("wheelRockers", "Bool");
  mgWheelSensitivity = mgGetPref("wheelSensitivity", "Int");
  mgWheelRockersAutoRepeat = mgGetPref("wheelRockersAutoRepeat", "Bool");
  mgStaticRockers = mgGetPref("staticRockers", "Bool");
  mgStaticRockersDelay = mgGetPref("staticRockersDelay", "Int");
  dTolerance = mgGetPref("diagonalTolerance", "Int");
  mgButton = mgGetPref("mousebutton", "Int");
  mgLeftHanded = mgGetPref("lefthanded", "Bool");
  if (mgLeftHanded)
    mgButton = Math.abs(mgButton - 2);

  // mgGestureCondition is a boolean expression consisting of event object values
  mgGestureCondition = "e.button==" + mgButton;
  if (mgGetPref("modifier.ctrl", "Bool"))
    mgGestureCondition += " && e.ctrlKey";
  if (mgGetPref("modifier.alt", "Bool"))
    mgGestureCondition += " && e.altKey";
  if (mgGetPref("modifier.shift", "Bool"))
    mgGestureCondition += " && e.shiftKey";
  if (navigator.platform == "MacPPC" && mgGetPref("modifier.meta", "Bool"))
    mgGestureCondition += " && e.metaKey";

  drawTrail = mgGetPref("trails.enabled", "Bool");
  mgTrails.width = mgGetPref("trails.width", "Int");
  mgTrails.limit = mgGetPref("trails.length-limit", "Int");
  mgTrails.interval = mgGetPref("trails.interval", "Int");
  mgTrails.color = mgGetPref("trails.color", "Char");
  mgTrails.opacity = mgGetPref("trails.opacity", "Int");
  mgContextOnMouseDown = mgGetPref("experimental.contextOnMouseDown", "Bool");
  mgGetPref("sideBarSort", "Char");
  mgGetPref("sideBarToolTip", "Bool");
  mgGetPref("classicSideBar", "Bool");
}

// Gets a pref setting. If it's missing, set it to a default value.
function mgGetPref(name, type) {
  if ((type != "Bool" && type != "Char" && type != "Int") || !name) {
    return null;
  }
  var mgDefaults, defaultValue, min, max;

  // get the default value. see pref/defaultPrefs.js
  mgDefaults = mgDefaultPrefs.getPref(name);
  defaultValue = mgDefaults[0];
  if (type == "Int") {
     min = mgDefaults[1];
     max = mgDefaults[2];
  }
  var notfound = false;
  var value;
  try {
      value = eval("mgPref.get" + type + "Pref(\"" + name + "\");");
  } catch (e) {
    notfound = true;
  }
  if (notfound || (type == "Int" && (min || max) && (value > max || value < min))) {
    val = (type == "Char") ? ("\"" + defaultValue + "\"") : defaultValue;
    eval("mgPref.set" + type + "Pref(\"" + name + "\", " + val + ");");
    return defaultValue;
  } else {
    return value;
  }
}


//-----------------------
//-- Utility functions --
//-----------------------

function showMgPrefPanel() {
  window.openDialog("chrome://mozgest/content/pref/mozgestPrefWindow.xul",
                    "mozgestprefs", "chrome,centerscreen,resizable,modal");
}

function dockElement(setType, type, id, aNames, aValues) {
  dockElementAt(setType, type, id, aNames, aValues, document.documentElement);
}

function dockElementAt(setType, type, id, aNames, aValues, container) {
  var sets = document.getElementsByTagName(setType);
  var set;
  if (sets && sets.length > 0) {
    set = sets[0];
  } else {
    set = document.createElement(setType);
    container.appendChild(set);
  }
  var element = document.createElement(type);
  element.setAttribute("id", id);
  for (i=0; i < aNames.length; i++) {
    element.setAttribute(aNames[i], aValues[i]);
  }
  set.appendChild(element);
}

function undockElement(id) {
  var node = document.getElementById(id);
  node.parentNode.removeChild(node);
}

function mgGetBuildProperties() {
  return mgGetBundle("chrome://mozgest/content/mgbuild.properties");
}

function mgGetBundle(url) {
  return Components.classes["@mozilla.org/intl/stringbundle;1"].getService()
                   .QueryInterface(Components.interfaces.nsIStringBundleService)
                   .createBundle(url);
}