/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *  Neil <neil@parkwaycc.co.uk>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var dialogMode;
var gestureType;
var gestureInput;
var codeBox;
var appBox;
var wheelBtn;
var wheelDir;
var functionType;
var functionsTree;
var mgBundle;

var resourceURI;
var code;
var fPrefix;
var wType;
var mName;
var bmTree;
var bmSelected;
var bmProps;
var bmPropsDefault = 0;
var bmDeleted = false;
var bmInfo;
var bmImage;
var bmp_attention = "chrome://mozgest/skin/attention.png"
var bmp_placeholder = "chrome://mozgest/skin/placeholder.png"


function bmSelect(e) {
  if (e && e.type == "dblclick") {
    if (!bmProps.disabled)
      document.getElementById("bmMappingName").value = bmInfo.value;

    return;
  }

  var elt = bmTree.view.getResourceAtIndex(e.target.currentIndex);
  var target = mgBMService.Book.GetTarget(elt, mgBMService.Href, true)

  // check for livemarks
  try {
    var check = mgBMService.Book.GetTarget(elt, mgBMService.Type, true);
    check = check.QueryInterface(Components.interfaces.nsIRDFResource).Value.toLowerCase();
    if (check == "http://home.netscape.com/nc-rdf#livemark")
      target = false;
    else {
      var eltParent = bmTree.view.getResourceAtIndex(
                      bmTree.view.getParentIndex(e.target.currentIndex));
      check = mgBMService.Book.GetTarget(eltParent, mgBMService.Type, true);
      check = check.QueryInterface(Components.interfaces.nsIRDFResource).Value.toLowerCase();

      if (check == "http://home.netscape.com/nc-rdf#livemark")
        target = false;
    }
  }
  catch (e) {}

  bmProps.disabled = !target;
  if (target)
    bmSelected = elt.QueryInterface(Components.interfaces.nsIRDFNode).Value;
  else
    bmSelected = "";

  updateInfoBox();
}

function radioSelect() {
  bmPropsDefault = bmProps.selectedIndex;
}

function showTooltip(e, target) {
  if (e.type == "click" && e.button == 0) {
    target.removeAttribute('tooltip');
    document.getElementById('mgToolTip').showPopup(
             document.documentElement, e.screenX,
             e.screenY, 'tooltip', null, null);
  }
  if (e.type == "mouseout" && !target.hasAttribute('tooltip')) {
    document.getElementById('mgToolTip').hidePopup();
    target.setAttribute('tooltip', 'mgToolTip');
  }
}

function updateInfoBox(emptyNew) {
  var mgRow1 = document.getElementById("mgRow1");
  var mgRow2 = document.getElementById("mgRow2");
  var mgRow3 = document.getElementById("mgRow3");
  mgRow1.hidden = mgRow2.hidden = mgRow3.hidden = true;

  if (emptyNew) {
    bmInfo.value =  mgRow2.value = mgBundle.getString("chooseBM");
    mgRow2.hidden = false;
    bmProps.disabled = true;
    return;
  }

  if (bmSelected == "" || bmDeleted) {
    mgRow2.value = mgBundle.getString("chooseBM");
    bmImage.src = bmp_attention;

    if (bmDeleted)
      bmInfo.value = mgRow1.value = mgBundle.getString("unknownBookmark");
    else
      bmInfo.value = mgRow1.value = mgBundle.getString("notValid");

    mgRow1.hidden = mgRow2.hidden = false;
    bmDeleted = false;
    return;
  }

  var bmName = mgBMService.Book.GetTarget(mgBMService.RDFS.GetResource(bmSelected),
                                          mgBMService.Name, true);
  if (bmName)
    bmName = bmName.QueryInterface(Components.interfaces.nsIRDFLiteral).Value
  else
    bmName = mgBundle.getString("noName");

  bmInfo.value = mgRow1.value = bmName;
  mgRow1.value = mgBundle.getString("bmName") + mgRow1.value;
  mgRow1.hidden = false;

  var bmHref = mgBMService.Book.GetTarget(mgBMService.RDFS.GetResource(bmSelected),
                                          mgBMService.Href, true);

  if (bmHref) {
    bmHref = mgBMService.makeURI(bmHref
             .QueryInterface(Components.interfaces.nsIRDFLiteral).Value);

    for (var i = 1; i < bmProps.childNodes.length; i++)
      bmProps.childNodes[i].disabled = false;

    if (bmHref.scheme == "javascript") {
      for (i = 2; i < bmProps.childNodes.length; i++)
        bmProps.childNodes[i].disabled = true;

      bmProps.selectedIndex = 0;
      mgRow2.value = mgBundle.getString("bmBookmarklet");
    }
    else if (bmHref.spec.indexOf("%s") != -1)
      mgRow2.value = mgBundle.getString("bmSearch");
    else
      mgRow2.value = mgBundle.getString("bmBookmark");

    var bmPost = mgBMService.Book.GetTarget(mgBMService.RDFS.GetResource(bmSelected),
                                          mgBMService.Post, true);

    if (bmPost) {
      bmPost = unescape(bmPost.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
      if (bmPost.indexOf("%s") != -1)
        mgRow2.value = mgBundle.getString("bmSearch");
    }

    mgRow2.value = mgBundle.getString("bmType") + mgRow2.value;
    mgRow3.value = mgBundle.getString("bmHref") + bmHref.spec;
    mgRow2.hidden = mgRow3.hidden = false;
  }

  var bmIcon = mgBMService.Book.GetTarget(mgBMService.RDFS.GetResource(bmSelected),
                                          mgBMService.Icon, true);
  if (bmIcon)
    bmImage.src = bmIcon.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
  else
    bmImage.src = bmp_placeholder;
}

function bmInit() {
  // show open in Sidebar for Firefox
  if (mgAppInfo.name == "Firefox")
    bmProps.lastChild.hidden = false;

  bmTree = document.getElementById("mgBookmarksTree");
  bmTree.removeAttribute("hidden");
  updateInfoBox(true);

  // arg[6] == id of bookmark
  // arg[7] == target of bookmark (window, tab, etc.)
  // arg[7] is null if a new gesture is created from bookmark properties
  // but then dialogMode == "New" (handleArguments() in mappings.js)
  if (window.arguments[6] && (window.arguments[7] || dialogMode == "New")) {
    // if the tree is not expanded: be silent!
    try {
      var sel = bmTree.view
                .getIndexOfResource(mgBMService.RDFS.GetResource(window.arguments[6]));
      bmTree.builderView.selection.select(sel);
    }
    catch (e) {}

    bmSelected = window.arguments[6]
    var elt = mgBMService.RDFS.GetResource(bmSelected);
    var target = mgBMService.Book.GetTarget(elt, mgBMService.Href, true);

    // mapping with an unknown(deleted) bookmark
    if (!target)
      bmDeleted = true;

    updateInfoBox();

    // new gesture from bookmark properties -> prefill mappingname
    if (dialogMode == "New" && target) {
      var bmName = mgBMService.Book.GetTarget(elt, mgBMService.Name, true);
      if (bmName)
        mName = bmName.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
    }
  }
}

function initEditor() {
  mgBundle = document.getElementById("mozgestbundle");
  gestureType = document.getElementById("gestureType");
  gestureInput = document.getElementById("gestureInput");
  codeBox = document.getElementById("code");
  appBox = document.getElementById("appearance");
  wheelBtn = document.getElementById("wheelRockerButton");
  wheelDir = document.getElementById("wheelDirection");
  functionType = document.getElementById("functionType");
  functionsTree = document.getElementById("functionsTree");

  // get passed arguments
  dialogMode = window.arguments[0];
  resourceURI = window.arguments[1];
  code = window.arguments[2];
  var appearance = window.arguments[3];
  var selectedFunc = window.arguments[4];
  mName = window.arguments[5];
  var customCode = window.arguments[6];
  var openIn = window.arguments[7];
  fPrefix = window.arguments[8];
  wType = window.arguments[9];

  // set bookmark stuff
  bmInfo = document.getElementById("bmInfo");
  bmImage = document.getElementById("bmImage");
  bmProps = document.getElementById("bmProps");
  bmSelected = "";

  if (wType != "browser" || dialogMode == "Import")
    mgBMService.enabled = false;

  if (mgBMService.enabled) {
    document.getElementById("miBookmark").removeAttribute("hidden");

    if (openIn)
      bmPropsDefault = openIn;

    bmProps.selectedIndex = bmPropsDefault;
    bmInit();
  }

  initDirectionCodes();

  var docTitle = mgBundle.getString(dialogMode + "MappingWindow")
                 + " - " + document.documentElement.getAttribute("mg" + wType);
  document.title = docTitle;                                //gecko 1.8
  document.documentElement.setAttribute("title", docTitle); //gecko < 1.8

  // determine gesture type
  if (code.substr(0, 1) == ":") {
    var a = code.substr(1, 1);
    var b = code.substr(2, 1);
    if (!isNaN(b)) {
      gestureType.selectedIndex = 1;
      document.getElementById("rocker1").value = a;
      document.getElementById("rocker2").value = b;
    } else {
      gestureType.selectedIndex = 2;
      wheelBtn.value = a;
      wheelDir.selectedIndex = (b == "+") ? 1 : 0;
    }
  } else {
    codeBox.value = code;
    appBox.value = appearance;
  }
  updateTypeDeck();

  // fill function list
  var ftChildren = document.getElementById("ftChildren");
  var dsFunc = mgStorage.RDF.GetDataSourceBlocking("chrome://mozgest/content/functions.rdf");
  var functionList = Components.classes['@mozilla.org/rdf/container;1']
                           .createInstance()
                           .QueryInterface(Components.interfaces.nsIRDFContainer);
  try {
    functionList.Init(dsFunc, mgStorage.RDF.GetResource("urn:mozgest:functions"));
  } catch (e) {
    mgCommon.dump("MozGest: Could not init functionList. " + e + "\n");
  }
  var ftRows = 0;
  var selFuncRow = -1;
  var funcEnum = functionList.GetElements();
  while (funcEnum.hasMoreElements()) {
    var func = funcEnum.getNext()
               .QueryInterface(Components.interfaces.nsIRDFResource);
    var fName = mgStorage.getProperty(dsFunc, func, "func");
    var fSupports = ","+mgStorage.getProperty(dsFunc, func, "supports")+",";
    if (fName.indexOf("mg" + fPrefix + "_") == 0
        || fName.indexOf("mgW_") == 0
        || fSupports.indexOf(","+wType+",") != -1) {
      addTreeRow(ftChildren, new Array(fName, mgBundle.getString(fName)));
      if (fName == selectedFunc) {
        selFuncRow = ftRows;
      }
      ftRows++;
    }
  }

  // switch to custom mode or show selected function
  if (selFuncRow >= 0) {
    functionsTree.contentView.selection.select(selFuncRow);
  } else if (customCode) { // must be non-null, non-empty string

    if (customCode.indexOf("rdf:") == 0) {
       document.getElementById("bmMappingName").value = mName;
       functionType.selectedIndex = 2;
    }
    else {
       document.getElementById("custom").value = customCode;
       document.getElementById("mappingName").value = mName;
       functionType.selectedIndex = 1;
    }
  }
  updateFunctionDeck();

  if (code == "UUUUUU") { //it's a patch disable some elements.
    document.getElementById("isPatch").setAttribute("disabled", true);
  }
}

function updateTypeDeck() {
  document.getElementById("gestureTypeDeck").selectedIndex = gestureType
                                                             .selectedIndex;
}

function updateFunctionDeck() {
  document.getElementById("functionDeck").selectedIndex = functionType
                                                          .selectedIndex;
}

function updateSecondRocker() {
  var first = document.getElementById("rocker1").value;
  for (i=0; i < 3; i++) {
    var si = document.getElementById("second"+i);
    if (i==first) {
      si.setAttribute("disabled", true);
    } else {
      si.removeAttribute("disabled");
    }
  }
  var r2 = document.getElementById("rocker2");
  if (r2.value == first && first != -1) {
    r2.value = -1;
  }
}

function saveMapping() {
  // ignore enter-keypresses when in textarea (= multiline textbox)
  // so user can enter newlines.
  // needed for seamonkey - obsolete for fb0.6, but doesn't hurt
  if (document.commandDispatcher.focusedElement instanceof
      Components.interfaces.nsIDOMHTMLTextAreaElement) {
    return false;
  }

  var code = codeBox.value;
  var appearance = appBox.value;
  var noCheck = false;
  //it's a patch:
  if (mgMappingLocalizer.deLocalize(code) == "UUUUUU" &&
      functionType.selectedIndex == 1) {
    appearance = "";
    noCheck = true;
  }

  if (!noCheck) {
    if (gestureType.selectedIndex == 0) {
      var stdCode = mgMappingLocalizer.deLocalize(code);
      var stdApp = mgMappingLocalizer.deLocalize(appearance);
      if (!stdCode.match(/^\*{0,1}[1379DLUR]+$/)
          || mgStorage.compactCode(stdCode) != stdCode) {
        alert(mgBundle.getString("enterGesture"));
        return false;
      }
      if (stdApp && mgStorage.compactCode(stdApp) != stdCode) {
        alert(mgBundle.getString("invalidAppearance"));
        return false;
      }

    } else if (gestureType.selectedIndex == 1) {
      var a = document.getElementById("rocker1").value;
      var b = document.getElementById("rocker2").value;
      if (a == -1 || b == -1) {
        alert(mgBundle.getString("chooseRockerButtons"));
        return false;
      }
      code = ":" + a + b;
    } else if (gestureType.selectedIndex == 2) {
      var wb = wheelBtn.value;
      var wd = wheelDir.selectedIndex;
      if (wd == -1 || wb == -1) {
        alert(mgBundle.getString("chooseWheelDirBtn"));
        return false;
      }
      code = ":" +  wb + ((wd == 1) ? "+" : "-");
    }
  }

  var name;
  var func = "";
  var custom = "";
  var bmOpenIn = false;

  if (functionType.selectedIndex == 1) {
    name = document.getElementById("mappingName").value;
    if (name == "") {
      alert(mgBundle.getString("enterMappingName"));
      return false;
    }
    custom = document.getElementById("custom").value;
    if (custom == "") {
       alert(mgBundle.getString("chooseFunction"));
       return false;
    }
  }
  else if (functionType.selectedIndex == 2) {  // bookmark mapping
    name = document.getElementById("bmMappingName").value;
    if (name == "") {
      alert(mgBundle.getString("enterMappingName"));
      return false;
    }

    custom = bmSelected;
    bmOpenIn = bmProps.selectedIndex.toString();

    if (custom == "") {
      alert(mgBundle.getString("chooseBM"));
      return false;
    }
  }
  else {
    var row = functionsTree.contentView.selection.currentIndex;
    if (row == -1) {
      alert(mgBundle.getString("chooseFunction"));
      return false;
    }

    if ("columns" in functionsTree) {
       func = functionsTree.view.getCellText(row, functionsTree.columns["ftFuncCol"]);
    }
    else {
       func = functionsTree.treeBoxObject.view.getCellText(row, "ftFuncCol");
    }

    name = mgBundle.getString(func);
  }
  var owner = (dialogMode == "Import") ? window.opener.mgStorage
                                       : window.opener;

  return owner.receiveEditedMapping(resourceURI, code, appearance,
                                    func, name, custom, bmOpenIn, wType);
}

function recognizeGesture() {
  window.openDialog("chrome://mozgest/content/pref/recognize.xul",
                    "mozgest:recognize", "chrome,centerscreen,modal=yes");
}

function receiveGesture(code) {
  codeBox.value = mgMappingLocalizer.localize(code);
  appBox.value = "";
}