/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var mgMappingLocalizer = {
  dict : null,
  reverse : null,
  bundle : null,

  init : function() {
    // initialize localization dictionary
    var srv = Components.classes["@mozilla.org/intl/stringbundle;1"].getService()
              .QueryInterface(Components.interfaces.nsIStringBundleService);
    this.bundle = srv.createBundle("chrome://mozgest/locale/mozgest.properties");

    this.dict = new Array();
    this.dict["R"] = this.bundle.GetStringFromName("abbreviation.right");
    this.dict["L"] = this.bundle.GetStringFromName("abbreviation.left");
    this.dict["U"] = this.bundle.GetStringFromName("abbreviation.up");
    this.dict["D"] = this.bundle.GetStringFromName("abbreviation.down");
    this.dict["1"] = this.bundle.GetStringFromName("abbreviation.d1");
    this.dict["3"] = this.bundle.GetStringFromName("abbreviation.d3");
    this.dict["7"] = this.bundle.GetStringFromName("abbreviation.d7");
    this.dict["9"] = this.bundle.GetStringFromName("abbreviation.d9");

    this.reverse = new Array();
    for (var loc in this.dict) {
      this.reverse[this.dict[loc]] = loc;
    }
  },

  localize : function(orig) {
    if(!this.dict) this.init();
    return this.convert(orig, this.dict);
  },

  deLocalize : function(localized) {
    if(!this.dict) this.init();
    return this.convert(localized, this.reverse);
  },

  convert : function(str, table) {
    if (!str) return "";
    if (str.substring(0,1) == ":") return str;
    var trans = "";
    for (var i = 0; i < str.length; i++) {
      var o = str.substring(i, i+1);

      if(o != "*" && table[o]) {
        trans = trans + table[o];
      } else {
        trans = trans + o;
      }
    }
    return trans;
  },

  getString : function(aName) {
    if(!this.bundle) this.init();
    return this.bundle.GetStringFromName(aName);
  }
}