/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var treeDS;
var mappingsTree;
var typesTree;
var tChildren;
var dmTree;
var mappingsContainer;
var defContainer;
var curType;
var curTypeLabel;
var typePrefix = new Array();
var mgBundle;

function initMappingsWindow() {
  // get all elements we'll work with
  mgCommon.dump("Welcome to mappings")
  mgBundle = document.getElementById("mozgestbundle");
  mappingsTree = document.getElementById("mappingstree");
  typesTree = document.getElementById("typesTree");
  dmTree = document.getElementById("defaultmappingstree");

  initDirectionCodes();
  treeDS = new mgMappingsDS();
  mappingsTree.database.AddDataSource(treeDS);

  tChildren = document.getElementById("typestreechildren");
  var dsTypes = mgStorage.RDF.GetDataSourceBlocking("chrome://mozgest/content/windowTypes.rdf");

  // pref-common.js
  readPackages();

  for (var i = 0; i < mgPackages.length; i++) {
    if (mgPackages[i][0] == "separator")
      tChildren.appendChild(document.createElement("treeseparator"));
    else {
      typePrefix[mgPackages[i][0]] = mgStorage.getProperty(dsTypes, mgPackages[i][1], "prefix");
      addTreeRow(tChildren, new Array(mgStorage.getProperty(dsTypes, mgPackages[i][1], "label"),
                            mgPackages[i][0]));
    }
  }
  // this is called when window is opened for direct editing
  // (Sidebar and bmPropsOverlay for now)
  if (("arguments" in window)) {
    if (window.arguments[0].indexOf("directEdit") == 0) {
      var ynode = typesTree.getElementsByAttribute("label",
                            window.arguments[2])[0].parentNode.parentNode;

      typesTree.contentView.selection.select(typesTree.view.getIndexOfItem(ynode));
      showMappingsFor(window.arguments[2]);
      setTimeout(handleArguments, 0, window.arguments[0], window.arguments[1]);
    }
  }
  else {
    var winMed = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                .getService().QueryInterface(Components.interfaces.nsIWindowMediator);

    var winEnum = winMed.getZOrderDOMWindowEnumerator(null, true);
    var winFound = false;

    while (winEnum.hasMoreElements()) {
      var win = winEnum.getNext();
      if ("mgWindowType" in win) {
        ynode = typesTree.getElementsByAttribute("label",
                win.mgWindowType)[0].parentNode.parentNode;

        typesTree.contentView.selection.select(typesTree.view.getIndexOfItem(ynode));
        showMappingsFor(win.mgWindowType);
        winFound = true;
        break;
      }
    }
    if (!winFound) {
      typesTree.contentView.selection.select(0);
      showMappingsFor("window");
    }
  }
  typesTree.addEventListener("select", showSelectedComponent, false);
}

function handleArguments(editMode, res) {
  if (editMode == "directEdit") {
    var mIndex = mappingsTree.builderView
                 .getIndexOfResource(mgStorage.RDF.GetResource(res));
    mappingsTree.builderView.selection.select(mIndex);
    mappingsTree.boxObject.ensureRowIsVisible(mIndex)
    mappingsTree.focus();
    editMapping(true);
  }
  else
    openEditMappingWindow("New", "", "", "", "", "", res, 0);
}

function showSelectedComponent() {
  var row = typesTree.contentView.selection.currentIndex;
  if (!typesTree.treeBoxObject.view.isSeparator(row)) {
    if ("columns" in typesTree) {
      showMappingsFor(typesTree.view.getCellText(row, typesTree.columns["typeCol"]));
    }
    else {
      showMappingsFor(typesTree.treeBoxObject.view.getCellText(row, "typeCol"));
    }
  }
}

function showMappingsFor(component) {
  mappingsTree.ref = "urn:mozgest:mappings:" + component;
  mappingsTree.builder.rebuild();

  var dsDefault = mgStorage.getDefaultMappings();
  mappingsContainer = mgStorage.newContainer();
  defContainer = mgStorage.newContainer();
  var containerNode = mgStorage.RDF.GetResource(mappingsTree.ref);
  try {
    mappingsContainer.Init(treeDS, containerNode);
  }
  catch (e) {
    // create mappings container in treeDS...
    mgStorage.RDFCUtils.MakeSeq(treeDS, containerNode);
    mappingsContainer.Init(treeDS, containerNode);
    // ... and in user store to make sure treeDS can copy mappings back
    mgStorage.RDFCUtils.MakeSeq(mgStorage.getUserRDF(), containerNode);
    mgStorage.newContainer().Init(mgStorage.getUserRDF(), containerNode);
  }
  try {
    defContainer.Init(dsDefault, containerNode);
  }
  catch (e) {
    alert("MozGest: Fatal error - could not init defaultMappingsContainer.\n" + e);
  }
  curType = component;
  curTypeLabel = typesTree.contentView.getItemAtIndex(typesTree.currentIndex)
                 .firstChild.firstChild.getAttribute("label");
  showRemovedDefaults();
}

function showRemovedDefaults() {
  var dsDefault = mgStorage.getDefaultMappings();
  var mCode;
  var mFunction;
  var mapping;

  // determine which mappings are (will be) installed
  var installed = new Array();
  var mappingsEnum = mappingsContainer.GetElements();
  while (mappingsEnum.hasMoreElements()) {
    mapping = mappingsEnum.getNext();
    mCode = mgStorage.getProperty(treeDS, mapping, "code");
    mFunction = mgStorage.getProperty(treeDS, mapping, "function");

    // default mappings have non-localized codes, so we must deLocalize here
    installed[mgMappingLocalizer.deLocalize(mCode) + "~" + mFunction] = true;
  }

  // clear default mapping tree
  tChildren = document.getElementById("defMappingRows");
  while(tChildren.firstChild) {
    tChildren.removeChild(tChildren.firstChild);
  }

  // determine default mappings that will be missing & display them
  var defaultsEnum = defContainer.GetElements();
  while (defaultsEnum.hasMoreElements()) {
    mapping = defaultsEnum.getNext()
              .QueryInterface(Components.interfaces.nsIRDFResource);
    mCode = mgStorage.getProperty(dsDefault, mapping, "code");
    mFunction = mgStorage.getProperty(dsDefault, mapping, "function");
    if (!((mCode + "~" + mFunction) in installed)) {
      var funcName = mgStorage.getProperty(dsDefault, mapping, "function");
      addTreeRow(tChildren, new Array(mgMappingLocalizer.localize(mCode),
                                      mgBundle.getString(funcName),
                                      mapping.Value));
    }
  }
}

function onAcceptMappings() {
  treeDS.applyChanges();
  return true;
}


/*** mapping actions ***/

function newMapping() {
  openEditMappingWindow("New", "", "", "", "", "", "", "");
}

function editMapping(passURI) {
  var node = mappingsTree.builderView.getResourceAtIndex(mappingsTree.currentIndex);
  // handle old keyword settings
  if (decodeURI(mgStorage.getProperty(treeDS, node, "custom")).indexOf("mozgest_iKey:") == 0)
    openEditMappingWindow("Edit",
                          (passURI) ? node.Value : "",
                          mgStorage.getProperty(treeDS, node, "code"),
                          mgStorage.getProperty(treeDS, node, "appearance"),
                          "",
                          mgStorage.getProperty(treeDS, node, "name"),
                          "rdf:xxxxx", "", "", "browser");
  else
    openEditMappingWindow("Edit",
                          (passURI) ? node.Value : "",
                           mgStorage.getProperty(treeDS, node, "code"),
                           mgStorage.getProperty(treeDS, node, "appearance"),
                           mgStorage.getProperty(treeDS, node, "function"),
                           mgStorage.getProperty(treeDS, node, "name"),
                           decodeURI(mgStorage.getProperty(treeDS, node, "custom")),
                           mgStorage.getProperty(treeDS, node, "bmOpenIn"));
}

function openEditMappingWindow(mode, uri, code, appearance, func, name, custom, openIn) {
  window.openDialog("chrome://mozgest/content/pref/edit-mapping.xul",
                    "mozgest:editmapping", "chrome,centerscreen,modal=yes",
                    mode, uri, code, appearance, func, name, custom, openIn,
                    typePrefix[curType], curType, curTypeLabel);
}

function receiveEditedMapping(uri, code, appearance,
                              func, name, custom, bmOpenIn, aWindowType) {

  if (!mgStorage.duplicateCheck(code, mappingsContainer, uri, treeDS)) {
    return false;
  }
  if (uri != "") {
    mgStorage.deleteNode(mgStorage.RDF.GetResource(uri), treeDS);
  }

  var node = mgStorage.RDF.GetAnonymousResource();
  mgStorage.saveMapping(treeDS, mappingsContainer, node,
                        code, appearance, func,
                        encodeURI(custom), bmOpenIn, name);

  showRemovedDefaults();
  return true;
}

function removeMapping() {
  mgStorage.deleteNode(mappingsTree.builderView.getResourceAtIndex(mappingsTree.currentIndex),
                       treeDS);
  showRemovedDefaults();
}

function publishMapping() {
  var node = mappingsTree.builderView.getResourceAtIndex(mappingsTree.currentIndex);
  window.openDialog("chrome://mozgest/content/pref/publishMapping.xul",
                    "mozgest:publishmapping", "chrome,centerscreen,modal=yes",
                    curType,
                    mgStorage.getProperty(treeDS, node, "code"),
                    mgStorage.getProperty(treeDS, node, "appearance"),
                    mgStorage.getProperty(treeDS, node, "function"),
                    mgStorage.getProperty(treeDS, node, "name"),
                    decodeURI(mgStorage.getProperty(treeDS, node, "custom")));
}


/*** commands for default mappings ***/

function addDefault() {
  // determine RDF node (get URN from dmResCol column)
  var row = dmTree.contentView.selection.currentIndex;
  var locCode;
  if ("columns" in dmTree) {
    locCode = dmTree.view.getCellText(row, dmTree.columns["dmCodeCol"]);
  }
  else {
    locCode = dmTree.treeBoxObject.view.getCellText(row,"dmCodeCol");
  }

  if (!mgStorage.duplicateCheck(locCode, mappingsContainer, "", treeDS)) {
    return false;
  }

  var urn;
  if ("columns" in dmTree) {
    urn = dmTree.view.getCellText(row, dmTree.columns["dmResCol"]);
  }
  else {
    urn = dmTree.treeBoxObject.view.getCellText(row, "dmResCol");
  }

  var sourceNode = mgStorage.RDF.GetResource(urn);

  // read the mapping's data
  var dsDefault = mgStorage.getDefaultMappings();
  var mFunction = mgStorage.getProperty(dsDefault, sourceNode, "function");
  var mAppearance = mgStorage.getProperty(dsDefault, sourceNode, "appearance");

  // create new node for treeDS (with localized data)
  var newNode = mgStorage.RDF.GetAnonymousResource();
  mgStorage.saveMapping(treeDS, mappingsContainer, newNode,
                        locCode, mgMappingLocalizer.localize(mAppearance),
                        mFunction, "", "", mgMappingLocalizer.getString(mFunction));
  showRemovedDefaults();
  return true;
}

function updateButtons(tree, buttons) {
  buttons.setAttribute("disabled", tree.currentIndex != -1 ? false : true);
  if (buttons.id == "editButtons") {
    try {
      var mNode = mappingsTree.builderView.getResourceAtIndex(tree.currentIndex);
      var mOpenIn = mgStorage.getProperty(treeDS, mNode, "bmOpenIn");
      // do not try to publish bookmark mappings
      document.getElementById("publishButton").disabled = mOpenIn ? true : false;
    }
    catch (e) {}
  }
}