/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var mgMappingsDS = function() {
  this.init();
}

mgMappingsDS.prototype = {
  mgLocalized : true,
  ds : null,
  source : null,
  loc : null,
  deletedNodes : new Array(),  // URN strings of all deleted nodes
  addedNodes : new Array(),    // URN strings of all added nodes

  init : function() {
    this.ds = Components.classes['@mozilla.org/rdf/datasource;1?name=in-memory-datasource']
              .createInstance(Components.interfaces.nsIRDFDataSource);

    // store a reference to our localizer (needed when window is closing)
    this.loc = mgMappingLocalizer;

    this.source = mgStorage.getUserRDF();

    this.copyUserStore();
  },

  copyUserStore : function() {
    var elements = this.source.GetAllResources();
    while (elements.hasMoreElements()) {
      var el = elements.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
      // only process Seqs
      if(mgStorage.RDFCUtils.IsSeq(this.source, el)) {
        var seqRes = el;
        var sourceSeq = mgStorage.newContainer();
        sourceSeq.Init(this.source, el);
        var targetSeq = mgStorage.newContainer();
        try {
          targetSeq.Init(this.ds, seqRes);
        } catch (e) {
          mgStorage.RDFCUtils.MakeSeq(this.ds, seqRes);
          targetSeq.Init(this.ds, seqRes);
        }

        var mappingsEnum = sourceSeq.GetElements();
        while (mappingsEnum.hasMoreElements()) {
          var mapping = mappingsEnum.getNext()
                        .QueryInterface(Components.interfaces.nsIRDFResource);
          this.loadMapping(mapping, targetSeq);
        }
      }
    }
  },

  // copies a mapping from userstore to memory datasource, while localizing
  // function names & codes. note that the mapping has the same URN as in the
  // userstore to make back-synchronization (see applyChanges) easier
  loadMapping : function(aMapping, aTargetSeq) {
    // get original values
    var oCode = mgStorage.getProperty(this.source, aMapping, "code");
    var oApp = mgStorage.getProperty(this.source, aMapping, "appearance");
    var oFunc = mgStorage.getProperty(this.source, aMapping, "function");
    var oCustom = mgStorage.getProperty(this.source, aMapping, "custom");
    var oName = mgStorage.getProperty(this.source, aMapping, "name");
    var oBMopen = mgStorage.getProperty(this.source, aMapping, "bmOpenIn");

    if (oFunc == null || mgStorage.functionKnown(oFunc)) {
      // localize movement code (excluding rockers)
      var locCode;
      if (oCode.substring(0,1) == ":") {
        locCode = oCode;
      } else {
        locCode = this.loc.localize(oCode);
      }
      // add mapping to memory datasource
      mgStorage.saveMapping(this.ds, aTargetSeq, aMapping,
                            locCode, this.loc.localize(oApp), oFunc,
                            oCustom, oBMopen, oName || this.loc.getString(oFunc));
    } else {
      mgCommon.dump(oFunc + " not supported. mapping not loaded, scheduled for deletion.\n");
      this.mindDeleted(aMapping);
    }
  },

  mindAdded : function(aNode) {
    this.addedNodes[this.addedNodes.length] = aNode;
  },

  mindDeleted : function(aNode) {
    for (var i = 0; i < this.addedNodes.length; i++) {
      if (this.addedNodes[i] && this.addedNodes[i].Value == aNode.Value) {
        this.addedNodes[i] = null;
        return;
      }
    }
    this.deletedNodes[this.deletedNodes.length] = aNode;
  },

  applyChanges : function() {
    for (var i = 0; i < this.addedNodes.length; i++) {
      if (this.addedNodes[i]) {
        this.saveMapping(this.addedNodes[i]);
      }
    }
    for (i = 0; i < this.deletedNodes.length; i++) {
      mgStorage.deleteNode(this.deletedNodes[i], this.source);
    }
  },

  // saves a mapping to the userstore, while deLocalizing it
  saveMapping : function(aMapping) {
    // get original values
    var code = mgStorage.getProperty(this.ds, aMapping, "code");
    var app = mgStorage.getProperty(this.ds, aMapping, "appearance");
    var func = mgStorage.getProperty(this.ds, aMapping, "function");
    var custom = mgStorage.getProperty(this.ds, aMapping, "custom");
    var bmOpen = mgStorage.getProperty(this.ds, aMapping, "bmOpenIn");
    var name = mgStorage.getProperty(this.ds, aMapping, "name");

    // delocalize movement code (excluding rockers)
    var stdCode;
    if (code.substring(0,1) == ":") {
      stdCode = code;
    } else {
      stdCode = this.loc.deLocalize(code);
    }

    // determine the mapping's parent container
    var container = null;
    var arcs = this.ds.ArcLabelsIn(aMapping);
    while(arcs.hasMoreElements()) {
      var arc = arcs.getNext();
      var parent = this.ds.GetSource(arc, aMapping, true);
      if (mgStorage.RDFCUtils.IsContainer(this.ds, parent)) {
        container = mgStorage.newContainer();
        try {
          container.Init(this.source, parent);
        } catch (e) {
          alert("MozGest fatal error (mappingsDS.saveMapping):\n" + e + "\n");
          return;
        }
      }
    }
    // save mapping to userstore
    mgStorage.saveMapping(this.source, container, aMapping,
                          stdCode, this.loc.deLocalize(app), func,
                          custom, bmOpen, custom ? name : "");
  },

  // nsIRDFDatasource wrapper implementation

  GetSource : function(aProperty, aTarget, aTruthValue) {
    return this.ds.GetSource(aProperty, aTarget, aTruthValue);
  },
  GetSources : function(aProperty, aTarget, aTruthValue) {
    return this.ds.GetSources(aProperty, aTarget, aTruthValue);
  },
  GetTarget : function(aSource, aProperty, aTruthValue) {
    return this.ds.GetTarget(aSource, aProperty, aTruthValue);
  },
  GetTargets: function(aSource, aProperty, aTruthValue) {
    return this.ds.GetTargets(aSource, aProperty, aTruthValue);
  },
  HasAssertion: function(aSource, aProperty, aTarget, aTruthValue) {
    return this.ds.HasAssertion(aSource, aProperty, aTarget, aTruthValue);
  },
  AddObserver: function(aObserver) {
    return this.ds.AddObserver(aObserver);
  },
  RemoveObserver: function(aObserver) {
    return this.ds.RemoveObserver(aObserver);
  },
  ArcLabelsIn: function(aNode) {
    return this.ds.ArcLabelsIn(aNode);
  },
  hasArcOut: function(aSource, aArc) {
    return this.ds.hasArcOut(aSource, aArc);
  },

  Assert: function(aSource, aProperty, aTarget, aTruthValue) {
    return this.ds.Assert(aSource, aProperty, aTarget, aTruthValue);
  },
  Unassert: function(aSource, aProperty, aTarget) {
    return this.ds.Unassert(aSource, aProperty, aTarget);
  },
  Change: function(aSource, aProperty, aOldTarget, aNewTarget) {
    return this.ds.Change(aSource, aProperty, aOldTarget, aNewTarget);
  },
  Move: function(aOldSource, aNewSource, aProperty, aTarget) {
    return this.ds.Move(aOldSource, aNewSource, aProperty, aTarget);
  },

  ArcLabelsOut: function(aSource) {
    return this.ds.ArcLabelsOut(aSource);
  },
  GetAllResources : function() {
    return this.ds.GetAllResources();
  },
  IsCommandEnabled: function(aSources, aCommand, aArguments) {
    return this.ds.IsCommandEnabled(aSources, aCommand, aArguments);
  },
  DoCommand: function(aSources, aCommand, aArguments) {
    return this.ds.DoCommand(aSources, aCommand, aArguments);
  },
  GetAllCmds: function(aSource) {
    return this.ds.GetAllCmds(aSource);
  },
  hasArcIn: function(aNode, aArc) {
    return this.ds.hasArcIn(aNode, aArc);
  },

  beginUpdateBatch: function() {
  },
  endUpdateBatch: function() {
  }
}