/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var mgPackages = new Array();

function ensureBetween(elt) {
    var newVal;
    var def = elt.mgDefaults[0];
    var min = elt.mgDefaults[1];
    var max = elt.mgDefaults[2];

    if (isNaN(elt.value))
      newVal = def;
    else if (elt.value < def)
      newVal = min;
    else
      newVal = max;

    var bundle = document.getElementById("mozgestbundle");
    var m = bundle.getString("mustBeBetween");
    m = m.replace(/MAX/, max);
    m = m.replace(/MIN/, min);
    m = m.replace(/DEF/, newVal);
    elt.value = newVal;
    var pNode = elt;
    try {
      while (pNode.nodeName != "tabpanel")
        pNode = pNode.parentNode;

      document.getElementById("mgTabBox").selectedIndex = pNode.getAttribute("mgPN");
    }
    catch (e) {}
    alert(document.getElementsByAttribute("for", elt.id)[0].value+"\n\n" + m);
}

/* fill mgPackages with windowtypes supported by the app and remove unwanted separators.
   Called from mappings.js and sidebar.js */

function readPackages() {
  var dsTypes = mgStorage.RDF.GetDataSourceBlocking("chrome://mozgest/content/windowTypes.rdf")
  var typesList = Components.classes['@mozilla.org/rdf/container;1']
                  .createInstance()
                  .QueryInterface(Components.interfaces.nsIRDFContainer);
  try {
    typesList.Init(dsTypes, mgStorage.RDF.GetResource("urn:mozgest:windows:list"));
  }
  catch (e) {}

  var typesEnum = typesList.GetElements();
  var lastPackage = "";
  var packageExists = false;
  mgPackages = new Array();

  const chromeRegistry = Components.classes["@mozilla.org/chrome/chrome-registry;1"]
                         .getService(Components.interfaces.nsIXULChromeRegistry);

  while (typesEnum.hasMoreElements()) {
    var type = typesEnum.getNext()
               .QueryInterface(Components.interfaces.nsIRDFResource);

    var curPackage = mgStorage.getProperty(dsTypes, type, "package");
    if (curPackage != lastPackage && curPackage != null) {
      packageExists = false;
      var packages = curPackage.split("|");
      for (var i = 0; i < packages.length && !packageExists; i++) {
        try {
          chromeRegistry.getSelectedLocale(packages[i]);
          packageExists = true;
        }
        catch (e) {}
      }
      lastPackage = curPackage;
    }
    if (packageExists || curPackage == null) {
      var cur = mgPackages[mgPackages.length] = new Array();
      if (mgStorage.getProperty(dsTypes, type, "wtype")) {
        cur[0] = mgStorage.getProperty(dsTypes, type, "wtype");
        cur[1] = type;
      }
      if (mgStorage.getProperty(dsTypes, type, "separator"))
        cur[0] = "separator";
    }
  }
  //romove unwanted separators
  for (i = 0; i < mgPackages.length; i++) {
    if (mgPackages[i][0] == "separator") {
      try {
        if (mgPackages[i+1][0] == "separator")
          mgPackages.splice(i, 1)
      }
      catch (e) {}
    }
  }
  //romove the last "standalone" separator
  if (mgPackages[mgPackages.length-1][0] == "separator")
    mgPackages.pop();
}

/* convenience functions for tree handling */

function addTreeRow(treechildren, args) {
  var ti = document.createElement("treeitem");
  var row = document.createElement("treerow");
  for(var i = 0; i < args.length; i++) {
    var cell = document.createElement("treecell");
    cell.setAttribute("label", args[i]);
    row.appendChild(cell);
  }
  ti.appendChild(row);
  treechildren.appendChild(ti);
}