/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Chase Tingley <tingley@sundell.net>
 *  David Perry <d.perry@utoronto.ca>
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *  Pavol Vaskovic <pali@pali.sk>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var lmbOptionLabel, rmbOptionLabel;
var uninstallTestOnly = false;

function mgInitPrefPanel() {
  for (var i = 0; i < eltIDs.length; i++) {
    var curEl = document.getElementById(eltIDs[i]);
    var prefstring = curEl.getAttribute("mgPrefString");
    var preftype = curEl.getAttribute("mgPrefType");
    curEl.mgDefaults = mgDefaultPrefs.getPref(prefstring.substring(8));
    try {
      switch(preftype) {
        case "int":
          curEl.value = mgPrefRoot.getIntPref(prefstring);
          curEl.addEventListener("input", function (){mgCheckIntPref(this)}, true);
          break;
        case "bool":
          curEl.checked = mgPrefRoot.getBoolPref(prefstring);
          break;
        default:
          curEl.setAttribute("value", mgPrefRoot.getCharPref(prefstring));
          break;
      }
    }
    catch(e) {}
  }

  if (!("mgWindow" in parent)) { // we are "embedded" (SeaMonkey)
    parent.initPanel("chrome://mozgest/content/pref/pref-mozgest.xul");
    parent.hPrefWindow.registerOKCallbackFunc(savePrefs);
  }

  if (navigator.platform.indexOf("Mac") == 0) {
    document.getElementById("metaK").hidden = false;
  }
  toggleTrailSettingsBox();
  lmbOptionLabel = document.getElementById('LMBoptions').label;
  rmbOptionLabel = document.getElementById('RMBoptions').label;
  onMouseButtonChange();
  loadTrailColor();
  document.getElementById("buttonOptionsDeck").hidden = false;
  toggleRockersBox();

  // get release info from property file
  var propertyBundle = Components.classes["@mozilla.org/intl/stringbundle;1"].getService()
                       .QueryInterface(Components.interfaces.nsIStringBundleService)
                       .createBundle("chrome://mozgest/content/mgbuild.properties");
  var releaseVersion = propertyBundle.GetStringFromName("mozgest.version");
  document.getElementById("version").setAttribute("value", releaseVersion);

  mgComponentLoader.initMouseService();
  document.getElementById("JSTrailsOptionsBox").hidden = mgNativeTrails;
  var lblTrail = document.getElementById("lblTrailOpacity");
  var trailOpacityBox = document.getElementById("trailOpacityBox");
  if (mgNativeTrails)
    lblTrail.hidden = trailOpacityBox.hidden = !mgNativeTrailsOpacity;

  document.getElementById("staticRockersBox").hidden = !mgMouseEvents;

  // hide our uninstaller if extension manager is present
  if ("@mozilla.org/extensions/manager;1" in Components.classes) {
    document.getElementById("uninstallButtonRow").setAttribute("hidden", true);
  }
  //debugging for uninstall
  document.getElementById("uninstallDesc").addEventListener("click", toggleUninstallDebug, false);

  if (mgAppInfo.name == "SeaMonkey") {
   document.getElementById("sidebarButtonRow").removeAttribute("hidden");
   sidebarPref.initSidebarData();
  }
}

function savePrefs() {
  for (var i = 0; i < eltIDs.length; i++) {
    var curEl = document.getElementById(eltIDs[i]);
    var prefstring = curEl.getAttribute("mgPrefString");
    var preftype = curEl.getAttribute("mgPrefType");
    switch(preftype) {
      case "int":
        if (curEl.hasAttribute("mgNotValid"))
          ensureBetween(curEl);
        mgPrefRoot.setIntPref(prefstring, curEl.value);
        break;
      case "bool":
        mgPrefRoot.setBoolPref(prefstring, curEl.checked);
        break;
      default:
        mgPrefRoot.setCharPref(prefstring, curEl.getAttribute("value"));
        break;
    }
  }
}

function mgCheckIntPref(elt) {
  if (elt.value < elt.mgDefaults[1] ||
      elt.value > elt.mgDefaults[2] ||
      isNaN(elt.value))
  {
     elt.setAttribute("mgNotValid", true);
  }
  else
     elt.removeAttribute("mgNotValid");
}

// these prefs are only available when no modifier has been selected
function toggleLmbOnlyOptions() {
  var button = document.getElementById('mButton').value;
  if (document.getElementById('leftHanded').checked)
     button = Math.abs(button - 2);

  toggleElements((button != 0)
      || document.getElementById("ctrlK").checked
      || document.getElementById("altK").checked
      || document.getElementById("shiftK").checked,
      new Array("lblLmbGestureLimit1", "lmbGestureLimit", "lblLmbGestureLimit2",
      "dscLmbGestureLimit", "lblLmbDragdropDelay1", "lblLmbDragdropDelay2",
      "lmbDragdropDelay", "dscLmbDragdropDelay"));
}

function onMouseButtonChange() {
  var button = document.getElementById('mButton').value;
  document.getElementById('buttonImageDeck').selectedIndex = button;
  if (document.getElementById('leftHanded').checked)
     button = Math.abs(button - 2);
  document.getElementById('buttonOptionsDeck').selectedIndex = button;
  toggleButtonOptionsCaption();
  toggleLmbOnlyOptions();
}

function toggleButtonOptionsCaption() {
  if (document.getElementById('leftHanded').checked) {
     document.getElementById('LMBoptions').label = rmbOptionLabel;
     document.getElementById('RMBoptions').label = lmbOptionLabel;
  }
  else {
     document.getElementById('LMBoptions').label = lmbOptionLabel;
     document.getElementById('RMBoptions').label = rmbOptionLabel;
  }
}

function toggleTrailSettingsBox() {
  toggleElements(!document.getElementById("trailsEnabled").checked,
      new Array("lblTrailWidth", "trailWidth", "lblTrailWidthPx",
      "lblTrailColor", "trailColor", "dTrailColor", "lblTrailInterval",
      "trailInterval", "lblTrailIntervalPx", "lblTrailOpacity", "trailOpacity",
      "lblTrailOpacityPct", "lblTrailLengthLimit", "trailLengthLimit",
      "lblTrailLengthLimitDots", "dscTrailStopDrawingHint", "dscTrailWarning"));
}

function toggleRockersBox() {
  toggleElements(!document.getElementById("rockersEnabled").checked,
      new Array("wheelRockers", "dscWheelRockersHint", "lblWheelSensitivity",
                "wheelSensitivity", "staticRockers",
                "lblStaticDelay", "staticRockersDelay"));
  toggleWheelSettings();
  toggleStaticRockerSettings();
}

function toggleWheelSettings() {
  toggleElements(!document.getElementById("rockersEnabled").checked
                 || !document.getElementById("wheelRockers").checked,
                 new Array("lblWheelSensitivity", "wheelSensitivity"));
}

function toggleStaticRockerSettings() {
  toggleElements(!document.getElementById("staticRockers").checked
                 || !document.getElementById("rockersEnabled").checked,
                  new Array("lblStaticDelay", "staticRockersDelay"));
}

function toggleElements(d, idArray) {
  for (var i = 0; i < idArray.length; i++) {
    document.getElementById(idArray[i]).disabled = d;
  }
}

function loadTrailColor() {
  document.getElementById("trailColor").color =
      document.getElementById("dTrailColor").getAttribute("value");
}

function saveTrailColor() {
  document.getElementById("dTrailColor").setAttribute("value",
      document.getElementById("trailColor").getAttribute("color"));
}

function openMappingsWindow() {
    window.openDialog("chrome://mozgest/content/pref/mappings.xul", "mozgestmappings",
      "chrome,centerscreen,resizable,modal");
}

function openPrintWindow() {
  try {
    var appS = Components.classes["@mozilla.org/appshell/appShellService;1"]
               .getService().QueryInterface(Components.interfaces.nsIAppShellService);

    var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService);
    var pURI = ioService.newURI('chrome://mozgest/content/sidebar/mozgestSidebar.xul', null, null);
    appS.createTopLevelWindow(null, pURI, true, false, 4094, null, null);
  }
  catch (e) {}
}

function toggleUninstallDebug(event) {
  if (event.shiftKey) {
    uninstallTestOnly = !uninstallTestOnly;
    document.getElementById("uninstallDesc")
      .setAttribute("value", "{{{ uninstall debug: "
                             + (uninstallTestOnly ? "test run" : "real uninstall")
                             + " }}}");
  }
}

function resetToDefault() {
  for (var x = 0; x < eltIDs.length; x++) {
    var elt = document.getElementById(eltIDs[x]);
    if (elt.mgDefaults[0] == "notFound")
      continue;
    var prefType = elt.getAttribute("mgPrefType");

    if (prefType == "int")
      elt.value = elt.mgDefaults[0];
    else if (prefType == "bool")
      elt.checked = elt.mgDefaults[0]
    else
      elt.setAttribute("value", elt.mgDefaults[0]);

    elt.removeAttribute("mgNotValid");
  }
  onMouseButtonChange();
  toggleTrailSettingsBox();
  loadTrailColor();
  toggleRockersBox();
}

function doUninstall() {
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                      .getService(Components.interfaces.nsIPromptService);
  var bundle = document.getElementById("mozgestbundle");
  if (!promptService.confirm(window,
                             bundle.getString("uninstallTitle"),
                             bundle.getString("uninstallWarning"))){
    return;
  }

  // shutdown mozgest instances in all opened windows
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .notifyObservers(null, "mozgestControl", "shutdown");

  var u = new ExtensionUninstall("urn:mozilla:package:mozgest");
  u.logDialogURL = 'chrome://mozgest/content/uninstall/log_dialog.xul';
  u.doRegisterForCleanup = false;

  // make test run
  u.test = true;
  var success = u.uninstall();

  // if test was successfull, do the real run
  if (success && !uninstallTestOnly) {
    u.test = false;
    success = u.uninstall();
  }

  if (!success) {
    promptService.alert(window,
                        bundle.getString("uninstallTitle"),
                        bundle.getString("uninstallAborted"));
    u.showLogDialog();
  } else {
    // Remove sidebar panel (if installed)
    if (!uninstallTestOnly) sidebarPref.uninstallSidebar();

    // Ask whether the mappings RDF should be deleted.
    var buttonFlags = promptService.BUTTON_POS_0 * promptService.BUTTON_TITLE_YES
                      + promptService.BUTTON_POS_1 * promptService.BUTTON_TITLE_NO;
    var checkbox = {};
    var button = promptService.confirmEx(window,
                                         bundle.getString("mozgest"),
                                         bundle.getString("uninstallDeleteMappings"),
                                         buttonFlags,
                                         null,
                                         null,
                                         null,
                                         null,
                                         checkbox);
    if (button == 0 && !uninstallTestOnly) {
      var mappingsFile = mgStorage.getProfileDir();
      mappingsFile.append("mousegestures.rdf");
      mappingsFile.remove(false);
    }

    // Announce successful uninstall, and tell the user to delete the jar file.
    var message = bundle.getString("deleteJar");
    message = message + "\n";
    message = message + u.getJarFilePath();

    if (u.supportsReveal()) {
      message = message + "\n";
      message = message + bundle.getString("revealJar");
      promptService.alert(window,
                          bundle.getString("uninstallCompleteTitle"),
                          message);
      u.revealJarFile();
    } else {
      var checkResult = {};
      promptService.alertCheck(window,
                               bundle.getString("uninstallCompleteTitle"),
                               message,
                               bundle.getString("copyJarPath"),
                               checkResult);
      if (checkResult.value) {
        Components.classes["@mozilla.org/widget/clipboardhelper;1"]
                  .getService(Components.interfaces.nsIClipboardHelper)
                  .copyString(u.getJarFilePath());
      }
    }
    if (!uninstallTestOnly) {
      goQuitApplication();
    }
  }
}