/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Joe Hewitt <hewitt@netscape.com> (original author)
 *   Ilkka Loppi <loppi@iki.fi>
 *   David Perry <d.perry@utoronto.ca> (modified for MozGest)
 *   Jens Bannmann <jens.b@web.de>
 *   Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const kNCURI               = "http://home.netscape.com/NC-rdf#";
const kSidebarURNPanelList = "urn:sidebar:current-panel-list";
const kSidebarURN3rdParty  = "urn:sidebar:3rdparty-panel";
const kSidebarURL          = "chrome://mozgest/content/sidebar/mozgestSidebar.xul";


var sidebarPref =
{
  gRDF : Components.classes["@mozilla.org/rdf/rdf-service;1"]
         .getService(Components.interfaces.nsIRDFService),

  cUtil : Components.classes["@mozilla.org/rdf/container-utils;1"]
          .getService().QueryInterface(Components.interfaces.nsIRDFContainerUtils),

  initSidebarData : function()
  {
    var pPath = Components.classes['@mozilla.org/file/directory_service;1']
                .getService(Components.interfaces.nsIProperties)
                .get('UPnls', Components.interfaces.nsILocalFile);

    var fHandler = Components.classes["@mozilla.org/network/io-service;1"]
                   .getService(Components.interfaces.nsIIOService);

    this.panelsDS = this.gRDF.GetDataSourceBlocking(fHandler.newFileURI(pPath).spec);
    this.mPanelRes = this.gRDF.GetResource(kSidebarURN3rdParty + ":" + kSidebarURL);

    this.panels = this.panelsDS.GetTarget(this.gRDF.GetResource(kSidebarURNPanelList),
                                this.gRDF.GetResource(kNCURI + "panel-list"), true);

    this.mPanelSeq = this.cUtil.MakeSeq(this.panelsDS, this.panels);

    this.isSidebarInstalled();
    this.updateButton();
  },

  isSidebarInstalled : function()
  {
    this.sbInstalled = this.panelsDS.GetTarget(this.mPanelRes,
                       this.gRDF.GetResource(kNCURI + "content"), true);

    if (this.sbInstalled)
      return true;

    return false;
  },

  updateButton : function()
  {
    var btn = document.getElementById("btnSidebarInstall");
    var sbDesc = document.getElementById("sidebarDescDeck");

    if (this.sbInstalled) {
      btn.disabled = true;
      sbDesc.selectedIndex = 1;
      return;
    }

    btn.disabled = false;
    sbDesc.selectedIndex = 0;
  },

  installSidebar : function()
  {
    if (!this.isSidebarInstalled())
    {
      var sidebarTitle = document.getElementById("sidebarTitle").value;
      this.panelsDS.Assert(this.mPanelRes, this.gRDF.GetResource(kNCURI + "title"), this.gRDF.GetLiteral(sidebarTitle), true);
      this.panelsDS.Assert(this.mPanelRes, this.gRDF.GetResource(kNCURI + "content"), this.gRDF.GetLiteral(kSidebarURL), true);
      this.mPanelSeq.AppendElement(this.mPanelRes);
      this.forceSidebarRefresh();
      this.sbInstalled = true;
      this.updateButton();

      return true;
    } else
      return false;
  },

  forceSidebarRefresh : function()
  {
    var listRes = this.gRDF.GetResource(kSidebarURNPanelList);
    var refreshRes = this.gRDF.GetResource(kNCURI + "refresh");
    var trueRes = this.gRDF.GetLiteral("true");
    this.panelsDS.Assert(listRes, refreshRes, trueRes, true);
    this.panelsDS.Unassert(listRes, refreshRes, trueRes);
  },

  uninstallSidebar : function()
  {
    if (this.isSidebarInstalled()) {

      var arcs = this.panelsDS.ArcLabelsOut(this.mPanelRes);
      while(arcs.hasMoreElements()) {
        var arc = arcs.getNext();
        var targets = this.panelsDS.GetTargets(this.mPanelRes, arc, true);
        while (targets.hasMoreElements()) {
          var target = targets.getNext();
          this.panelsDS.Unassert(this.mPanelRes, arc, target, true);
        }
      }
      this.mPanelSeq.RemoveElement(this.mPanelRes, true);
      this.forceSidebarRefresh();
      this.sbInstalled = false;
      this.updateButton();
    }
  }
}