/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


const cClipboardHelper = Components
                         .classes["@mozilla.org/widget/clipboardhelper;1"]
                         .getService(Components.interfaces.nsIClipboardHelper);
var link;
var type;
var code;
var app;
var func;
var name;
var custom;

function generateLink() {
  type = window.arguments.shift();
  code = window.arguments.shift();
  app = window.arguments.shift();
  func = window.arguments.shift();
  name = window.arguments.shift();
  custom = window.arguments.shift();
  link = "mozgest://addmapping/"
  if (mgMappingLocalizer.deLocalize(code) == "UUUUUU")
    link = "mozgest://patch/";

  // generate link target
  link = link + type
              + "/" + mgMappingLocalizer.deLocalize(code);
  if (app) {
    link += ";" + mgMappingLocalizer.deLocalize(app);
  }
  link += "/";
  link += !func ? "custom/" + (encodeURIComponent(name) + "/" + encodeURIComponent(custom))
                 : func;
  link += "/";

  // put it into textbox
  document.getElementById("linkTargetBox").value = link;
}

function copyLink() {
  cClipboardHelper.copyString(link);
}

function copyHTML() {
  var desc = func ? mgMappingLocalizer.getString(func)
                  : name;
  cClipboardHelper.copyString("<a href=\"" + link + "\">" +
                              desc + " (" + code + ")" + "</a>");
}