/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var gesturesTable = new Array();
var rockerCode = "";

// "embedding" the gesture engine
function initGestureEngine() {
  mgComponentLoader.initMouseService();
  mozgestLoadStrings();

  // load preferences, but override some of them
  mozgestReadPref();
  mgWheelRockers = false;
  rockersEnabled = false;
  drawTrail = true;
  mgTrails.width = 5;
  mgTrails.interval = 7;
  mgTrails.color = "#000000";
  mgTrails.opacity = 100;

  addWindowWatch();
}

function mgGetContentArea() {
  return document.getElementById("gestureArea");
}

function fireGesture(code) {
  window.opener.receiveGesture(code);
  window.close();
  return;
}

// the following dummy functions are needed because
// we did not load gestures.js and windowTypes.js.
// Also we don't want to examine hovered elements

function mgMsg() {
  return;
}
function mgExamineHoveredElement() {
  return true;
}
function checkForRocker() {
  return false;
}
function releaseRocker() {
  return;
}
function resetRocker() {
  return;
}
function mgGetContextMenu() {
  return null;
}
function mgMousewheelHandler() {
  return;
}
function mgGetSelection() {
  return;
}