var gesturesTable = new Array()
var mgSelected = new Array()
var mgHistoryItem = new Array()
var mgBundle = document.getElementById("mozgestbundle")
var sbWindow, sbDoc, sbBody, counts, sortOrder, isSideBar;
var activeElt = null
var toolTipEnabled = false

document.getElementById(mgPref.getCharPref("sideBarSort")).setAttribute('checked', true)
isSideBar = parent.mgWindowType ? true : false

if (isSideBar)
  toolTipEnabled = mgPref.getBoolPref("sideBarToolTip");

if (!isSideBar) {
  document.getElementById("theFrame").removeAttribute("context")
  document.getElementById("printToolbox").removeAttribute("hidden")
}

function addObserver() {
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .addObserver(mgSidebarObserver, "mozgestControl", false);
}

function removeObserver() {
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .removeObserver(mgSidebarObserver, "mozgestControl");
}

var mgSidebarObserver = {
  observe: function(subject, topic, data) {
    if (topic == "mozgestControl") {
      if (data == "mappingsUpdated")
        setTimeout("document.getElementById('theFrame').webNavigation.reload(0)", 0);
    }
  }
}

function reloadFrame(aID) {
  mgPref.setCharPref("sideBarSort", aID)
  document.getElementById('theFrame').webNavigation.reload(0)
}

function updateGestureHistory(target) {
  for (var x = 0; x < mgHistoryItem.length; x++)
    target.removeChild(mgHistoryItem[x]);

  for (x = 0; x < parent.gestureHistory.length; x++) {
    mgHistoryItem[x] = document.createElement('menuitem')
    mgHistoryItem[x].setAttribute('label', parent.gestureHistoryMSG[x])
    mgHistoryItem[x].setAttribute('acceltext', parent.gestureHistory[x])
    mgHistoryItem[x].setAttribute('disabled', true)
    mgHistoryItem[x].setAttribute('mgMenuItem', true)
    target.insertBefore(mgHistoryItem[x], document.getElementById("historyMore"));
  }
}

function renderClassic(aGest, targetNode) {
  if (aGest.charAt(0) != ":") {
    var plusFlag = false;
    for(var i=0; i < aGest.length; i++) {
      if(aGest[i]=='*') {
        plusFlag = true;
        continue;
      }
      var imgUrl = "chrome://mozgest/content/sidebar/X.png";
      imgUrl = imgUrl.replace(/X/,aGest[i]);
      var image = sbDoc.createElement("img")
      image.setAttribute("width", 10)
      image.setAttribute("height", 10)
      image.setAttribute("style", "margin-right: 1px;")
      image.setAttribute("src", imgUrl);
      if (plusFlag) {
        image.setAttribute("class", "link");
        plusFlag = false;
      }
      targetNode.appendChild(image);
    }
  }
  else
    targetNode.appendChild(document.createTextNode(aGest));
}

function renderModern(aGest, targetNode) {
  sbDoc.defaultView.createGestureBox(aGest, targetNode);
}

function fillIn() {
  sbWindow = document.getElementById("theFrame");
  sbDoc = sbWindow.contentDocument;
  sbBody = sbDoc.body;
  sbBody.setAttribute("isSideBar", isSideBar);

  // Allow localizers to define font size
  var fontSize;
  try {
    fontSize = mgBundle.getString("fontSize." + (isSideBar ? "sidebar"
                                                           : "print"));
  } catch (e) {
    fontSize = null;
  }
  if (fontSize) {
    sbBody.setAttribute("style", "font-size: " + fontSize);
  }

  //pref-common.js
  readPackages()
  //print active mappings
  for (var i = 0; i < mgPackages.length; i++) {
    if (mgPackages[i][0] != "separator")
      prepareInject(mgPackages[i][0], false);
  }
  //print default mappings
  if (!isSideBar) {
    sbBody.appendChild(sbDoc.createElement("hr"))
    for (i = 0; i < mgPackages.length; i++) {
      if (mgPackages[i][0] != "separator") {
        prepareInject(mgPackages[i][0], true);
      }
    }
  }
}

function prepareInject(component, readDef) {
  gesturesTable = new Array();
  mgStorage.readRDFGestureTable(component, readDef)
  counts = new Array();
  for (var p in gesturesTable)
    counts.push(gesturesTable[p]);

  if (counts.length == 0)
    return;

  if (mgPref.getCharPref("sideBarSort") == "sortByName") {
    counts.sort(function(a,b) {return ((a.name.toLowerCase())>(b.name.toLowerCase()) ? 1 : -1)} )
    sortOrder = "sortByName"
  }
  else {
    counts.sort(function(a,b) {return ((a.countBase+a.countCur)>(b.countBase+b.countCur) ? 1 : -1)} )
    sortOrder = "sortByUsage"
  }

  inject(document.documentElement.getAttribute(component), readDef)
}

function inject(wType, readDef) {
  var head = sbDoc.createElement("span")
  head.className = "component"

  if (!isSideBar)
  {
    if (!readDef)
      head.appendChild(sbDoc.createTextNode(document
                       .documentElement.getAttribute("mgActive") + wType))
    else
      head.appendChild(sbDoc.createTextNode(document
                       .documentElement.getAttribute("mgDefault") + wType))
  }
  else
    head.appendChild(sbDoc.createTextNode(wType))

  sbBody.appendChild(head)

  var rowEven = false
  var table = sbDoc.createElement("table")
  table.className = "mTable"
  table.setAttribute("width", "100%")
  table.setAttribute("cellspacing", 0)
  sbBody.appendChild(table)

  for (var x=0; x < counts.length; x++)
  {
    if (counts[x].code.indexOf(":") == 0 && !readDef)
    {
      if (!mgPref.getBoolPref("enableRockers") ||
          (!mgPref.getBoolPref("wheelRockers") && isNaN(counts[x].code.substring(2))))
        continue;
    }
    rowEven = !rowEven
    var tRow = sbDoc.createElement("tr")
    tRow.setAttribute("class", (rowEven ? 'even' : 'odd'))
    tRow.setAttribute("isGestureRow", true)
    tRow.mgWindowType = counts[x].component
    tRow.mgResource = counts[x].resource

    var left = sbDoc.createElement("td")
    left.appendChild(sbDoc.createTextNode(counts[x].name))
    var right = sbDoc.createElement("td")
    right.setAttribute("align", "right")
    right.className = "gesture"
    tRow.appendChild(left)
    tRow.appendChild(right)
    table.appendChild(tRow)
    var aGest = (counts[x].appearance) ? counts[x].appearance : counts[x].code;
    if (toolTipEnabled)
    {
      right.setAttribute("mgToolTipLabel_1", document.documentElement.getAttribute("mgGestureCode"))
      right.setAttribute("mgToolTipLabel_2", mgMappingLocalizer.localize(counts[x].code))
    }
    if (!isSideBar)
      right.appendChild(sbDoc.createTextNode(mgMappingLocalizer.localize(aGest)));
    else if (mgPref.getBoolPref("classicSideBar"))
      renderClassic(aGest, right);
    else
      renderModern(aGest, right);

    if (counts[x].code.indexOf("UUUUUU") == 0)
      tRow.setAttribute("isPatch", true)
  }
}

function handleContextMenu(elt) {
  document.getElementById("editThis").setAttribute("hidden", true)

  if (isSideBar && activeElt)
    activeElt.removeAttribute("contextVisible");

  while (elt && elt.nodeName.toLowerCase() != "html") {
    if (elt.hasAttribute("isGestureRow")) {
      document.getElementById("editThis").setAttribute("hidden", false)
      mgSelected[0] = elt.mgResource
      mgSelected[1] = elt.mgWindowType
      if (isSideBar) {
        elt.setAttribute("contextVisible", true)
        activeElt = elt
      }
      break
    }
    elt = elt.parentNode;
  }
  sbBody.setAttribute("contextVisible", true)
}

function mgFillToolTip() {
  if (sbBody.hasAttribute("contextVisible") || !isSideBar)
    return false;

  var mgTNode = document.tooltipNode;
  var mgT1 = document.getElementById("mgToolTipLabel_1");
  var mgT2 = document.getElementById("mgToolTipLabel_2");

  var showToolTip = false;

  try {
    for (mgTNode; mgTNode; mgTNode = mgTNode.parentNode) {
      if (mgTNode.hasAttribute("mgToolTipLabel_1")) {
        mgT1.value = mgTNode.getAttribute("mgToolTipLabel_1");
        mgT2.value = mgTNode.getAttribute("mgToolTipLabel_2");
        showToolTip = true;
        break;
      }
      if (mgTNode == sbBody)
        break;
    }
    return showToolTip;
  }
  catch (e) {return false}
}

function addGesture(entry) {
  gesturesTable[entry.code] = entry
}

function Mapping() {
  this.name = null
  this.code = null
  this.appearance = null
  this.func = null
  this.custom = null
  this.countBase = 0
  this.countCur = 0
  this.resource = null
}