/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is wz_jsgraphics.js (Mozilla Version).
 *
 * The Initial Developer of the Original Code is Walter Zorn.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Walter Zorn           http://www.walterzorn.com/
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


/* ***** ORIGINAL AUTHOR'S NOTES *****
 * This file implements vectorgraphics functionalities for the
 * MozGests extension (Mouse Gestures) in order to visualize the available
 * mouse gestures.
 *
 * wz_jsgraphics.js (Mozilla Version) has been derived from wz_jsgraphics.js,
 * a cross-browser JavaScript vectorgraphics library available on
 * http://www.walterzorn.com/ .
 *
 * Operations, functions and branching have rather been optimized
 * to efficiency and speed than to shortness of source code.
 */


/* ***** PUBLIC METHODS *****
 * Name:                             Example and/or comment:
 *
 * .setColor(html colorstring)       .setColor("#ff0000"); or .setColor("red");
 * .setStroke(linewidth)             .setStroke(2);         maximum width is 3px
 * .drawLine(x1, y1, x2, y2)         .drawLine(10,20,110,120);
 * .drawPolyLine(x-array, y-array)   .drawPolyline([10,40,20], [200,180,220]);
 * .fillOval(x, y, width, height)    .fillOval(10, 100, 5, 5);
 * .fillRect(x, y, width, height)    .fillRect(30, 70, 40, 10);
 * .paint()                     renders the internally generated graphics-markup
 * .clear()        clears the graphics which have been generated by this library
 *
 *  Numeric arguments must be integers!!!!
 */


function mkLin(x1, y1, x2, y2)
{
    if (x1 > x2)
    {
        var _x2 = x2;
        var _y2 = y2;
        x2 = x1;
        y2 = y1;
        x1 = _x2;
        y1 = _y2;
    }
    var dx = x2-x1, dy = Math.abs(y2-y1),
    x = x1, y = y1,
    yIncr = (y1 > y2)? -1 : 1;

    if (dx >= dy)
    {
        var pr = dy<<1,
        pru = pr - (dx<<1),
        p = pr-dx,
        ox = x;
        while ((dx--) > 0)
        {
            ++x;
            if (p > 0)
            {
                this.mkDiv(ox, y, x-ox, 1);
                y += yIncr;
                p += pru;
                ox = x;
            }
            else p += pr;
        }
        this.mkDiv(ox, y, x2-ox+1, 1);
    }
    else
    {
        pr = dx<<1;
        pru = pr - (dy<<1);
        p = pr-dy;
        var oy = y;
        if (y2 <= y1)
        {
            while ((dy--) > 0)
            {
                if (p > 0)
                {
                    this.mkDiv(x++, y, 1, oy-y+1);
                    y += yIncr;
                    p += pru;
                    oy = y;
                }
                else
                {
                    y += yIncr;
                    p += pr;
                }
            }
            this.mkDiv(x2, y2, 1, oy-y2+1);
        }
        else
        {
            while ((dy--) > 0)
            {
                y += yIncr;
                if (p > 0)
                {
                    this.mkDiv(x++, oy, 1, y-oy);
                    p += pru;
                    oy = y;
                }
                else p += pr;
            }
            this.mkDiv(x2, oy, 1, y2-oy+1);
        }
    }
}

function mkLin2D(x1, y1, x2, y2)
{
    if (x1 > x2)
    {
        var _x2 = x2;
        var _y2 = y2;
        x2 = x1;
        y2 = y1;
        x1 = _x2;
        y1 = _y2;
    }
    var dx = x2-x1, dy = Math.abs(y2-y1),
    x = x1, y = y1,
    yIncr = (y1 > y2)? -1 : 1;
    var s = this.stroke;
    if (dx >= dy)
    {
        var ad = Math.ceil(s/2);
        var pr = dy<<1,
        pru = pr - (dx<<1),
        p = pr-dx,
        ox = x;
        while ((dx--) > 0)
        {
            ++x;
            if (p > 0)
            {
                this.mkDiv(ox, y, x-ox+ad, s);
                y += yIncr;
                p += pru;
                ox = x;
            }
            else p += pr;
        }
        this.mkDiv(ox, y, x2-ox+ad+1, s);
    }
    else
    {
        ad = Math.round(s/2);
        pr = dx<<1;
        pru = pr - (dy<<1);
        p = pr-dy;
        oy = y;
        if (y2 <= y1)
        {
            ++ad;
            while ((dy--) > 0)
            {
                if (p > 0)
                {
                    this.mkDiv(x++, y, s, oy-y+ad);
                    y += yIncr;
                    p += pru;
                    oy = y;
                }
                else
                {
                    y += yIncr;
                    p += pr;
                }
            }
            this.mkDiv(x2, y2, s, oy-y2+ad);
        }
        else
        {
            while ((dy--) > 0)
            {
                y += yIncr;
                if (p > 0)
                {
                    this.mkDiv(x++, oy, s, y-oy+ad);
                    p += pru;
                    oy = y;
                }
                else p += pr;
            }
            this.mkDiv(x2, oy, s, y2-oy+ad+1);
        }
    }
}

function jsGraphics(id)
{
    this.setColor = new Function("arg", "this.color = arg.toLowerCase();");
    this.setStroke = function(x)
    {
        this.stroke = x;
        if (x > 1) this.drawLine = mkLin2D;
        else this.drawLine = mkLin;
    };
    this.beginPath = function() {};
    this.drawLine = mkLin2D;
    this.drawPolyline = function(x, y, s)
    {
        for (var i=0 ; i<x.length-1 ; i++ )
            this.drawLine(x[i], y[i], x[i+1], y[i+1]);
    };
          this.fillRect = function(x, y, w, h)
          {
                  this.mkDiv(x, y, w, h);
          };
    this.fillOval = function(left, top, w, h)
    {
        var a = (w -= 1)>>1, b = (h -= 1)>>1,
        wod = (w&1)+1, hod = (h&1)+1,
        cx = left+a, cy = top+b,
        x = 0, y = b,
        ox = 0, oy = b,
        aa2 = (a*a)<<1, aa4 = aa2<<1, bb = (b*b)<<1,
        st = (aa2>>1)*(1-(b<<1)) + bb,
        tt = (bb>>1) - aa2*((b<<1)-1),
        pxl, dw, dh;
        if (w+1) while (y > 0)
        {
            if (st < 0)
            {
                st += bb*((x<<1)+3);
                tt += (bb<<1)*(++x);
            }
            else if (tt < 0)
            {
                st += bb*((x<<1)+3) - aa4*(y-1);
                pxl = cx-x;
                dw = (x<<1)+wod;
                tt += (bb<<1)*(++x) - aa2*(((y--)<<1)-3);
                dh = oy-y;
                this.mkDiv(pxl, cy-oy, dw, dh);
                this.mkDiv(pxl, cy+oy-dh+hod, dw, dh);
                ox = x;
                oy = y;
            }
            else
            {
                tt -= aa2*((y<<1)-3);
                st -= aa4*(--y);
            }
        }
        this.mkDiv(cx-a, cy-oy, w+1, (oy<<1)+hod);
    };
    this.clear = function()
    {
        this.htm = "";
        this.cnv.innerHTML = this.defhtm;
    };
    this.setStroke(2);
    this.color = "#000000";
    this.htm = "";
    this.cnv = document.getElementById(id);
    this.defhtm = this.cnv.innerHTML || "";
    this.paint = function()
    {
        var x = document.createRange();
        x.setStartBefore(this.cnv);
        x = x.createContextualFragment(this.htm);
        this.cnv.appendChild(x);
        this.htm = '';
    };
    this.mkDiv = function(x, y, w, h)
    {
        this.htm += '<div style="position:absolute;'+
            'left:' + x + 'px;'+
            'top:' + y + 'px;'+
            'width:' + w + 'px;'+
            'height:' + h + 'px;'+
            'clip:rect(0,'+w+'px,'+h+'px,0);'+
            'background-color:' + this.color +
            ';"><\/div>';
    };
}