/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *  Mike Kozlowski <mozdev@klio.org>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var mgTrails =
{   trailActive:false,
    trailArea:false,
    trailLength:0,
    trailInt:0,
    noContent:false,

    shouldDrawTrail:function(e)
    {
       if (mgNativeTrails) {
         var mgDocShell = mgGetContentArea().docShell;

         if (mgContent.id == "output-deck")
           mgDocShell = mgGetContentArea().selectedPanel.docShell;

         var baseWin = mgDocShell
                       .QueryInterface(Components.interfaces.nsIBaseWindow);

         mgMouseService.initTrails(baseWin,
                                   mgTrails.width,
                                   mgTrails.interval,
                                   mgTrails.opacity,
                                   grid,
                                   mgTrails.color.substring(1));
         return true;
       }

       this.Enum = mgkWindowMediator.getEnumerator(null, true);
       while (this.Enum.hasMoreElements()) {
           this.InspectorWin = this.Enum.getNext();

           if ("inspector" in this.InspectorWin) {
              this.noContent = true;
              this.InspectorWin = null;
              return false;
              break;
           }
       }

       this.doc = e.view.document;

       if (this.doc instanceof Components.interfaces.nsIDOMHTMLDocument) {
         if (mgContent.id == "output-deck")
           return true;

         // the gesture started over valid html-content
         // get the "highest" HTMLDocument
         try {
           while (this.doc != this.doc.defaultView.self.parent.document &&
                  this.doc.defaultView.self.parent.document
                  instanceof Components.interfaces.nsIDOMHTMLDocument) {
             this.doc = this.doc.defaultView.self.parent.document;
           }
           return true;
         } catch (e) {}
       }
       this.noContent = true;
       return false;
    },

    draw:function(sx, sy, e)
    {
        if (!this.trailActive && !this.noContent) {
           try {
               this.h = Math.round(this.width/2);
               this.sizeArea = this.doc.createElementNS("http://www.w3.org/1999/xhtml", "MGtrailarea");
               this.sizeArea.style.position = "fixed";
               this.sizeArea.style.bottom = "0px";
               this.sizeArea.style.right = "0px";
               this.sizeArea.style.minWidth = "1px";
               this.sizeArea.style.minHeight = "1px";
               this.doc.documentElement.appendChild(this.sizeArea);
               this.sizeBox = this.doc.getBoxObjectFor(this.sizeArea);
               this.maxX = this.sizeBox.screenX - this.h +1;
               this.maxY = this.sizeBox.screenY - this.h +1;
               this.doc.documentElement.removeChild(this.sizeArea);
               this.sizeBox = this.sizeArea = null;

               this.trailArea = this.doc.createElementNS("http://www.w3.org/1999/xhtml", "MGtrailarea");
               this.trailArea.style.visibility = "hidden";
               this.doc.documentElement.appendChild(this.trailArea);

               this.xOffset = this.doc.getBoxObjectFor(this.doc.documentElement).screenX;
               this.yOffset = this.doc.getBoxObjectFor(this.doc.documentElement).screenY;

               if (!("@mozilla.org/content/style-sheet-service;1" in Components.classes)) //<1.8
               {
                  this.xOffset -= this.doc.defaultView.pageXOffset;
                  this.yOffset -= this.doc.defaultView.pageYOffset;
               }

               this.trailDot = this.doc.createElementNS("http://www.w3.org/1999/xhtml", "MGtraildot");
               this.trailDot.style.width = this.width+"px";
               this.trailDot.style.height = this.width+"px";
               this.trailDot.style.backgroundColor = this.color;
               this.trailDot.style.position = "absolute";
               this.trailDot.style.zIndex = "999999";
               if (this.opacity != 100)
                  this.trailDot.style.MozOpacity = this.opacity/100;

               this.trailX = sx;
               this.trailY = sy;

               if (sx >= this.maxX)
                  this.trailX = sx - this.h;

               if (sy >= this.maxY)
                  this.trailY = sy - this.h;

               this.trailLength = this.trailInt = 0;
               this.trailActive = true;
           }
           catch (e) {
               this.noContent = true;
               return;
           }
           return;
        }

        if (sx >= this.maxX || sy >= this.maxY)
           return;

        this.xMove = sx - this.trailX;
        this.yMove = sy - this.trailY;
        this.xDecrement = (this.xMove < 0) ? 1 : (-1);
        this.yDecrement = (this.yMove < 0) ? 1 : (-1);
        if (Math.abs(this.xMove) >= Math.abs(this.yMove) && this.xMove != 0) {
           for (x = this.xMove; x != 0; x = x + this.xDecrement) {
               this.setDot(sx - this.xOffset - x,
                    sy - this.yOffset - Math.round(this.yMove * x / this.xMove),e);
           }
        } else {
          for (y = this.yMove; y != 0; y = y + this.yDecrement) {
              this.setDot(sx - this.xOffset - Math.round(this.xMove * y / this.yMove),
                    sy - this.yOffset - y,e);
          }
        }
        this.trailX = sx;
        this.trailY = sy;
    },

    setDot:function(x, y, e)
    {
        if (this.trailInt % this.interval == 0) {
           this.dot = this.trailDot.cloneNode(true);
           this.dot.style.top = (y - this.h) + "px";
           this.dot.style.left = (x - this.h) + "px";
           this.trailArea.appendChild(this.dot);
           this.trailLength++;
        }
        this.trailInt++;
        if (this.trailInt == grid)
           this.trailArea.style.visibility = "visible";
    },

    endTrail:function()
    {
        if (mgNativeTrails) {
           mgMouseService.stopTrails();
           return;
        }

        if (this.trailArea && this.trailArea.parentNode)
           this.trailArea.parentNode.removeChild(this.trailArea);

        this.trailLength = this.trailInt = 0;
        this.trailArea = false;
        this.trailActive = false;
        this.noContent = false;
    }
}