/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Extension Uninstaller API.
 *
 * The Initial Developer of the Original Code is Jeremy Gillick.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jeremy Gillick <moz_jg@yahoo.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
*        Error Codes
*        100 - 199: extuninstall_removeFromOverlays
*        200 - 299: extuninstall_removeFromChrome
*        300 - 399: extuninstall_rdf_removeElement
*        400 - 499: extuninstall_addToCleanupList
*        500 - 599: extuninstall_customInfo
*        600 - 699: extuninstall_findRelatedExtensions
*      1000 - 1099: Custom Extension Function (#uninstallFunc)
*/

// Props & Chrome Dirs
var oProps       = Components.classes["@mozilla.org/file/directory_service;1"].getService(Components.interfaces.nsIProperties);
var aChromeDirs  = new Array();
aChromeDirs[0]   = (oProps.get("AChrom", Components.interfaces.nsIFile)).path;
aChromeDirs[1]   = (oProps.get("UChrm", Components.interfaces.nsIFile)).path;
var sMozDir      = (oProps.get("CurProcD", Components.interfaces.nsIFile)).path;

// Path Seperator
var sPathSeperator = "\\";
if(aChromeDirs[0].indexOf("/") > -1) sPathSeperator = "/";

var hasCleaned = false;

// Constructor Object
// packageUri is the chrome uri for the package to uninstall
function ExtensionUninstall( sPackageUri ){
  this.version                   = "0.2.4";
  this.type                      = "ExtensionUninstall";
  this.packageUri                = sPackageUri; // Chrome URI

  this.test                      = false;
  this.logger                    = new ExtUninstallLogger();

  this.removeContent             = true;
  this.removeLocale              = true;
  this.removeSkin                = true;
  this.doCustomInfo              = true;
  this.doRegisterForCleanup      = true;
  this.logDialogURL              = 'chrome://extuninstallapi/content/log_dialog.xul';

  this.cleanupRdf                = aChromeDirs[1] + sPathSeperator + "extuninstallapi.rdf";

  // Array of extensions to remove
  this.extensions                = new Array();

  // User Functions
  this.hasError                  = extuninstall_hasError;
  this.hasWarning                = extuninstall_hasWarning;
  this.uninstall                 = extuninstall_uninstall;
  this.showLogDialog             = extuninstall_showLogDialog;

  // API Functions
  this.findRelatedExtensions     = extuninstall_findRelatedExtensions;
  this.customInfo                = extuninstall_customInfo;
  this.removeFromChrome          = extuninstall_removeFromChrome;
  this.removeFromInstalledChrome = extuninstall_removeFromInstalledChrome;
  this.removeFromOverlays        = extuninstall_removeFromOverlays;
  this.addToCleanupList          = extuninstall_addToCleanupList;
  this.supportsReveal            = extuninstall_supportsReveal;
  this.revealJarFile             = extuninstall_revealJarFile;
  this.getJarFilePath            = extuninstall_getJarFilePath;
}

function ExtensionUninstall_version(){
  return (new ExtensionUninstall("")).version;
}

// Uninstall Item Object
function ExtUninstallItem(packageName){
  this.type        = "ExtUninstallItem";
  this.packageName = packageName; // Chrome Name of the package
  this.packageUri  = null;        // Chrome URI
  this.packagePath = null;        // Jar or Directory Path
  this.logger      = new ExtUninstallLogger();
  this.logItem     = new ExtuninstallLogItem(this.logger.UNINSTALL_ACTION, this.logger.SUCCESS_STATUS, this.packageName, null, null);
}

// Did Uninstall have any errors?
function extuninstall_hasError(){
  return this.logger.hasError();
}

// Did Uninstall have any warnings?
function extuninstall_hasWarning(){
  return this.logger.hasWarning();
}

// Init Uninstall
function extuninstall_uninstall(){
  this.extensions = new Array();
  var hasError = false;

  try{
    this.findRelatedExtensions();
    for(var e = 0; e < this.extensions.length; e++){
      hasError = false;

      try{
        if(this.doCustomInfo){
          this.customInfo(this.extensions[e]);
        }

        if(!this.hasError() && !this.extensions[e].logItem.hasError()){ // If no errors logged from customInfo
          if(this.removeContent){
            this.removeFromChrome(this.extensions[e]);
            this.removeFromInstalledChrome(this.extensions[e]);
            this.removeFromOverlays(this.extensions[e]);
          }
          this.addToCleanupList(this.extensions[e].logItem, extuninstall_getBaseFile(this.extensions[e].packagePath, this.extensions[e].packageName));
          this.logger.addLog(this.extensions[e].logItem);
        }
        else{
          this.extensions[e].logItem.status = this.logger.FAIL_STATUS;
          this.logger.addLog(this.extensions[e].logItem);
          break;
        }
      }catch(err){
        hasError = true;
        this.extensions[e].logItem.status = this.logger.FAIL_STATUS;
        this.logger.addLog(this.extensions[e].logItem);
        break;
      }
    }
    hasError = this.hasError();
  }catch(err){ hasError = true; }

  return !hasError;
}

// Show Log Dialog
// isModule: if true dialog is modal (default = true)
// openFrom: Object to call openDialog from (default = window | opener)
function extuninstall_showLogDialog(isModal, openFrom){
  var sModal = ", modal";
  if(isModal == null && isModal == false)
    sModal = "";

  if(openFrom != null && openFrom.openDialog){
    openFrom.openDialog(this.logDialogURL,'ExtUninstallLogDialog','centerscreen, chrome'+ sModal, this).focus();
  }
  else if(window){
    window.openDialog(this.logDialogURL,'ExtUninstallLogDialog','centerscreen, chrome'+ sModal, this).focus();
  }
  else if(opener){
    opener.openDialog(this.logDialogURL,'ExtUninstallLogDialog','centerscreen, chrome'+ sModal, this).focus();
  }
}

// Get all extensions that use the same applicate file(s)
function extuninstall_findRelatedExtensions(){
  try{
    // Define RDF Objects
    var oRdf     = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var oDs      = oRdf.GetDataSourceBlocking("rdf:chrome");
    var oRdfC    = Components.classes["@mozilla.org/rdf/container;1"].createInstance(Components.interfaces.nsIRDFContainer);
    var oRdfUtil = Components.classes["@mozilla.org/rdf/container-utils;1"].getService(Components.interfaces.nsIRDFContainerUtils);
    var oPackage = oRdf.GetResource("urn:mozilla:package:root");
    var oBaseRes = oRdf.GetResource("http://www.mozilla.org/rdf/chrome#baseURL");
    var oNameRes = oRdf.GetResource("http://www.mozilla.org/rdf/chrome#name");

    // Get Base Application Path
    try{
      var sAppPath   = null;
      var oBasePath  = oDs.GetTarget(oRdf.GetResource(this.packageUri), oBaseRes, true);
      var oBaseName  = oDs.GetTarget(oRdf.GetResource(this.packageUri), oNameRes, true);

      if(oBasePath instanceof Components.interfaces.nsIRDFLiteral &&
         oBaseName instanceof Components.interfaces.nsIRDFLiteral){

         // Add to array
         oExt             = new ExtUninstallItem(oBaseName.Value);
         oExt.packageUri  = this.packageUri;
         oExt.packagePath = oBasePath.Value;
         this.extensions[this.extensions.length] = oExt;

         // Set App Path
         var iFind = -1;
         sAppPath  = oBasePath.Value;

         if((iFind = sAppPath.lastIndexOf("!")) > -1){
           sAppPath = sAppPath.substring(0, iFind);
         }
      }
      else{
        this.logger.addLog(new ExtuninstallLogItem(this.logger.READ_ACTION,
                                                   this.logger.FAIL_STATUS,
                                                   "Getting Extension Information",
                                                   602,
                                                   "Failed to retrieve extension info from Chrome.rdf"));
        throw 602;
      }
    }catch(err){
      if(isNaN(err)){
        this.logger.addLog(new ExtuninstallLogItem(this.logger.READ_ACTION,
                                                   this.logger.FAIL_STATUS,
                                                   "Getting Extension Information", 601, err));
        throw 601;
      }
      else{ throw err; }
    }

    // Look through Root Package Sequence
    if(oRdfUtil.IsSeq(oDs, oPackage)){
      oRdfC.Init(oDs, oPackage);

      var oRes   = null;
      var oBase  = null;
      var oName  = null;
      var oExt   = null;
      var aElems = oRdfC.GetElements();

      while(aElems.hasMoreElements()){
        oRes = aElems.getNext();

        // Get #baseURL of this package
        if(oRes instanceof Components.interfaces.nsIRDFResource && oRes.Value != this.packageUri){
          oBase = oDs.GetTarget(oRes, oBaseRes, true);
          oName = oDs.GetTarget(oRes, oNameRes, true);

          // Match
          if(oName instanceof Components.interfaces.nsIRDFLiteral
             && oBase instanceof Components.interfaces.nsIRDFLiteral
             && oBase.Value.indexOf(sAppPath) == 0 ){

             // Create Extension Item
            oExt             = new ExtUninstallItem(oName.Value);
            oExt.packageUri  = oRes.Value;
            oExt.packagePath = oBase.Value;
            this.extensions[this.extensions.length] = oExt;
          }
        }
      }
    }
  }catch(err){
    if(!isNaN(err)){
      this.logger.addLog(new ExtuninstallLogItem(this.logger.READ_ACTION,
                                                 this.logger.FAIL_STATUS,
                                                 "Getting Related Extensions", 603, err));
      throw err;
    }
  }
}

// Get Custom uninstall info from contents.rdf
function extuninstall_customInfo(oExt){
  var sDsUri = "chrome://"+ oExt.packageName +"/content/contents.rdf";

  try{
    var oParentLog = new ExtuninstallLogItem(this.logger.READ_ACTION, this.logger.SUCCESS_STATUS, "Uninstall custom info", null, null);

    // Define RDF Objects
    var oRdf     = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var oDs      = oRdf.GetDataSourceBlocking(sDsUri); // nsIRDFDataSource
    var oRdfC    = Components.classes["@mozilla.org/rdf/container;1"].createInstance(Components.interfaces.nsIRDFContainer);
    var oRdfUtil = Components.classes["@mozilla.org/rdf/container-utils;1"].getService(Components.interfaces.nsIRDFContainerUtils);

    // Call Custom Function
    var sFunc = null;
    var oTrgt = oDs.GetTarget(oRdf.GetResource(oExt.packageUri),
                              oRdf.GetResource("http://www.mozilla.org/rdf/chrome#uninstallFunc"), true);

    if(oTrgt instanceof Components.interfaces.nsIRDFLiteral){
      sFunc = oTrgt.Value;

      // Remove Parens
      var iParen = -1;
      if((iParen = sFunc.indexOf("(")) > -1)
        sFunc = sFunc.substring(0, iParen);

      // Execute Function
      var oLogger = new ExtUninstallLogger();
      var oExecLog = new ExtuninstallLogItem(this.logger.EXECUTE_ACTION,
                                             this.logger.SUCCESS_STATUS,
                                             (sFunc + "()"), null, null);
      try{
        // Verify Function
        var v = eval(sFunc);

        // Execute
        eval(sFunc + "(oLogger, this.test)");
      }catch(err){
        if(isNaN(err)){
          oExecLog.status = this.logger.WARN_STATUS;
          oExecLog.errorCode = 501;
          oExecLog.errorMsg = err;
        }
      }

      //Add Child Logs
      for(var i = 0; i < oLogger.logs.length; i++){
        oExecLog.addChild(oLogger.logs[i]);
      }

      oParentLog.addChild(oExecLog)
    }

    // Add #InstallInfo Files to Cleanup
    var oSeq = oDs.GetTarget(oRdf.GetResource(oExt.packageUri), oRdf.GetResource("http://www.mozilla.org/rdf/chrome#uninstallInfo"), true);
    if(oSeq instanceof Components.interfaces.nsIRDFResource && oRdfUtil.IsSeq(oDs, oSeq)){
      oRdfC.Init(oDs, oSeq);

      var oElem  = null;
      var sPath  = null;
      var oFile  = null;
      var sKey   = null;
      var aElems = oRdfC.GetElements();
      oFile      = Components.classes["@mozilla.org/file/local;1"].getService(Components.interfaces.nsILocalFile);

      while(aElems.hasMoreElements()){
        oElem = aElems.getNext();

        if(oElem instanceof Components.interfaces.nsIRDFLiteral){
          // For Directory Service
          if((iKey = oElem.Value.indexOf(":")) > -1 && oProps != null){
            try{
              // Seperate
              sKey  = oElem.Value.substring(0, iKey);
              sPath = oElem.Value.substring(iKey + 1);

              // Get Key Value & Make Path
              sKey  = (oProps.get(sKey, Components.interfaces.nsIFile)).path;
              sPath = sKey + sPathSeperator + sPath;

              // Restrict Harmfull Keys
              if(sKey.toLowerCase() == "appdata"
                 || sKey.toLowerCase() == "appregf"
                 || sKey.toLowerCase() == "wind"){
                return;
              }

              // Add to cleanup
              oFile.initWithPath(sPath)
              if( oFile.exists() && sPath.indexOf("..") < 0){
                this.addToCleanupList(oExt, sPath);
              }
            }catch(err){ }
          }
          // For Relative Paths
          else{
            try{
              // Make Path
              sPath = sMozDir + sPathSeperator + oElem.Value;

              // Add to cleanup
              oFile.initWithPath(sPath);
              if( oFile.exists() && sPath.indexOf("..") < 0 ){
                this.addToCleanupList(oExt.logItem, sPath);
              }
            }catch(err){ }
          }
        }
      }
    }
  }catch(err){ }

  oExt.logItem.addChild(oParentLog);
}

// Remove elements from Chrome.rdf
function extuninstall_removeFromChrome(oExt){
  var oMainLog = new ExtuninstallLogItem(this.logger.READ_ACTION, null, "Chrome Datasources", null, null);
  try{
    var aRefs = new Array();

    //Define RDF Objects
    var oDs   = null;
    var oRdf  = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var oRdfC = Components.classes["@mozilla.org/rdf/container;1"].createInstance(Components.interfaces.nsIRDFContainer);

    //Search Chrome in Application and Profile
    var oParentLog  = null;
    for(var d = 0; d < aChromeDirs.length; d++){
      sChromeDir = aChromeDirs[d];
      oParentLog = new ExtuninstallLogItem(this.logger.READ_ACTION, null, sChromeDir + "/chrome.rdf", null, null);
      try{
        aRefs = new Array();
        oDs   = oRdf.GetDataSourceBlocking("file:///"+ sChromeDir + "/chrome.rdf") // nsIRDFDataSource
        oDs   = oDs.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);

        // Find References
        var oRes   = null;
        var aSrc   = null;
        var oSrc   = null;
        var aArchs = oDs.ArcLabelsIn(oRdf.GetResource(oExt.packageUri));

        while(aArchs.hasMoreElements()){
          oRes = aArchs.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
          aSrc = oDs.GetSources(oRes, oRdf.GetResource(oExt.packageUri), true);

          while(aSrc.hasMoreElements()){
            oSrc = aSrc.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
            aRefs[aRefs.length] = oSrc;
          }
        }

        //Remove References
        for(var i = 0; i < aRefs.length; i++){
          // Main
          if(aRefs[i].Value == "urn:mozilla:package:root" && this.removeContent){
            try{
              //Remove
              oRdfC.Init(oDs, oRdf.GetResource("urn:mozilla:package:root"));

              if(!this.test)
                extuninstall_rdf_removeElement(oExt.packageUri, oDs, oRdf, oRdfC);

              oParentLog.addChild(new ExtuninstallLogItem(this.logger.REMOVE_ACTION,
                                                          this.logger.SUCCESS_STATUS,
                                                          oExt.packageUri, null, null));
            }catch(err){
              oParentLog.addChild(new ExtuninstallLogItem(this.logger.REMOVE_ACTION,
                                                          this.logger.FAIL_STATUS,
                                                          oExt.packageUri, 201, err));
              throw 201;
            }
          }
          // Locale
          else if(aRefs[i].Value.indexOf("urn:mozilla:locale:") == 0
                  && aRefs[i].Value.indexOf(oExt.packageName) > -1 && this.removeLocale){
            try{
              //Get Locale Root
              var sLocaleRoot = aRefs[i].Value.substring(19, (Math.abs(aRefs[i].Value.length - oExt.packageName.length))); //extract skin
              sLocaleRoot = "urn:mozilla:locale:"+ sLocaleRoot +"packages";

              //Remove
              oRdfC.Init(oDs, oRdf.GetResource(sLocaleRoot));

              if(!this.test)
                extuninstall_rdf_removeElement(aRefs[i].Value, oDs, oRdf, oRdfC);

              oParentLog.addChild(new ExtuninstallLogItem(this.logger.REMOVE_ACTION,
                                                          this.logger.SUCCESS_STATUS,
                                                          aRefs[i].Value, null, null));
            }catch(err){
              oParentLog.addChild(new ExtuninstallLogItem(this.logger.REMOVE_ACTION,
                                                          this.logger.FAIL_STATUS,
                                                          aRefs[i].Value, 202, err));
              throw 202;
            }
          }
          // Skin
          else if(aRefs[i].Value.indexOf("urn:mozilla:skin:") == 0
                  && aRefs[i].Value.indexOf(oExt.packageName) > -1 && this.removeSkin){
            try{
              //Get Skin Root
              var sSkinUri = aRefs[i].Value.substring(17, (Math.abs(aRefs[i].Value.length - oExt.packageName.length))); //extract skin
              sSkinUri = "urn:mozilla:skin:"+ sSkinUri +"packages";

              //Remove
              oRdfC.Init(oDs, oRdf.GetResource(sSkinUri));

              if(!this.test)
                extuninstall_rdf_removeElement(aRefs[i].Value, oDs, oRdf, oRdfC);

              oParentLog.addChild(new ExtuninstallLogItem(this.logger.REMOVE_ACTION,
                                                          this.logger.SUCCESS_STATUS,
                                                          aRefs[i].Value, null, null));
            }catch(err){
              oParentLog.addChild(new ExtuninstallLogItem(this.logger.REMOVE_ACTION,
                                                          this.logger.FAIL_STATUS,
                                                          aRefs[i].Value, 203, err));
              throw 203;
            }
          }
        }

        //Flush
        oDs.Flush();
        oParentLog.status = this.logger.SUCCESS_STATUS;
      }catch(err){
        if(isNaN(err)){
          oParentLog.status = this.logger.FAIL_STATUS;
          oParentLog.errorCode = 204;
          oParentLog.errorMsg = err;
        }
      }
      oMainLog.addChild(oParentLog);
    }

    oMainLog.status = this.logger.SUCCESS_STATUS;
  }catch(err){
    oMainLog.status = this.logger.FAIL_STATUS;

    if(isNaN(err)){
      oMainLog.errorCode = 200;
      oMainLog.errorMsg = err;
    }

    this.logger.addLog(oMainLog);
    throw 200;
  }

  oExt.logItem.addChild(oMainLog);
}

function extuninstall_removeFromInstalledChrome(oExt){
  var dirService = Components.classes['@mozilla.org/file/directory_service;1']
                             .getService(Components.interfaces.nsIProperties);

  var installedChromeArray = new Array();
  installedChromeArray[0] = dirService.get("UChrm", Components.interfaces.nsIFile); // app-chrome file
  installedChromeArray[1] = dirService.get("AChrom", Components.interfaces.nsIFile); // profile-chrome file

  installedChromeArray[0].append("installed-chrome.txt");
  installedChromeArray[1].append("installed-chrome.txt");

  var streamIn = Components.classes["@mozilla.org/network/file-input-stream;1"]
                           .createInstance(Components.interfaces.nsIFileInputStream);
  var streamOut = Components.classes["@mozilla.org/network/file-output-stream;1"]
                            .createInstance(Components.interfaces.nsIFileOutputStream);
  var wrappedIn = Components.classes["@mozilla.org/scriptableinputstream;1"]
                            .createInstance(Components.interfaces.nsIScriptableInputStream);
  var input;

  var jarFile = extuninstall_getBaseFile(oExt.packagePath, oExt.packageName)
  jarFile = jarFile.substr(jarFile.lastIndexOf(sPathSeperator)+1);

  var chromeRe = /^.*\/chrome\/(\w+\.jar)\!\/(\w+)\/.*$/i;

  for (var n = 0 ; n < installedChromeArray.length ; n++) {
    if (installedChromeArray[n].exists() && installedChromeArray[n].isWritable()) {
      streamIn.init(installedChromeArray[n], 0x01, 0444, null);
      wrappedIn.init(streamIn);
      input = wrappedIn.read(streamIn.available());
      wrappedIn.close();
      streamIn.close();

      var output = "";
      var matches = input.split("\n");
      for (var i=0; i < matches.length; i++) {
        chromeRe.exec(matches[i]);
        if (!(RegExp.$1 == jarFile
              && ((RegExp.$2 == "content" && this.removeContent)
                  || (RegExp.$2 == "locale" && this.removeLocale)
                  || (RegExp.$2 == "skin" && this.removeSkin)))
            && matches[i] != "") {
          output = output + matches[i] + "\n";
        }
      }

      // remove the file so we can replace it
      installedChromeArray[n].remove(true);
      // create a new, blank file -- there's no way to empty an existing one
      installedChromeArray[n].create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0666);

      streamOut.init(installedChromeArray[n], 0x02, 0x200, null);
      streamOut.flush();
      streamOut.write(output, output.length);
      streamOut.close();
    }
  }
}

//Read the contents.rdf for package sPackage
function extuninstall_removeFromOverlays(oExt){
  var sDsUri     = "chrome://"+ oExt.packageName +"/content/contents.rdf"
  var aOverlays  = new Array();
  var oLogOverlay = new ExtuninstallLogItem(this.logger.READ_ACTION, this.logger.SUCCESS_STATUS, sDsUri, null, null);

  try{

    // Define RDF Objects
    var  oRdf     = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var oDs      = oRdf.GetDataSourceBlocking(sDsUri); // nsIRDFDataSource
      oDs      = oDs.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
    var oRdfC     = Components.classes["@mozilla.org/rdf/container;1"].createInstance(Components.interfaces.nsIRDFContainer);
    var oRdfC2     = Components.classes["@mozilla.org/rdf/container;1"].createInstance(Components.interfaces.nsIRDFContainer);
    var  oRdfUtil   = Components.classes["@mozilla.org/rdf/container-utils;1"].getService(Components.interfaces.nsIRDFContainerUtils);
    var oSeq    = oRdf.GetResource("urn:mozilla:overlays")

    // Collect Overlays
    try{

      if(oRdfUtil.IsSeq(oDs, oSeq)){
        oRdfC.Init(oDs, oSeq);

        var oRes    = null;
        var sRdf    = null;
        var aSeq    = null;
        var oElem    = null;
        var aElements  = oRdfC.GetElements();
        while(aElements.hasMoreElements()){
          oRes = aElements.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
          sRdf = extuninstall_getOverlayPath(oRes.Value);

          oRdfC2.Init(oDs, oRes);
          aSeq = oRdfC2.GetElements();
          while(aSeq.hasMoreElements()){
            oElem = aSeq.getNext()

            if(oElem instanceof Components.interfaces.nsIRDFLiteral){

              if(typeof(aOverlays[sRdf]) == 'undefined'){
                aOverlays[sRdf] = new Array(oElem.Value);
              }
              else{
                aOverlays[sRdf][aOverlays[sRdf].length] = oElem.Value;
              }
            }
          }
        }
      }
      else{
        oLogOverlay.status     = this.logger.WARNING_STATUS;
        oLogOverlay.errorCode  = 102;
        oLogOverlay.errorMsg  = "No overlay data";
      }
    }catch(err){
      oLogOverlay.status   = this.logger.FAIL_STATUS;
      oLogOverlay.errorCode  = 101;
      oLogOverlay.errorMsg  = err;
      oLogOverlay.addChild(oLogOverlay);
      oExt.logItem.addChild(oLogOverlay);
      throw 101;
    }

    // Remove from Overlays (Application & Profile)
    var sSearch  = "";
    oDs   = null;
    var aArchs  = null;
    var aSrc  = null;
    for(var p = 0; p < aChromeDirs.length; p++){ // Application & Profile Dirs

      // Loop files
      for(sRdfFile in aOverlays){
        var oParentLog = new ExtuninstallLogItem(this.logger.READ_ACTION, null, aChromeDirs[p] + sRdfFile, null, null);
        try{
          oDs  = oRdf.GetDataSourceBlocking("file:///"+ aChromeDirs[p] + sRdfFile)
          oDs  = oDs.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);

          // Loop overlay elements for this file
          for(var i = 0; i < aOverlays[sRdfFile].length; i++){

            // Find Element
            aArchs = oDs.ArcLabelsIn(oRdf.GetLiteral(aOverlays[sRdfFile][i]));
            while(aArchs.hasMoreElements()){
              oRes   = aArchs.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
              aSrc   = oDs.GetSources(oRes, oRdf.GetLiteral(aOverlays[sRdfFile][i]), true);

              // Get parent element for element
              while(aSrc.hasMoreElements()){
                oSrc = aSrc.getNext().QueryInterface(Components.interfaces.nsIRDFResource);

                try{
                  //Remove
                  if(!this.test)
                    oDs.Unassert(oSrc, oRes, oRdf.GetLiteral(aOverlays[sRdfFile][i]));

                  oParentLog.addChild(new ExtuninstallLogItem(this.logger.REMOVE_ACTION, this.logger.SUCCESS_STATUS, aOverlays[sRdfFile][i], null, null));
                }catch(err){
                  oParentLog.addChild(new ExtuninstallLogItem(this.logger.REMOVE_ACTION, this.logger.FAIL_STATUS, aOverlays[sRdfFile][i], 104, err));
                }
              }
            }
          }
          oDs.Flush();

          // Get corresponding stylesheets RDF
          var sSkinRdfFile = sRdfFile.replace(/content\/overlays\.rdf/,"skin/stylesheets.rdf");
          var oSkinDs = oRdf.GetDataSourceBlocking("file:///"+ aChromeDirs[p] + sSkinRdfFile)
          oSkinDs = oSkinDs.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);

          // Find stylesheet elements
          var oResourceEnum = oSkinDs.GetAllResources();
          while (oResourceEnum.hasMoreElements()) {
            var oElement = oResourceEnum.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
            if (oRdfUtil.IsSeq(oSkinDs, oElement)) {
               oSeq = Components.classes['@mozilla.org/rdf/container;1']
                         .createInstance()
                         .QueryInterface(Components.interfaces.nsIRDFContainer);
              oSeq.Init(oSkinDs, oElement);
              var oSkinEnum = oSeq.GetElements();
              while (oSkinEnum.hasMoreElements()) {
                var oSkin = oSkinEnum.getNext().QueryInterface(Components.interfaces.nsIRDFLiteral);
                var sSkin = oSkin.Value;
                if (sSkin.indexOf("chrome://" + oExt.packageName + "/") == 0) {
                  try {
                    //Remove from seq
                    if(!this.test)
                      oSeq.RemoveElement(oSkin, true);
                    oParentLog.addChild(new ExtuninstallLogItem(this.logger.REMOVE_ACTION, this.logger.SUCCESS_STATUS, sSkin, null, null));
                  } catch(err) {
                    oParentLog.addChild(new ExtuninstallLogItem(this.logger.REMOVE_ACTION, this.logger.FAIL_STATUS, sSkin, 105, err));
                  }
                }
              }
            }
          }
          oSkinDs.Flush();

          oParentLog.status = this.logger.SUCCESS_STATUS;
        }catch(err){
          oParentLog.status     = this.logger.FAIL_STATUS;
          oParentLog.errorCode  = 102;
          oParentLog.errorMsg    = err;

          oLogOverlay.addChild(oParentLog);
          oExt.logItem.addChild(oLogOverlay);
          throw 102
        }
        oLogOverlay.addChild(oParentLog);
      }
    }

    oExt.logItem.addChild(oLogOverlay);

  }catch(err){
    if(isNaN(err)){
      oLogOverlay.status     = this.logger.FAIL_STATUS;
      oLogOverlay.errorCode  = 100;
      oLogOverlay.errorMsg  = err;
      oExt.logItem.addChild(oLogOverlay);
      throw 100;
    }
    throw err;
  }
}

// Add sFilePath to Cleanup list in local.rdf
function extuninstall_addToCleanupList(oLogItem, sFilePath){
  if(this.doRegisterForCleanup){
    try{
      sFilePath = decodeURI(sFilePath);

      extuninstall_checkRdf(); // Verify RDF Exists

      var sCleanupUri = "http://jgillick.nettripper.com/extuninstallapi/cleanup";

      // Define RDF Objects
      var oRdf     = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
      var oDs      = oRdf.GetDataSourceBlocking("file:///"+ this.cleanupRdf);
      oDs          = oDs.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
      var oRdfC    = Components.classes["@mozilla.org/rdf/container;1"].createInstance(Components.interfaces.nsIRDFContainer);
      var oRdfUtil = Components.classes["@mozilla.org/rdf/container-utils;1"].getService(Components.interfaces.nsIRDFContainerUtils);

      // Get or Create Sequence
      try{
        oRdfC.Init(oDs, oRdf.GetResource(sCleanupUri)); //Get
      }catch(err){
        oRdfC = oRdfUtil.MakeSeq(oDs, oRdf.GetResource(sCleanupUri)); //Create
      }

      //Add Element to Cleanup list
      if(!this.test)
        oRdfC.AppendElement(oRdf.GetLiteral(sFilePath));

      oDs.Flush();
      oLogItem.addChild(new ExtuninstallLogItem(this.logger.WRITE_ACTION, this.logger.SUCCESS_STATUS, "To Cleanup ("+ sFilePath +")", null, null));
    }catch(err){
      oLogItem.addChild(new ExtuninstallLogItem(this.logger.WRITE_ACTION, this.logger.WARN_STATUS, "To Cleanup ("+ sFilePath +")", 400, err));
    }
  }
}

// Verify ExtensionApi RDF Exists
function extuninstall_checkRdf(){
  try{
    var oFileLocal = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    oFileLocal.initWithPath((new ExtensionUninstall()).cleanupRdf);

    // Doesn't Exist?
    if(!oFileLocal.exists()){
      // Read RDF
      var oRequest = new XMLHttpRequest();
      oRequest.open("GET", "chrome://extuninstallapi/content/extuninstallapi.rdf", false);
      oRequest.send("");
      var sContent = oRequest.responseText;

      // Write
      oFileLocal.create(0x00, 0666);
      var oFileOut = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
      oFileOut.init(oFileLocal, 0x20 | 0x02, 00666, null);
      oFileOut.write(sContent, sContent.length);
      oFileOut.flush();
      oFileOut.close();
    }
  }catch(err){ }
}

// Call cleanup 4 seconds after browser starts
function extuninstall_loadCleanup(){
  if(!hasCleaned){
    hasCleaned = true;
    setTimeout("extuninstall_cleanup()", 4000);
  }
}

// Cleanup file list in local.rdf
function extuninstall_cleanup(){
  try{
    extuninstall_checkRdf(); // Verify RDF Exists

    // Define RDF Objects
    var sRdf     = "file:///"+ (new ExtensionUninstall()).cleanupRdf;
    var oRdf     = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var oDs      = oRdf.GetDataSourceBlocking(sRdf);
    oDs          = oDs.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
    var oRdfC    = Components.classes["@mozilla.org/rdf/container;1"].createInstance(Components.interfaces.nsIRDFContainer);
    var oRdfUtil = Components.classes["@mozilla.org/rdf/container-utils;1"].getService(Components.interfaces.nsIRDFContainerUtils);
    var oSeq     = oRdf.GetResource("http://jgillick.nettripper.com/extuninstallapi/cleanup");

    // Get Cleanup Sequence
    if(oRdfUtil.IsSeq(oDs, oSeq)){
      oRdfC.Init(oDs, oSeq);
    }
    else{
      return;
    }

    // Loop through files
    var oElem  = null;
    var aElems = oRdfC.GetElements();
    var oFile1= Components.classes["@mozilla.org/file/local;1"].getService(Components.interfaces.nsILocalFile);

    while(aElems.hasMoreElements()){
      oElem = aElems.getNext();

      if(oElem instanceof Components.interfaces.nsIRDFLiteral){
        // Remove file
        try{
          oFile.initWithPath(decodeURI(oElem.Value))

          if(oFile.exists() && oFile.isWritable()){
            oFile.remove(true);
          }
        }catch(err){ }

        // Remove from Seq
        oRdfC.RemoveElement(oElem, false);
      }
    }

    oDs.Flush();
  }catch(err){ }
}


// Gets the base file of the application
// most cases this is a JAR
// sPackage is the package name
// sUri is the file URI
// ex: jar:resource:/chrome/app.jar!/content/
function extuninstall_getBaseFile(sUri, sPackage){
  var isJar = (sUri.substring(0, 3) == "jar");
  sPackage = sPackage.toLowerCase();

  //Remove JAR text
  if(isJar)
    sUri = sUri.substring(4);

  //Translate resource
  if(sUri.substring(0, 8) == "resource"){
    sUri = sUri.substring(9);

    //Remove /chrome
    if(sUri.substring(0, 7) == "/chrome")
      sUri = sUri.substring(7);

    sUri = aChromeDirs[0] + sUri;
  }

  //Remove '!'
  var iFind = 0;
  if((iFind = sUri.indexOf("!")) > -1){
    sUri = sUri.substring(0, (iFind));
  }

  // If File, remove directory after the package name from file path
  // most likely 'content'
  if(!isJar){
    iFind = sUri.toLowerCase().lastIndexOf(sPackage);
    if(iFind > -1){
      sUri = sUri.substring(0, (iFind + sPackage.length + 1));
    }
  }

  //Remove file:///
  if(sUri.indexOf("file:///") == 0)
    sUri = sUri.substring(8);

  //Convert Slashes
  sUri = sUri.replace(/[\\\\]/g, sPathSeperator);
  sUri = sUri.replace(new RegExp("[\\/]", "g"), sPathSeperator);

  return sUri;
}

// Gets the path to the overlay RDF
// sXul is the path defined in contents.rdf
// converts: chrome://browser/content/browser.xul
// to: /overlayinfo/browser/content/overlays.rdf
//
// converts: chrome://browser/content/bookmarks/bm-props.xul
// to: /overlayinfo/browser/content/overlays.rdf
function extuninstall_getOverlayPath(sXul){
  //Remove chrome://
  if(sXul.indexOf("chrome://") == 0){
    sXul = sXul.substring(9);
  }

  //Add overlayinfo
  sXul = "/overlayinfo/"+ sXul;

  //Remove any subdirectory under content/
  iPosContent = sXul.indexOf("/content/");
  if(iPosContent > -1){
    sXul = sXul.substring(0, iPosContent + 9);
  }

  //Add overlays.rdf
  var iLast = -1;
  if( (iLast = sXul.lastIndexOf("/")) > -1){
    sXul = sXul.substring(0, (iLast + 1));
    sXul += "overlays.rdf";
  }

  return sXul;
}

// Removes an RDF element with sUri
// sUri: URI of element to remove
// oDs: DataSouces Object
// oRdf: RDFService Object
// oRdfC: RDFContainer Object
function extuninstall_rdf_removeElement(sUri, oDs, oRdf, oRdfC){
  try{
    var oRes = oRdf.GetResource(sUri);

    //Remove All Archs
    // Loop for duplicates
    var aArchs   = null;
    var hasArchs = true;
    while(hasArchs){
      aArchs   = oDs.ArcLabelsOut(oRes);
      hasArchs = aArchs.hasMoreElements();
      while(aArchs.hasMoreElements()){
        oArch = aArchs.getNext().QueryInterface(Components.interfaces.nsIRDFResource);

        //Remove
        oDs.Unassert(oRes, oArch, oDs.GetTarget(oRes, oArch, true));
      }
    }

    //Remove Element
    oRdfC.RemoveElement(oRes, true);

    //Flush
    if(oDs instanceof Components.interfaces.nsIRDFRemoteDataSource)
      oDs.Flush();

  }catch(err){ throw err }
}

// Determines whether Mozilla supports the reveal() function
// on the current operating system. Currently, this is the case
// on Windows, Mac OS X and OS/2. OS/2 only opens the directory,
// but does not select the file.
function extuninstall_supportsReveal(){
  return navigator.platform == "Win32"
         || navigator.platform.indexOf("Mac") == 0
         || navigator.platform == "OS/2";
}

// Reveals the extension's jar file in the operating system's
// file manager, so the user can delete it. Note: this will only
// work if the extension consists of a single jar file.
function extuninstall_revealJarFile(){
  var jarfile = Components.classes["@mozilla.org/file/local;1"]
                .createInstance(Components.interfaces.nsILocalFile);
  jarfile.initWithPath(this.getJarFilePath());
  jarfile.reveal();
}

// Gets the path of the extension's jar file. Note: this will
// only work if the extension consists of a single jar file.
function extuninstall_getJarFilePath(){
  return decodeURI(extuninstall_getBaseFile(this.extensions[0].packagePath,
                                                  this.extensions[0].packageName));
}