var oLogger = new extuninstall_Logger();

function extuninstall_log_loadInit(){
  var oLogList = document.getElementById('log-items');

  if(oLogList != null && window.arguments.length > 0 && window.arguments[0].type == "ExtensionUninstall"){
    oLogger = window.arguments[0].logger;
    extuninstall_log_loadLogs(oLogger.logs, oLogList);
  }
}

function extuninstall_log_loadLogs(aLogs, oLogContainer){
  for(var i = 0; i < aLogs.length; i++){
    try{
      // Add Log Item
      var oLogItem = document.createElement("treeitem");
      var oLogRow  = oLogItem.appendChild(document.createElement("treerow"));
      (oLogRow.appendChild(document.createElement("treecell"))).setAttribute("label", (extuninstall_log_getActionText(aLogs[i].action) + aLogs[i].message) );
      var oLogStatus = oLogRow.appendChild(document.createElement("treecell"));
      oLogStatus.setAttribute("label", extuninstall_log_getStatusText(aLogs[i].status));

      // Set Error/Warning attributes
      if(aLogs[i].status == oLogger.FAIL_STATUS || aLogs[i].status == oLogger.WARN_STATUS){
        if(aLogs[i].errorCode != null || aLogs[i].errorMsg != null){
          oLogStatus.setAttribute("status", aLogs[i].status);
          oLogStatus.setAttribute("errcode", aLogs[i].errorCode);
          oLogStatus.setAttribute("errmsg", aLogs[i].errorMsg);
        }
      }

      // Show children
      if(aLogs[i].children.length > 0){
        oLogItem.setAttribute("container", "true");
        oLogItem.setAttribute("open", "true");

        var oLogChildren = oLogItem.appendChild(document.createElement("treechildren"));

        extuninstall_log_loadLogs(aLogs[i].children, oLogChildren);
      }

      oLogContainer.appendChild(oLogItem);
    }catch(err){ }
  }
}

function extuninstall_log_getActionText(iAction){
  if(iAction == null)
    return "";

  switch(iAction){
    case 20:
      return "READ: ";
    case 21:
      return "WRITE: ";
    case 22:
      return "ADD: ";
    case 23:
      return "REMOVE: ";
    case 24:
      return "EDIT: ";
    case 25:
      return "EXECUTE: ";
    default:
      return "";
  }
}

function extuninstall_log_getStatusText(iStatus){
  if(iStatus == null)
    return "";

  switch(iStatus){
    case 30:
      return "DONE";
    case 31:
      return "";
    case 32:
      return "FAILED";
    case 33:
      return "WARNING";
    default:
      return "";
  }
}

function extuninstall_showError(oTree){
  if(oTree){
    var sTitle = "";
    var sMsg   = "";
    var iStatus = 0;

    try{
      var oSelected = oTree.contentView.getItemAtIndex(oTree.currentIndex).firstChild.childNodes.item(1);

      if(oSelected != null){
        iStatus = parseInt(oSelected.getAttribute("status"));
        if(iStatus == oLogger.FAIL_STATUS || iStatus == oLogger.WARN_STATUS){
          sTitle = "Error: "+ oSelected.getAttribute("errcode");
          sMsg = oSelected.getAttribute("errmsg");
        }
      }

      //Title
      document.getElementById('error-title').setAttribute("value", sTitle);

      //Description
      var oDesc = document.getElementById('error-desc');
      while(oDesc.hasChildNodes())
        oDesc.removeChild(oDesc.firstChild);

      oDesc.appendChild(document.createTextNode(sMsg));
    }catch(err){ }
  }
}