//Logger Object
function ExtUninstallLogger(){
  // Constants
  // Actions
  this.READ_ACTION = 20;
  this.WRITE_ACTION = 21;
  this.ADD_ACTION = 22;
  this.REMOVE_ACTION = 23;
  this.EDIT_ACTION = 24;
  this.EXECUTE_ACTION = 25;
  this.UNINSTALL_ACTION = 26;

  // Status
  this.SUCCESS_STATUS = 30;
  this.EMPTY_STATUS = 31;
  this.FAIL_STATUS = 32;
  this.WARN_STATUS = 33;

  this.type = "logger";
  this.logs = new Array();

  // Functions
  this.addLog = extuninstall_log_addLog;
  this.hasError = extuninstall_log_hasError;
  this.hasWarning = extuninstall_log_hasWarning;
}

// Add Log Object
function extuninstall_log_addLog(oLogItem){
  this.logs[this.logs.length] = oLogItem;
  return oLogItem;
}

// Is there any log item with Errors or Warnings
function extuninstall_log_hasError(aLogs, status){
  // Fill Status
  if(status == null){
    status = (new ExtUninstallLogger()).FAIL_STATUS;
  }

  // Fill aLogs
  if(aLogs == null && this.type == "logger"){
    aLogs = this.logs;
  }
  else if(aLogs == null && this.type == "logitem"){
    aLogs = this.children;

    if(this.status == status)
      return true;
  }
  else if(aLogs == null){
    return false;
  }

  // Loop through logs
  for(var i = 0; i < aLogs.length; i++){

    if(aLogs[i].status == status){
      return true;
    }
    else if(aLogs[i].children.length > 0){
      if(this.hasError(aLogs[i].children, status))
        return true;
    }
  }
  return false;
}

function extuninstall_log_hasWarning(){
  if(this.type == "logger"){
    return this.hasError(this.logs, this.WARN_STATUS);
  }
  else if(this.type == "logitem"){
    return this.hasError(this.children, (new ExtUninstallLogger()).WARN_STATUS);
  }
}

// Log Item
function ExtuninstallLogItem(iAction, iStatus, sMessage, iErrorCode, sError){
  this.type = "logitem";
  this.action = iAction;
  this.status = iStatus;
  this.message = sMessage;
  this.errorCode = iErrorCode;
  this.errorMsg = sError;
  this.children = new Array();

  this.addChild = extuninstall_log_addChild;
  this.hasError = extuninstall_log_hasError;
  this.hasWarning = extuninstall_log_hasWarning;
}

// Add log to log
function extuninstall_log_addChild(oLog){
  this.children[this.children.length] = oLog;
  return oLog;
}