/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var mgWindowType; // type of the window this mozgest instance is working on
var activationPref; // preference name
var contentAreaGetter;
var messageSetter;      // js code to display a message; alternative:
var statusbarcontainer; // id of the element a statusbar is appended to
var mgMessageTimeout = null;
var mgNavtoolbox;
const mgWindowTypesURL = "chrome://mozgest/content/windowTypes.rdf";


function determineWindowType() {
  mgWindowType = false;

  // get our datasource
  var dsource = mgStorage.RDF.GetDataSourceBlocking(mgWindowTypesURL);

  // get all application window types and default their prefs to true.
  var apps = Components.classes['@mozilla.org/rdf/container;1'].createInstance()
             .QueryInterface(Components.interfaces.nsIRDFContainer);
  var appsNode = mgStorage.RDF.GetResource("urn:mozgest:windows:apps");
  try {
    apps.Init(dsource, appsNode);
  } catch (e) {
    alert("Fatal error - could not read windowTypes.rdf: " + e);
  }
  var enumerator = apps.GetElements();
  while (enumerator.hasMoreElements()) {
    var pref = mgStorage.getProperty(dsource, enumerator.getNext(), "wtype");
  }

  // find the windowtype the document is linked to
  var docInfo = mgStorage.RDF.GetResource(document.location.href);
  var linkedType = mgStorage.getProperty(dsource, docInfo, "wtype");

  // read that type-definition
  var typeDef = mgStorage.RDF.GetResource("urn:mozgest:windowtype:" + linkedType);
  var c = mgStorage.getProperty(dsource, typeDef, "contentarea");
  if (!c) {
    mgCommon.dump("MozGest: could not identify overlaid window " +
          "'" + document.location.href + "'");
    return false;
  } else {
    mgWindowType = linkedType;
    // default activationpref is windowtype, but may be set differently
    activationPref = mgStorage.getProperty(dsource, typeDef, "depends") || linkedType;
    contentAreaGetter = c;
    messageSetter = mgStorage.getProperty(dsource, typeDef, "showmsg");
    statusbarcontainer = mgStorage.getProperty(dsource, typeDef, "statusbarcontainer");

    if (statusbarcontainer != null && !document.getElementById("mgStatusbar")) {
      dockElementAt("statusbar", "statusbarpanel", "mgStatusbar",
                    new Array("flex", "label"),
                    new Array("1", ""),
                    document.getElementById(statusbarcontainer));
    }

    mgNavtoolbox = document.getElementById("navigator-toolbox");
    if (mgNavtoolbox) {
      mgWindowType = (mgNavtoolbox.getAttribute("hidden") == "true") ? "browser_printpreview"
                                                                   : "browser";
      // get notified when user enters or leaves print-preview
      mgNavtoolbox.addEventListener("DOMAttrModified", navToolboxChanged, true);
    }
    return true;
  }
}

function mgGetWindowTypePrefix(typeCode) {
  var dsTypes = mgStorage.RDF.GetDataSourceBlocking(mgWindowTypesURL);
  var typesList = Components.classes['@mozilla.org/rdf/container;1']
                     .createInstance()
                     .QueryInterface(Components.interfaces.nsIRDFContainer);
  try {
    typesList.Init(dsTypes, mgStorage.RDF.GetResource("urn:mozgest:windows:list"));
  } catch (e) {
    mgCommon.dump("MozGest: Could not init typesList. " + e + "\n");
  }
  var typesEnum = typesList.GetElements();
  while (typesEnum.hasMoreElements()) {
    var node = typesEnum.getNext()
               .QueryInterface(Components.interfaces.nsIRDFResource);
    if (!mgStorage.getProperty(dsTypes, node, "separator")
        && typeCode == mgStorage.getProperty(dsTypes, node, "wtype")) {
      return mgStorage.getProperty(dsTypes, node, "prefix");
    }
  }
  mgCommon.dump("mgGetWindowTypePrefix: typeCode not found.\n");
  return "?";
}

// since most browser commands are disabled or buggy in print preview,
// we switch to a different gesture set, although it's the same window
function navToolboxChanged(event) {
  if (event.attrName == "hidden" && event.target == mgNavtoolbox) {
    mgWindowType = (event.newValue == "true") ? "browser_printpreview" : "browser";
    resetGesturesTable();
    mgStorage.readRDFGestureTable("window");
    mgStorage.readRDFGestureTable(mgWindowType);
  }
}

function mgGetContentArea() {
  return eval(contentAreaGetter);
}

function mgMsg(msgStr) {
  clearTimeout(mgMessageTimeout)
  if (msgStr != "")
     mgMessageTimeout = setTimeout(mgMsg, 3000, "");

  if (messageSetter != null) {
    eval(messageSetter);
  } else if (statusbarcontainer != null) {
    document.getElementById("mgStatusbar").setAttribute("label", msgStr);
  }
}

// mozgestIsInContent is called from startGesture to check whether the click has
// occured in content area
function mozgestIsInContent(found) {
  // prevent gestures over scrollbars or input elements
  if (found["scrollbar"] || found["select"] || found["input"] ||
      found["textarea"] || found["textbox"]) {
    return false;
  }
  return true;
}

function mgIsEnabled() {
  return mgWindowType != false && mgGetPref(activationPref, "Bool");
}