/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Andy Edmonds <aedmonds@mindspring.com>
 *  Ben Williams <benw@webmedia.com.au>
 *  Benjamin K. Stuhl <tiriath@yahoo.com>
 *  David Illsley <illsleydc@bigfoot.com>
 *  David Perry <d.perry@utoronto.ca>
 *  Jens Bannmann <jens.b@web.de>
 *  Jeremy Wrinkle (Exotrip)        FIXME email
 *  Jochen <bugs@krickelkrackel.de>
 *  Pavol Vaskovic <pali@pali.sk>
 *  Scurrie                         FIXME whole name, email
 *  Steve Kangas <bookmarklets.com> FIXME email
 *  Squarefree.com                  FIXME who exactly: whole name, email
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


/*** BROWSER FUNCTIONS ***/

function mgB_Back() {
  BrowserBack();
  mgResetRocker();
}

function mgB_Forward() {
  BrowserForward();
  mgResetRocker();
}

function mgB_AddBookmark() {
  setTimeout(function () {document.getElementById("Browser:AddBookmarkAs").doCommand()}, 50);
}

function mgB_CloseDoc() {
  if (gBrowser.mTabs.length > 1)
    gBrowser.removeCurrentTab();
  else
    mgW_CloseWin();
}

function mgB_CloseTab() {
  getBrowser().removeCurrentTab();
}

function mgB_DoubleImageSize() {
  mgSetImageSize(2);
}

function mgB_DoubleStackWin() {
  var tempW;
  if (globalOnLink) {
    window.moveTo(screen.availLeft, screen.availTop);
    window.resizeTo(screen.availWidth/2, screen.availHeight);
    tempW = mgNewBrowserWindow();
    tempW.loadURI(globalOnLink[0].href, mgGetReferrer(globalOnLink[0]));
    tempW.moveTo(screen.availWidth/2 + (screen.width - screen.availWidth),
                 screen.availTop);
    tempW.resizeTo(screen.availWidth/2, screen.availHeight);
  }
}

function mgB_HalveImageSize() {
  mgSetImageSize(.5);
}

function mgB_HideImage() {
  mgSetImageSize(0);
}

function mgB_Home() {
  BrowserHome();
  mgResetRocker();
}

function mgB_LinksInTabs() {
  var browser = getBrowser();
  for (var i = 0; i < globalOnLink.length; i++)
    tab = browser.addTab(globalOnLink[i].href, mgGetReferrer(globalOnLink[i]));
}

function mgB_LinksInWindows() {
  for (var i = 0; i < globalOnLink.length; i++)
    mgNewBrowserWindow().loadURI(globalOnLink[i].href, mgGetReferrer(globalOnLink[i]));
}

function mgB_NextTab() {
  getBrowser().mTabBox._tabs.advanceSelectedTab(+1, true);
}

function mgB_OpenNewDocument() {
  if(globalOnLink) // open link in new window
    mgNewBrowserWindow().loadURI(globalOnLink[0].href, mgGetReferrer(globalOnLink[0]));
  else {
    if (globalOnImage) // Open image in new window
      window.open(globalOnImage.src);
    else // open blank window
      OpenBrowserWindow();
  }
}

function mgB_OpenTab() {
  return mgOpenTab();
}

function mgB_PreviousTab() {
  getBrowser().mTabBox._tabs.advanceSelectedTab(-1, true);
}

function mgB_Reload() {
  BrowserReload();
  mgResetRocker();
}

function mgB_ReloadSkipCache() {
  BrowserReloadSkipCache();
  mgResetRocker();
}

function mgB_Stop() {
  BrowserStop();
}

function mgB_UpDir() { //from bookmarklets.com
  if (window._content.document.location.protocol != "about:") {
    var aUrl = window._content.document.location.href;
    aUrl = aUrl.substring(0, aUrl.substring(0, aUrl.length-1).lastIndexOf('/')+1);
    aUrl = mgBMService.makeURI(aUrl);

    if (aUrl.spec != (aUrl.scheme + ":///"))
      window._content.document.location.href = aUrl.spec;
  }
}

function mgB_ViewPageInfo() {
  BrowserPageInfo();
}

function mgB_ViewPageSource() {
  BrowserViewSourceOfDocument(content.document);
}

function mgB_ZoomIn() {
  if (ZoomManager.prototype)
    ZoomManager.prototype.getInstance().enlarge();
  else if ("FullZoom" in window)
    FullZoom.enlarge();
  else if (ZoomManager.enlarge)
    ZoomManager.enlarge();
}

function mgB_ZoomOut() {
  if (ZoomManager.prototype)
    ZoomManager.prototype.getInstance().reduce();
  else if ("FullZoom" in window)
    FullZoom.reduce();
  else if (ZoomManager.reduce)
    ZoomManager.reduce();
}

function mgB_ZoomIn_DoubleImage() {
  if (globalOnImage)
    mgB_DoubleImageSize();
  else
    mgB_ZoomIn();
}

function mgB_ZoomOut_HalveImage() {
  if (globalOnImage)
    mgB_HalveImageSize();
  else
    mgB_ZoomOut();
}

function mgB_ResetZoom() {
  var doc = globalSrcEvent.view.document;

  if (ZoomManager.prototype)
    ZoomManager.prototype.getInstance().reset();
  else if ("FullZoom" in window)
    FullZoom.reset();
  else if (ZoomManager.reset)
    ZoomManager.reset();

  if (doc.images && doc.images.length > 0) {
    for (var y = 0; y < doc.images.length; y++) {
      var img = doc.images[y];

      if (img.mgOriginalWidth &&
          !isNaN(img.mgOriginalWidth) &&
          !isNaN(img.mgOriginalHeight)) {
        img.style.width = img.mgOriginalWidth +"px";
        img.style.height = img.mgOriginalHeight +"px";
        img.mgImageRatio = img.mgOriginalWidth = img.mgOriginalHeight = false;
      }
    }
  }
}

/*** HELPER FUNCTIONS ***/

function mgGetReferrer(aLink) {
  try {
    var mgRefURL = aLink.ownerDocument.location.href;

    if (mgRefURL) {
      var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                      .getService(Components.interfaces.nsIIOService);
      return ioService.newURI(mgRefURL, null, null);
    }
  }
  catch (e) {}
  return null;
}

function mgGetSelection() {
  return (globalSrcEvent.view != null) ? globalSrcEvent.view.getSelection() : "";
}

function mgLinkInTab(url, aLink) {
  var tab = getBrowser().addTab(url, mgGetReferrer(aLink));
  if (!mgPrefs.root.getBoolPref("browser.tabs.loadInBackground"))
    getBrowser().selectedTab = tab;
}

function mgLoadSideBar(aUrl, aPostData) {
  var mgSidebar = document.getElementById("sidebar");
  if (!mgSidebar.contentDocument ||
      !mgSidebar.contentDocument.getElementById('web-panels-browser')) {
    setTimeout(mgLoadSideBar, 100, aUrl, aPostData);
    return;
  }
  mgSidebar.contentDocument.getElementById('web-panels-browser')
           .loadURIWithFlags(aUrl, null, null, null, aPostData);
}

function mgNewBrowserWindow() {
  window.open();
  return mgCommon.winMediator.getMostRecentWindow("navigator:browser");
}

function mgOpenTab() {
  if (globalOnLink && globalOnLink.length > 0)
    mgLinkInTab(globalOnLink[0].href, globalOnLink[0]);
  else {
    var sel = mgGetSelection().toString();
    if (sel.match(/^(http)|(ftp):/))
      mgLinkInTab(sel, null);
    else
      BrowserOpenTab();
  }
}

function mgSetImageSize(aSize) {
  if (!globalOnImage)
    return;

  var img = globalOnImage;

  if (!img.mgImageRatio) {
    img.mgImageRatio = img.width / img.height;
    img.mgOriginalWidth = img.width;
    img.mgOriginalHeight = img.height;
  }
  if (!isNaN(img.mgImageRatio)) {
    var w = parseFloat(img.style.width);
    if (isNaN(w))
      w = img.width;

    img.style.width = (w * aSize) + "px";
    w = parseFloat(img.style.width);
    img.style.height = (w / img.mgImageRatio) + "px";
  }
}

/*** GENERIC FUNCTIONS ***/

function mgW_RestMaxWin() {
  if (window.maximize != 'undefined') {
    if (window.windowState == STATE_MAXIMIZED)
      window.restore();
    else window.maximize();
  }
}

function mgW_MinWin() {
  if (window.minimize != 'undefined') {
    window.minimize();
    mgResetRocker(true);
  }
}

function mgW_CloseWin() {
  if ("BrowserTryToCloseWindow" in window)
    window.setTimeout("BrowserTryToCloseWindow()", 10);
  else
    window.setTimeout("window.close()", 10);
}

function mgW_Cut() {
  goDoCommand('cmd_cut');
}

function mgW_Copy() {
  goDoCommand('cmd_copy');
}

function mgW_Paste() {
  goDoCommand('cmd_paste');
}

function mgW_ScrollDown() {
  globalSrcEvent.view.scrollBy(0, 200);
}

function mgW_ScrollUp() {
  globalSrcEvent.view.scrollBy(0, -200);
}

function mgW_ScrollRight() {
  globalSrcEvent.view.scrollBy(200, 0);
}

function mgW_ScrollLeft() {
  globalSrcEvent.view.scrollBy(-200, 0);
}

/*** MESSENGER FUNCTIONS ***/

function mgM_DeleteMessage(){
  goDoCommand('cmd_delete');
}

function mgM_ForwardMessage(){
  goDoCommand('cmd_forward');
}

function mgM_Home() {
  loadStartPage();
}

function mgM_NextMessage(){
  goDoCommand('cmd_nextMsg');
}

function mgM_NextUnreadMessage(){
  goDoCommand('cmd_nextUnreadMsg');
}

function mgM_NewMessage() {
  MsgNewMessage();
}

function mgM_OpenLinks() {
  if (globalOnLink && globalOnLink.length > 0) {
    for (var x=0; x<globalOnLink.length; x++)
      mgCommon.showWebPage(globalOnLink[x].href);
  }
}

function mgM_PrevMessage(){
  goDoCommand('cmd_previousMsg');
}

function mgM_PrevUnreadMessage(){
  goDoCommand('cmd_previousUnreadMsg');
}

function mgM_Reload() {
  goDoCommand('cmd_reload');
}

function mgM_ReplyMessage(){
  goDoCommand('cmd_reply');
}

function mgM_ViewSource() {
  MsgViewPageSource();
}