/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Andy Edmonds <aedmonds@mindspring.com>
 *  Ben Williams <benw@webmedia.com.au>
 *  David Illsley <illsleydc@bigfoot.com>
 *  Jens Bannmann <jens.b@web.de>
 *  Jeremy Wrinkle (Exotrip)        FIXME email
 *  Jochen <bugs@krickelkrackel.de>
 *  Pavol Vaskovic <pali@pali.sk>
 *  Scurrie                         FIXME whole name, email
 *  Steve Kangas <bookmarklets.com> FIXME email
 *  Squarefree.com                  FIXME who exactly: whole name, email
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/**
7   U   9  Function processCoordinates returns in global variable 'gesture'
  \ | /    list of 8-directional movements made in gesture. Function fireGesture
R---x---L  takes compacted 8dir chain code and fires the desired action.
  / | \    Ex. "DL" means that user has moved mouse down, then left
1   D   3      "LRL" was gesture left-right-left etc.
 globalOnLink is an array that holds a list of all the links traversed during
 the active gesture.  It's defined in mozgestOverlay.js.
*/


/* This function attempts to fire the gesture, initially with the unmodified
   gesture it has been passed. If that fails, it fires the case with an onLink
   where the ending of the gesture matches a specific pattern. */
function mgFireGesture(aGesture){
  if (!mgFireGestureFromTable(aGesture)) {
    if (!mgFireOnLinkGesture()) {
      if (mgPrefs["status.enabled"])
        mgStatusPopup.firstChild.value = mgGetString("g.unknown") + " " + mgState.localizedGesture;

      mgCommon.dump("MozGest: Unknown Gesture: " + aGesture + "\n");
    }
  }
  // clear global variables
  globalOnLink = globalOnImage = globalSrcEvent = false;
}

function mgFireGestureFromTable(aGesture, map) {
  var mapping = null;

  if (map)
    mapping = map;
  else
    mapping = mgGetMapping(aGesture)[0];

  if (mapping) {
    if (mgPrefs.mousebutton == 0 && mgState.previousSelection && globalSrcEvent) {
      mgGetSelection().removeAllRanges();
      mgGetSelection().addRange(mgState.previousSelection);
      mgState.previousSelection = null;
    }

    mgState.gestureDone = true;
    var message = mgGetMapping(aGesture)[1];
    mgCommon.dump("MozGest: Invoking '" + message + "'\n");

    try {
      var mType = (mapping.type) ? parseInt(mapping.type) : 0;

      if (mType < 2) {
        var mgFunctionToFire = (mType == 0) ? new Function(mapping.func+"()") :
                                              new Function(decodeURIComponent(mapping.func));
        mgFunctionToFire();
      }
      else if (mType == 2) {
        var mData = mapping.func.split("|");
        var ev = document.createEvent('KeyEvents');

        ev.initKeyEvent('keypress', true, true, null,
                        eval(mData[0]), eval(mData[1]), eval(mData[2]),
                        eval(mData[3]), parseInt(mData[4]), parseInt(mData[5]));

        document.documentElement.dispatchEvent(ev);
      }
      else if (mgBMService.enabled || mgBMService.plEnabled) {
        mgBmInfo.get(mapping.func);
        var mgLocation = mgBmInfo.uri.spec;
        var mgPostData = { };

        if (mgLocation) {
           var mgLoadIn = parseInt(mapping.type.substring(1,2));

           if (mgBMService.makeURI(mgLocation).scheme == "javascript")
             mgLoadIn = 0;
           else {
             var selString = mgGetSelection().toString().replace(/\s$/, "");

             var mgKeyW = mgBmInfo.key;

             if (mgKeyW) // if bookmark has a keyword, use browser-function to replace %s
               mgLocation = getShortcutOrURI(mgKeyW + " " + selString, mgPostData);

             else if (mgLocation.match(/%s/))
               mgLocation = mgLocation.replace(/%s/g, encodeURIComponent(selString));
           }

           if (mgLoadIn == 4 && mgAppInfo.name != "Firefox")
             mgLoadIn = 0;

           switch (mgLoadIn) {
             case 4:
               var mgPanelTitle = mgBmInfo.title;
               openWebPanel(mgPanelTitle, mgLocation);

               if (mgPostData.value)
                 setTimeout(mgLoadSideBar, 100, mgLocation, mgPostData.value);
               break;

             case 3:
               getBrowser().selectedTab = getBrowser().addTab(mgLocation, null, null, mgPostData.value);
               break;

             case 2:
               getBrowser().addTab(mgLocation, null, null, mgPostData.value);
               break;

             case 1:
               mgNewBrowserWindow().loadURI(mgLocation, null, mgPostData.value);
               break;

             case 0:
               loadURI(mgLocation, null, mgPostData.value);
               break;
           }
        }
        else {
           mgShowStatus(null, null, null, mgGetString("unknownBookmark"));
           return true;
        }
      }
    }
    catch(e) {
      var errorMessage = "";
      var source = null;
      if (typeof e == "object" && "message" in e) {
        errorMessage = e.message;
        if ("filename" in e)
          source = e.filename;
        else if ("fileName" in e)
          source = e.fileName;
      }
      else
        errorMessage = String(e);

      if (source == null || source.indexOf("chrome://mozgest/") == 0) {
        var msg = mgGetString("errorInGestureFunction");
        msg = msg.replace(/%MESSAGE%/, errorMessage);
        mgState.lastError = errorMessage;
        mgShowStatus(null, null, null, msg);
      }
      return true;
    }

    if (mgState.history.length > 9)
      mgState.history.pop();

    mgState.history.unshift([message, mgMappingLocalizer.localize(aGesture)]);

    if (_mgMS.history.length > 9)
      _mgMS.history.pop();

    _mgMS.history.unshift([message, mgMappingLocalizer.localize(aGesture)]);

    mapping.count ? mapping.count++ : mapping.count = 1;
    return true;
  }
  else
    return false;
}

function mgFireOnLinkGesture() {
  if (globalOnLink) {
    var g = mgState.gesture.join("");
    var twoStroke = g.substr(g.length-2,2);
    var threeStroke = g.substr(g.length-3,3);
    mgCommon.dump("MozGest: Multiple link spawn: " + g
      + ' spotted... \n  ...Looking for Finishing Move\n');

    if (!mgFireGestureFromTable("*" + twoStroke))
      return mgFireGestureFromTable("*" + threeStroke);
    else
      return true;
  }
  return false;
}

function mgCheckForRocker(e) {
  if (!mgPrefs.enableRockers && !mgPrefs.enableWheelRockers)
    return false;

  if (mgState.rockerAborted) {
     mgState.rockerCode = "";
     mgState.rockerAborted = false;
  }

  if (mgState.rockerCode == "")
    mgState.rockerCode = ":";

  var mgRockerButton = (mgPrefs.lefthanded) ? Math.abs(e.button - 2) : e.button;
  mgState.rockerCode += "" + mgRockerButton;

  if (!mgPrefs.enableRockers)
    return false;

  return mgFireRocker(mgState.rockerCode, e);
}

function mgFireRocker(code, e, map, byTimer, time) {
  mgFireStatic.clearTimer();
  // sometimes the timeout is wrong
  if (byTimer) {
    var tD = (new Date).getTime() - time;
    if (tD < mgPrefs.staticRockersDelay/1.5) {
      mgFireStatic.setTimer(code, map, mgPrefs.staticRockersDelay - tD);
      return null;
    }
  }

  var mapping = map ? map : mgGetMapping(code)[0];

  if (mapping) {
    gestureInProgress = mgState.gestureStartTime = false;

    if (mgNativeTrails)
      mgMouseService.stopTrails();

    window.clearTimeout(mgState.gestureTimeout);
    mgStopAutoScroll();

    if (e && !mgMouseEvents) {
      e.preventDefault();
      e.stopPropagation();
    }

    if (mgPrefs["status.rockers.enabled"])
      mgShowStatus(code, true, byTimer);

    mgFireGestureFromTable(code, mapping);

    if (mgMouseEvents && mgState.rockerCode.length > 1) {
      var isWheel = isNaN(code.substring(1));

      if ((isWheel && mgPrefs.staticWheelRockers) || (!isWheel && mgPrefs.staticRockers))
        mgFireStatic.setTimer(code, mapping);
    }

    return true;
  }
  else
    return false;
}

var mgFireStatic = {
  timeout : null,

  setTimer : function(code, mapping, tO) {
    var timer = tO ? tO : mgPrefs.staticRockersDelay;
    this.timeout = setTimeout(mgFireRocker, timer, code, false, mapping, true, (new Date).getTime());
  },

  clearTimer : function() {
    clearTimeout(this.timeout);
  }
}

function mgReleaseRocker(e) {
  mgFireStatic.clearTimer();
  if (e) {
    var button = mgPrefs.lefthanded ? Math.abs(e.button - 2) : e.button;
    eval("mgState.rockerCode = mgState.rockerCode.replace(/" + button + "/g, '');");
  }
}

function mgResetRocker(force) {
  if (!mgMouseEvents || force)
    mgState.rockerCode = "";
}

function mgMousewheelHandler(e) {
  if (mgState.rockerAborted)
    return;

  var dir = e.detail > 0 ? "+" : "-";

  if (mgState.rockerCode && mgGetMapping(mgState.rockerCode+dir)[0]) {
    e.preventDefault();
    e.stopPropagation();
  }

  mgFireRocker(mgState.rockerCode + dir);
}