/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jochen Schlehuber.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de> (mappingsLocalizer)
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

// Please keep this file clean!
// Only things that have a chance to be reused often should go here!

// global variables
var mgGetString;

var mgPrefs = {
  init : function() {
    if (!this.prefs) {
      var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                                .getService(Components.interfaces.nsIPrefService);

      this.root = prefService.getBranch(null);   // root preferences branch
      this.prefs = prefService.getBranch("mozgest."); // mozgest preferences branch
    }

    var g = this.get;
    var p = this;

    for (var each in mgDefaultPrefs.prefs)
      p[each] = g(each);

    if (p.lefthanded)
      p.mousebutton = Math.abs(p.mousebutton - 2);

    p.gestureCondition = "e.button==" + p.mousebutton;

    if (g("modifier.ctrl"))
      p.gestureCondition += " && e.ctrlKey";
    if (g("modifier.alt"))
      p.gestureCondition += " && e.altKey";
    if (g("modifier.shift"))
      p.gestureCondition += " && e.shiftKey";
    if (navigator.platform.indexOf("Mac") == 0 && g("modifier.meta"))
      p.gestureCondition += " && e.metaKey";

    g("sideBarSort");
    g("importFrom");
    g("selectedTabIndex");
  },

  get : function(name) {
    if (!name || !(name in mgDefaultPrefs.prefs))
      return null;

    var mgDefault = mgDefaultPrefs.prefs[name];
    var type;

    switch(typeof mgDefault[0]) {
      case "number":
        type = "Int"
        break;
      case "boolean":
        type = "Bool";
        break;
      case "string":
        type = "Char";
        break;
      default:
        break;
    }

    var notfound = false;
    var value;

    try {
      value = eval("mgPrefs.prefs.get" + type + "Pref('" + name + "');");
    }
    catch (e) {
      notfound = true;
    }
    if (notfound || (type == "Int" && (value < mgDefault[1] || value > mgDefault[2]))) {
      var val = (type == "Char") ? ("'" + mgDefault[0] + "'") : mgDefault[0];
      value = eval("mgPrefs.prefs.set" + type + "Pref('" + name + "', " + val + ");");
    }
    return value;
  }
}

var mgCommon = {
  winMediator : Components.classes["@mozilla.org/appshell/window-mediator;1"]
                .getService(Components.interfaces.nsIWindowMediator),

  winWatcher  : Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
                .getService().QueryInterface(Components.interfaces.nsIWindowWatcher),

  init : function() {
    var mgBundle = Components.classes["@mozilla.org/intl/stringbundle;1"].getService()
                   .QueryInterface(Components.interfaces.nsIStringBundleService)
                   .createBundle("chrome://mozgest/locale/mozgest.properties");

    mgGetString = mgBundle.GetStringFromName;
  },

  dump : function(aText) {
    try {
      if (mgPrefs.prefs.getBoolPref("enableDump"))
        dump(aText);
    }
    catch (e) {}
  },

  showWebPage : function(pageUrl) {
    // determine locale
    var locale = null;
    try {
      locale = Components.classes["@mozilla.org/chrome/chrome-registry;1"]
                         .getService(Components.interfaces.nsIXULChromeRegistry)
                         .getSelectedLocale("global");
    }
    catch (e) {}

    if (locale != null && pageUrl.indexOf("http://www.mousegestures.org") == 0)
      pageUrl = pageUrl + "?language=" + locale;

    //check for an existing browser window
    var browserWindow = this.winMediator.getMostRecentWindow("navigator:browser");

    if (browserWindow) {
      try {
        browserWindow.delayedOpenTab(pageUrl);
      }
      catch(e) {
        browserWindow.loadURI(pageUrl);
      }
    }
    else {
      var uri = Components.classes["@mozilla.org/network/standard-url;1"]
                          .createInstance(Components.interfaces.nsIURI);
      uri.spec = pageUrl;

      var protocolSvc = Components.classes["@mozilla.org/uriloader/external-protocol-service;1"]
                        .getService(Components.interfaces.nsIExternalProtocolService);
      protocolSvc.loadUrl(uri);
    }
  },

  compactCode : function(aCode) {
    var compacted = aCode.substr(0, 1);
    for (var i = 1; i < aCode.length; i++) {
      var c = aCode.substr(i, 1);
      if (c != compacted.substr(compacted.length - 1, 1))
        compacted += c;
    }
    return compacted;
  },

  addTreeRow : function(tChildren, args, mozgestGeneric) {
    var ti = document.createElement("treeitem");
    var row = document.createElement("treerow");

    for (var i = 0; i < args.length; i++) {
      var cell = document.createElement("treecell");
      cell.setAttribute("label", args[i]);
      if (mozgestGeneric)
        cell.setAttribute("properties", mozgestGeneric);
      row.appendChild(cell);
    }
    ti.appendChild(row);
    tChildren.appendChild(ti);
  },

  openDialog : function(aURL, aParams) {
    if (!this.checkWindowOpen(aURL)) {
      if (aURL == "chrome://mozgest/content/sidebar/mozgestSidebar.xul")
        openDialog(aURL);
      else if (aParams)
        openDialog(aURL, "", "chrome,resizable,modal", aParams);
      else
        openDialog(aURL, "", "chrome,resizable,modal");
    }
  },

  checkWindowOpen : function(aURL) {
    var retVal = false;
    var winEnum = this.winMediator.getEnumerator(null);

    while (winEnum.hasMoreElements() && !retVal) {
      var win = winEnum.getNext();
      try {
        if (win.document.location == aURL) {
          retVal = true;
          win.focus();
        }
      }
      catch (e) {}
    }

    return retVal;
  },

  openHint : function(title, target) {
    openDialog("chrome://mozgest/content/pref/help.xul",
               "Mozgest Help",
               "titlebar=no, modal, left=" + target.boxObject.screenX + ", top="+target.boxObject.screenY,
               title, target.getAttribute('mgHelpDesc'));
  },

  notifyObservers : function(aboutWhat) {
    Components.classes["@mozilla.org/observer-service;1"]
              .getService(Components.interfaces.nsIObserverService)
              .notifyObservers(null, "mozgestControl", aboutWhat);
  }
}

var mgAppInfo = {
  init : function() {
    var em = Components.classes["@mozilla.org/extensions/manager;1"]
             .getService(Components.interfaces.nsIExtensionManager);

    this.mozgestVersion = em.getItemForID("{FFA36170-80B1-4535-B0E3-A4569E497DD0}").version;

    var pHandler = Components.classes['@mozilla.org/network/io-service;1']
                  .getService(Components.interfaces.nsIIOService)
                  .getProtocolHandler('http')
                  .QueryInterface(Components.interfaces.nsIHttpProtocolHandler);

    this.geckoVersion = pHandler.misc.substring(3);
    this.oscpu = pHandler.oscpu;
    this.platform = pHandler.platform;

    var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                  .getService(Components.interfaces.nsIXULAppInfo);

    this.appBuildID = appInfo.appBuildID;
    this.ID = appInfo.ID;
    this.name = appInfo.name;
    this.os = appInfo.QueryInterface(Components.interfaces.nsIXULRuntime).OS;
    this.platformBuildID = appInfo.platformBuildID;
    this.vendor = appInfo.vendor;
    this.version = appInfo.version;
  }
}

var mgMappingLocalizer = {
  dict : null,
  reverse : null,

  init : function() {
    this.dict = new Array();
    this.dict["R"] = mgGetString("a.right");
    this.dict["L"] = mgGetString("a.left");
    this.dict["U"] = mgGetString("a.up");
    this.dict["D"] = mgGetString("a.down");
    this.dict["1"] = mgGetString("a.d1");
    this.dict["3"] = mgGetString("a.d3");
    this.dict["7"] = mgGetString("a.d7");
    this.dict["9"] = mgGetString("a.d9");

    this.reverse = new Array();
    var dic = this.dict;

    for (var loc in dic)
      this.reverse[dic[loc]] = loc;
  },

  localize : function(orig) {
    return this.convert(orig, this.dict);
  },

  deLocalize : function(localized) {
    return this.convert(localized, this.reverse);
  },

  convert : function(str, table) {
    if (!str)
      return "";

    if (str.substring(0,1) == ":")
      return str;

    var trans = "";

    for (var i = 0; i < str.length; i++) {
      var o = str.substring(i, i+1);

      if (o != "*" && table[o])
        trans = trans + table[o];
      else
        trans = trans + o;
    }
    return trans;
  }
}

var mgBackup = {
  manualExport : function() {
    var title = mgGetString("expTitle");
    var cc = Components.classes;
    var ci = Components.interfaces;

    _mgMS.writeActiveMappingsToFile(false);

    var profile = cc['@mozilla.org/file/directory_service;1'].getService(ci.nsIProperties);

    var filePath = profile.get('ProfD', ci.nsILocalFile);
    filePath.appendRelativePath("mousegestures.js");

    var fp = cc["@mozilla.org/filepicker;1"].createInstance(ci.nsIFilePicker);
    fp.init(window, title, ci.nsIFilePicker.modeSave);

    var now = new Date();
    var year = now.getFullYear();
    var month = now.getMonth() +1;
    month = (month < 10) ? "0"+month : month;
    var day = now.getDate();
    day = (day < 10) ? "0"+day : day;

    fp.defaultString = "mousegestures_backup_"+mgAppInfo.name+"_"+year+month+day+".js";

    var retVal = fp.show();

    if (retVal == ci.nsIFilePicker.returnOK || retVal == ci.nsIFilePicker.returnReplace) {
      try {
        if (retVal == ci.nsIFilePicker.returnReplace)
          fp.file.remove(false);

        filePath.copyTo(fp.file.parent, fp.file.leafName);
        alert(mgGetString("expSuccess"));
      }
      catch (e) {}
    }
  },

  manualImport : function() {
    var importWarning = confirm(mgGetString("impWarning"));

    if (!importWarning)
      return;

    var title = mgGetString("impTitle");
    var cc = Components.classes;
    var ci = Components.interfaces;

    var profile = cc['@mozilla.org/file/directory_service;1'].getService(ci.nsIProperties);

    var filePath = profile.get('ProfD', ci.nsILocalFile);

    var fp = cc["@mozilla.org/filepicker;1"].createInstance(ci.nsIFilePicker);
    fp.init(window, title, ci.nsIFilePicker.modeOpen);

    var retVal = fp.show();

    if (retVal == ci.nsIFilePicker.returnOK) {
      var mgPath = profile.get('ProfD', ci.nsILocalFile);
      mgPath.appendRelativePath("mousegestures.js");

      try {
        mgPath.remove(false);
        fp.file.copyTo(filePath, "mousegestures.js");
        _mgMS.getActiveMappings();
        mgCommon.notifyObservers("mappingsUpdated");
        alert(mgGetString("impSuccess"))
      }
      catch (e) {
        try {
          mgPath.remove(false);
        }
        catch (e) {}

        _mgMS.removedDefaultMappings = new Array();
        _mgMS.cleanUp();
        _mgMS.getActiveMappings();
        mgCommon.notifyObservers("mappingsUpdated");
        alert(mgGetString("impCorrupt"))
      }
    }
  }
}

var mgBMService = {
  enabled : false,

  init : function() {
    if ("@mozilla.org/browser/bookmarks-service;1" in Components.classes) {
      this.enabled = true;

      this.RDFS = Components.classes["@mozilla.org/rdf/rdf-service;1"]
                  .getService(Components.interfaces.nsIRDFService);

      this.Book = this.RDFS.GetDataSource("rdf:bookmarks");
      this.Icon = this.RDFS.GetResource("http://home.netscape.com/NC-rdf#Icon");
      this.Href = this.RDFS.GetResource("http://home.netscape.com/NC-rdf#URL");
      this.Type = this.RDFS.GetResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
      this.Name = this.RDFS.GetResource("http://home.netscape.com/NC-rdf#Name");
      this.KeyW = this.RDFS.GetResource("http://home.netscape.com/NC-rdf#ShortcutURL");
      this.Post = this.RDFS.GetResource("http://home.netscape.com/NC-rdf#PostData");
    }

    if ("@mozilla.org/browser/nav-history-service;1" in Components.classes) {
      this.plEnabled = true;

      this.plHist = Components.classes["@mozilla.org/browser/nav-history-service;1"]
                    .getService(Components.interfaces.nsINavHistoryService);

      this.plBook = Components.classes["@mozilla.org/browser/nav-bookmarks-service;1"]
                    .getService(Components.interfaces.nsINavBookmarksService);

      this.plLive = Components.classes["@mozilla.org/browser/livemark-service;2"]
                    .getService(Components.interfaces.nsILivemarkService);

      this.plIcon = Components.classes["@mozilla.org/browser/favicon-service;1"]
                    .getService(Components.interfaces.nsIFaviconService);
    }
  },

  makeURI : function(bmHref) {
    var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService);
    return ioService.newURI(bmHref, null, null);
  }
}

var mgBmInfo = {
  get : function(bmId) {
    this.title = null;
    this.uri = null;
    this.key = null;

    if ("@mozilla.org/browser/bookmarks-service;1" in Components.classes) {
      this.uri = mgBMService.Book.GetTarget(mgBMService.RDFS
                            .GetResource(bmId), mgBMService.Href, true);

      if (this.uri) {
        this.uri = this.uri.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
        this.uri = mgBMService.makeURI(this.uri);
      }

      this.title = mgBMService.Book.GetTarget(mgBMService.RDFS
                              .GetResource(bmId), mgBMService.Name, true)
      if (this.title)
        this.title = this.title.QueryInterface(
                                Components.interfaces.nsIRDFLiteral).Value;
      else
        this.title = "";

      this.key = mgBMService.Book.GetTarget(mgBMService.RDFS
                            .GetResource(bmId), mgBMService.KeyW, true);

      if (this.key)
        this.key = this.key.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
    }

    if ("@mozilla.org/browser/nav-history-service;1" in Components.classes) {
      this.uri = mgBMService.plBook.getBookmarkURI(mgBMService.plBook.getItemIdForGUID(bmId));
      this.title = mgBMService.plBook.getItemTitle(mgBMService.plBook.getItemIdForGUID(bmId));
      this.key =  mgBMService.plBook.getKeywordForBookmark(mgBMService.plBook.getItemIdForGUID(bmId));
    }
  }
}

mgDefaultPrefs.init();
mgPrefs.init();
mgCommon.init();
mgAppInfo.init();
mgMappingLocalizer.init();
mgBMService.init();