/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var mgTabBox, mappingsTree, defaultTree;
var tChildren, mChildren, dChildren;
var sortByGesture = new Array();
var sortByName = new Array();
var sortBy = "byName";
var sortOrder = "ascending";
var wType;
var exportButton;

function initMappingsWindow(restart) {
  mgTabBox     = document.getElementById("mgTabBox");
  mappingsTree = document.getElementById("mappingstree");
  defaultTree  = document.getElementById("defaultmappingstree");
  mChildren    = document.getElementById("mappingstreechildren");
  dChildren    = document.getElementById("defaultstreechildren");
  exportButton = document.getElementById("exportButton");

  //from compassOverlay.xul
  initDirectionCodes();

  //fill _mgMS.actTemp
  for (component in _mgMS.activeMappings) {
     _mgMS.actTemp[component] = new Array();

     for (mapping in _mgMS.activeMappings[component])
       _mgMS.actTemp[component][mapping] = _mgMS.activeMappings[component][mapping];
  }

  //presort _mgMS.actTemp by Name and ascending
  sortTree("byName", "ascending");

  //fill _mgMS.defTemp
  for (component in _mgMS.removedDefaultMappings) {
     _mgMS.defTemp[component] = new Array();

     for (mapping in _mgMS.removedDefaultMappings[component])
       _mgMS.defTemp[component][mapping] = _mgMS.removedDefaultMappings[component][mapping];
  }

  //restart is only set to true by 'mgMappingsObserver' (import gesture set)
  if (!restart) {
    //get window types supported by the app
    var sW = document.getElementsByAttribute("mgWinType", "*");

    for (var y = 1; y < sW.length; y++) {
      if (!(sW[y].getAttribute("mgWinType") in _mgMS.supportedWindows))
        sW[y].setAttribute("mgDummyTab", true);
    }

    while (mgTabBox._tabs.getElementsByAttribute("mgDummyTab", "*").length)
      mgTabBox._tabs.removeChild(mgTabBox._tabs.getElementsByAttribute("mgDummyTab", "*")[0]);

    mgTabBox._tabs.firstChild.removeAttribute("afterselected");

    //select a window type
    if (("arguments" in window)) {
      if (window.arguments[0]) {
        var args = window.arguments[0];
        mgTabBox.selectedTab = document.getElementsByAttribute("mgWinType", args[1])[0];
        setTimeout(handleArguments, 0, args[0], args[2]);
      }
    }
    else {
      var winEnum = mgCommon.winMediator.getZOrderDOMWindowEnumerator(null, true);
      var winFound = false;

      while (winEnum.hasMoreElements()) {
        var win = winEnum.getNext();
        if ("mgWindowType" in win) {
          mgTabBox.selectedTab = document.getElementsByAttribute("mgWinType", win.mgWindowType)[0];
          winFound = true;
          break;
        }
      }
      if (!winFound)
        mgTabBox.selectedTab = document.getElementsByAttribute("mgWinType", "window")[0];
    }
  }
}

function showMappingsFor(component) {
  wType = component;
  clearTrees();
  var acm = _mgMS.actTemp[component];

  for (mapping in acm) {
    var mName;
    if (acm[mapping].name)
      mName = acm[mapping].name;
    else
      mName = mgGetString(acm[mapping].func);

    mgCommon.addTreeRow(mChildren, new Array(mgMappingLocalizer.localize(mapping), decodeURIComponent(mName), mapping));
  }

  showRemovedDefaults(component);
}

function clearTrees() {
  while (mChildren.hasChildNodes())
    mChildren.removeChild(mChildren.firstChild);

  while (dChildren.hasChildNodes())
    dChildren.removeChild(dChildren.firstChild);

}

function sortTree(sortOrder, dir) {
  if (sortOrder == "byName") {
    sortByName = new Array();

    for (component in _mgMS.actTemp) {
      sortByName[component] = new Array();

      for (mapping in _mgMS.actTemp[component]) {
        var mName;

        if (_mgMS.actTemp[component][mapping].name)
          mName = decodeURIComponent(_mgMS.actTemp[component][mapping].name);
        else
          mName = mgGetString(_mgMS.actTemp[component][mapping].func);

        sortByName[component][sortByName[component].length] = [mName, mapping];
      }

      if (dir == "ascending")
        sortByName[component].sort(function(a, b) {return ((a[0].toLowerCase())>(b[0].toLowerCase()) ? 1 : -1)} );
      if (dir == "descending")
        sortByName[component].sort(function(a, b) {return ((a[0].toLowerCase())<(b[0].toLowerCase()) ? 1 : -1)} );
    }

    for (component in _mgMS.actTemp) {
      var temp = _mgMS.actTemp[component];
      _mgMS.actTemp[component] = new Array()

      for (var x=0; x < sortByName[component].length; x++) {
        var mapping = sortByName[component][x][1];
        _mgMS.actTemp[component][mapping] = temp[mapping];
      }
    }
  }

  if (sortOrder == "byGesture") {
    sortByGesture = new Array();

    for (component in _mgMS.actTemp) {
      sortByGesture[component] = new Array();

      for (mapping in _mgMS.actTemp[component])
        sortByGesture[component][sortByGesture[component].length] = mapping;

      if (dir == "ascending")
        sortByGesture[component].sort(function(a, b) {return ((a.toLowerCase())>(b.toLowerCase()) ? 1 : -1)} );

      if (dir == "descending")
        sortByGesture[component].sort(function(a, b) {return ((a.toLowerCase())<(b.toLowerCase()) ? 1 : -1)} );
    }

    for (component in _mgMS.actTemp) {
      var temp = _mgMS.actTemp[component];
      _mgMS.actTemp[component] = new Array()

      for (x=0; x < sortByGesture[component].length; x++)
        _mgMS.actTemp[component][sortByGesture[component][x]] = temp[sortByGesture[component][x]];
    }
  }
}

function changeSortOrder(order, target, oldTarget) {
  sortBy = order;
  oldTarget.removeAttribute("sortDirection");

  if (target.hasAttribute("sortDirection"))
    sortOrder = target.getAttribute("sortDirection");

  else if (target.hasAttribute("mgOldSortDirection"))
    sortOrder = target.getAttribute("mgOldSortDirection");

  if (sortOrder == "descending")
    target.setAttribute("sortDirection", "ascending");

  if (sortOrder == "ascending")
    target.setAttribute("sortDirection", "descending");

  target.setAttribute("mgOldSortDirection", sortOrder);
  sortTree(sortBy, target.getAttribute("sortDirection"));
  showMappingsFor(wType);
}

function showRemovedDefaults() {
  while (dChildren.hasChildNodes())
    dChildren.removeChild(dChildren.firstChild);

  var rdm = _mgMS.defTemp[wType];

  for (var mapping in rdm)
    mgCommon.addTreeRow(dChildren, new Array(mgMappingLocalizer.localize(mapping),
                        mgGetString(rdm[mapping].func)));
}

function removeMapping() {
  exportButton.disabled = true;
  var delArray = new Array();

  if (mappingsTree.view.selection.count > 1) {
    for (var x = 0; x < mappingsTree.view.rowCount; x++)
      if (mappingsTree.view.selection.isSelected(x))
        delArray.push(x);
  }
  else
    delArray.push(mappingsTree.view.selection.currentIndex);

  var tempArray = new Array();

  while (delArray.length) {
    var row = delArray[delArray.length-1];
    var map = mappingsTree.view.getCellText(row, mappingsTree.columns["origCodeCol"]);
    tempArray[map] = "true";

    if (map in _mgMS.defaultMappings[wType]) {
      if (!_mgMS.actTemp[wType][map].name &&
          _mgMS.actTemp[wType][map].func ==  _mgMS.defaultMappings[wType][map].func)
      {
        var mName = mgGetString(_mgMS.actTemp[wType][map].func);
        _mgMS.defTemp[wType][map] = _mgMS.actTemp[wType][map];
        mgCommon.addTreeRow(dChildren, new Array(mgMappingLocalizer.localize(map), mName, map));
      }
    }
    mChildren.removeChild(mChildren.childNodes[row]);
    delArray.pop();
  }

  // rebuild _mgMS.actTemp
  var temp = _mgMS.actTemp[wType];
  _mgMS.actTemp[wType] = new Array();

  for (mapping1 in temp) {
    if (mapping1 in tempArray)
      continue;

    _mgMS.actTemp[wType][mapping1] = temp[mapping1];
  }
}

function addDefault() {
  var row = defaultTree.contentView.selection.currentIndex;
  var locCode = defaultTree.view.getCellText(row, defaultTree.columns["dmCodeCol"]);
  var locName = defaultTree.view.getCellText(row, defaultTree.columns["dmDescCol"]);
  var mapping = mgMappingLocalizer.deLocalize(locCode);

  if (overWriteCheck(mapping)) {
    // search for the mapping and remove it!
    // setting the cellText will crash!
    for (var x = 0; x < mChildren.childNodes.length; x++) {
       if (mappingsTree.view.getCellText(x, mappingsTree.columns["origCodeCol"]) == mapping) {
         mChildren.removeChild(mChildren.childNodes[x]);
         break;
       }
    }

    mgCommon.addTreeRow(mChildren, new Array(locCode, locName, mapping));

    // rebuild _mgMS.defTemp
    var temp = _mgMS.defTemp[wType];
    _mgMS.defTemp[wType] = new Array();

    for (mapping1 in temp) {
      if (mapping1 == mapping)
        continue;

      _mgMS.defTemp[wType][mapping1] = temp[mapping1];
    }

    _mgMS.actTemp[wType][mapping] = temp[mapping];

    if (!_mgMS.actTemp[wType][mapping].count)
      _mgMS.actTemp[wType][mapping].count = 0;

    temp = null;
    dChildren.removeChild(dChildren.childNodes[row]);
    sortTree(sortBy, sortOrder);
    showMappingsFor(wType);
    exportButton.disabled = true;
  }
}

function overWriteCheck(mapping) {
  var conf = true;

  if (mapping in _mgMS.actTemp[wType]) {
    var msg = mgGetString("overwriteWarning");
    var xName;

    if (_mgMS.actTemp[wType][mapping].name)
      xName = decodeURIComponent(_mgMS.actTemp[wType][mapping].name);
    else
      xName = mgGetString(_mgMS.actTemp[wType][mapping].func);

    msg = msg.replace(/%MAPPINGNAME%/, xName);
    var dc = mgMappingLocalizer.localize(mapping);
    msg = msg.replace(/%CODE%/, dc);
    conf = confirm(msg)
  }
  return conf;
}

function handleArguments(editMode, eCode) {
  if (editMode == "directEdit") {
    for (var x = 0; x < mChildren.childNodes.length; x++) {
      var oCode = mappingsTree.view.getCellText(x, mappingsTree.columns["origCodeCol"]);

      if (oCode == eCode) {
        mappingsTree.view.selection.select(x);
        mappingsTree.boxObject.ensureRowIsVisible(x)
        break;
      }
    }
    mappingsTree.focus();
    editMapping("Edit");
  }
  else if (editMode == "Import")
    editMapping("Import");
  else
    editMapping("New");
}

function onAcceptMappings() {
  _mgMS.activeMappings = _mgMS.actTemp;
  _mgMS.removedDefaultMappings = _mgMS.defTemp;
  _mgMS.writeActiveMappingsToFile(false);
  _mgMS.cleanUp();
  mgCommon.notifyObservers("mappingsUpdated");
  return true;
}

function onCancel() {
  _mgMS.cleanUp();
  _mgMS.curBookmark = null;
  return true;
}

/*** mapping actions ***/

function editMapping(mode) {
  var mapping = null;

  if (mode == "Edit") {
    var row = mappingsTree.view.selection.currentIndex;
    mapping = mappingsTree.view.getCellText(row, mappingsTree.columns["origCodeCol"]);
  }
  if (mode == "Import") {
    wType =_mgMS.importWinType;
    mapping = _mgMS.importCode;
  }
  openEditWindow(mode, mapping);
}

function openEditWindow(mode, mapping) {
  window.openDialog("chrome://mozgest/content/pref/edit-mapping.xul",
                    "mozgest:editmapping", "chrome,modal,resizable",
                    mode, wType, mapping);
}

function publishMapping() {
  var row = mappingsTree.view.selection.currentIndex;
  var mapping = mappingsTree.view.getCellText(row, mappingsTree.columns["origCodeCol"]);

  window.openDialog("chrome://mozgest/content/pref/publishMapping.xul",
                    "mozgest:publishmapping", "chrome,centerscreen,modal",
                    wType, mapping);
}


function updateButtons(tree, buttons) {
  buttons.setAttribute("disabled", tree.currentIndex != -1 ? false : true);

  if (buttons.id == "editButtons") {
    try {
      var row = mappingsTree.view.selection.currentIndex;
      var mapping = mappingsTree.view.getCellText(row, mappingsTree.columns["origCodeCol"]);
      var isBookMark = false;

      if ((mapping in _mgMS.actTemp[wType] &&
           _mgMS.actTemp[wType][mapping].type &&
           (_mgMS.actTemp[wType][mapping].type.toString().indexOf("2") == 0 ||
           _mgMS.actTemp[wType][mapping].type.toString().indexOf("9") == 0)) ||
           mappingsTree.view.selection.count > 1)
        isBookMark = true;

      document.getElementById("publishButton").disabled = isBookMark ? true : false;
    }
    catch (e) {}

    try {
      document.getElementById("editButton").disabled = (mappingsTree.view.selection.count == 1) ? false : true;
    }
    catch (e) {}
  }
}

var mgMappingsObserver = {
  observe: function(subject, topic, data) {
    if (topic == "mozgestControl" && data == "tempMappingsUpdated") {
      exportButton.disabled = true;
      sortTree(sortBy, sortOrder);
      showMappingsFor(wType);
    }

    if (topic == "mozgestControl" && data == "mappingsUpdated") {
      exportButton.disabled = false;
      initMappingsWindow(true);
      showMappingsFor(wType);
    }
  }
}

function mgAddObserver() {
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .addObserver(mgMappingsObserver, "mozgestControl", false);
}

function mgRemoveObserver() {
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .removeObserver(mgMappingsObserver, "mozgestControl");
}