var sbContent, counts, sortOrder;
var activeElt = null;
var canvasEnabled = true;
var scrollX = {};
scrollX.value = 0;
var scrollY = {};
scrollY.value = 0;

function initSidebar() {
  sbContent = document.getElementById("sbMappings");
  document.getElementById(mgPrefs.prefs.getCharPref("sideBarSort")).setAttribute('checked', true);

  try {
    scrollY.value = sbContent.getAttribute("mgScrollTop");
    setScrollPos();
  }
  catch (e) {}
  addEventListener("scroll", getScrollPos, true);
}

function addObserver() {
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .addObserver(mgSidebarObserver, "mozgestControl", false);

  mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal)
         .addObserver("", mgSidebarObserver, false);
}

function removeObserver() {
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .removeObserver(mgSidebarObserver, "mozgestControl");

  mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal)
         .removeObserver("", mgSidebarObserver);
}

var mgSidebarObserver = {
  observe: function(subject, topic, data) {
    if (topic == "mozgestControl") {
      if (data == "mappingsUpdated")
        document.location.reload();
    }

    if (topic.indexOf("nsPref") == 0) {
      if (data == "enableStrokes" ||
          data == "enableRockers" ||
          data == "enableWheelRockers")
        setTimeout("document.location.reload()", 0);
    }
  }
}

function reloadDoc(aID) {
  mgPrefs.prefs.setCharPref("sideBarSort", aID)
  document.location.reload(0)
}

function updateGestureHistory(target) {
  while (target.childNodes.length > 1)
    target.removeChild(target.firstChild);

  var h
  if (parent && parent.mgState)
    h = parent.mgState.history;
  else
    h = _mgMS.history;

  for (var x = 0; x < h.length; x++) {
    var item = document.createElement("menuitem");
    item.setAttribute("label", h[x][0] + "  ");
    item.setAttribute("acceltext", h[x][1]);
    item.setAttribute("disabled", true);
    item.setAttribute("mgMenuItem", true);
    target.insertBefore(item, target.lastChild);
  }
}

function fillIn() {
  var canvas = document.createElementNS("http://www.w3.org/1999/xhtml", "canvas");
  try {
    canvas.getContext("2d");
  }
  catch (e) {
    canvasEnabled = false;
  }

  prepareInject("window", false);

  for (component in _mgMS.supportedWindows)
    prepareInject(component, false);

  setTimeout("initSidebar()", 0);
}

function prepareInject(component) {
  var  mappingsSet = _mgMS.activeMappings[component];
  counts = new Array();

  for (mapping in mappingsSet) {
    var mName = null;
    var mCount = null;

    if (mappingsSet[mapping].name)
      mName = decodeURIComponent(mappingsSet[mapping].name);
    else
      mName = mgGetString(mappingsSet[mapping].func);

    if (mappingsSet[mapping].count)
      mCount = mappingsSet[mapping].count;

    counts[counts.length] = { component : component,
                              code : mapping,
                              name : mName,
                              count : mCount };
  }

  if (counts.length == 0)
    return;

  if (mgPrefs.prefs.getCharPref("sideBarSort") == "sortByName") {
    counts.sort(function(a, b) {return ((a.name.toLowerCase())>(b.name.toLowerCase()) ? 1 : -1)} );
    sortOrder = "sortByName";
  }
  else {
    counts.sort(function(a, b) {return ((a.count)>(b.count) ? 1 : -1)} );
    sortOrder = "sortByUsage";
  }

  inject(document.documentElement.getAttribute(component));
}

function inject(wType) {
  var gLength = 0;

  for (var n=0; n < counts.length; n++) {
    if (counts[n].code.indexOf(":") == 0) {
      var isWheel = isNaN(counts[n].code.substring(1));

      if ((isWheel && !mgPrefs.prefs.getBoolPref("enableWheelRockers")) ||
          (!isWheel && !mgPrefs.prefs.getBoolPref("enableRockers")))
        continue;
    }
    else if (!mgPrefs.prefs.getBoolPref("enableStrokes"))
      continue

    gLength++;
  }

  if (gLength < 1)
    return;

  var rowEven = false;
  var mC = document.getElementById("sbMappings")

  //the header of the window type
  var hL = document.createElement("label");
  hL.setAttribute("class", "header");
  hL.setAttribute("value", wType);
  mC.appendChild(hL);

  //rL is the window box
  var rL = document.createElement("richlistbox")
  rL.setAttribute("mgMappingsBox", true);
  mC.appendChild(rL);

  for (var x=0; x < counts.length; x++) {
    if (counts[x].code.indexOf(":") == 0) {
      var isWheel = isNaN(counts[x].code.substring(1));

      if ((isWheel && !mgPrefs.prefs.getBoolPref("enableWheelRockers")) ||
          (!isWheel && !mgPrefs.prefs.getBoolPref("enableRockers")))
        continue;
    }
    else if (!mgPrefs.prefs.getBoolPref("enableStrokes"))
      continue;

    rowEven = !rowEven;

    //rI is the row within rL
    var rI = document.createElement("richlistitem");
    rI.mgWindowType = counts[x].component;
    rI.mgCode = counts[x].code;
    rI.mgTooltip = true;
    rI.setAttribute("mgRowClass", (rowEven ? 'even' : 'odd'));
    rI.setAttribute("context", "mgSidebarContext");
    rI.setAttribute("oncontextmenu", "activeElt=this");

    //rIH is the hbox of rI
    var rIH = document.createElement("hbox");
    rIH.setAttribute("flex", "1");
    rIH.setAttribute("align", "center");
    var rIHLabel = document.createElement("label");
    rIHLabel.setAttribute("flex", "1");
    rIHLabel.setAttribute("crop", "end");
    rIHLabel.setAttribute("value", counts[x].name);
    rIH.appendChild(rIHLabel);
    var rIHSpacer = document.createElement("spacer");
    rIHSpacer.setAttribute("flex", "1");
    rIH.appendChild(rIHSpacer);

    var gBox = document.createElement("hbox");
    gBox.setAttribute("tooltip", "mgSidebarToolTip");

    if (!canvasEnabled) {
      var label = document.createElement("label");
      label.setAttribute("value", mgMappingLocalizer.localize(counts[x].code))
      gBox.appendChild(label);
      rIH.appendChild(gBox)
      rI.appendChild(rIH);
      rL.appendChild(rI);
    }
    else {
      var canvas = document.createElementNS("http://www.w3.org/1999/xhtml", "canvas");
      canvas.setAttribute("width", "32");
      canvas.setAttribute("height", "32");
      gBox.setAttribute("mgGestBox", "true");
      gBox.appendChild(canvas);
      rIH.appendChild(gBox)
      rI.appendChild(rIH);
      rL.appendChild(rI);
      draw(canvas, counts[x].code);
      canvas.style.height="32px";
      canvas.style.width="32px";
    }
  }
  var hS = document.createElement("spacer");
  hS.setAttribute("height", "15");
  mC.appendChild(hS);
}

function setScrollPos() {
  var sI = sbContent.boxObject.QueryInterface(Components.interfaces.nsIScrollBoxObject);
  sI.scrollTo(0, scrollY.value);
}

function getScrollPos() {
  var sB = sbContent.boxObject.QueryInterface(Components.interfaces.nsIScrollBoxObject);
  sB.getPosition(scrollX, scrollY);
  sbContent.setAttribute("mgScrollTop", scrollY.value)
}

function mgFillToolTip() {
  var mgTNode = document.tooltipNode;
  var mgT2 = document.getElementById("mgToolTipLabel_2");
  var mgT4 = document.getElementById("mgToolTipLabel_4");

  var showToolTip = false;

  try {
    for (mgTNode; mgTNode; mgTNode = mgTNode.parentNode) {
      if (mgTNode.mgTooltip) {
        mgT2.value = mgMappingLocalizer.localize(mgTNode.mgCode);
        mgT4.value = _mgMS.activeMappings[mgTNode.mgWindowType][mgTNode.mgCode].count;
        showToolTip = true;
        break;
      }
      if (mgTNode == document)
        break;
    }
    return showToolTip;
  }
  catch (e) {return false}
}