/*
 * chrome://tabmixplus/content/links/setup.js
 *
 * original code by Bradley Chapman
 * modified and developped by Hemiola SUN
 * modified again by Bradley Chapman
 *
 */
var gObserver =      Components.classes["@mozilla.org/observer-service;1"]
                     .getService(Components.interfaces.nsIObserverService);

var __contentAreaClick;

/**
 * @brief Install the link-handling functions of Tab Mix Plus.
 *
 * @returns		Nothing.
 */
function TMP_TBP_init()
{
  var eStrings = document.getElementById("extensionsStrings");
  if (eStrings) {
      // we're in the EM
      openURL = TMP_openURL;

      // catch call to tabmix options from EM
      eval("gExtensionsViewController.commands.cmd_options ="+gExtensionsViewController.commands.cmd_options.toString().replace(
      'var optionsURL = aSelectedItem.getAttribute("optionsURL");',
      '$& \ if (TMP_cmd_options(optionsURL)) return;'
      ));
  }

  // with MR Tech's local install
  if (typeof(Local_Install) == "object") {
    // use TMP call to TMP Options
    var _aURL = "'chrome://tabmixplus/content/pref/pref-tabmix.xul'";
    eval("Local_Install.createDropDownMenu ="+Local_Install.createDropDownMenu.toString().replace(
    'aMenuItem.setAttribute("oncommand", thisAction + "; event.stopPropagation();");',
    'if (thisAction.indexOf(_aURL) != -1) thisAction = "TMP_cmd_options(" + _aURL + ")"; \ $&'
    ));
    // fix problem in firefox 2.0 ??
    eval("Local_Install.createDropDownMenu ="+Local_Install.createDropDownMenu.toString().replace(
    'while (list) {',
    'for (var i in list) {'
    ));
  }

  // we need this only for use our loadSearchInBackground pref
  var autoComplete = document.getElementById("PopupAutoCompleteRichResult");
  if (autoComplete) {
    eval("autoComplete.onPopupClick ="+autoComplete.onPopupClick.toString().replace(
      'openUILink(url, aEvent);',
      'TMP_BrowserLoadURL(aEvent, null, null, url);'
    ));
  }

  __contentAreaClick = window.contentAreaClick;
  window.contentAreaClick = TMP_contentAreaClick;
  window.BrowserOpenTab = TMP_BrowserOpenTab;
  window.openUILink = TMP_openUILink;
  if ("BrowserLoadURL" in window) // BrowserLoadURL removed in Firefox 3.1
     window.BrowserLoadURL = TMP_BrowserLoadURL;
  if ("dotCOMplete" in window)
     window.dotCOMplete.realBrowserLoadURL = TMP_BrowserLoadURL;       
}

/**
 * @brief Force-call the window observer at least one time.
 *
 * @returns		Nothing.
 */
function TMP_TBP_Startup()
{
    // session manager extension start to add tab befor our onWindowOpen run
    // so we initialize this befor start
    gWidthFitTitle = TMP_getBoolPref(tabxBranch, "flexTabs", false) &&
                    (TMP_getIntPref(tabxBranch, "maxWidth", 250) != TMP_getIntPref(tabxBranch, "minWidth", 22));

    gTMPprefObserver = new TMP_PrefObserver();

    // force-call the observer once, in order to kill new windows faster
    TMP_DOMWindowOpenObserver.onObserve(window, TMP_DOMWindowOpenObserver);

    // make tabmix compatible with ezsidebar
    var TMP_BrowserStartup = "BrowserStartup" in window ? "BrowserStartup" : "Startup";
    if ('__ezsidebar__'+TMP_BrowserStartup in window)
      TMP_BrowserStartup =  '__ezsidebar__'+TMP_BrowserStartup;

    if (!gPrefService)
         gPrefService = Components.classes["@mozilla.org/preferences-service;1"]
                  .getService(Components.interfaces.nsIPrefBranch);

    var stringBundle = document.getElementById("tmp-string-bundle");
    var tabmix_loading = stringBundle.getString("session.loading.label") + "...";

    var windowOpeneByTabmix = "tabmixdata" in window;
    var firstWindow = numberOfWindows() == 1;

    var sessionStore = TMP_SessionStore.isSessionStoreEnabled() || "gSessionManager" in window;
    var sessionManager = gPref.getBoolPref("extensions.tabmix.sessions.manager");
    var crashRecovery = gPref.getBoolPref("extensions.tabmix.sessions.crashRecovery");
    var afterRestart = false;

    var restoreOrAsk = gPref.getIntPref("extensions.tabmix.sessions.onStart") < 2 || afterRestart;
    var afterCrash = gPref.prefHasUserValue("extensions.tabmix.sessions.crashed");

    // don't load home page on first window if session manager or crash recovery is enabled
    window.isLoadHomePage = true;
    if (!sessionStore && ((sessionManager && windowOpeneByTabmix) ||
         (firstWindow && crashRecovery && afterCrash) ||
         (firstWindow && sessionManager && restoreOrAsk))) {
            eval("window."+TMP_BrowserStartup+" ="+window[TMP_BrowserStartup].toString().replace(
              'uriToLoad = window.arguments[0];',
              'uriToLoad = gHomeButton.getHomePage() == window.arguments[0] ? "about:blank" : window.arguments[0];'
            ).replace(
              'if (window.opener && !window.opener.closed) {',
              'if (uriToLoad && uriToLoad != "about:blank")\
                  for (var i = 0; i < gBrowser.mTabContainer.childNodes.length ; i++)\
                     gBrowser.mTabContainer.childNodes[i].loadOnStartup = true;\
               if (uriToLoad == "about:blank" || "tabmixdata" in window) {\
                  var aBrowser = gBrowser.mCurrentBrowser;\
                  aBrowser.contentDocument.title = tabmix_loading;\
                  aBrowser.mIconURL = "chrome://tabmixplus/skin/tmp.png";\
                  gBrowser.mCurrentTab.setAttribute("image", aBrowser.mIconURL);\
               }\
               $&'
            ));
    }

    var rExp = /BMSVC.readBookmarks\(\);|PlacesStarButton.init\(\);/
    eval("delayedStartup ="+delayedStartup.toString().replace(rExp,'$& \ TMP_delayedStartup();'));

    // look for installed extensions that are incompatible with tabmix
    if (gPref.getBoolPref("extensions.tabmix.disableIncompatible")) {
      if (typeof(PlacesController) == "function")
        window.setTimeout(disableExtensions, 3000, window);
      else
        disableExtensions();
    }

    // set the corect getTitleFromBookmark function
    window._getBookmarkTitle = gIsFirefox3 ? TMP_Places._getBookmarkTitle :
                                           TMP_Bookmark._getBookmarkTitle;

   // add tabmix menu item to tab context menu befor menumanipulator and MenuEdit initialize
    TM_creatMenuItems();

    // if nglayout.debug.disable_xul_cache == true sometimes sessionHistory act strange
    // especially with many extensions installed
    var pref = "nglayout.debug.disable_xul_cache";
    var openFromPlaces;
    if ("openFromPlaces" in window) {
      openFromPlaces = window.openFromPlaces;
      delete window.openFromPlaces;
    }

    if ((!firstWindow && !windowOpeneByTabmix || openFromPlaces) && gPref.prefHasUserValue(pref) && gPref.getBoolPref(pref))
      window.setTimeout(window[TMP_BrowserStartup], 0);
    else
      window[TMP_BrowserStartup]();

    return;
}

function getTitleFromBookmark(aUrl, aTitle)
{
   if (!gPref.getBoolPref("extensions.tabmix.titlefrombookmark") || !aUrl)
      return aTitle;

   var title = _getBookmarkTitle(aUrl);
   if (title || !window.gIeTab)
      return title || aTitle;

   // IE Tab is installed try to find url with or without the prefix
   var ietab = "chrome://ietab/content/reloaded.html?url="
   if (aUrl == ietab)
      return aTitle;
   if (aUrl.indexOf(ietab) == 0)
      title = _getBookmarkTitle(aUrl.replace(ietab, ""));
   else
      title = _getBookmarkTitle(ietab + aUrl);

   return title || aTitle;
}

function TMP_delayedStartup()
{
  if (numberOfWindows() == 1) {
    // make sure that we don't enable both sessionStore and session manager
    TMP_SessionStore.setService(1, true);
    // Add attribute to nsSessionStore persistTabAttribute after delay
    // we call this after nsSessionStore.init
    // we add this also when we use TMP session manager, because we always use Firefox SessionStore for restart
    window.setTimeout(TMP_SessionStore.persistTabAttribute, 2000);
  }

  // set title at startup if we not use session manager
  // startup page or home page load befor BMSVC
  if (gPrefService.getBoolPref("extensions.tabmix.titlefrombookmark")) {
    for (var i = 0; i < gBrowser.mPanelContainer.childNodes.length ; i++) {
      var aBrowser = gBrowser.getBrowserAtIndex(i);
      var aUrl = aBrowser.contentDocument.baseURI;
      aUrl = (aUrl) ? aUrl : aBrowser.currentURI.spec ;
      var bookMarkName = getTitleFromBookmark(aUrl);
      if (bookMarkName && aBrowser.contentDocument.title != bookMarkName)
        aBrowser.contentDocument.title = bookMarkName;
    }
  }
}

// this must run befor all
function TMP_beforStartup(tabBrowser)
{
    // ODFReader change Cc to something else maybe some other extensions do that too !!!
    if ("Cc" in window && Cc != Components.classes)
       Cc = Components.classes;

    if ("Ci" in window && Ci != Components.interfaces)
       Ci = Components.interfaces;

    var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                     .getService(Components.interfaces.nsIXULAppInfo);
    var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
                     .getService(Components.interfaces.nsIVersionComparator);
    gIsFirefox31 = versionChecker.compare(appInfo.version, "3.1a2") > 0;

    // fix conflict with Lori extension
    // and fix bug in Lori extension that prevent it from closing unread tabs
    if ("loriOldRemoveTab" in tabBrowser) {
      tabBrowser.removeTab = tabBrowser.loriOldRemoveTab;
      delete tabBrowser.loriOldRemoveTab;
      eval("tabBrowser.removeTab ="+tabBrowser.removeTab.toString().replace(
         'var index = -1;',
         'var b = this.getBrowserForTab(aTab); \
          if ("loriTabListener" in b) { \
            b.loriTabListener.destroy(); \
            b.loriTabListener = null; \
          } \ $&'
      ));
    }

    // we call this here befor some other extension (like Highlander) change handleLinkClick
    // don't call openNewWindowWith when we are in single window mode
    eval("handleLinkClick ="+handleLinkClick.toString().replace(
       'if (event.shiftKey)',
       'if (gSingleWindowMode && event.shiftKey) { \
           openNewTabWith(href, doc, null, event, false); \
           event.stopPropagation(); \
           return true; \
        } \
        $&'
    ).replace(
       'if (tab)',
       'if (gSingleWindowMode || tab)'
    ));

    // remove call to "arrowscrollbox" by "this.mTabContainer.mTabstrip" we don't use it in tabmix
    // for Firefox 2.0 +
    eval("tabBrowser.moveTabTo ="+tabBrowser.moveTabTo.toString().replace(
         'this.mTabContainer.insertBefore(aTab, this.mTabContainer.childNodes[aIndex]);',
         'this.mTabContainer.insertBefore(aTab, this.mTabContainer.childNodes.item(aIndex));'
        ).replace(
         'this.mTabContainer.mTabstrip.scrollBoxObject.ensureElementIsVisible(this.mCurrentTab);',
         ''
    ));

    eval("tabBrowser.addTab ="+tabBrowser.addTab.toString().replace(
         'aTabContainer.mTabstrip._updateScrollButtonsDisabledState();',
         ''
        ).replace(
         'this.mTabContainer.mTabstrip.scrollBoxObject.scrollBy(this.mTabContainer.firstChild.boxObject.width, 0);',
         ''
    ));

    if ("_beginRemoveTab" in tabBrowser) {
       // for Firefox 3.1+ //
       eval("tabBrowser._beginRemoveTab ="+tabBrowser._beginRemoveTab.toString().replace(
            'setTimeout(_delayedUpdate, 0, this.mTabContainer);',
            ''
           ).replace(
            /return;/g,
            'return null;'
       ));
       eval("tabBrowser._endRemoveTab ="+tabBrowser._endRemoveTab.toString().replace(
            'tabStrip.scrollBoxObject.getPosition(scrollPos, {});',
            'scrollPos.value = -tabStrip.boxObject.width;'
           ).replace(
            'tabStrip.scrollBoxObject.getScrolledSize(scrolledSize, {});',
            'scrolledSize.value = 2000;'
       ));
    }
    else {
       // for Firefox 2.0 - 3.0 //
       eval("tabBrowser.removeTab ="+tabBrowser.removeTab.toString().replace(
            'setTimeout(_delayedUpdate, 0, this.mTabContainer);',
            ''
           ).replace(
            'tabStrip.scrollBoxObject.getPosition(scrollPos, {});',
            'scrollPos.value = -tabStrip.boxObject.width;'
           ).replace(
            'tabStrip.scrollBoxObject.getScrolledSize(scrolledSize, {});',
            'scrolledSize.value = 2000;'
       ));
    }

    // return true if all tabs in the window are blank
    tabBrowser.isBlankWindow = function() {
       for (var i = 0; i < this.mTabs.length; i++) {
          if (!this.isBlankBrowser(this.getBrowserAtIndex(i)))
             return false;
       }
       return true;
    }

    tabBrowser.isBlankTab = function(aTab) {
      return this.isBlankBrowser(this.getBrowserForTab(aTab));
    }

    tabBrowser.isBlankNotBusyTab = function TMP_isBlankNotBusyTab(aTab) {
       if (aTab.hasAttribute("busy"))
          return false;

       return this.isBlankBrowser(this.getBrowserForTab(aTab));
    }

    tabBrowser.isBlankBrowser = function _isBlankBrowser(aBrowser) {
       try{
          if (!aBrowser)
             return true;
          return (!aBrowser.sessionHistory || aBrowser.sessionHistory.index < 0 ||
                  (aBrowser.sessionHistory.count < 2 &&
                  (!aBrowser.currentURI || aBrowser.currentURI.spec == 'about:blank')));
       } catch (e) {tmLog(e); return true;}
    }

    var tabContainer = tabBrowser.mTabContainer ||
                       document.getAnonymousElementByAttribute(tabBrowser, "anonid", "tabcontainer");
    eval("tabContainer.handleEvent ="+tabContainer.handleEvent.toString().replace(
         'this.mTabstrip.scrollBoxObject.ensureElementIsVisible(this.selectedItem);',
         'this.ensureTabIsVisible(this.selectedIndex);'
         ).replace( // for Firefox 3.0 after bug 347363
         'case "resize":',
         'case "resize": break;'
    ));

    if (!gIsFirefox3) {
      var _notifyBackgroundTab = tabContainer._notifyBackgroundTab.toString().split("(tsboStart > ctboStart || ctboEnd > tsboEnd)")
      _notifyBackgroundTab[0] = "function _notifyBackgroundTab(aTab) { \n if ";
      _notifyBackgroundTab = _notifyBackgroundTab.join("(!this.isTabVisible(aTab._tPos))");
      eval("tabContainer._notifyBackgroundTab =" + _notifyBackgroundTab);
    }

    var _mAllTabsPopup = tabContainer.mAllTabsPopup;
    if ("_updateTabsVisibilityStatus" in _mAllTabsPopup) {
      eval("_mAllTabsPopup._updateTabsVisibilityStatus ="+_mAllTabsPopup._updateTabsVisibilityStatus.toString().replace(
         'var tabstripBO = tabContainer.mTabstrip.scrollBoxObject;',
         'var tabstripBO = tabContainer.tabstrip.boxObject;'
      ));
    }

    TMP_eventListener.init(tabContainer);

}
