/*
 * chrome://tabmixplus/content/links/userInterface.js
 *
 * original code by Bradley Chapman
 * modified and developped by Hemiola SUN
 * modified again by Bradley Chapman
 *
 * modified again and again... by onemen
 *
 */
var gIOService =     Components.classes["@mozilla.org/network/io-service;1"]
                     .getService(Components.interfaces.nsIIOService);
var gPref =          Components.classes["@mozilla.org/preferences-service;1"]
                     .getService(Components.interfaces.nsIPrefBranch);
var gURIFixer =      Components.classes["@mozilla.org/docshell/urifixup;1"]
           .getService(Components.interfaces.nsIURIFixup);
var gWindowManager = Components.classes["@mozilla.org/appshell/window-mediator;1"]
           .getService(Components.interfaces.nsIWindowMediator);

/**
 * @brief Catch call to tabmix options from EM
 *        we only use Tabmix options if we have browser window
 *
 * @param aURL       A valid options URL string.
 *
 * @return           true if the URL is for tabmix options
 *                   false if not.
 *
 */
function TMP_cmd_options(aURL)
{
   if (aURL != "chrome://tabmixplus/content/pref/pref-tabmix.xul")
      return false;

   var browserWindow = gWindowManager.getMostRecentWindow("navigator:browser");

   if (!browserWindow) {
      var tabmixopt = gWindowManager.getMostRecentWindow("mozilla:tabmixopt");
      if (tabmixopt)
         tabmixopt.close();

      var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                    .getService(Components.interfaces.nsIPromptService);
      var stringBundle = Components.classes["@mozilla.org/intl/stringbundle;1"]
               .getService(Components.interfaces.nsIStringBundleService)
               .createBundle("chrome://tabmixplus/locale/tabmix.properties");
      var title = stringBundle.GetStringFromName("tabmixoption.error.title");
      var msg = stringBundle.GetStringFromName("tabmixoption.error.msg");
      promptService.alert(window, title, msg);
   }
   else
      browserWindow.TMP_openDialog(-1);

   return true;
}

/**
 * @brief Load URLs from the Extension/Theme Managers, and item with text-link class
 *
 * This redefines chrome://mozapps/content/extensions/extensions.js:openURL()
 *
 * @param aURL       A valid URI string.
 * @param event      A valid event union. This can be null when
 *                   calling this function.
 * @return           true.
 *
 */
function TMP_openURL(aURL, event)
{
   var linkTarget, loadInBackground;
   try {
            linkTarget = gPref.getIntPref("browser.link.open_newwindow");
   }
   catch (e) {
      linkTarget = 1;
   }

   if (aURL == null) aURL = "about:blank";

   // check for an existing window and focus it; it's not application modal
   var browserWindow = gWindowManager.getMostRecentWindow("navigator:browser");

   if (!browserWindow) {
      openDialog("chrome://browser/content/browser.xul", "_blank", "chrome,all,dialog=no", aURL, null, null, null);
      if (event && event instanceof Event) {
         event.preventDefault();
         event.stopPropagation();
      }
      return true;
   }

   var tabBrowser = browserWindow.getBrowser();
   var originCharset = tabBrowser.contentDocument.characterSet;

   // if the current tab is empty, then do not open a new tab
   if (tabBrowser.selectedBrowser.webNavigation.currentURI.spec == "about:blank") {
      // 1: CURRENT_TAB
      linkTarget = 1;
      originCharset = null;
   }

      switch (linkTarget) {
         case 1 :
            tabBrowser.loadURI(aURL, null, originCharset);
            break;
         case 2 :
            browserWindow.openNewWindowWith(aURL, null, null, false);
            break;
         case 3 :
            // added by request, for extensions with multiple homepages
            var urls = aURL.split("|");
            var firstTab = tabBrowser.addTab(urls[0], null, originCharset);
            // only select the EM/TM link when asked to do so
            tabBrowser.TMP_selectNewForegroundTab(firstTab);
            for (var i = 1; i < urls.length; ++i) {
               tabBrowser.addTab(urls[i], null, originCharset);
            }
            tabBrowser.mTabContainer.nextTab = 1;
            break;
      }

   if (event && event instanceof Event) {
      event.preventDefault();
      event.stopPropagation();
   }
   return true;
}

function TMP_BrowserOpenTab(aTab)
{
   var newTabContent = TMP_getIntPref(tabxBranch, "loadOnNewTab", 0 );

   var url;
   switch (newTabContent) {
      case 0 : // blank tab, by default
         url = "about:blank";
         break;
      case 1 :  // home page
         url = gHomeButton.getHomePage().split("|")[0];
         break;
      case 2 : // current URI
         var currentURI = gBrowser.selectedBrowser.webNavigation.currentURI;
         url = currentURI ? currentURI.spec : "about:blank";
         break;
      case 3 : // duplicate tab
         gBrowser.duplicateTab(gBrowser.selectedTab);
         return;
      case 4 : // user url
         try {
            url = gPref.getComplexValue("extensions.tabmix.newTabUrl",
                                Components.interfaces.nsIPrefLocalizedString).data;
         } catch (e) {  tmLog(e); }
         // use this if we can't find the pref
         if (!url)
            url = "about:blank";
         break;
      default:
         url = "about:blank";
   }

   var loadBlank = url == "about:blank";
   var newTab = gBrowser.addTab();
   if (aTab && aTab.localName == "tab") {
      var pos = newTab._tPos > aTab._tPos ? 1 : 0;
      gBrowser.TMmoveTabTo(newTab, aTab._tPos + pos);
   }
   if (!loadBlank) {
      try { // just in case.....
         var originCharset = gBrowser.selectedBrowser.contentDocument.characterSet;
         var flags = nsIWebNavigation.LOAD_FLAGS_NONE;
         gBrowser.getBrowserForTab(newTab).loadURIWithFlags(url, flags, null, originCharset);
         content.focus();
      }
      catch (ex) {}
   }
   gBrowser.TMP_selectNewForegroundTab(newTab, tabxPrefs.getBoolPref("loadNewInBackground"), url);
}

/**
 * @brief Load URLs generated by the search bar.
 *
 * @param aData            A string containing text to search.
 * @param aEvent           a valid event union.
 * @param aWhere           where to open the search result. (firefox 3.0+)
 * @return                 Nothing.
 *
 */
function TMP_SearchLoadURL(aData, aEvent, aWhere)
{
  var newTabPref, isAltKey;
  var theBGPref  = TMP_getBoolPref(tabxBranch, "loadSearchInBackground", false);

  var searchbar = document.getElementById("searchbar");
  var submission = searchbar.currentEngine.getSubmission(aData, null);
  var url = submission.uri.spec;
  var postData = submission.postData;

  if (gIsFirefox3) {
    switch (aWhere) {
      case "window":
        openUILinkIn(url, aWhere, null, postData);
        return;
        break;
      case "tabshifted":
        theBGPref = !theBGPref;
      case "tab":
        newTabPref = true;
        break;
      case "current":
        newTabPref = false;
        break;
      default: // just in case...
        newTabPref = TMP_getBoolPref("", "browser.search.openintab", false);
    }
  }
  else { // firefox 2.0
     // Bug 336925: Middle clicking search button should open new tab search.xml version 1.67
     // Always open in a new tab on a middle-click; otherwise examine the
     // preference and the alt key.
     if (aEvent && "button" in aEvent && aEvent.button == 1)
        newTabPref = true;
     else
        newTabPref = TMP_getBoolPref("", "browser.search.openintab", false);

     isAltKey = aEvent && "altKey" in aEvent && aEvent.altKey;
  }
  newTabPref = TMP_whereToOpen(newTabPref, isAltKey).inNew;
  __TMP_LoadBarURL(url, aEvent, newTabPref, theBGPref, postData, false);
}

/**
 * @brief Load URLs from the URL bar.
 *
 * @param event         A valid event union.
 * @param aPostData     Additional opaque data used by __TMP_LoadBarURL().
 * @param altDisabled   parameter set by URL Suffix extension, to prevent ALT from opening new tab
 * @return              Nothing.
 *
 */
function TMP_BrowserLoadURL(theEvent, aPostData, altDisabled, aUrl)
{
  var newTabPref = TMP_getBoolPref(tabxBranch, "opentabfor.urlbar", false);
  var theBGPref  = TMP_getBoolPref(tabxBranch, "loadUrlInBackground", false);

  var theURI = window.gIeTab ? gIeTab.getHandledURL(aUrl || gURLBar.value, gURLBar.isModeIE) : aUrl || gURLBar.value;
  var middleClick = theEvent instanceof MouseEvent && (theEvent.button == 1 || theEvent.ctrlKey || theEvent.metaKey);
  if (aUrl || middleClick) { // aUrl is not null when we call this function from PopupAutoCompleteRichResult.onPopupClick
    var where = whereToOpenLink(theEvent);
    if (where == "tabshifted") {
      theBGPref  = !theBGPref;
      newTabPref = true;
    }
    else {
      openUILinkIn(theURI, where, true /* allow third party fixup */, aPostData);
      return;
    }
  }

  var isAltKey = !altDisabled && (theEvent instanceof Event && ('altKey' in theEvent && theEvent.altKey));
  newTabPref = TMP_whereToOpen(newTabPref, isAltKey).inNew;

  __TMP_LoadBarURL(theURI, theEvent, newTabPref, theBGPref, aPostData, true);
}

/**
 * @brief Load URLs from the URL bar, search bar and search dialog.
 *
 * This function is used directly by Tab Mix Plus.
 *
 * @param aURI                    The URI to be opened.
 * @param aEvent                  A valid event union, or a Boolean value when
 *                                called by TMP_SearchLoadURL().
 * @param aNewTabPref             A Boolean preference - if true, the URL will be
 *                                opened in a new tab; if false, it will load in
 *                                the current tab.
 * @param aLoadInBackground       A Boolean preference - if false, the newly created tab will be focused;
 *                                if true, the newly created tab will be unfocused.
 * @param aPostData               Additional opaque data used by tabbrowser methods
 * @param aAllowThirdPartyFixup   Allow third-party services to fixup this URL
 * @returns                       Nothing.
 *
 */
function __TMP_LoadBarURL(aURI, aEvent, aNewTabPref, aLoadInBackground, aPostData, aAllowThirdPartyFixup)
{
  var originCharset = null;

  if (gBrowser.localName != "tabbrowser") {
    loadURI(aURI, null, aPostData, aAllowThirdPartyFixup);
    content.focus();
    return;
  }
  else {
    var currentURI = gBrowser.selectedBrowser.webNavigation.currentURI;
    var url = currentURI ? currentURI.spec : "about:blank";
    originCharset = url != "about:blank" ? gBrowser.selectedBrowser.contentDocument.characterSet : null;
  }

  if (aNewTabPref) {
    if (gIsFirefox31) {
      if (gURLBar)
        gURLBar.handleRevert();
    }
    else
      handleURLBarRevert();
    content.focus();
    try {
      // open new tab in 2 step, this prevent focus problem with forms field
      var newTab = gBrowser.addTab();
      var flags = nsIWebNavigation.LOAD_FLAGS_NONE;
      if (aAllowThirdPartyFixup) {
        flags = nsIWebNavigation.LOAD_FLAGS_ALLOW_THIRD_PARTY_FIXUP;
      }
      gBrowser.getBrowserForTab(newTab).loadURIWithFlags(aURI, flags, null, originCharset, aPostData);
    } catch (e) {  }
    gBrowser.TMP_selectNewForegroundTab(newTab, aLoadInBackground);
  }
  // not opening in a new tab at all
  else
    loadURI(aURI, null, aPostData, aAllowThirdPartyFixup);

  if (gIsFirefox3)
     focusElement(content);
  else
    content.focus();

  if (aEvent instanceof Event) {
    aEvent.preventDefault();
    aEvent.stopPropagation();
  }
  return;
}

// openUILink handles clicks on UI elements that cause URLs to load.
function TMP_openUILink( url, e, ignoreButton, ignoreAlt, allowKeywordFixup, postData, referrerUrl)
{
  var where = whereToOpenLink(e, ignoreButton, ignoreAlt);

  var win = getTopWin();
  if (win) {
    // don't open blanke tab when we are about to add new livemark
    var _addLivemark = /^feed:/.test(url) && gPref.getCharPref("browser.feeds.handler") == "bookmarks";
    if (where == "current" && TMP_openUILink.caller.name != "openTopWin" && !_addLivemark)
      where = win.TMP_checkCurrent(url);
  }

  try {
    openUILinkIn(url, where, allowKeywordFixup, postData, referrerUrl);
  }
  catch (ex) {   }
}

function TMP_checkCurrent(url)
{
  if (gBrowser.mCurrentTab.hasAttribute("locked")) {
    var isBlankTab = gBrowser.isBlankNotBusyTab(gBrowser.mCurrentTab);
    if (!isBlankTab)
       return "tab";
  }
  else if (gPref.getIntPref("extensions.tabmix.speLink") == 2 ) {
    // Get current page url
    var curpage = gBrowser.mCurrentBrowser.webNavigation.currentURI.spec;
    var domain = checkDomain(curpage, url);
    if (domain.current && domain.target && domain.target != domain.current)
      return "tab";
  }
  return "current";
}
