//code from Dorando and Sboulema's MiniT+, modified by Hemiola SUN
// modified by onemen

const DRAG_LINK = 0;
const DRAG_TAB_TO_NEW_WINDOW = 1;
const DRAG_TAB_IN_SAME_WINDOW = 2;

function TMP_DragAndDrop_init() {
   TMP_setDragEvents(true);

   // for Firefox Dragmark
   gBrowser.mTabDropIndicatorBar.addEventListener('dragover', TMP_TabDragOver, true);
   gBrowser.mTabDropIndicatorBar.addEventListener('dragdrop', TMP_TabDragDrop, true);

   // insert vide-bar after update mTabDropIndicatorBar to prevent bug 398254
   // Bug 398254  Since the landing of 372769, I can no longer drag and drop tabs with TabMixPlus
   gBrowser.mTabBox.insertBefore(document.getElementById('vide-bar'), gBrowser.mTabBox.firstChild);

   var stringBundle = document.getElementById("tmp-string-bundle");
   TabDNDObserver.draglink = stringBundle.getString("droplink.label")
}

function TMP_setDragEvents(atStart) {
  // we only set Tabmix events at start if Tree Style Tab is not in vertical mode
  var useDefaultDnD = false;
  if ("TreeStyleTabBrowser" in window) {
    try {
      var tabbarPosition = gPref.getCharPref("extensions.treestyletab.tabbar.position").toLowerCase();
    }
    catch (er) {};
    useDefaultDnD = tabbarPosition == "left" || tabbarPosition == "right";
    if (atStart && useDefaultDnD) {
      gBrowser.mStrip.useDefaultDnD = useDefaultDnD;
      return; // nothing to do here;
    }
  }

  if (gBrowser.mStrip.useDefaultDnD == useDefaultDnD) {
    return; // nothing to do here;
  }
  gBrowser.mStrip.useDefaultDnD = useDefaultDnD;

  if (useDefaultDnD && gIsFirefox31) {
    gBrowser.mStrip.setAttribute("ondragstart", "this.parentNode.parentNode._onDragStart(event); event.stopPropagation();");
    gBrowser.mStrip.setAttribute("ondragover", "this.parentNode.parentNode._onDragOver(event); event.stopPropagation();");
    gBrowser.mStrip.setAttribute("ondrop", "this.parentNode.parentNode._onDrop(event); event.stopPropagation();");
    gBrowser.mStrip.setAttribute("ondragleave", "this.parentNode.parentNode._onDragLeave(event); event.stopPropagation();");
  }
  else if (useDefaultDnD && !gIsFirefox31) {
    gBrowser.mStrip.setAttribute("ondraggesture","nsDragAndDrop.startDrag(event, this.parentNode.parentNode); event.stopPropagation();");
    gBrowser.mStrip.setAttribute("ondragover","nsDragAndDrop.dragOver(event, this.parentNode.parentNode); event.stopPropagation();");
    gBrowser.mStrip.setAttribute("ondragdrop","nsDragAndDrop.drop(event, this.parentNode.parentNode); event.stopPropagation();");
    gBrowser.mStrip.setAttribute("ondragexit","nsDragAndDrop.dragExit(event, this.parentNode.parentNode); event.stopPropagation();");
  }
  else if (gIsFirefox31) {
    gBrowser.mStrip.setAttribute("ondragstart", "TMP_TabDragGesture(event);");
    gBrowser.mStrip.setAttribute("ondragover", "TMP_TabDragOver(event);");
    gBrowser.mStrip.setAttribute("ondrop", "TMP_TabDragDrop(event);");
    gBrowser.mStrip.setAttribute("ondragleave", "TMP_TabDragExit(event);");
  }
  else {
    gBrowser.mStrip.setAttribute("ondraggesture", "TMP_TabDragGesture(event);");
    gBrowser.mStrip.setAttribute("ondragover", "TMP_TabDragOver(event);");
    gBrowser.mStrip.setAttribute("ondragdrop", "TMP_TabDragDrop(event);");
    gBrowser.mStrip.setAttribute("ondragexit", "TMP_TabDragExit(event);");
  }
}

///////////////////////////////////////////////////////////////////////////
//// Drag and Drop observers

function TMP_TabDragGesture(aEvent) {
   nsDragAndDrop.startDrag(aEvent, TabDNDObserver);
   aEvent.stopPropagation();
}

function TMP_TabDragOver(aEvent) {
   nsDragAndDrop.dragOver(aEvent, TabDNDObserver);
   aEvent.stopPropagation();
}

function TMP_TabDragDrop(aEvent) {
   nsDragAndDrop.drop(aEvent, TabDNDObserver);
   aEvent.stopPropagation();
   if (gIsFirefox31)
      aEvent.preventDefault();   
}

function TMP_TabDragExit(aEvent) {
   nsDragAndDrop.dragExit(aEvent, TabDNDObserver);
   aEvent.stopPropagation();
}

var TabDNDObserver = {
  gBackupLabel: "",
  gMsg: null,
  draglink: "",
  lastTime: 0,

  onDragStart: function (event, transferData, action) {
   if(event.target.localName != "tab" || event.originalTarget.localName == "toolbarbutton") return;

   for ( var i = 0; i < gBrowser.mTabs.length; i++ )
      gBrowser.mTabs[i].setAttribute("showbutton","off");

   transferData.data = new TransferData();

   var URI = gBrowser.getBrowserForTab(event.target).currentURI;
   if (URI) {
      transferData.data.addDataForFlavour("text/x-moz-url", URI.spec + "\n" + event.target.label);
      transferData.data.addDataForFlavour("text/unicode", URI.spec);
      transferData.data.addDataForFlavour("text/html", '<a href="' + URI.spec + '">' + event.target.label + '</a>');
   } else {
      transferData.data.addDataForFlavour("text/unicode", "about:blank");
   }
  },

  getSupportedFlavours : function () {
   var flavourSet = new FlavourSet();
   flavourSet.appendFlavour("text/x-moz-url");
   flavourSet.appendFlavour("text/unicode");
   flavourSet.appendFlavour("application/x-moz-file", "nsIFile");
   return flavourSet;
  },

  canDrop: function (aEvent, aDragSession) {
   if (aDragSession.sourceNode &&
       aDragSession.sourceNode.parentNode == gBrowser.mTabContainer) {
       var sourceBo = aDragSession.sourceNode.boxObject;
       if (aEvent.screenX >= sourceBo.screenX &&
           aEvent.screenX <= (sourceBo.screenX +sourceBo.width) &&
           aEvent.screenY >= sourceBo.screenY &&
           aEvent.screenY <= (sourceBo.screenY +sourceBo.height))
         return false;
   }
   return true;
  },

  onDragOver: function minit_onDragOver(event, flavours, session) {
   var draggeType = this.getDragType(session);
   var newIndex = this.getNewIndex(event);
   var oldIndex = draggeType != DRAG_LINK ? session.sourceNode._tPos : -1;
   var left_right; // 1:right, 0: left, -1: drop link on tab to replace tab
   if (newIndex < gBrowser.mTabs.length)
      left_right = this.getLeft_Right(event, newIndex, oldIndex, draggeType);
   else {
      newIndex = draggeType != DRAG_TAB_IN_SAME_WINDOW && tabxPrefs.getBoolPref("openTabNext") ? gBrowser.mTabContainer.selectedIndex :
                  gBrowser.mTabs.length - 1;
      left_right = 1;
   }

   var replaceTab = false;
   var isCopy = "dataTransfer" in event ? (event.dataTransfer.dropEffect == "copy") : (event.ctrlKey || event.metaKey);   
   // don't allow to drop on lock tab unless the tab is blanck or the user press Ctrl/Meta Key or we drop link that start dounload
   if (left_right == -1) { // check if tab is lock
      replaceTab = true;
      var aTab = gBrowser.mTabs[newIndex];
      if (!isCopy && aTab.getAttribute("locked") && !gBrowser.isBlankNotBusyTab(aTab)) {
         var disAllowDrop = true;
         try {
            var trans = Cc["@mozilla.org/widget/transferable;1"]
                                        .createInstance(Ci.nsITransferable);
            trans.addDataFlavor("text/unicode");
            trans.addDataFlavor("text/x-moz-url");
            session.getData(trans, 0);
            var data = { }, type = { };
            trans.getAnyTransferData(type, data, { });
            if (data) {
               data = data.value.QueryInterface(Ci.nsISupportsString).data;
               var url = transferUtils.retrieveURLFromData(data, type.value);
               disAllowDrop = !isUrlForDownload(url);
            }
         } catch (ex) {
         }

         if(disAllowDrop)
            gIsFirefox31 && "effectAllowed" in event.dataTransfer ? event.dataTransfer.effectAllowed = "none" : session.canDrop = false;
      }
   }

   if (draggeType == DRAG_TAB_IN_SAME_WINDOW && oldIndex == newIndex) {
      if (isCopy)
         gIsFirefox31 && "effectAllowed" in event.dataTransfer ? event.dataTransfer.effectAllowed = "copyMove" : session.canDrop = true;
      else
         gIsFirefox31 && "effectAllowed" in event.dataTransfer ? event.dataTransfer.effectAllowed = "none" : session.canDrop = false;
   }

   var canDrop = gIsFirefox31 && "effectAllowed" in event.dataTransfer ? event.dataTransfer.effectAllowed != "none" : session.canDrop;
   if (canDrop && !this.isValidTarget(event, session))
      return;

   // show Drag & Drop message
   if (draggeType == DRAG_LINK) {
      this.gMsg = event.originalTarget.id == "tabs-newbutton" ? gNavigatorBundle.getString("droponnewtabbutton") : this.draglink;
      var statusTextFld = document.getElementById("statusbar-display");
      if (statusTextFld.label != this.gMsg) {
         if (this.gBackupLabel=="") this.gBackupLabel = statusTextFld.label;
         statusTextFld.label = this.gMsg;
      }
   }

   var hideIndicator = false;
   var tabStripBoxObject = gBrowser.mTabContainer.tabstrip.boxObject;
   var index = newIndex+left_right-1;
   var newTime;
   if (gBrowser.mTabContainer.getAttribute("overflow") == "true") {
      var _scroll;
      var targetAnonid = event.originalTarget.getAttribute("anonid");
      switch (targetAnonid) {
         case "scrollbutton-up":
             if (gBrowser.mTabContainer.canScrollTabsLeft)
                _scroll = -1;
             break;
         case "scrollbutton-down":
            if (gBrowser.mTabContainer.canScrollTabsRight)
               _scroll = 1;
            break;
      }
      if (_scroll) {
         newTime = new Date().getTime();
         if (newTime - this.lastTime > 100) {
            gBrowser.mTabContainer.tabsScroll(_scroll);
            this.lastTime = newTime;
         }
         hideIndicator = true;
      }
   }

    if ( replaceTab || hideIndicator || !canDrop) {
      this.clearDragmark();
      return;
   }

   this.setDragmark(newIndex, left_right);

   if (gIsFirefox3 && draggeType == DRAG_LINK && event.target.localName == "tab") {
      if (!gBrowser.mDragTime)
         gBrowser.mDragTime = Date.now();
      if (Date.now() >= gBrowser.mDragTime + gBrowser.mDragOverDelay)
         gBrowser.mTabContainer.selectedItem = event.target;
      return;
   }

  },

  onDrop: function minit_onDrop(event, dropData, session) {
    this.clearDragmark();
    var draggeType = this.getDragType(session);
    var isCopy = "dataTransfer" in event ? (event.dataTransfer.dropEffect == "copy") : (event.ctrlKey || event.metaKey);
    var draggedTab;
    if (draggeType != DRAG_LINK)
      draggedTab = session.sourceNode;

    var isTabReorder = draggeType == DRAG_TAB_IN_SAME_WINDOW // TreeStyleTab extension look for isTabReorder in our code
    var newIndex = this.getNewIndex(event);
    var oldIndex = draggedTab ? draggedTab._tPos : -1;
    var left_right;

    if (newIndex < gBrowser.mTabs.length)
       left_right = this.getLeft_Right(event, newIndex, oldIndex, draggeType);
    else {
       newIndex = draggeType != DRAG_TAB_IN_SAME_WINDOW && tabxPrefs.getBoolPref("openTabNext") ? gBrowser.mTabContainer.selectedIndex :
                   gBrowser.mTabs.length - 1;
       left_right = 1;
    }

    if (draggedTab && (isCopy || draggeType == DRAG_TAB_IN_SAME_WINDOW)) {
      if (isCopy) {
        // copy the dropped tab (wherever it's from)
        var newTab = gBrowser.duplicateTab(draggedTab);
        gBrowser.moveTabTo(newTab, newIndex + left_right);

        if (draggeType == DRAG_TAB_TO_NEW_WINDOW || event.shiftKey)
          gBrowser.selectedTab = newTab;
      }
      else {
        // move the dropped tab
        newIndex += left_right - (newIndex > oldIndex);
        if (newIndex != draggedTab._tPos)
          gBrowser.moveTabTo(draggedTab, newIndex);
      }

      draggedTab.collapsed = false;
      if ( gBrowser.mTabContainer.getAttribute("flowing") == "multibar" &&
            gBrowser.mTabContainer.getAttribute("multibar") == "scrollbar" &&
            oldIndex < gBrowser.mTabContainer.collapsedTabs )
         gBrowser.mTabs[gBrowser.mTabContainer.collapsedTabs-1].collapsed = true;
      gBrowser.mTabContainer.ensureTabIsVisible(newIndex);
      checkBeforeAndAfter();
    }
    else if (draggedTab) {
      if ("swapBrowsersAndCloseOther" in gBrowser) {
        // Firefox 3.1+
        // swap the dropped tab with a new one we create and then close
        // it in the other window (making it seem to have moved between
        // windows)
        newTab = gBrowser.addTab("about:blank");
        var newBrowser = gBrowser.getBrowserForTab(newTab);
        // Stop the about:blank load
        newBrowser.stop();
        // make sure it has a docshell
        newBrowser.docShell;

        gBrowser.moveTabTo(newTab, newIndex + left_right);

        gBrowser.swapBrowsersAndCloseOther(newTab, draggedTab);

        // We need to set selectedTab after we've done
        // swapBrowsersAndCloseOther, so that the updateCurrentBrowser
        // it triggers will correctly update our URL bar.
        gBrowser.selectedTab = newTab;
        gBrowser.setTabTitle(newTab);
      }
      else {
        // Firefox 2.0 - 3.0
        // copy the dropped tab and remove it from the other window
        // (making it seem to have moved between windows)
        var sourceWindow = draggedTab.ownerDocument.defaultView;
        var remoteBrowser = sourceWindow.getBrowser();
        var tabCount = remoteBrowser.tabContainer.childNodes.length;

       /*
        * In Firefox 2.0 when we move the current tab select other tab in surece window
        * before the new window get the focus, this will prevent the focus to jump back
        * to the surece window from the new window when gBrowser.removetab select new tab.
        */
        if (!gIsFirefox3 && tabCount > 1 && draggedTab == remoteBrowser.mCurrentTab) {
          var newIndex = remoteBrowser.selectIndexAfterRemove(draggedTab);
          remoteBrowser.selectedTab = remoteBrowser.mTabContainer.childNodes[newIndex];
        }

        newTab = gBrowser.duplicateTab(draggedTab);
        gBrowser.moveTabTo(newTab, newIndex + left_right);
        gBrowser.selectedTab = newTab;
        remoteBrowser.removeTab(draggedTab);
        // close the other window if gBrowser was its last tab
        if (tabCount == 1)
          draggedTab.ownerDocument.defaultView.close();
      }
    }
    else {
      var url = transferUtils.retrieveURLFromData(dropData.data, dropData.flavour.contentType);

      // valid urls don't contain spaces ' '; if we have a space it isn't a valid url.
      // Also disallow dropping javascript: or data: urls--bail out
      if (!url || !url.length || url.indexOf(" ", 0) != -1 ||
         /^\s*(javascript|data):/.test(url))
         return;

      // in firefox 3.0 dragDropSecurityCheck moved from gBrowser to nsDragAndDrop
      if (gIsFirefox3)
        nsDragAndDrop.dragDropSecurityCheck(event, session, url);
      else
             gBrowser.dragDropSecurityCheck(event, session, url);

      var bgLoad = true;
      try {
        bgLoad = gBrowser.mPrefs.getBoolPref("browser.tabs.loadInBackground");
      }
      catch (e) { }

      if (event.shiftKey)
        bgLoad = !bgLoad; // shift Key reverse the pref

      url = getShortcutOrURI(url);
      var tab = null;
      if (left_right > -1 && !isUrlForDownload(url)) {
        // We're adding a new tab.
         try {
            tab = gBrowser.addTab(url);
            gBrowser.moveTabTo(tab, newIndex + left_right);
         } catch(ex) {
            // Just ignore invalid urls
            tmLog("addTab\n" + ex);
            return;
         }
      }
      else {
        // Load in an existing tab.
        tab = event.target.localName == "tab" ? event.target : gBrowser.mTabs[newIndex];
        try {
          gBrowser.getBrowserForTab(tab).loadURI(url);
        } catch(ex) {
          // Just ignore invalid urls
          tmLog("load\n" + ex);
          return;
        }
      }
      if (gBrowser.mCurrentTab != tab)
        gBrowser.TMP_selectNewForegroundTab(tab, bgLoad, url);
    }
  },

  onDragExit: function (event, session) {
   gBrowser.mDragTime = 0;
   this.isValidTarget(event, session);
  },

  isValidTarget: function (event, session) {
   if ( event.clientY <= gBrowser.mStrip.boxObject.y+1 ||
         event.clientX < gBrowser.mStrip.boxObject.x ||
         event.clientY >= gBrowser.mStrip.boxObject.y + gBrowser.mStrip.boxObject.height) {
      if (document.getElementById("statusbar-display").label == this.gMsg) {
         document.getElementById("statusbar-display").label = this.gBackupLabel;
         this.gBackupLabel="";
      }
      this.clearDragmark(event);
      gIsFirefox31 && "effectAllowed" in event.dataTransfer ? event.dataTransfer.effectAllowed = "none" : session.canDrop = false;
      return false;
   }
   return true;
  },

  getNewIndex: function (event) {
   // start to chack after collapsedTabs
   // if X is less then the first tab return 0
   // check if the tab is visible... if not return gBrowser.mTabs.length
   // check if Y is below the tab.... if yes go to next row
   // in the row find the closest tab by X,
   // if no tab is match return gBrowser.mTabs.length
   var mX = event.clientX, mY = event.clientY;
   var i, aTab, tabs = gBrowser.mTabContainer.childNodes;
   var collapsed = gBrowser.mTabContainer.collapsedTabs;
   if ( !gBrowser.mTabContainer.hasAttribute("multibar") ) {
      if (window.getComputedStyle(gBrowser, null).direction == "ltr") {
         for (i = event.target.localName == "tab" ? event.target._tPos : collapsed; i < gBrowser.mTabs.length; i++)
            if (mX < tabs[i].boxObject.x + tabs[i].boxObject.width)
               return i;
      }
      else {
         for (i = event.target.localName == "tab" ? event.target._tPos : 0 ; i < gBrowser.mTabs.length - collapsed; i++)
            if (mX > tabs[i].boxObject.x + tabs[i].boxObject.width*0)
               return i;
      }
   }
   else if (window.getComputedStyle(gBrowser, null).direction == "ltr") {
      for (i = collapsed; i < tabs.length; i++) {
         if (!gBrowser.mTabContainer.isTabVisible(i))
            return tabs.length;
         aTab = tabs[i];
         if (mY >= aTab.baseY) {
            while (i < tabs.length - 1 && inSameRow(aTab, tabs[i+1]) )
               i++;
         }
         else if (mX < aTab.boxObject.x + aTab.boxObject.width )
            return i;
         else if (i == tabs.length - 1 || !inSameRow(aTab, tabs[i+1]) )
            return i;
      }
   }
   else {
      for (i = collapsed; i < tabs.length; i++) {
         if (!gBrowser.mTabContainer.isTabVisible(i))
            return tabs.length;
         aTab = tabs[i];
         if (mY >= aTab.baseY) {
            while (i < tabs.length - 1 && inSameRow(aTab, tabs[i+1]) )
               i++;
         }
         else if (mX > aTab.boxObject.x)
            return i;
         else if (i == tabs.length - 1 || !inSameRow(aTab, tabs[i+1]) )
            return i;
      }
   }
   return tabs.length;
  },

  getLeft_Right: function (event, newIndex, oldIndex, draggeType) {
   var clientX = event.clientX;
   var left_right;
   var tab = gBrowser.mTabs[newIndex];
   var tabBo = tab.boxObject;
   var ltr = (window.getComputedStyle(gBrowser, null).direction == "ltr");
   var _left = ltr ? 0 : 1;
   var _right = ltr ? 1 : 0;

   var isCtrlKey = ((event.ctrlKey || event.metaKey) && !event.shiftKey && !event.altKey);   
   var lockedTab = tab.getAttribute("locked") && !gBrowser.isBlankNotBusyTab(tab);
   if ((draggeType == DRAG_LINK && lockedTab) || (draggeType == DRAG_LINK && !lockedTab && !isCtrlKey)) {
      left_right = (clientX < tabBo.x + tabBo.width / 4 ) ? _left : _right;
      if (left_right == 1 && clientX < tabBo.x + tabBo.width * 3 / 4 )
         left_right = -1;
   }
   else {
      left_right = ( clientX < tabBo.x + tabBo.width / 2 ) ? _left : _right;
      if (!isCtrlKey && draggeType == DRAG_TAB_IN_SAME_WINDOW) {
        if (newIndex == oldIndex - 1)
          left_right = _left;
        else if (newIndex == oldIndex + 1)
          left_right = _right;
      }
   }

   return left_right;
  },

  getDragType: function minit_onDrop(session) {
    if (session.sourceNode && session.sourceNode.localName == "tab") {
      if (session.sourceNode.parentNode == gBrowser.mTabContainer)
        return DRAG_TAB_IN_SAME_WINDOW; // 2
      if (session.sourceNode.ownerDocument.defaultView instanceof ChromeWindow &&
         session.sourceNode.ownerDocument.documentElement.getAttribute("windowtype") == "navigator:browser")
        return DRAG_TAB_TO_NEW_WINDOW; // 1
    }
    return DRAG_LINK; // 0
  },

  setDragmark: function (index, left_right) {
   var newIndex = index + left_right;
   if (gBrowser.hasAttribute("dragmarkindex") && gBrowser.getAttribute("dragmarkindex") == newIndex)
      return;

   this.clearDragmark();// clear old dragmark if one exist

   if (!tabxPrefs.getBoolPref("useFirefoxDragmark")) {
      var sameRow = newIndex != 0 && newIndex != gBrowser.mTabs.length &&
            inSameRow(gBrowser.mTabs[newIndex-1], gBrowser.mTabs[newIndex]);
      if (sameRow || left_right==0)
         this.setDragmarkAttribute(gBrowser.mTabs[newIndex], "atLeft");
      if (sameRow || left_right==1)
         this.setDragmarkAttribute(gBrowser.mTabs[newIndex-1], "atRight");
   }
   else {
      // code for firefox indicator
      var ib = gBrowser.mTabDropIndicatorBar;
      var ind = ib.firstChild;
      this.setFirefoxDropIndicator(true);
      var tabStripBoxObject = gBrowser.mTabContainer.tabstrip.boxObject;
      var halfIndWidth = gIsFirefox3 ? 0 : Math.floor((ind.boxObject.width + 1) / 2);
      var minMargin = tabStripBoxObject.x - halfIndWidth - (gIsFirefox3 ? gBrowser.boxObject.x : ib.boxObject.x);
      var maxMargin = Math.min((minMargin + tabStripBoxObject.width),
                  (ib.boxObject.x + ib.boxObject.width - ind.boxObject.width));

      var ltr = (window.getComputedStyle(gBrowser, null).direction == "ltr");
      if (!ltr)
         [minMargin, maxMargin] = [gBrowser.boxObject.width - maxMargin, gBrowser.boxObject.width - minMargin];

      if (gTabbarPosition != 1)
         this.setFirefoxDropIndicator(false);
      var newMargin;
      var tabBoxObject = gBrowser.mTabs[index].boxObject;
      if ( left_right == 0 ) {
         if (ltr)
            newMargin = tabBoxObject.screenX - gBrowser.boxObject.screenX - halfIndWidth;
         else
            newMargin = gBrowser.boxObject.screenX - tabBoxObject.screenX
                        + gBrowser.boxObject.width - tabBoxObject.width - halfIndWidth;
      }
      else {
         if (ltr)
            newMargin = tabBoxObject.screenX - gBrowser.boxObject.screenX
                         + tabBoxObject.width - halfIndWidth;
          else
             newMargin = gBrowser.boxObject.screenX - tabBoxObject.screenX
                         + gBrowser.boxObject.width  - halfIndWidth;
      }

      // ensure we never place the drop indicator beyond our limits
      if (newMargin < minMargin)
         newMargin = minMargin;
      else if (newMargin > maxMargin)
            newMargin = maxMargin;

      ind.style.MozMarginStart = newMargin + 'px';

      if ( gTabbarPosition == 1) {
         ind.style.marginTop = tabBoxObject.screenY - ib.boxObject.screenY + "px";
         ind.style.backgroundPosition = "50% 0%";
      } else {
         var offset = gFirefox2DefaultTheme ? -3 : 0;
         ind.style.marginBottom = gBrowser.mTabContainer.boxObject.screenY -
                                  tabBoxObject.screenY + offset + "px";
         ind.style.backgroundPosition = "50% 100%";
         this.setFirefoxDropIndicator(true);
      }

   }

   gBrowser.setAttribute("dragmarkindex", newIndex);
  },

  clearDragmark: function () {
   if (!gBrowser.hasAttribute("dragmarkindex"))
      return;

   if (!tabxPrefs.getBoolPref("useFirefoxDragmark")) {
      var index = gBrowser.getAttribute("dragmarkindex");
      if (index != gBrowser.mTabs.length && gBrowser.mTabs[index].hasAttribute("dragmark"))
         this.removetDragmarkAttribute(gBrowser.mTabs[index]);
      if (index != 0 && gBrowser.mTabs[index-1].hasAttribute("dragmark"))
         this.removetDragmarkAttribute(gBrowser.mTabs[index-1]);
   }
   else
      this.setFirefoxDropIndicator(false);

   gBrowser.removeAttribute("dragmarkindex");
  },

  // since bug 390979 landed (2007-09-17) firefox use collapsed instead of visibility to show the tab drop indicator
  setFirefoxDropIndicator: function (val) {
    var ib = gBrowser.mTabDropIndicatorBar;
    if (gIsFirefox3)
      ib.collapsed = !val;
    else
      ib.setAttribute('dragging',val);
  },

  removetDragmarkAttribute: function (tab) {
   tab.removeAttribute("dragmark");
   if (gWidthFitTitle && tab.hasAttribute("width"))
      window.setTimeout( function (aTab) {aTab.removeAttribute("width");}, 0, tab);
  },

  setDragmarkAttribute: function (tab, markSide) {
   if (gWidthFitTitle)
      tab.setAttribute("width", tab.boxObject.width);
   tab.setAttribute("dragmark", markSide);
  }

} // TabDNDObserver end

function TMP_goButtonClick(aEvent) {
   if (aEvent.button == 1 && gURLBar.value == gBrowser.currentURI.spec)
      gBrowser.duplicateTab(gBrowser.mCurrentTab);
   else if (aEvent.button != 2) {
      if (gIsFirefox31)
         gURLBar.handleCommand(aEvent);
      else
         handleURLBarCommand(aEvent);
   }
}

function TM_BrowserHome() {
   var homePage = gHomeButton.getHomePage();
   if (TMP_whereToOpen(false).inNew) {
      var urls = homePage.split("|");
      var firstTabAdded = gBrowser.addTab(urls[0]);
      var bgLoad = getBoolPref("browser.tabs.loadBookmarksInBackground", false);
      content.focus();
      gBrowser.TMP_selectNewForegroundTab(firstTabAdded, bgLoad, urls[0]);

      for (var i = 1; i < urls.length; ++i)
         gBrowser.addTab(urls[i]);
   }
   else
      loadOneOrMoreURIs(homePage);
}

var undocloseTabButtonObserver = {
  onDragOver: function(aEvent, aFlavour, aDragSession) {
      var aLocalName = aDragSession.sourceNode ? aDragSession.sourceNode.localName : null;
      if (aLocalName!="tab") {
         gIsFirefox31 ? aEvent.dataTransfer.effectAllowed = "none" : aDragSession.canDrop = false;
         return true;
      }
      var statusTextFld = document.getElementById("statusbar-display");
      var stringBundle = document.getElementById("tmp-string-bundle");
      statusTextFld.label = stringBundle.getString("droptoclose.label");
      aEvent.target.setAttribute("dragover", "true");
      return true;
    },

  onDragExit: function (aEvent, aDragSession) {
      var aLocalName = aDragSession.sourceNode ? aDragSession.sourceNode.localName : null;
      if (aLocalName!="tab") return;
      var statusTextFld = document.getElementById("statusbar-display");
      statusTextFld.label = "";
      aEvent.target.removeAttribute("dragover");
    },

  onDrop: function (aEvent, aXferData, aDragSession) {
      var aLocalName = aDragSession.sourceNode ? aDragSession.sourceNode.localName : null;
      if (aLocalName=="tab") gBrowser.removeTab(aDragSession.sourceNode);
    },

  getSupportedFlavours: function () {
      var flavourSet = new FlavourSet();
      flavourSet.appendFlavour("text/x-moz-url");
      return flavourSet;
    }
}

const prefStringTMHistory = "extensions.tabmix.opentabfor.history";
const NC_NS_TM = "http://home.netscape.com/NC-rdf#";
const prefStringTMUseMiddleClick = "extensions.tabmix.middlecurrent";
const prefStringTMBookmark = "extensions.tabmix.opentabfor.bookmarks";
function isBookmarkletTM(aSelection, aDS) {
    if (aSelection && (aSelection.length == 1)
        && ((aSelection.type[0] == "Bookmark") || (aSelection.type[0] == "ImmutableBookmark"))) {
        var jsURL = /^ *javascript:/;
        return jsURL.test(BookmarksUtils.getProperty(aSelection.item[0], NC_NS_TM+"URL", aDS));
    }
    else
        return false;
}

function openInWebPanelTM(aSelection, aDS) {
    if (aSelection && (aSelection.length == 1)
        && ((aSelection.type[0] == "Bookmark") || (aSelection.type[0] == "ImmutableBookmark")))
        return BMDS.GetTarget(aSelection.item[0], RDF.GetResource(NC_NS_TM + "WebPanel"), true);
    else
        return false;
}

function whereToOpenLinkTabmix(aEvent, prefString, aSelection, aDS) {
    var w = getTopWin();
    if (!w)
      return "window";

    var browserTarget = aEvent ? whereToOpenLink(aEvent) : "current";

    var topBrowser = w.document.getElementById("content");
    var prefService = Components.classes['@mozilla.org/preferences-service;1']
                                .getService(Components.interfaces.nsIPrefService).getBranch(null);
    if ((prefService.getBoolPref(prefString) || topBrowser.mCurrentTab.hasAttribute("locked"))
        && !isBookmarkletTM(aSelection, aDS)
        && !openInWebPanelTM(aSelection, aDS)) {
        var _button = aEvent instanceof MouseEvent ? aEvent.button : 0;
        if (aEvent && prefService.getBoolPref(prefStringTMUseMiddleClick) && (_button == 1 || _button == 0 && (aEvent.ctrlKey || aEvent.metaKey)))
            browserTarget = "current";
        else {
            if ((browserTarget == "current")
                && (topBrowser.mCurrentBrowser.webProgress.isLoadingDocument
                    || (topBrowser.mCurrentBrowser.currentURI.spec != "about:blank")))
                browserTarget = "tab";
        }
    }

    return browserTarget;
}

// wee need to call this function for each new window,
// Library window and side panel for history and bookmarks.
function TMP_update_whereToOpen() {
  // fix small bug when the event is not mouse event
  // inverse focus of middle/ctrl/meta clicked bookmarks/history
  // when we are in single window mode set the function to retuen "tab"
  eval("whereToOpenLink ="+whereToOpenLink.toString().replace(
     'var middle = !ignoreButton && e.button == 1;',
     'var middle = e instanceof MouseEvent && !ignoreButton && e.button == 1;'
  ).replace(
     'if (shift)',
     'var inversefocus = getBoolPref("extensions.tabmix.inversefocusOther", true);\
      if (inversefocus || (!inversefocus && shift))'
  ).replace(
     'return "window";',
     'return gSingleWindowMode ? "tab" : "window";'
  ));

  eval("openUILinkIn ="+openUILinkIn.toString().replace(
     'var w = getTopWin();',
     '$& \
      if (getBoolPref("extensions.tabmix.singleWindow", false) && where == "window") where = "tab";'
  ));
}

function TMP_whereToOpen(pref, altKey) {
   var aTab = gBrowser.mCurrentTab;
   var isBlankTab = gBrowser.isBlankNotBusyTab(aTab);
   var isLockTab = !isBlankTab && aTab.hasAttribute("locked");

   var openTabPref = typeof(pref) == "string" ? gPref.getBoolPref(pref) : pref;
   if (typeof(altKey) != "undefined") {
      // don't reuse balnk tab if the user press alt key when the pref is to open in current tab
      if (altKey && !openTabPref)
         isBlankTab = false;

      // see bug 315034 If search is set to open in a new tab,
      // Alt+Enter should open the search result in the current tab
      // so here we reverse the pref if user press Alt key
      openTabPref = (altKey ^ openTabPref) == 1;
   }

   return { inNew: !isBlankTab && (isLockTab || openTabPref), lock: isLockTab };
}

// update context menu for bookmarks manager and sidebar
// for bookmarks/places, history, sage and more.....
function TMP_updateContextMenu(open, openInWindow, openInTab, pref) {
   // if all 3 was hidden ... probably "Open all in Tabs" is visible
   if (open.hidden && openInWindow.hidden && openInTab.hidden)
      return;

   var w = getTopWin();
   if (w) {
      var where = w.TMP_whereToOpen(pref);

      if (!openInWindow.hidden && w.gSingleWindowMode)
         openInWindow.hidden = true;
      else if (openInWindow.hasAttribute("default"))
         openInWindow.removeAttribute("default");

      TMP_setItem(openInTab, "default", where.inNew ? "true" : null);

      if (open.hidden != where.lock)
         open.hidden = where.lock;
      if (!open.hidden)
         TMP_setItem(open, "default", !where.inNew ? "true" : null);
   }
   else {
      open.hidden = true;
      openInTab.hidden = true;
      openInWindow.hidden = false;
      openInWindow.setAttribute("default", true);
   }
}

// Show/hide one item (specified via name or the item element itself).
function TMP_showItem (aItemOrId, aShow) {
   var item = typeof(aItemOrId) == "string" ? document.getElementById(aItemOrId) : aItemOrId;
   if (item)
      item.hidden = !aShow;
}

function TMP_setItem(aItemOrId, aAttr, aVal) {
   var elem = typeof(aItemOrId) == "string" ? document.getElementById(aItemOrId) : aItemOrId;
   if (elem) {
      if (aVal == null) {
         elem.removeAttribute(aAttr);
      }
      else if (elem.getAttribute(aAttr) != aVal) {
         elem.setAttribute(aAttr, aVal);
      }
   }
}
