var gPref = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch);
var WindowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
var mainOptions = WindowManager.getMostRecentWindow("mozilla:tabmixopt");

function Appearance_Init()
{
   var allColorPickers = document.getElementsByTagName("colorpicker");
   for (var i = 0; i < allColorPickers.length; i++) {
      allColorPickers[i].color = gPref.getCharPref(allColorPickers[i].getAttribute("prefstring"));
   }

   var allCheckboxes = document.getElementsByTagName("checkbox");
   for (i = 0; i < allCheckboxes.length; i++) {
      allCheckboxes[i].checked = gPref.getBoolPref(allCheckboxes[i].getAttribute("prefstring"));
   }

   setDisabled("currentTab");
   setDisabled("unreadTab");
   setDisabled("progressMeter");

}

function Appearance_Save()
{
   var allColorPickers = document.getElementsByTagName("colorpicker");
   for (var i = 0; i < allColorPickers.length; i++) {
      gPref.setCharPref(allColorPickers[i].getAttribute("prefstring"), allColorPickers[i].color);
   }

   var allCheckboxes = document.getElementsByTagName("checkbox");
   for (i = 0; i < allCheckboxes.length; i++) {
      gPref.setBoolPref(allCheckboxes[i].getAttribute("prefstring"), allCheckboxes[i].checked);
   }
}

function setDisabled(id)
{
   if (mainOptions.document.getElementById(id).checked)
      document.getElementById(id).removeAttribute("disabled");
   else
      setColorpicker(id, false);
}

function setColorpicker(id, checked)
{
   var cP = document.getElementById(id+"-colorpicker");
   if (!checked)
      cP.setAttribute("disabled", true);
   else
     cP.removeAttribute("disabled");

   cP.setAttribute("style", checked ? "opacity: 1.0" : "opacity: 0.5");
}
