/***** Preference Dialog Functions *****/

const pBranch = Components.interfaces.nsIPrefBranch;
var gPref = Components.classes["@mozilla.org/preferences-service;1"].getService(pBranch);
var nsIPrefServiceObj = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
var winMediator= Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
var gIsFirefox3;

var gPrefs;

// load all preferences into the dialog
function TM_EMinit()
{
  var browserWindow = getMostRecentWindow();
  gIsFirefox3 = browserWindow.gIsFirefox3;
  gPrefs =  document.getElementsByAttribute("prefstring", "*");

  getTab();

  // show groupbox if incompatible extensions exist in this profile
  if (browserWindow.getExtensions().length == 0)
    document.getElementById("incompatible").collapsed = true;

  // icon for dropIndicator-native
  if (!gIsFirefox3)
    document.getElementById("dropIndicator-native").setAttribute("src","chrome://global/skin/tabDragDrop/tabDragIndicator.png");

  // add EventListener when we start
  window.addEventListener("command", TM_enableApply, false);
  window.addEventListener("input", TM_enableApply, false);

  // prevent non intiger key in int text box
  if (!gIsFirefox3)
    window.addEventListener("keypress", keyPressInText, false);

  // update tabclicking items that aren't change by tabmix
  TM_Options.setItem("snapBack", "hidden", !(browserWindow.SessionSaver && browserWindow.SessionSaver.snapBackTab));
  var isIE = (browserWindow.IeView && browserWindow.IeView.ieViewLaunch) ||
             (browserWindow.gIeTab && browserWindow.gIeTab.switchTabEngine) ||
             (browserWindow.ieview && browserWindow.ieview.launch);
  TM_Options.setItem("ieView", "hidden", !isIE);

  // check if bookmark item in tab context menu
  TM_Options.setItem("bmMenu", "hidden", !(browserWindow.document.getElementById("context_bookmarkAllTabs")));
  // check if book "Browser:BookmarkAllTabs" command exist
  TM_Options.setItem("bmTabsCommand", "hidden", !(browserWindow.document.getElementById("Browser:BookmarkAllTabs")));

  // update pref for 'places'
  if (gIsFirefox3) {
    document.getElementById("openBookmarks").setAttribute("label", document.getElementById("selectTabBH").getAttribute("label"));
    document.getElementById("openHistory").hidden = true;
  }

  // disable TMP session manager setting if session manager extension is install
  if ("gSessionManager" in browserWindow) {
    document.getElementById("sessionmanager_ext").hidden = false;
    document.getElementById("sessionstore_box").hidden = true;
    document.getElementById("session_deck").hidden = true;
    document.getElementById("chooseFile").selectedIndex = 1;
  }
  else {
    // create saved Session popup menu
    var popup = document.getElementById("onStart.popup");
    SessionManager.createMenuForDialog(popup);
  }

  // disable options for position the tabbar and scroll mode if TreeStyleTab extension installed
  if ("TreeStyleTabBrowser" in browserWindow) {
    TM_Options.setItem("tabBarPosition", "disabled", true);
    TM_Options.setItem("tabBarPosition.label", "disabled", true);
    TM_Options.setItem("tabScroll", "disabled", true);
    TM_Options.setItem("tabScroll.label", "disabled", true);
  }

  // Init tabclicking options
  var menuPopup = document.getElementById("ClickTab").firstChild;
  document.getElementById("ClickTabbar").appendChild(menuPopup.cloneNode(true));

  // verify that all the prefs exist .....
  browserWindow.gTMPprefObserver.addMissingPrefs();

  TM_setElements(false, true);
  // check if apply is on
  // apply changes if we set single window mode status
  TM_EMsave();

  var tabclicking = document.getElementById("tabclicking_tabs");
  setVisibility(tabclicking.selectedIndex);
  // change tab label on Mac. trigger onselect before broadcaster is set
  // so we add the onselect here
  tabclicking.addEventListener("select", tabSelectionChanged, false);

  if (/^Linux/.test(navigator.platform))
     sizeToContent();

  window.setTimeout( function () { window.focus();}, 0 );
}

// save all preferences entered into the dialog
function TM_EMsave(onApply)
{
  // we only need to save if apply is enabled
  if (!onApply && document.documentElement.getButton("extra1").disabled)
    return true;

  // set flag to prevent TMupdateSettings from run for each change
  gPref.setBoolPref("extensions.tabmix.setDefault", true);

  TM_Options.singleWindow( document.getElementById("singleWindow").checked );
  TM_Options.setTabXUI();
  TM_verifyWidth();
  TM_Options.verify_PostDataBytes();

  document.documentElement.getButton('accept').focus()
  document.documentElement.getButton("extra1").disabled = true;

  if (!("undefined" in applyData)) {
    for (var _pref in applyData)
      setPrefByType(_pref, applyData[_pref]);
  }
  else {
    // this part is only if the applayData fail for some unknown reason
    // we don't supposed to get here
    for (var i = 0; i < gPrefs.length; ++i )
      setPrefByType(gPrefs[i].getAttribute("prefstring"), getValue(gPrefs[i]));
  }

  // set saved sessionpath if loadsession >=0
  var val = gPref.getIntPref("extensions.tabmix.sessions.onStart.loadsession");
  var popup = document.getElementById("onStart.popup");
  var pref = "extensions.tabmix.sessions.onStart.sessionpath";
  gPref.setCharPref(pref, popup.getElementsByAttribute("value", val)[0].getAttribute("session"));

  applyData = [];
  gPref.clearUserPref("extensions.tabmix.setDefault"); // this trigger TMupdateSettings
  getMostRecentWindow().TMP_SessionStore.setService(2, false, window);

  callUpdateSettings();

  nsIPrefServiceObj.savePrefFile(null); // store the pref immediately
  return true;
}

function callUpdateSettings() {
  var pref = "extensions.tabmix.PrefObserver.error";
  if (gPref.prefHasUserValue(pref) && gPref.getBoolPref(pref)) {
    var wnd, enumerator = winMediator.getEnumerator("navigator:browser");
    while (enumerator.hasMoreElements()) {
      wnd = enumerator.getNext();
      wnd.TMupdateSettings();
    }
  }
}

function TM_verifyWidth() {
   var minWidth = document.getElementById("minWidth");
   var maxWidth = document.getElementById("maxWidth");

   var minValue = minWidth.value;
   var maxValue = maxWidth.value;

   if (maxValue - minValue < 0) {
      minWidth.value = maxValue;
      maxWidth.value = minValue;
   }

   if (minWidth.value < 22)
     minWidth.value = 22;

   if (minValue != minWidth.value)
      updateApplyData(minWidth);

   if (maxValue != maxWidth.value)
      updateApplyData(maxWidth);

}

var TM_Options = {
   checkDependant: function(start) {

      this.singleWindow( document.getElementById("singleWindow").checked );

      var broadcasters = document.getElementById("disabled:Broadcaster");
      for (var i = 0; i < broadcasters.childNodes.length; ++i ) {
         var _id = broadcasters.childNodes[i].id.replace("obs_", "");
         this.disabled(_id, start);
      }

      this.setTabXUI();
      this.addTabXUI();
      this.selectTab();
      this.tabScroll();
      this.speLink();
      this.setAppearanceButton();
      this.newTabUrl(document.getElementById("loadOnNewTab"), false);
      this.setShowTabList();

      var sessionStoreEnabled = getMostRecentWindow().TMP_SessionStore.isSessionStoreEnabled();
      document.getElementById("sessionstore").checked = sessionStoreEnabled;
      document.getElementById("session_deck").selectedIndex = sessionStoreEnabled ? 0 : 1;

      this.setDisabled("obs_ss_postdata", document.getElementById("ss_postdata").value == 2);
      this.setDisabled('obs_hideTabbar', document.getElementById("hideTabbar").value != 0);
   },

   disabled: function(itemOrId, start) {
      var item = typeof(itemOrId) == "string" ? document.getElementById(itemOrId) : itemOrId;
      var val = item.getAttribute("inverseDependency") ? item.checked : !item.checked;
      if (start && !val)
         return;
      this.setDisabled("obs_" + item.id, val);
   },

   setDisabled: function(id, val) {
      if (val == true)
         this.setItem(id, "disabled" , val);
      else {
         // remove disabled from all observers,
         // we can't edit textbox-input with disabled=null or disabled=false
         // textbox-input inherits the dislabled attribute from the textbox

         // all broadcaster has no disabled attribute at startup
         var aBroadcaster = document.getElementById(id);
         if (aBroadcaster.hasAttribute("disabled")) {
            aBroadcaster.removeAttribute("disabled");
         }
      }
   },

   newTabUrl: function(item, setFocus) {
      var showTabUrlBox = item.selectedItem.value == 4;
      var idnum = item.getAttribute("idnum") || "" ;
      this.setDisabled("newTabUrlLabel" + idnum, !showTabUrlBox);
      this.setDisabled("newTabUrl" + idnum, !showTabUrlBox);
      if (setFocus && showTabUrlBox)
         document.getElementById("newTabUrl" + idnum).focus();
   },

   addTabXUI: function() {
      var tabXValue = document.getElementById("addTabXUI").selectedItem.value;
      this.setItem("tabXdelaycheck", "hidden", tabXValue != 2 && tabXValue != 4);
      this.setItem("tabXwidthBox", "hidden", tabXValue != 5);
   },

   setTabXUI: function() {
      if (document.getElementById("flexTabs").checked) {
         var tabXUI = document.getElementById("addTabXUI");
         if ( tabXUI.selectedItem.value == 5) {
            updateApplyData(tabXUI, 1);
            this.addTabXUI();
         }
      }
   },

   selectTab: function() {
      var focusType = document.getElementById("selectTab").checked ? "bg":"fg";
      var val = document.getElementById("showInverseLink").getAttribute(focusType+"label");
      this.setItem("showInverseLink", "label", val);
   },

   tabScroll: function() {
      var selectedValue = document.getElementById("tabScroll").value;
      var vis = selectedValue == 2 ? "visibility: visible" : "visibility: hidden";
      this.setItem("maxbar", "style", vis);
   },

   speLink: function() {
      var spelink = document.getElementById("speLink").selectedItem.value;
      document.getElementById("inverselinks").disabled =  spelink != 2 && document.getElementById("midcurrent").checked;
   },

   setAppearanceButton: function() {
      document.getElementById("advancedAppearance").disabled =
                              !document.getElementById("unreadTab").checked &&
                              !document.getElementById("currentTab").checked &&
                              !document.getElementById("progressMeter").checked;
   },

   singleWindow: function(enableSingleWindow) {
      if ( enableSingleWindow ) {
         function updateStatus(itemId, testVal, test, newVal) {
            var item = document.getElementById(itemId);
            test = test ? item.value == testVal : item.value != testVal
            if ( test ) {
               updateApplyData(item, newVal);
            }
         }

         updateStatus("externalLinkTarget", 2, true, 3);
         updateStatus("divertedWindowOpen", 0, false, 0);
         updateStatus("generalWindowOpen", 2, true, 3);
      }
   },

   verify_PostDataBytes: function() {
      var ss_postdatabytes = document.getElementById("ss_postdatabytes");
      var val = ss_postdatabytes.value;
      if (val == "-" || val == "") {
         updateApplyData(ss_postdatabytes, val == "" ? "0" : "-1");
      }
   },

   setSessionsOptions: function (item) {
      var useSessionManager = !item.checked;
      document.getElementById("session_deck").selectedIndex = useSessionManager ? 1 : 0;

      function updateSessionPrefs(aItemId, aValue) {
         var item = document.getElementById(aItemId);
         updateApplyData(item, aValue);
      }

      // TMP session pref
      updateSessionPrefs("sessionManager", useSessionManager);
      updateSessionPrefs("sessionCrashRecovery", useSessionManager);

      // sessionstore pref
      updateSessionPrefs("browser.warnOnRestart", !useSessionManager);
      updateSessionPrefs("browser.warnOnQuit", !useSessionManager);
      updateSessionPrefs("resume_from_crash", !useSessionManager);
      // "browser.startup.page"
      var browserStartupPage = document.getElementById("browserStartupPage");
      updateApplyData(browserStartupPage, useSessionManager ? 1 : 3);
   },

   setUndoCloseCache: function (item) {
      var undoCloseCache = document.getElementById("undoCloseCache");
      var currentValue = undoCloseCache.value;
      var newValue = item.checked ? 10 : 0;
      if (newValue != currentValue) {
        updateApplyData(undoCloseCache, newValue);
      }
   },

   setUndoClose: function (item) {
      if (item.value == "")
        item.value = 0;

      if (item.value == 0) {
        var undoClose = document.getElementById('undoClose');
        undoClose.checked = false;
        this.disabled(undoClose);
        this.setUndoCloseCache(undoClose);
      }
   },

   setShowTabList: function () {
      // we only need this in Firefox 3.1+
      if (document.getElementById("ctrltab.tabPreviews") == null)
         return;

      var disableShowTabList = document.getElementById("ctrltab").checked &&
                                document.getElementById("ctrltab.tabPreviews").checked;
      this.setDisabled('showTabList', disableShowTabList);
   },

   // Set given attribute of specified item.  If the
   // value is null, then it removes the attribute (which works
   // nicely for the disabled attribute).
   setItem: function (id, attrib, val) {
      var item = document.getElementById(id);
      if (val == null)
         item.removeAttribute(attrib);
      else if (item.getAttribute(attrib) != val)
         item.setAttribute(attrib, val);
   }

}

// other settings not in the main option dialog
var otherPref = ["sessions.onStart.sessionpath",
                  "filetype","boldUnread","italicUnread","underlineUnread",
                  "boldCurrent","italicCurrent","underlineCurrent","unreadColorCode",
                  "currentColorCode","progressColorCode","useCurrentColor",
                  "useUnreadColor","noprogress","useProgressColor","sessions.menu.showext",
                  "disableIncompatible","hideIcons","disableF9Key"];

function TM_defaultSetting () {
  // set flag to prevent TMupdateSettings from run for each change
  gPref.setBoolPref("extensions.tabmix.setDefault", true);

  TM_setElements(true);

  TM_disableApply();

  // reset other settings to default
  var tmpPref = "extensions.tabmix.";
  for (var i = 0; i < otherPref.length; ++i )
    if (gPref.prefHasUserValue(tmpPref+otherPref[i])) gPref.clearUserPref(tmpPref+otherPref[i]);

  gPref.clearUserPref("extensions.tabmix.setDefault");
  getMostRecentWindow().TMP_SessionStore.setService(2, false, window);
  callUpdateSettings();

  nsIPrefServiceObj.savePrefFile(null); // store the pref immediately
}

function getPrefByType(prefName) {
   try {
      switch (gPref.getPrefType(prefName)) {
         case pBranch.PREF_BOOL:
            return gPref.getBoolPref(prefName);
         case pBranch.PREF_INT:
            return gPref.getIntPref(prefName);
         case pBranch.PREF_STRING:
            return gPref.getCharPref(prefName);
      }
   } catch (e) {tmLog("error in getPrefByType " + "\n" + "caller " + getPrefByType.caller.name + "\n"+ prefName + "\n" + e);}
   return null;
}

function setPrefByType(prefName, newValue, atImport) {
   try {
      switch (gPref.getPrefType(prefName)) {
         case pBranch.PREF_BOOL:
            if (atImport) {
               newValue = /true/i.test(newValue);
               // from tabmix 0.3.6.0.080223 we use extensions.tabmix.hideTabbar
               if (prefName == "browser.tabs.autoHide") {
                  newValue = newValue ? 1 : 0;
                  gPref.setIntPref("extensions.tabmix.hideTabbar", newValue);
                  return;
               }
            }
            gPref.setBoolPref(prefName, newValue);
            break;
         case pBranch.PREF_INT:
            gPref.setIntPref(prefName, newValue);
            break;
         case pBranch.PREF_STRING:
            // in prev version we use " " for to export string to file
            if (atImport && newValue.indexOf('"') == 0)
               newValue = newValue.substring(1,newValue.length-1);
            gPref.setCharPref(prefName, newValue);
            break;
         default:
            if (!atImport)
               break;
            // when we import from old saved file, we need to replace old pref that are not in use.
            switch (prefName) {
               // in 0.3.0.605 we changed tab color from old pref to new pref
               // old pref "extensions.tabmix.currentColor" type integer
               // new pref "extensions.tabmix.currentColorCode" type string
               case "extensions.tabmix.currentColor":
               case "extensions.tabmix.unreadColor":
               case "extensions.tabmix.progressColor":
                  var colorCodes = ["#CF1919", "#0E36EF", "#DDDF0D", "#3F8F3E", "#E066FF", "#86E7EF",
                                   "#FFFFFF", "#7F7F7F", "#000000", "#EF952C", "#FF82AB", "#7F4C0F", "#AAAAFF"]
                  gPref.setCharPref(prefName + "Code", colorCodes[newValue]);
                  break;
               // changed at 2008-02-26
               case "extensions.tabmix.undoCloseCache":
                  gPref.setIntPref("browser.sessionstore.max_tabs_undo", newValue);
                  break;
               // changed at 2008-08-17
               case "extensions.tabmix.opentabfor.search":
                  gPref.setBoolPref("browser.search.openintab", /true/i.test(newValue));
                  break;
               // changed at 2008-09-23
               case "extensions.tabmix.keepWindow":
                  gPref.setBoolPref("browser.tabs.closeWindowWithLastTab", !(/true/i.test(newValue)));
                  break;
               // changed at 2008-09-28
               case "extensions.tabmix.lasttab.handleCtrlTab":
                  gPref.setBoolPref("browser.ctrlTab.mostRecentlyUsed", /true/i.test(newValue));
                  break;
            }
      }
   } catch (e) {tmLog("error in setPrefByType " + "\n" + "caller " + setPrefByType.caller.name + "\n"+ prefName + "\n" + newValue + "\n" + e);}
}

function TM_setElements (restore, start) {
   for (var i = 0; i < gPrefs.length; ++i ) {
      var item = gPrefs[i];
      var pref = item.getAttribute("prefstring");

      if (restore) {
        switch (pref) {
           case "browser.tabs.closeWindowWithLastTab": // exist in firefox version 3.1
              gPref.setBoolPref(pref, false);
              break;
           case "browser.ctrlTab.mostRecentlyUsed": // exist in firefox version 3.1
           case "browser.warnOnRestart": // exist in firefox version 3.0
           case "browser.warnOnQuit": // exist in firefox version 3.0
              gPref.setBoolPref(pref, true);
              break;
           case "browser.link.open_external": // not exist from firefox 3.1
             gPref.setIntPref(pref, 3);
              break;
           default:
             if (gPref.prefHasUserValue(pref))
               gPref.clearUserPref(pref);
        }
      }

      var prefValue = getPrefByType(pref);
      switch (item.localName) {
         case "checkbox":
            if (item.hasAttribute("inverted"))
               prefValue = !prefValue;
            item.checked = prefValue;
            break;
         case "radiogroup":
            if (item.hasAttribute("boolean"))
               prefValue = prefValue ? 0 : 1;
            item.selectedIndex = prefValue;
            break;
         default:
            item.value = prefValue;
      }
   }

   setSelectedIndex(document.getElementById("tabclicking_tabs").selectedIndex);
   TM_Options.checkDependant(start);
}

function exportData() {

  TM_EMsave();

  var patterns=new Array;
  patterns[0]='tabmixplus';
  var z=1, pref;

  for (var i = 0; i < gPrefs.length; ++i ) {
     pref = gPrefs[i].getAttribute("prefstring");
     patterns[z++] = pref + "=" + getPrefByType(pref);
  }

  // more pref to save
  for (i = 0; i < otherPref.length; ++i ){
    pref = "extensions.tabmix." + otherPref[i];
    patterns[z++] = pref + "=" + getPrefByType(pref);
  }

  saveToFile(patterns);
  return true;
}

function saveToFile (patterns) {
  // thanks to adblock
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
  var stream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);

  fp.init(window, null, fp.modeSave);
  fp.defaultExtension='txt';
  fp.defaultString='TMPpref';
  fp.appendFilters(fp.filterText);

  if (fp.show() != fp.returnCancel) {
    if (fp.file.exists()) fp.file.remove(true);
    fp.file.create(fp.file.NORMAL_FILE_TYPE, 0666);
    stream.init(fp.file, 0x02, 0x200, null);

    for (var i = 0; i < patterns.length ; i++) {
      patterns[i]=patterns[i]+"\n";
      stream.write(patterns[i], patterns[i].length);
    }

    stream.close();
  }
}

function importData () {
   var pattern = loadFromFile();

   if (!pattern) return false;
   var i, stringBundle;
   if(pattern[0]!="tabmixplus") {
      stringBundle = document.getElementById("tmp-string-bundle");
      //  Can not import because it is not a valid file.
      alert(stringBundle.getString("tmp.importPref.error1"));
      return false;
   }

   // set flag to prevent TMupdateSettings from run for each change
   gPref.setBoolPref("extensions.tabmix.setDefault", true);
   var prefName, prefValue;
   for (i=1; i<pattern.length; i++){
      var index = pattern[i].indexOf("=");
      if (index > 0){
         prefName  = pattern[i].substring(0,index);
         prefValue = pattern[i].substring(index+1,pattern[i].length);
         setPrefByType(prefName, prefValue, true);
      }
   }
   gPref.clearUserPref("extensions.tabmix.setDefault");
   getMostRecentWindow().TMP_SessionStore.setService(2, false, window);
   callUpdateSettings();

   nsIPrefServiceObj.savePrefFile(null); // store the pref immediately

   TM_setElements(false);

   TM_disableApply();

   return true;
}

function loadFromFile() {
   // thanks to adblock
   var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
   var stream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
   var streamIO = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);

   fp.init(window, null, fp.modeOpen);
   fp.defaultExtension='txt';
   fp.appendFilters(fp.filterText);

   if (fp.show() != fp.returnCancel) {
      stream.init(fp.file, 0x01, 0444, null);
      streamIO.init(stream);
      var input = streamIO.read(stream.available());
      streamIO.close();
      stream.close();

      var linebreak = input.match(/(((\n+)|(\r+))+)/m)[1]; // first: whole match -- second: backref-1 -- etc..
      return input.split(linebreak);
   }
   return null;
}

function convertSession() {
   var browserWindow = getMostRecentWindow();
   if (document.getElementById("chooseFile").selectedItem.value == 0)
      browserWindow.convertSession.selectFile(window);
   else
      browserWindow.convertSession.convertFile();

   this.focus();
}

// We don't use this in Firefox 3.0
// Firefox 3.0 uses numberbox.xml
function keyPressInText(event) {
   if(event.target.localName != "textbox")
      return;

   if(event.target.getAttribute("type") != "number")
      return;

   event.target.oldvalue = event.target.value;
   if (event.target.id == "ss_postdatabytes" && event.charCode == 45) {
      event.target.value = "";
      return;
   }

   if(event.charCode) {
     var key = String.fromCharCode(event.charCode).match(/\d/g);
     if (!key) {
         event.preventDefault();
         event.stopPropagation();
     }
   }
}

var applyData = [];
function TM_enableApply(aEvent) {
   var item = aEvent.target;

   // only allow event from this item to go on....
   var n = item.localName;
   if (n != "radio" && n != "menuitem" &&
              n != "checkbox" && n != "textbox")
      return;

   if (n == "checkbox" && document.getElementById("obs_" + item.id))
     TM_Options.disabled(item);

   // if we fail once no need to continue and we keep the apply button enable
   if ("undefined" in applyData)
      return;

   // set item for menuitem
   if (n == "menuitem")
     item = item.parentNode.parentNode;
   // set item for radio
   if (n == "radio")
     item = item.parentNode;

   if (item.hasAttribute("prefstring_item")) {
     var itemId = item.getAttribute("prefstring_item");
     if (itemId == "no_prefstring")
       return;
     else {
       item = document.getElementById(itemId);
       item.value = aEvent.target.value; // we don't use this for checkbox
     }
   }

   // fix "-" in ss_postdatabytes to allow "-1"
   if (item.id == "ss_postdatabytes" && item.value.length > 1) {
      var val = item.value;

      if (val.length == 2 && val.indexOf("-") == 0 && val != "-1")
         aEvent.target.value = "-1";

      if (val.length > 2 && val.indexOf("-") == 0)
         aEvent.target.value = val.substr(2);
   }

   if (item.hasAttribute("prefstring"))
      updateApplyData(item);
   else {
      tmLog("erorr in tabmix options, item.id " + aEvent.target.id + "\n has no prefstring");
      applyData["undefined"] = true;
      document.documentElement.getButton("extra1").disabled = false;
   }
}

// return value from item
function getValue(item) {
   if (item.localName == "checkbox")
      return item.hasAttribute("inverted") ? !item.checked : item.checked;

   return item.value;
}

// set value to item
function setValue(item, newValue) {
   if (item.localName == "checkbox")
      item.checked = item.hasAttribute("inverted") ? !newValue : newValue;
   else
      item.value = newValue;
}

function updateApplyData(item, newValue) {
   if (typeof(newValue) == "undefined")
     newValue = getValue(item);
   else
     setValue(item, newValue)

   var pref = item.getAttribute("prefstring");
   var savedValue = getPrefByType(pref);

   if (savedValue != newValue)
      applyData[pref] = newValue;
   else if (pref in applyData)
      delete applyData[pref];

   var applyCount = 0;
   for (var n in applyData) {
      if (++applyCount > 0)
         break;
   }

   var applyButton = document.documentElement.getButton("extra1");
   if (applyButton.disabled != (applyCount == 0))
      applyButton.disabled = applyCount == 0;
}

function TM_disableApply() {
   document.documentElement.getButton("extra1").disabled = true;
   applyData = [];
}

function setLastTab() {
   gPref.setIntPref("extensions.tabmix.selected_tab", document.getElementById("tabMixTabBox").selectedIndex);

   var subtabs = document.getElementsByAttribute("subtub", "true");
   var subTab = "extensions.tabmix.selected_sub_tab";
   for (var i = 0; i < subtabs.length; i++)
      gPref.setIntPref(subTab + subtabs[i].getAttribute("value"), subtabs[i].selectedIndex);

   nsIPrefServiceObj.savePrefFile(null); // store the pref immediately

   // remove EventListener when we exit
   window.removeEventListener("command", TM_enableApply, false);
   window.removeEventListener("input", TM_enableApply, false);

   if (!gIsFirefox3)
     window.removeEventListener("keypress", keyPressInText, false);

   document.getElementById("tabclicking_tabs").removeEventListener("select", tabSelectionChanged, false);
}

function getTab() {
   var browserWindow = getMostRecentWindow();
   var selTabindex = browserWindow.TMP_getIntPref("", "extensions.tabmix.selected_tab" , 0);
   TM_selectTab(selTabindex);

   var subtabs = document.getElementsByAttribute("subtub", true);
   var subTab = "extensions.tabmix.selected_sub_tab";
   for (var i = 0; i < subtabs.length; i++) {
      var val = browserWindow.TMP_getIntPref("" ,subTab + subtabs[i].getAttribute("value"), 0);
      subtabs[i].selectedIndex = val;
   }
}

// this function is called from here and from TMP_openDialog if the dialog already opened
function TM_selectTab(aSelTab) {
  document.getElementById("tabMixTabBox").selectedIndex = (aSelTab) ? aSelTab : 0;
  var tabId = document.getElementsByTagName("tab")[aSelTab].id;
  var catButtons = document.getElementById("TM_ButtonBox").childNodes;

  for(var i = 0; i < catButtons.length; i++)
    if(catButtons[i].getAttribute('group', 'categories'))
      catButtons[i].setAttribute('checked', (catButtons[i].id == 'button' + tabId));
}

function showIncompatible() {
   var browserWindow = getMostRecentWindow();
   if (browserWindow) {
      var result = browserWindow.disableExtensions(this);
      if (result) {
         document.getElementById("incompatible").collapsed = true;
         sizeToContent();
      }
      this.focus();
   }
   else {
      var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                    .getService(Components.interfaces.nsIPromptService);
      var stringBundle = document.getElementById("tmp-string-bundle");
      var title = stringBundle.getString("tabmixoption.error.title");
      var msg = stringBundle.getString("tabmixoption.error.msg");
      promptService.alert(window, title, msg);
      window.close();
   }
}

function tabSelectionChanged(event) {
   if (!event || event.target.localName != "tabs")
      return;

   var index = event.target.selectedIndex;
   setVisibility(index);
   setSelectedIndex(index);
}

function setVisibility(index) {
   if (index == 1) {
      TM_Options.setItem("contentLoad", "style", "visibility: visible");
      TM_Options.disabled("contentLoad");
   }
   else {
      TM_Options.setItem("contentLoad", "style", "visibility: hidden");
      document.getElementById("obs_contentLoad").removeAttribute("disabled");
   }
}

function setSelectedIndex(index) {
   var c = ["dbl", "middle", "ctrl", "shift", "alt"];
   var clickTab = document.getElementById("ClickTab");
   var prefId = c[index] + "ClickTab";
   clickTab.value = document.getElementById(prefId).value;
   clickTab.setAttribute("prefstring_item", prefId);

   var clickTabbar = document.getElementById("ClickTabbar");
   prefId = c[index] + "ClickTabbar";
   clickTabbar.value = document.getElementById(prefId).value;
   clickTabbar.setAttribute("prefstring_item", prefId);
}

function getMostRecentWindow()
{
  return winMediator.getMostRecentWindow('navigator:browser');
}
