// code based on Tab X 0.5 enhanced version by Morac, modified by Hemiola SUN, later CPU & onemen

var nsIPrefServiceObj = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
var tabxBranch = "extensions.tabmix.";
var tabxPrefs = nsIPrefServiceObj.getBranch(tabxBranch);

var gTMPprefObserver = null;
var gTabBarWidth = -1;
var addtabx;
var tabxleft;
var tabscroll;
var gWidthFitTitle;
var gTabbarPosition;
var gSingleWindowMode;
var alwaysNewTab;
var gFirefox2DefaultTheme;
var gHideTabBar;

function TMupdateSettings(start) {
  var tabBrowser = getBrowser();
  if (!tabBrowser || tabxPrefs.prefHasUserValue("setDefault"))
    return;

  var tabBar  = tabBrowser.mTabContainer;

  var i;
//  var showCloseButton = TMP_getBoolPref(tabxBranch, "tabXMode.enable",  true);
  addtabx =          TMP_getIntPref (tabxBranch, "tabXMode",         1);
  // in old version we use tabXMode = 0 to disable the button
  if (addtabx < 1 || addtabx > 5) {
    addtabx = 1;
    tabxPrefs.setIntPref("tabXMode", 1);
    return;
  }
  tabxleft =         TMP_getBoolPref(tabxBranch, "tabXLeft",         false);
  tabscroll =        TMP_getIntPref (tabxBranch, "tabBarMode",       1);
  if (tabscroll < 0 || tabscroll > 3 || (tabscroll != 1 && "TreeStyleTabBrowser" in window)) {
    tabxPrefs.setIntPref("tabBarMode", 1);
    return;
  }
//XXX replace the pref to use browser.tabs.tabMaxWidth and browser.tabs.tabMinWidth
// remember that browser.tabs.tabMaxWidth is not in use in Firefox 2.0
  tabBar.mTabMaxWidth  =       TMP_getIntPref (tabxBranch, "maxWidth",         250);
  tabBar.mTabMinWidth  =       TMP_getIntPref (tabxBranch, "minWidth",         22);
  if (tabBar.mTabMaxWidth < tabBar.mTabMinWidth) {
    tabxPrefs.setBoolPref("setDefault", true);
    tabxPrefs.setIntPref("maxWidth", tabBar.mTabMinWidth);
    tabxPrefs.setIntPref("minWidth", tabBar.mTabMaxWidth);
    tabxPrefs.clearUserPref("setDefault"); // this trigger TMupdateSettings
    return;
  }
  gWidthFitTitle = TMP_getBoolPref(tabxBranch, "flexTabs", false) &&
                   (tabBar.mTabMaxWidth != tabBar.mTabMinWidth);
  alwaysNewTab =     TMP_getIntPref (tabxBranch, "speLink",          0);

  var currentVisible = start ? true : tabBar.isTabVisible(tabBrowser.mCurrentTab._tPos);
  var direction = gTabbarPosition == 1 || gTabbarPosition == 3 ? "rtl" : "ltr";
  tabBrowser.mTabBox.setAttribute("dir", direction);
  // fix bug in positioning  the popup off screen or on the button when window is not maximize or when tab bar is in the botton
  TMP_setItem(tabBar.mAllTabsPopup, "position",
            (window.windowState != window.STATE_MAXIMIZED || gTabbarPosition == 1) ? "start_before" : "after_end");

  switch ( tabscroll ) {
    case 0:
      tabBar.setAttribute("flowing", "singlebar");
      if (gIsFirefox3)
        tabBar.overflow = false;
      break;
    case 1:
      if (!tabBar.hasAttribute("scrollbutton-up"))
        tabBar.setAttribute("scrollbutton-up", "left");
    case 3:
      if (tabBar.getAttribute("flowing") != "scrollbutton") {
        tabBar.setAttribute("flowing", "scrollbutton");
        if (gIsFirefox3)
          tabBar.overflow = tabBar.canScrollTabsLeft || tabBar.canScrollTabsRight;
      }
      break;
    case 2:
      if (tabBar.getAttribute("flowing") != "multibar") {
         tabBar.setAttribute("flowing", "multibar");
         if (!start || tabBar.collapsedTabs > 0)
           tabBar.collapsedTabs = 0;
      }
      break;
  }

  /* Fix problem with multi-row when tab width is very small
     need to findout how to remove extra space when display is block or inline
     then we don't have to fix the tab height
  */
  if (tabscroll == 2 && tabBar.mTabMaxWidth < 50)
    TMP_setItem(tabBar, "inline", true);
  else
    tabBar.removeAttribute("inline");

  if (tabscroll != 1 && tabBar.hasAttribute("scrollbutton-up"))
    tabBar.removeAttribute("scrollbutton-up");

  TMP_setItem("tabs-arrowscrollbox", "orient", tabscroll == 2 ? "vertical" : "horizontal");

  if (tabBar.collapsedTabs > 0 && !gWidthFitTitle)
    tabBar.collapsedTabs = 0;

  for (i = 0; i < tabBar.childNodes.length; i++) {
    var aTab = tabBar.childNodes[i];

    if (!aTab.hasAttribute("faviconized")) {
       aTab.maxWidth = tabBar.mTabMaxWidth;
       aTab.style.maxWidth = tabBar.mTabMaxWidth + "px";
       aTab.minWidth = tabBar.mTabMinWidth;
    }
    if (gWidthFitTitle) {
      if (aTab.hasAttribute("width")) aTab.removeAttribute("width");
      if (aTab.hasAttribute("flex")) aTab.removeAttribute("flex");
    } else {
      TMP_setItem(aTab, "width", "0");
      TMP_setItem(aTab, "flex", "100");
    }

    if ( alwaysNewTab == 1) {
      // when we can change user locked / unlock tabs
      var changeUserLockStatus = (start && aTab.getAttribute("_locked") != "false") ||
                          (!start && tabBar.getAttribute("lockAllTab") != "true")
      if (changeUserLockStatus) {
        aTab.setAttribute("locked", "true");
        aTab.removeAttribute("_locked");
      }
    }
    else if ( tabBar.getAttribute("lockAllTab") == "true" ) {
      aTab.removeAttribute("locked");
      aTab.removeAttribute("_locked");
    }

    SessionManager.updateTabProp(aTab);

    var showCloseButton = TMP_getBoolPref(tabxBranch, "tabXMode.enable",  true);
    if (showCloseButton) {
       var closeButtonOptions = ["no-button","always","showhover","current","current_hover","always"];
       aTab.setAttribute("tabx", closeButtonOptions[addtabx]);
    }
    else
       aTab.removeAttribute("tabx");

    if (tabxleft)
       aTab.setAttribute("tabxleft", "on");
    else
       aTab.removeAttribute("tabxleft");
  }

  var progressMeterOnTabs = TMP_getBoolPref(tabxBranch, "progressMeter", true);
  tabBar.setAttribute("closebutton", !TMP_getBoolPref(tabxBranch, "hideTabBarButton", true));
  tabBar.setAttribute("hideAllTabsButton", TMP_getBoolPref(tabxBranch, "hideAllTabsButton", false));
  tabBar.setAttribute("progressMeter", progressMeterOnTabs);
  tabBar.setAttribute("tabBarSpace", TMP_getBoolPref(tabxBranch, "tabBarSpace", false));
  tabBar.setAttribute("unreadTab", TMP_getBoolPref(tabxBranch, "unreadTab", false));
  tabBar.setAttribute("extraIcons", TMP_getBoolPref(tabxBranch, "extraIcons", true));
  tabBar.setAttribute("lockAllTab", alwaysNewTab == 1 );
  tabBar.setAttribute("newTabButton", TMP_getBoolPref(tabxBranch, "newTabButton", true));
  tabBar.setAttribute("boldUnread", TMP_getBoolPref(tabxBranch, "boldUnread", true));
  tabBar.setAttribute("italicUnread", TMP_getBoolPref(tabxBranch, "italicUnread", true));
  tabBar.setAttribute("underlineUnread", TMP_getBoolPref(tabxBranch, "underlineUnread", true));
  tabBar.setAttribute("boldCurrent", TMP_getBoolPref(tabxBranch, "boldCurrent", true));
  tabBar.setAttribute("italicCurrent", TMP_getBoolPref(tabxBranch, "italicCurrent", true));
  tabBar.setAttribute("underlineCurrent", TMP_getBoolPref(tabxBranch, "underlineCurrent", true));
  tabBar.setAttribute("currentTab", TMP_getBoolPref(tabxBranch, "currentTab", false));
  tabBar.setAttribute("useCurrentColor", TMP_getBoolPref(tabxBranch, "useCurrentColor", true));
  tabBar.setAttribute("useUnreadColor", TMP_getBoolPref(tabxBranch, "useUnreadColor", true));
  tabBar.setAttribute("useProgressColor", TMP_getBoolPref(tabxBranch, "useProgressColor", false));
  document.getElementById("statusbar-progresspanel").
        setAttribute("hidden", TMP_getBoolPref(tabxBranch, "noprogress",false) && progressMeterOnTabs);

  if (tabBar.tabstrip.style.maxHeight != "none" && !gBrowser.mStrip.collapsed && tabBar.collapsedTabs > 0) {
    var currentMaxRow = tabBar.tabstrip.style.maxHeight.replace("px", "") / getRowHeight();
    var rowDiff = tabBar.maxRow - currentMaxRow;
    while (tabBar.collapsedTabs > 0 && rowDiff > 0) {
      tabBar.rowScroll(-1);
      rowDiff--;
    }
  }
  // we need this to fix scroll when user change tab width
  while (tabBar.collapsedTabs > 0 && tabBar.lastTabVisible &&
          tabBar.lastChild.baseY + 2 < tabBar.tabstrip.boxObject.y + tabBar.tabstrip.boxObject.height) {
    tabBar.tabsScroll(-1);
  }

  if (start && "isLoadHomePage" in window) {
    window.setTimeout(tabBarScrollStatus, 0);
    delete window.isLoadHomePage;
  }
  else
    tabBarScrollStatus();

  window.setTimeout( function TMupdateSettings_adjustScroll(_currentVisible) {
      if (_currentVisible) {
        tabBar.ensureTabIsVisible(tabBar.selectedIndex);
      }
      tabBar.adjustScrollTabsLeft();
      tabBar.adjustScrollTabsRight();
      checkBeforeAndAfter();
     //XXX underline the label bleed over the end when tab is to small and we have close button on the tab !!!!????
      toggleUderlineTabsLabel();
  }, 50, currentVisible);

  // if the current Browser has SafeBrowsing problem and message is showing we need to
  // repaint the "safebrowsing-dim-area-canvas"
  window.setTimeout(adjustSafebrowsingDimArea, 0);

  // set some items
  document.getElementById("tabmix-menu").hidden = !TMP_getBoolPref(tabxBranch, "optionsToolMenu", true);

  SessionManager.updateSettings(); // this update all open windows, if we fix here we need to change in SessionManager
}

/*
XXX underline the label bleed over the end when tab is to small and we have close button on the tab !!!!????
workaround is to remove underline when tab is too small

when to set hideunderline
A. tababr is visibile
B. !gWidthFitTitle and width < 70
C. gWidthFitTitle and maxwidth < 70

*/
function toggleUderlineTabsLabel() {
  var tabBar = gBrowser.mTabContainer;
  if (tabBar.boxObject.width == 0)
    return;

  var _tinywidth;
  if (tabBar.mTabMaxWidth < 70)
    _tinywidth = true;
  else {
    var _width = tabBar.childNodes[tabBar.collapsedTabs].boxObject.width;
    _tinywidth = !gWidthFitTitle && _width < 70;
  }
  TMP_setItem(tabBar, "hideunderline", _tinywidth || null);
}

function tabBarScrollStatus () {
  var tabBar = gBrowser.mTabContainer;
  if (tabBar.boxObject.width == 0)
    return;

  tabBar.adjustScrollTabsLeft();

  var multibar = tabscroll == 2 ? getMultiRowAttribute() : null;

  TMP_setItem(tabBar, "multibar", multibar); // if multibar is null we remove the attribute
  setTabBarHeight(multibar);

  tabBar.adjustScrollTabsRight();
}

function getMultiRowAttribute () {
  var tabBar = gBrowser.mTabContainer;
  if (tabBar.collapsedTabs > 0)
    return "scrollbar";

  if (gBrowser.mStrip.collapsed || (tabBar.lastTabVisible && inSameRow(tabBar.firstChild, tabBar.lastChild)))
    return null; // tabBar.removeAttribute("multibar");

  tabBar.setAttribute("multibar", "true");
  var maxY = tabBar.tabstrip.boxObject.y + getRowHeight() * tabBar.maxRow;
  // if the top of the last tab is on or below the max line then enter scrollbar
  var lastTabY = tabBar.lastChild.boxObject.y;
  if (lastTabY >= maxY)
    return "scrollbar";

  return "true";
}

function setTabBarHeight (multibar) {
  var tabhbox = gBrowser.mTabContainer.tabstrip;
  var newHeight;
  if (multibar == "true" && gIsFirefox3) {
    // check bottom of 2 last tab just in case theme set different bottom to selected or hover tab
    var tabs = gBrowser.mTabContainer.childNodes;
    var tabBottom = Math.max(tabs[tabs.length - 1].baseY, tabs[tabs.length - 2].baseY);
    var maxHeight = getRowHeight() * gBrowser.mTabContainer.maxRow;
    newHeight = Math.min(tabBottom - tabhbox.boxObject.y, maxHeight);
    if (tabhbox.boxObject.height > newHeight && tabhbox.boxObject.height - newHeight < 2)
      return;
  }
  else if (multibar == "scrollbar")
    newHeight = getRowHeight() * gBrowser.mTabContainer.maxRow;

  if (!multibar || !newHeight) {
    if (tabhbox.hasAttribute("style"))
      tabhbox.removeAttribute("style");
    if (gBrowser.mTabContainer.hasAttribute("style"))
      gBrowser.mTabContainer.removeAttribute("style");
    return;
  }

  if (tabhbox.style.maxHeight != tabhbox.style.height || tabhbox.style.maxHeight != newHeight + "px") {
    tabhbox.style.maxHeight = tabhbox.style.height = newHeight + "px";
    // override fixed height set by theme to .tabbrowser-tabs class
    if (gBrowser.mTabContainer.boxObject.height < newHeight) {
      var tabsBottom = document.getAnonymousElementByAttribute(gBrowser.mTabContainer, "class", "tabs-bottom");
      gBrowser.mTabContainer.style.maxHeight = gBrowser.mTabContainer.style.height = newHeight + tabsBottom.boxObject.height + "px";
    }
  }
}

// Update beforeselected and afterselected attribute when we are in multi-row mode
function checkBeforeAndAfter() {
  var tabBar = getBrowser().mTabContainer;
  if (!tabBar.hasAttribute("multibar"))
     return;

  var tab = tabBar.selectedItem;
  var prev = tab.previousSibling, next = tab.nextSibling;
  if (prev) {
    TMP_setItem(prev, "beforeselected", inSameRow(prev, tab) ? true : null)
  }
  if (next) {
    TMP_setItem(next, "afterselected", inSameRow(next, tab) ? true : null)
  }
}

var gRowHeight = null;
function getRowHeight () {
  if (gRowHeight)
    return gRowHeight;

  var tabBar = getBrowser().mTabContainer;
  var tabs = getBrowser().mTabContainer.childNodes;

  var i, j;
  i = j = tabBar.collapsedTabs;
  if ( tabs[j] && tabs[j].getAttribute("selected") == "true" )
    j++;
  while (tabs.item(j) && tabs.item(i) && inSameRow( tabs.item(i), tabs.item(j) ) )
    i++;

  if ( !tabs[i] ) // only one row
    if ( tabs[j] )
      return tabs[j].baseY - tabs[j].boxObject.y;
    else
      return tabs[0].baseY - tabs[0].boxObject.y;

  if ( tabs[i].getAttribute("selected") == "true" )
    i++;
  if ( !tabs[i] )
    return tabs[i-1].baseY - tabs[i-1].boxObject.y;

  gRowHeight = tabs[i].baseY - tabs[j].baseY;
  return gRowHeight;
}

function inSameRow (tab1, tab2) {
  if ( !tab1 || !tab2 )
    return false;
  if ( !tabscroll || tabscroll != 2 )
    return true;

  var top1 = tab1.boxObject.y, top2 = tab2.boxObject.y;
  var base1 = tab1.baseY, base2 = tab2.baseY;
  var topH = Math.min(top1, top2), topL = Math.max(top1, top2);
  var baseH = Math.min(base1, base2), baseL = Math.max(base1, base2);

  if ( topH == topL || baseH == baseL )
    return true;

  return ( baseH > (top1+base1)/2 && baseH > (top2+base2)/2 && topL < (top1+base1)/2 && topL < (top2+base2)/2 ) ?
    true : false;
}

// call by resize event on content
function tabBarWidthChange (aEvent) {
  var tabBar = gBrowser.mTabContainer;

  // fix bug in positioning the popup off screen or on the button when window is not maximize or when tab bar is in the bottom
  TMP_setItem(tabBar.mAllTabsPopup, "position",
            (window.windowState != window.STATE_MAXIMIZED || gTabbarPosition == 1) ? "start_before" : "after_end");

  // we don't need to update scroll status when tab bar is in collapsed mode
  if (tabBar.boxObject.width == 0 || window.windowState == window.STATE_MINIMIZED)
    return;

  // we don't need to update scroll status if resize event not trigger by width change
  if ( gTabBarWidth == tabBar.boxObject.width)
    return;

  var tabs = gBrowser.mTabContainer.childNodes;

  if (addtabx == 5 && !gWidthFitTitle)
    adjustOn2ndTab.closeButton(1);

  var oldCollapsed = tabBar.collapsedTabs;
  var i = 0;
  if ( tabscroll != 2 && gTabBarWidth < tabBar.boxObject.width ) {
    while ( tabs[ oldCollapsed + i ] &&
            tabs[ oldCollapsed + i ].boxObject.screenX + tabs[ oldCollapsed + i ].boxObject.width <
              tabBar.tabstrip.boxObject.screenX + tabBar.tabstrip.boxObject.width ) {
      i++;
    }
    if (tabBar.collapsedTabs > 0)
      tabBar.collapsedTabs = 0;
    tabBar.ensureTabIsVisible( oldCollapsed + i - 1 );
    tabBarScrollStatus();
  }
  else if ( tabscroll == 2 ) {
    if (tabBar.collapsedTabs > 0)
      tabBar.collapsedTabs = 0;
    tabBarScrollStatus();
    tabBar.ensureTabIsVisible( tabs.length - 1);
    tabBar.ensureTabIsVisible( oldCollapsed );
    checkBeforeAndAfter();
  }
  else
    tabBarScrollStatus();

  gTabBarWidth = tabBar.boxObject.width;
}

// Function to catch changes to Tab Mix preferences and update existing windows and tabs
//
function TMP_PrefObserver() {
  var pref = "setDefault"
  if (tabxPrefs.prefHasUserValue(pref))
    tabxPrefs.clearUserPref(pref)
  pref = "PrefObserver.error";
  if (tabxPrefs.prefHasUserValue(pref))
    tabxPrefs.clearUserPref(pref)

  if ("TreeStyleTabBrowser" in window)
    this.OBSERVING.push("extensions.treestyletab.tabbar.position");

  try {
    var prefSvc = nsIPrefServiceObj.getBranch(null);
    this.tabxBranch = tabxBranch;
    this.pbi = prefSvc.QueryInterface(Components.interfaces.nsIPrefBranch2);

    // add Observer
    for (var i = 0; i < this.OBSERVING.length; ++i)
      this.pbi.addObserver(this.OBSERVING[i], this, true);
  }
  catch(e) {
    tmLog("prefs-Observer failed to attach:" + "\n" + e);
    tabxPrefs.setBoolPref(pref, true);
  }
}

TMP_PrefObserver.prototype = {
  tabxBranch: null,
  // nsISupports interface implementation -- for weak-reference by pref-observer service
  QueryInterface: function(iid) {
    if (!iid.equals(Components.interfaces.nsISupports)
        && !iid.equals(Components.interfaces.nsISupportsWeakReference)
        && !iid.equals(Components.interfaces.nsIObserver)) {
      dump("Tab Mix Plus pref-observer factory object: QI unknown interface: " + iid + "\n");
      throw Components.results.NS_ERROR_NO_INTERFACE;
    }
    return this;
  },

  OBSERVING: ["extensions.tabmix.",
              "browser.tabs.autoHide",
              "browser.tabs.tabClipWidth",
              "browser.sessionstore.max_tabs_undo",
              "browser.warnOnRestart",
              "browser.warnOnQuit",
              "browser.sessionstore.resume_from_crash",
              "browser.startup.page",
              "browser.link.open_external",
              "browser.link.open_newwindow.restriction",
              "browser.link.open_newwindow",
              "browser.ctrlTab.mostRecentlyUsed"],

  // removes the observer-object from service -- called when the window is no longer open
  removeObserver: function() {
    for (var i = 0; i < this.OBSERVING.length; ++i)
      this.pbi.removeObserver(this.OBSERVING[i], this);

    this.pbi = null;
  },

  /* Observer-function */
  /* subject: [wrapped nsISupports :: nsIPrefBranch], nsIPrefBranch Internal
     topic: "changed"*/
  observe: function TMP_pref_observer(subject, topic, prefName) {
    // if we don't have a valid window (closed)
    if ( !(typeof(document) == 'object' && document) ) {
      this.removeObserver(); // remove the observer..
      return;  // ..and don't continue
    }

    var prefValue;
    switch (prefName) {
      case "extensions.tabmix.filetype":
      case "extensions.tabmix.warnAboutClosingTabs.timeout":
      case "extensions.tabmix.sessions.crashed":
      case "extensions.tabmix.disableIncompatible":

      case "extensions.tabmix.selected_tab":
      case "extensions.tabmix.selected_sub_tab1":
      case "extensions.tabmix.selected_sub_tab2":
      case "extensions.tabmix.selected_sub_tab3":
      case "extensions.tabmix.selected_sub_tab4":
      case "extensions.tabmix.selected_sub_tab5":
      case "extensions.tabmix.selected_sub_tab6":

      case "extensions.tabmix.reload_time":
      case "extensions.tabmix.custom_reload_time":
      case "extensions.tabmix.resume_session_once":
        break;
      case "extensions.tabmix.undoCloseButton.menuonly":
        TMP_ClosedTabs.setButtonType(gPref.getBoolPref(prefName));
        break;
      case "extensions.tabmix.focusTab":
          gPref.setBoolPref("browser.tabs.selectOwnerOnClose", gPref.getIntPref(prefName) == 2);
        break;
      case "extensions.tabmix.disableF9Key":
        this.toggleKey("key_tm_toggleFLST", prefName);
        break;
      case "extensions.tabmix.disableF8Key":
        this.toggleKey("key_tm_slideShow", prefName);
        break;
      case "extensions.tabmix.hideIcons":
        this.setMenuIcons();
        break;
      case "extensions.tabmix.currentColorCode":
        this.setColor("currentTab", prefName, "#009900");
        break;
      case "extensions.tabmix.unreadColorCode":
        this.setColor("unreadTab", prefName, "#FF0000");
        break;
      case "extensions.tabmix.progressColorCode":
        this.setColor("progress", prefName, "#AAAAFF");
        break;
      case "extensions.tabmix.flexTabs":
      case "extensions.tabmix.tabXMode":
        TMupdateSettings(false);
      case "extensions.tabmix.keepLastTab":
      case "browser.tabs.tabClipWidth":
        adjustOn2ndTab.closeButton(1);
        break;
      case "extensions.tabmix.tabBarPosition":
         gTabbarPosition = TMP_getIntPref (tabxBranch, "tabBarPosition", 0);
         if (gTabbarPosition != 0 && "TreeStyleTabBrowser" in window) {
           tabxPrefs.setIntPref("tabBarPosition", 0);
           return;
         }         
         adjustSafebrowsingDimArea();
         TMupdateSettings(false);
        break;
      case "extensions.tabmix.useGreyCloseButton":
        this.tabCloseButton();
        break;
      case "extensions.tabmix.undoClose":
        if (!tabxPrefs.getBoolPref("undoClose")) {
          gPref.setIntPref("browser.sessionstore.max_tabs_undo", 0);
        }
        else if (gPref.prefHasUserValue("browser.sessionstore.max_tabs_undo"))
          gPref.clearUserPref("browser.sessionstore.max_tabs_undo");
        break;
      case "browser.sessionstore.max_tabs_undo":
        prefValue = gPref.getIntPref(prefName);
        while (prefValue < TMP_ClosedTabs.count) {
          TMP_ClosedTabs.ssIsON ? TMP_ClosedTabs.getClosedTabAtIndex(TMP_ClosedTabs.count - 1) : getClosedTab("delete", TMP_ClosedTabs.count - 1);
        }
        if (tabxPrefs.getBoolPref("undoClose") != (prefValue > 0))
          tabxPrefs.setBoolPref("undoClose", prefValue > 0);
        TMP_ClosedTabs.setButtonDisableState();
        break;
      case "browser.warnOnRestart": // not exist in firefox 2.0
      case "browser.warnOnQuit":    // not exist in firefox 2.0
      case "browser.sessionstore.resume_from_crash":
        try {
          if (!gPref.getBoolPref(prefName))
            return;

          var TMP_sessionManager_enabled = tabxPrefs.getBoolPref("sessions.manager") ||
                           tabxPrefs.getBoolPref("sessions.crashRecovery");
          if (TMP_sessionManager_enabled)
            gPref.setBoolPref(prefName, false);
        } catch (er) {return; /* we are in firefox 2.0 */}
        break;
      case "browser.startup.page":
        if (gPref.getIntPref(prefName) != 3)
          return;
        TMP_sessionManager_enabled = tabxPrefs.getBoolPref("sessions.manager") ||
                         tabxPrefs.getBoolPref("sessions.crashRecovery");

        if (TMP_sessionManager_enabled)
          gPref.setIntPref(prefName, 1);
        break;
      case "extensions.tabmix.sessions.manager":
      case "extensions.tabmix.sessions.crashRecovery":
        TMP_SessionStore.setService(2, false);
        SessionManager.updateSettings();
        break;
      case "browser.link.open_external":
      case "browser.link.open_newwindow.restriction":
      case "browser.link.open_newwindow":
        this.setLink_openPrefs();
        break;
      case "extensions.tabmix.singleWindow":
        this.setSingleWindowUI();
        break;
      case "extensions.tabmix.hideTabbar":
        this.setAutoHidePref();
        this.setTabBarVisibility(false);
        break;
      case "browser.tabs.autoHide":
        this.setAutoHidePref();
        break;
      case "extensions.tabmix.newTabButton.leftside":
        this.changeNewTabButtonSide(gPref.getBoolPref(prefName));
        break;
      case "browser.ctrlTab.mostRecentlyUsed":
      case "extensions.tabmix.lasttab.tabPreviews":
      case "extensions.tabmix.lasttab.favorLeftToRightOrdering":
      case "extensions.tabmix.lasttab.respondToMouseInTabList":
      case "extensions.tabmix.lasttab.showTabList":
        TMP_LastTab.ReadPreferences();
        break;
      case "extensions.treestyletab.tabbar.position":
        TMP_setDragEvents(false);
        break;        
      default:
        TMupdateSettings(false);
    }

  },

  tabCloseButton: function() {
    /* Mac from Firefox 2 and Linux from Firefox 3 don't use close.png */
    if (/^Linux/.test(navigator.platform) && gIsFirefox3)
       return;

    // we have some exeptions here.... 
    // classiccompact theme
    // .... if we find more we need to add theme here or maybe add some pref??
    if (/^Mac/.test(navigator.platform) && gPref.getCharPref("general.skins.selectedSkin") != "classiccompact")
       return;

    try {
      var useNewCloseIcon = tabxPrefs.getBoolPref("useGreyCloseButton");
    }
    catch(er) { useNewCloseIcon = true; }
    if (useNewCloseIcon) {
      gBrowser.mTabContainer.setAttribute("closeIcon", gIsFirefox3 ? "v3" : "v2");
    }
    else
      gBrowser.mTabContainer.removeAttribute("closeIcon");
  },

  toggleKey: function(keiID, prefName) {
    var key = document.getElementById(keiID);
    if (TMP_getBoolPref("", prefName, false)) {
      if (key.hasAttribute("oncommand"))
        key.removeAttribute("oncommand");
    } else
      key.setAttribute("oncommand", key.getAttribute("TM_oncommand"));
  },

  colorRules: {},
  createColorRules: function() {
    // find tab.css to insert our color rules into it.
    // insert our rules into document.styleSheets[0] cause problem with other extensions
    var ss = null;
    for (var i = 0; i < document.styleSheets.length; ++i) {
      if (document.styleSheets[i].href == "chrome://tabmixplus/skin/tab.css") {
        ss = document.styleSheets[i];
        break;
      }
    }
    if (!ss)
      ss = document.styleSheets[document.styleSheets.length-1];

    // create new css rules with the currrent preference value.
    var _colorRules = this.colorRules;
    function setNewRule(colorType, prefName, defaultPref, colorRule) {
      var codePrefName = "extensions.tabmix." + prefName + "Code";
      var colorCode = TMP_getCharPref("", codePrefName, defaultPref);
      colorRule = colorRule + colorCode + '}';
      var index = ss.insertRule(colorRule, ss.cssRules.length);
      _colorRules[colorType] = ss.cssRules[index];

     // in 0.3.0.605 we changed tab color from old pref to new pref
     // old pref "extensions.tabmix.currentColor" type integer
     // new pref "extensions.tabmix.currentColorCode" type string
      var oldPrefName = "extensions.tabmix." + prefName;
      if (gPref.prefHasUserValue(oldPrefName)) {
        var colorCodes = ["#CF1919", "#0E36EF", "#DDDF0D", "#3F8F3E", "#E066FF", "#86E7EF",
                           "#FFFFFF", "#7F7F7F", "#000000", "#EF952C", "#FF82AB", "#7F4C0F", "#AAAAFF"];
        var colorCode = colorCodes[gPref.getIntPref(oldPrefName)];
        gPref.clearUserPref(oldPrefName);
        if (gPref.getCharPref(codePrefName) != colorCode) {
          // this trigger call to setColor for this prefName
          gPref.setCharPref(codePrefName , colorCode);
        }
      }
    }
    setNewRule("currentTab", "currentColor", "#000000", 'tabs[currentTab=true][useCurrentColor=true] tab[selected="true"] .tab-text { color:');
    setNewRule("unreadTab", "unreadColor", "#CC0000", 'tabs[unreadTab=true][useUnreadColor=true] tab:not([selected]) .tab-text { color:');
    setNewRule("progress", "progressColor", "#AAAAFF", 'tabs[useProgressColor=true] tab .progress-bar { background-color:');

    // for ColorfulTabs in Firefox 2.0 - fix background for close button on tab
    if (!gIsFirefox3) {
      var skin = gPref.getCharPref("general.skins.selectedSkin");
      if (skin=="classic/1.0" && "setColor" in window && "clrtabsInit" in window)
        ss.insertRule(".tabbrowser-tab .tabs-closebutton, .tabbrowser-tab .tab-close-button {background-image: none !important;}", ss.cssRules.length);
    }
  },

  setColor: function(colorType, prefName, defaultPref) {
    var colorCode = TMP_getCharPref("", prefName, defaultPref);
    var _style = colorType == "progress" ? "backgroundColor" : "color";
    this.colorRules[colorType].style[_style] = colorCode;
  },

  setLink_openPrefs: function() {
    if (!gSingleWindowMode)
      return;

    function updateStatus(pref, testVal, test, newVal) {
      try {
        var prefValue = gPref.getIntPref(pref);
        test = test ? prefValue == testVal : prefValue != testVal
      }
      catch(e){ test = true; }

      if (test)
        gPref.setIntPref(pref, newVal);
    }

    updateStatus("browser.link.open_external", 2, true, 3);
    updateStatus("browser.link.open_newwindow.restriction", 0, false, 0);
    updateStatus("browser.link.open_newwindow", 2, true, 3);
  },

  // code for Single Window Mode...
  // disable the "Open New Window action
  //disable & hides some menuitem
  setSingleWindowUI: function() {
    gSingleWindowMode = TMP_getBoolPref(tabxBranch, "singleWindow", false);
    var newWindowButton = document.getElementById("new-window-button");
    if (newWindowButton)
      newWindowButton.setAttribute("disabled", gSingleWindowMode);

    var openLink = document.getElementById("context-openlink");
    if (openLink)
      openLink.setAttribute("disabled", gSingleWindowMode);

    var menuItem;
    var menuFile = document.getElementById("menu_FilePopup");
    if (menuFile) {
      menuItem = menuFile.getElementsByAttribute("command", "cmd_newNavigator")[0];
      if (menuItem)
        menuItem.setAttribute("hidden", gSingleWindowMode);
    }

    var frameMenu = document.getElementById("frame");
    if (frameMenu) {
      menuItem = frameMenu.getElementsByAttribute("oncommand", "gContextMenu.openFrame();")[0];
      if (menuItem)
        menuItem.setAttribute("hidden", gSingleWindowMode);
    }

    document.getElementById("tmOpenInNewWindow").hidden = gSingleWindowMode;
  },

  setMenuIcons: function() {
    function setClass(items, hideIcons) {
      if (hideIcons)
        for (var i = 0; i < items.length; ++i)
          items[i].removeAttribute("class");
      else
        for ( i = 0; i < items.length; ++i)
          items[i].setAttribute("class", items[i].getAttribute("tmp_iconic"));
    }
    var hideIcons = TMP_getBoolPref(tabxBranch, "hideIcons", false);
    var iconicItems = document.getElementsByAttribute("tmp_iconic", "*");
    setClass(iconicItems, hideIcons);

    iconicItems = document.getElementById("menuedit-tabContextMenu").getElementsByAttribute("tmp_iconic", "*");
    setClass(iconicItems, hideIcons);
  },

  setAutoHidePref: function() {
    gHideTabBar = tabxPrefs.getIntPref("hideTabbar");
    var autoHide = gHideTabBar != 0;
    if (autoHide != gPref.getBoolPref("browser.tabs.autoHide"))
      gPref.setBoolPref("browser.tabs.autoHide", autoHide);
  },

  setTabBarVisibility: function(onFullScreenExit) {
    if (gHideTabBar == 2) {
      gBrowser.mStrip.collapsed = true;
    }
    else if (gBrowser.mStrip.collapsed || onFullScreenExit) {
      // if we are in multi-row and we have more then one tab we need to initialize multi-row again
      gBrowser.mTabContainer.collapsedTabs = 0;
      setTabBarHeight(false);
      gBrowser.mTabContainer.removeAttribute("multibar");
      var moreThenOneTab = gBrowser.mTabContainer.childNodes.length > 1;
      if (onFullScreenExit) // from firefox 3.0 tab strip is collapsed by set moz-collapsed to true on full screen
        gBrowser.mStrip.setAttribute("moz-collapsed", false);
      else if (moreThenOneTab || gHideTabBar == 0)
        gBrowser.mStrip.collapsed = false;
      if (moreThenOneTab) {
         tabBarScrollStatus();
         gBrowser.mTabContainer.ensureTabIsVisible(gBrowser.mTabContainer.selectedIndex);
         checkBeforeAndAfter();
         //XXX underline the label bleed over the end when tab is to small and we have close button on the tab !!!!????
         toggleUderlineTabsLabel();
      }
    }
  },

  changeNewTabButtonSide: function(aButtonOnLeftSide) {
    var tabBar = gBrowser.mTabContainer;
    var newTabButton = document.getAnonymousElementByAttribute(tabBar, "id", "tabs-newbutton-box");
    // if we don't find tabs-newbutton-box prbebly some them changed our binding
    if (!newTabButton)
      return;

    if (aButtonOnLeftSide) {
      var leftContainer = document.getAnonymousElementByAttribute(tabBar, "class", "tabs-newTab");
      if (leftContainer)
        leftContainer.appendChild(newTabButton);
    }
    else {
      var allTabsButton = gIsFirefox3 ? document.getAnonymousElementByAttribute(tabBar, "class", "tabs-alltabs-topbox") :
                                        document.getAnonymousElementByAttribute(tabBar, "class", "tabs-alltabs-stack");
      // if we don't find allTabsButton prbebly some them changed our binding
      // look at Vista-aero 2.0.0.46 for example.
      if (allTabsButton)
        allTabsButton.parentNode.insertBefore(newTabButton, allTabsButton);
    }
  },

  // we replace some Tabmix settings with Firefox settings
  updateSettings: function() {
    if (tabxPrefs.prefHasUserValue("undoCloseCache")) {
       var max_tabs_undo = tabxPrefs.getIntPref("undoCloseCache");
       tabxPrefs.clearUserPref("undoCloseCache");
       gPref.setIntPref("browser.sessionstore.max_tabs_undo", max_tabs_undo);
    }
    // remove disp=attd&view=att it's make problem with gMail
    if (tabxPrefs.prefHasUserValue("filetype")) {
       var filetype = tabxPrefs.getCharPref("filetype");
       filetype = filetype.replace(" /disp=attd&view=att/ "," ");
       tabxPrefs.setCharPref("filetype", filetype);
    }
    // 2008-08-17
    if (tabxPrefs.prefHasUserValue("opentabfor.search")) {
       gPref.setBoolPref("browser.search.openintab", tabxPrefs.getBoolPref("opentabfor.search"));
       tabxPrefs.clearUserPref("opentabfor.search");
    }
    // 2008-09-23
    if (tabxPrefs.prefHasUserValue("keepWindow")) {
       gPref.setBoolPref("browser.tabs.closeWindowWithLastTab", !tabxPrefs.getBoolPref("keepWindow"));
       tabxPrefs.clearUserPref("keepWindow");
    }
    // 2008-09-28
    if (tabxPrefs.prefHasUserValue("lasttab.handleCtrlTab")) {
       gPref.setBoolPref("browser.ctrlTab.mostRecentlyUsed", tabxPrefs.getBoolPref("lasttab.handleCtrlTab"));
       tabxPrefs.clearUserPref("lasttab.handleCtrlTab");
    }
    // verify that all the prefs exist .....
    this.addMissingPrefs();
  },

  // we call this function also from pref-tabmix.js
  addMissingPrefs: function() {
    TMP_getBoolPref("", "browser.tabs.closeWindowWithLastTab", false); // exist in firefox version 3.1
    TMP_getBoolPref("", "browser.ctrlTab.mostRecentlyUsed", true);     // exist in firefox version 3.1
    TMP_getBoolPref("", "browser.warnOnRestart", true);                // exist in firefox version 3.0
    TMP_getBoolPref("", "browser.warnOnQuit", true);                   // exist in firefox version 3.0
    TMP_getIntPref("", "browser.link.open_external", 3);               // not exist in firefox from version 3.1
  }

}

// adjust attribute when we close 2nd tab (we left with only one) or when we open 2nd tab
var adjustOn2ndTab = {
  /*  don't show close tab button if there is only one blank tab or we keep last tab
   *  or if tab width is smaller then pref and not in WidthFitTitle mode.
   */
   closeButton: function adjust_closeButton(aNumTabs, oldTab) {
      var tabBar = gBrowser.mTabContainer;
      var tabs = tabBar.childNodes;
      var aTab = aNumTabs == 2 && tabs[0] == oldTab ? tabs[1] : tabs[0];
      if (tabs.length == aNumTabs &&
               (TMP_getBoolPref(tabxBranch, "keepLastTab", false) || gBrowser.isBlankNotBusyTab(aTab)))
         tabBar.setAttribute("hidebutton", "true");
      else if (tabBar.hasAttribute("hidebutton"))
         tabBar.removeAttribute("hidebutton");

      setTimeout( function(tabBar) {
         // make sure not to check collapsed tab for width
         var width = tabBar.lastChild.boxObject.width;
         // 0 width is an invalid value and indicates an item without display,
         // so ignore.
         var tabClipWidth = TMP_getIntPref("", "browser.tabs.tabClipWidth", 140);
         var attributeChanged = false;
         if (addtabx != 5 || gWidthFitTitle || width > tabClipWidth || width == 0) {
            if (tabBar.hasAttribute("tinywidth")) {
               tabBar.removeAttribute("tinywidth");
               attributeChanged = true;
            }
         }
         else if (!tabBar.hasAttribute("tinywidth")) {
            tabBar.setAttribute("tinywidth", "true");
            attributeChanged = true;
         }

         if (attributeChanged) {
            tabBarScrollStatus();
            checkBeforeAndAfter();
         }
      }, 0, tabBar);
   }
}

// in Firefox 2.0 with safebrowsing
// if the current Browser has problem and message is showing we need to
// repaint the "safebrowsing-dim-area-canvas" if we add or remove tabs and
// if we change tabbar position
//
// we don't need this in Firefox 3.0
function adjustSafebrowsingDimArea() {
   if (gIsFirefox3)
      return;

   var sbC = safebrowsing.controller;
   if (sbC == null)
      return;

   var browser = getBrowser().selectedBrowser;
   if (sbC.browserView_.hasProblem(browser)) {
      var displayer = sbC.browserView_.getCurrentProblem_(browser).displayer_;
      if (displayer.messageShowing_) {
         displayer.hideMessage_();
         displayer.showMessage_();
      }
   }
}

function TMP_getBoolPref(branch, prefname, def ) {
  try {
    if (!gPref)
      gPref = getPref();
    return gPref.getBoolPref(branch+prefname);
  }
  catch(er) {
    gPref.setBoolPref(branch+prefname, def);
    return def;
  }
}

function TMP_getIntPref(branch, prefname, def ) {
  try {
    if (!gPref)
      gPref = getPref();
    return gPref.getIntPref(branch+prefname);
  }
  catch(er) {
    gPref.setIntPref(branch+prefname, def);
    return def;
  }
}

function TMP_getCharPref(branch, prefname, def ) {
  try {
    if (!gPref)
      gPref = getPref();
    return gPref.getCharPref(branch+prefname);
  }
  catch(er) {
    gPref.setCharPref(branch+prefname, def);
    return def;
  }
}

function getPref() {
   return Components.classes["@mozilla.org/preferences-service;1"]
            .getService(Components.interfaces.nsIPrefBranch);
}

var TMP_ProgressListener = {

   startup: function TMP_PL_startup(tabBrowser) {
      eval("tabBrowser.enterTabbedMode ="+tabBrowser.enterTabbedMode.toString().replace(
         'filter.addProgressListener(listener, Components.interfaces.nsIWebProgress.NOTIFY_ALL);',
         'listener = TMP_ProgressListener.init(listener); \ $&'
      ));

      eval("tabBrowser.addTab ="+tabBrowser.addTab.toString().replace(
         'var tabListener = this.mTabProgressListener(t, b, blank);',
         '$& \ tabListener = TMP_ProgressListener.init(tabListener);'
      ));
   },

   init: function TMP_PL_init(progressListener) {
      var _this = "TMP_ProgressListener."
/*
// XXX this is not working in firefox 1.0.x ???
      eval("progressListener.onProgressChange = " + progressListener.onProgressChange.toString()
            .replace(/}$/,
            'this.onStateChange(aWebProgress, aRequest);' +
            _this + 'setTabProgress(this.mTab, aMaxTotalProgress, aCurTotalProgress); \ $&'));
*/

      function addToTheEnd(fnName, newString) {
         var fnString = progressListener[fnName].toString();
         fnString = fnString.substr(0, fnString.length - 2) + newString + "}";
         eval("progressListener." + fnName + " = " + fnString);
      }

      addToTheEnd('onProgressChange',
                  'this.onStateChange(aWebProgress, aRequest);' +
                  _this + 'setTabProgress(this.mTab, aMaxTotalProgress, aCurTotalProgress);');

      // we need to be compatible with XHTML Ruby Support
      var fnName = "onStateChange";
      var ruby = "__rubysupport__" + fnName;
      if (ruby in progressListener)
         fnName = ruby;

      eval("progressListener." + fnName + " = " + progressListener[fnName].toString().replace(
            'this.mTab.setAttribute("busy", "true");',
            _this + 'setTabWidth(this.mTab, aRequest.QueryInterface(nsIChannel).URI.spec);'
            + '$&'
         ).replace(
            'var location = aRequest.QueryInterface(nsIChannel).URI;',
            _this + 'setUnreadTab(this.mTab); \ $&'
         ));

      addToTheEnd(fnName,
                  _this + 'setAutoReload(this.mTab, this.mBrowser, aStateFlags);');

      // XXX how to do this with Regexp and replace ?
      var string = "if (this.mTabBrowser.mCurrentTab == this.mTab)";
      var split_fn = progressListener[fnName].toString().split(string);
      split_fn[1] += _this + 'updateSessionManager(this.mTab);'
      eval("progressListener." + fnName + " = " + split_fn.join(string));

      addToTheEnd('onLocationChange', _this + 'fixBug355253(this.mBrowser);')

      return progressListener;

   },

   setTabProgress: function TMP_PL_setTabProgress(aTab, aMaxTotalProgress, aCurTotalProgress) {
      if (gHideTabBar == 2 || aMaxTotalProgress < 1)
         return;
      var percentage = parseInt((aCurTotalProgress * 100) / aMaxTotalProgress);
      if (percentage > 0 && percentage < 100)
         aTab.setAttribute("tab-progress", percentage);
   },

   setTabWidth: function TMP_PL_setTabWidth(aTab, aLocation) {
      var tabBar = aTab.parentNode;
      var spacer = 0;
      // at this stage only unhide the button if needed.
      var buttonIsHidden = tabBar.hasAttribute("hidebutton");
      var keepLastTab = tabxPrefs.getBoolPref("keepLastTab");
      if (tabBar.childNodes.length == 1 && (buttonIsHidden || keepLastTab)) {
        var hidebutton = (aLocation == "about:blank") || keepLastTab;
        if (buttonIsHidden && !hidebutton)
          spacer = 5;
        TMP_setItem(tabBar, "hidebutton", hidebutton || null);
      }
      if (gHideTabBar != 2 && gWidthFitTitle && !aTab.hasAttribute("width") && aLocation != aTab.label) {
         if (aTab.hasAttribute("newtab")) {
           spacer = 5;
           aTab.removeAttribute("newtab");
         }
         aTab.setAttribute("width", aTab.boxObject.width + spacer);
      }
   },

   setUnreadTab: function TMP_PL_setUnreadTab(aTab) {
      if (aTab.parentNode.childNodes.length == 1) {
        var hidebutton = gBrowser.isBlankTab(aTab) || tabxPrefs.getBoolPref("keepLastTab");
        TMP_setItem(aTab.parentNode, "hidebutton", hidebutton || null);
      }
      aTab.removeAttribute("tab-progress");
      if (gPref.getBoolPref("extensions.tabmix.unreadTab") &&
            aTab.hasAttribute("selected") &&
            gPref.getBoolPref("extensions.tabmix.unreadTabreload") &&
            aTab.getAttribute("selected") == "false")
         aTab.removeAttribute("selected");
   },

   updateSessionManager: function TMP_PL_updateSessionManager(aTab) {
      if (!aTab.hasAttribute("busy"))
         SessionManager.tabLoaded(aTab);
   },

   setAutoReload: function TMP_PL_setAutoReload(aTab, aBrowser, aStateFlags) {
      const nsIWebProgressListener = Components.interfaces.nsIWebProgressListener;
      if ((aStateFlags & nsIWebProgressListener.STATE_IS_WINDOW) &&
            (aStateFlags & nsIWebProgressListener.STATE_STOP)) {
         if (aTab.autoReloadURI)
            gBrowser.onTabReloaded(aTab, aBrowser);

         // disabled name for locked tab, so locked tab don't get reuse
         if (aTab.getAttribute("locked") && aBrowser.contentWindow.name)
            aBrowser.contentWindow.name = "";
      }
   },

// XXX temp fix to bug 355253
   // recently closed tabs doesn't saved closed tab if it have "about:blank" first in history.
   fixBug355253: function TMP_PL_fixBug355253(aBrowser) {
      var history = aBrowser.webNavigation.sessionHistory;
      if (history && history.count == 2 && history.index == 1 &&
            history.getEntryAtIndex(0, false).URI.spec == "about:blank") {
         aBrowser.observe(null, "browser:purge-session-history", null);
         var backCommand = document.getElementById("Browser:Back");
         if (backCommand)
            backCommand.setAttribute("disabled", "true");
      }
   }

}
