/*
 * tabmix.js
 *
 * original code by Hemiola SUN, further developed by onemen and CPU
 */
var gPref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
var gIsFirefox3 = typeof(PlacesController) == "function";
var gIsFirefox31;

function TM_init()
{
  var historyMenu = document.getElementById("goPopup").parentNode;
  if (gIsFirefox3) {
     TMP_Places.init();
     document.getElementById("goPopup").addEventListener("popupshowing", TMP_Places.historyMenuItemsTitle, false);
    // history menu open in new tab if the curren tab is locked
    if (historyMenu)
      historyMenu.setAttribute("oncommand", "TMP_Places.historyMenu(event);");
  }
  else {
    Click2TabLoadBookmark.init();
    if (historyMenu)
      historyMenu.setAttribute("oncommand", "var url = event.target.getAttribute('statustext'); if (url) {openUILinkIn(url, whereToOpenLinkTabmix(event, prefStringTMHistory)); content.focus();}");
  }

  // disable the "Open New Window action in Single Window Mode...
  var cmdNewWindow = document.getElementById("cmd_newNavigator");
  var originalNewNavigator = cmdNewWindow.getAttribute("oncommand");
  cmdNewWindow.setAttribute("oncommand","if (gSingleWindowMode) BrowserOpenTab(); else {" + originalNewNavigator + "}");

  // replace browser handlers with ours so it recognizes when tabs are acted on
  gBrowser.onTabBarDblClick = TM_onTabBarDblClick;
  gBrowser.onTabClick = TM_checkClick;

  if(gBrowser.moveTabTo)
    gBrowser.moveTabTo = gBrowser.TMmoveTabTo;

  gBrowser.closedTabs = [];

  gBrowser.onresize = tabBarWidthChange;
  document.getElementById("contentAreaContextMenu").addEventListener("popupshowing", TM_checkContentMenu, false);

  // override some of All-in-One Gestures function
  // override the duplicate tab function
  if (typeof aioDupTab == 'function')
    aioDupTab = function() { gBrowser.duplicateTab(gBrowser.mCurrentTab); };

  //override the duplicate in new window function
  if (typeof aioDupWindow == 'function')
    aioDupWindow = function() { gBrowser.duplicateInWindow(gBrowser.mCurrentTab); };

  //override the aioCloseWindow function
  if (typeof aioCloseWindow == 'function')
    aioCloseWindow = BrowserTryToCloseWindow;

  // for session manager
  window.setTimeout( function () {
                       SessionManager.init();
                       TMP_ClosedTabs.setButtonDisableState();
                       gBrowser.mTabContainer.nextTab = 1;
                       // convert session.rdf to SessionManager extension format
                       convertSession.startup();
                     }, 0 );

  //Browser:Home open in new tab if the curren tab is locked
  window.BrowserHome = TM_BrowserHome;

  // add call to TMP_Sanitizer
  // nsBrowserGlue.js use loadSubScript to load Sanitizer so we need to add this here
  var cmd = document.getElementById("Tools:Sanitize");
  if (cmd)
    cmd.setAttribute("oncommand", cmd.getAttribute("oncommand") + " TMP_Sanitizer.tryToSanitize();");

  // if sessionStore disabled use TMP command
  window.undoCloseTab = function ct_window_undoCloseTab(aIndex, aWhere) {
                           return TMP_ClosedTabs.undoCloseTab(aIndex, aWhere);
                        };

  _BrowserToolboxCustomizeDone = window.BrowserToolboxCustomizeDone;
  window.BrowserToolboxCustomizeDone = function TMP_customizeDone (aToolboxChanged) {
                                         _BrowserToolboxCustomizeDone(aToolboxChanged);
                                         TMP_BrowserToolboxCustomizeDone(aToolboxChanged);
                                       };
  TMP_BrowserToolboxCustomizeDone(true);

  // Look for RSS/Atom News Reader
  TMP_LookForRSS();
}

// Create new items in the context menu of tab bar
var newMenuItems = ["tm-duplicateTab","tm-duplicateinWin","tm-detachTab","tm-mergeWindowsTab","tm-renameTab",
                    "tm-copyTabUrl", "tm-autoreloadTab_menu", "tm-reloadOther","tm-reloadLeft","tm-reloadRight","tm-separator",
                    "tm-undoCloseTab","tm-undoCloseList","tm-separator-2",
                    "tm-closeAllTabs","tm-closeSimilar","tm-closeLeftTabs","tm-closeRightTabs",
                    "tm-docShell","tm-freezeTab","tm-protectTab","tm-lockTab"];


var newMenuOrders = [ 1, 2, 3, 4, 5, 6,
                      9, 11, 12, 13, 14,
                      15, 16, 17,
                      19, 20, 22, 23,
                      25, 26, 27, 28];

function TM_creatMenuItems () {
  var tabContextMenu = document.getAnonymousElementByAttribute(getBrowser(), "anonid", "tabContextMenu");
  tabContextMenu.setAttribute("onpopuphidden", tabContextMenu.getAttribute("onpopuphidden") + "if (event.target == this) TM_hidePopup();");
  tabContextMenu.addEventListener("popupshowing", Tm_checkTabClick, false);
  tabContextMenu.addEventListener("popupshown", TMP_tabContextMenuShown, false);

  tabContextMenu.setAttribute("id", "menuedit-tabContextMenu");
  var menuItems = tabContextMenu.childNodes;

  // add bookmark options and tabmix function to context menu for tabs befor we add our menu ite,
  // ***** we dno't need this in Firefox 3.0 *****
  if (!gIsFirefox3) {
    gNavigatorBundle = document.getElementById("bundle_browser");
    if (addBookmarkMenuitems) {
      addBookmarkMenuitems();
      addBookmarkMenuitems = function(){}
    }
    if (AugmentTabs) {
      AugmentTabs.init = function(){}
    }
  }

  var i, separator = 0;
  for ( i = 0; i < menuItems.length; i++ ) {
      var item = menuItems[i];
      // from firefox 3.0 menu item have id. we use the same id in our code
      // see Tm_checkTabClick in click.js
      if (item.hasAttribute("id"))
         continue;

      else if (item.localName == "menuseparator")
         item.setAttribute("id", "original-separator-" + separator++);
      else if (item.getAttribute("xbl:inherits") == "oncommand=onnewtab")
         item.setAttribute("id", "context_newTab");
      else {
         var aCommand = item.getAttribute("oncommand");
         if (aCommand.indexOf("reloadTab") != -1 ) item.setAttribute("id", "context_reloadTab");
         else if (aCommand.indexOf("reloadAllTabs") != -1 ) item.setAttribute("id", "context_reloadAllTabs");
         else if (aCommand.indexOf("removeAllTabsBut") != -1 ) item.setAttribute("id", "context_closeOtherTabs");
         else if (aCommand.indexOf("removeTab") != -1 ) item.setAttribute("id", "context_closeTab");
         else if (aCommand.indexOf("BookmarkThisTab") != -1 ) item.setAttribute("id", "context_bookmarkTab");
         else if (item.hasAttribute("command"))
               if (item.getAttribute("command") == "Browser:BookmarkAllTabs") item.setAttribute("id", "context_bookmarkAllTabs");
      }
  }

  // update context_newTab attribute
  var newTab = document.getElementById("context_newTab");
  newTab.setAttribute("_newtab", newTab.getAttribute("label"));
  newTab.setAttribute("_afterthis", document.getElementById("tm-separator").getAttribute("_afterthis"));
  newTab.setAttribute("tmp_iconic", "menuitem-iconic tabs-newbutton tabs-newbutton-menu tmp-icon");
  newTab.removeAttribute("xbl:inherits");

  // group the close-tab options together
  var closeTab = document.getElementById("context_closeTab");
  var closeOther = document.getElementById("context_closeOtherTabs");
  tabContextMenu.insertBefore( closeTab, closeOther );

  // insert new menuitems and separators
  for ( i = 0; i < newMenuItems.length; i++ ) {
    var newMenuItem = document.getElementById(newMenuItems[i]);
    var item;
    if (tabContextMenu.childNodes.length < newMenuOrders[i]+1) item = null;
    else item = tabContextMenu.childNodes[newMenuOrders[i]];
    tabContextMenu.insertBefore( newMenuItem, item);
  }

  // in Firefox 3.0 use build in context_undoCloseTab
  // we set command "History:UndoCloseTab" to use TMP function TMP_ClosedTabs.undoCloseTab();
  var _undoCloseTab = document.getElementById("context_undoCloseTab");
  var tmp_undoCloseTab = document.getElementById("tm-undoCloseTab");
  if (_undoCloseTab) {
    tabContextMenu.insertBefore(_undoCloseTab, tmp_undoCloseTab);
    tabContextMenu.removeChild(tmp_undoCloseTab);
  }
  else // Firefox 2.0
    tmp_undoCloseTab.setAttribute("id", "context_undoCloseTab");

  // restore original-separator-2 to its original position
  var origSep2 = document.getElementById("original-separator-2");
  var addBookmark = document.getElementById("context_bookmarkTab");
  if (origSep2 && addBookmark)
    tabContextMenu.insertBefore(origSep2, addBookmark);

  // insret IE Tab menu-items befor Bookmakrs menu-items or at the end if origSep2 is null
  if (window.gIeTab) {
    var aFunction = "createTabbarMenu" in IeTab.prototype ? "createTabbarMenu" : "init";
    if (aFunction in IeTab.prototype) {
      eval("IeTab.prototype." + aFunction +" ="+IeTab.prototype[aFunction].toString().replace(
           'tabbarMenu.insertBefore(document.getElementById("ietab-tabbar-sep"), separator);',
           'separator = document.getElementById("original-separator-2"); $&'
      ));
    }
  }

 // fix conflict with CookiePie
 if ("cookiepieContextMenu" in window && !cookiepieContextMenu.initialized)
    cookiepieContextMenu.init();

}

function TMP_openDialog(panel)
{
  var WindowManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
                        .getService(Components.interfaces.nsIWindowMediator);
  var tabmixOptionsWin = WindowManager.getMostRecentWindow("mozilla:tabmixopt");
  if (tabmixOptionsWin) {

    var appearanceWin = WindowManager.getMostRecentWindow("mozilla:tabmixopt-appearance");
    var filetypeWin = WindowManager.getMostRecentWindow("mozilla:tabmixopt-filetype");

    if (!appearanceWin && !filetypeWin && panel > -1)
      tabmixOptionsWin.TM_selectTab(panel);

    var incompatibleBox = tabmixOptionsWin.document.getElementById("incompatible");
    var incompatibleStatus = incompatibleBox.collapsed;

    incompatibleBox.collapsed = getExtensions().length == 0;
    if (incompatibleStatus != incompatibleBox.collapsed)
      tabmixOptionsWin.sizeToContent();

    (appearanceWin || filetypeWin || tabmixOptionsWin).focus();
  }
  else {
    if(panel > -1)
      gPref.setIntPref('extensions.tabmix.selected_tab', panel);

    window.openDialog("chrome://tabmixplus/content/pref/pref-tabmix.xul", "Tab Mix Plus", "chrome,titlebar,toolbar,close,dialog=no");
  }
}

/*
   functions to disable incompatible extensions
   original code by mrtech local_install.js , code modified by onemen 2006-01-13
*/
function disableExtensions(aWindow) {
   var warning_list = getExtensions();

   if (warning_list.length == 0) {
      return true;
   }

   try {
      warning_list.sort();
   } catch(ex) { }

   var i, extension, outStr = "";
   for ( i = 0; i < warning_list.length; i++ ) {
      extension = warning_list[i];
      outStr += " - " + extension._name + " " + extension._version + "\n";
   }

   var showatStart = gPref.getBoolPref("extensions.tabmix.disableIncompatible")
   var chkBoxState = showatStart ? CHECKBOX_CHECKED : CHECKBOX_UNCHECKED;

   var bundleID = "tmp-string-bundle"
   var _stingBundle = document.getElementById(bundleID);
   var title = _stingBundle.getString("incompatible.title");
   var msg = _stingBundle.getString("incompatible.msg0") + "\n"
           + _stingBundle.getString("incompatible.msg1") + "\n\n" + outStr + "\n\n";
   var chkBoxLabel = _stingBundle.getString("incompatible.chkbox.label");
   var buttons = [SessionManager.setLabel("incompatible.button0", bundleID),
                 SessionManager.setLabel("incompatible.button1", bundleID)];
   buttons.push(SessionManager.setLabel("incompatible.button2", bundleID));

   var result = TM_PromptService([BUTTON_EXTRA1, HIDE_MENUANDTEXT, chkBoxState],[title, msg, "", chkBoxLabel, buttons.join("\n")], aWindow);
   if (result.checked != showatStart) {
      gPref.setBoolPref("extensions.tabmix.disableIncompatible", result.checked);
      nsIPrefServiceObj.savePrefFile(null); // store the pref immediately
   }

   if (result.button != BUTTON_CANCEL) {
      var extensionManager = Components.classes["@mozilla.org/extensions/manager;1"]
                             .getService(Components.interfaces.nsIExtensionManager);
      for ( i = 0; i < warning_list.length; i++ ) {
         extension = warning_list[i];
         try{
            extensionManager.disableItem(extension._guid);
         } catch(e) {
            tmLog("error while disabled " + extension._name)
         }
      }

      var dataSource = extensionManager.datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
      if (dataSource)
         dataSource.Flush();

      if (result.button == BUTTON_EXTRA1 && canQuitApplication()) {
         var appStartup = Components.interfaces.nsIAppStartup;
         Components.classes["@mozilla.org/toolkit/app-startup;1"]
            .getService(appStartup).quit(appStartup.eRestart | appStartup.eAttemptQuit);
      }
      else {
         msg = _stingBundle.getString("incompatible.msg2");
         buttons = ["", SessionManager.setLabel("sm.button.continue")].join("\n");
         TM_PromptService([BUTTON_CANCEL, HIDE_MENUANDTEXT, HIDE_CHECKBOX],[title, msg, "", "", buttons], aWindow);
      }

      return true;
   }
   return false;
}

function getExtensions() {

   var guid_list = {};
   /*
       The following extensions are integrated or incompatible with Tab Mix Plus

       add extensions ID in lowercase.
   */
   guid_list['{00bdd586-51fb-4b06-9c23-af2fb7609bf3}'] = true;    //   Basics
   guid_list['{b98719b3-76d6-4bec-aeed-3ab542b23bd7}'] = true;    //   BlankLast
   guid_list['{47921160-3085-4023-a145-8ec466babfba}'] = true;    //   Click2Tab
   guid_list['{b0f9cad2-ebae-4685-b518-d3d9b41ea183}'] = true;    //   Close Tab On Double Click
   guid_list['ctc@clav.mozdev.org'] = true;                       //   CTC
   guid_list['{61ed2a9a-39eb-4aaf-bd14-06dfbe8880c3}'] = true;    //   Duplicate Tab
   guid_list['flowtabs'] = true;                                  //   Flowing Tabs
   guid_list['{cd2b821e-19f9-40a7-ac5c-08d6c197fc43}'] = true;    //   FLST
   guid_list['{68e5dd30-a659-4987-99f9-eaf21f9d4140}'] = true;    //   LastTab
   guid_list['minit@dorando'] = true;                             //   MiniT
   guid_list['minit-drag'] = true;                                //   miniT-drag
   guid_list['minit-tabscroll@dorando'] = true;                   //   miniT-tabscroll
   guid_list['new-tab-button-on-tab-bar@mikegoodspeed.com'] = true;   //   new tab button on tab bar
   guid_list['{66E978CD-981F-47DF-AC42-E3CF417C1467}'] = true;    //   new tab homepage
   guid_list['newtaburl@sogame.cat'] = true;                      //   NewTabURL
   guid_list['{4b2867d9-2973-42f3-bd9b-5ad30127c444}'] = true;    //   Petite Tabbrowser Extensions
   guid_list['{888d99e7-e8b5-46a3-851e-1ec45da1e644}'] = true;    //   ReloadEvery
   guid_list['{aede9b05-c23c-479b-a90e-9146ed62d377}'] = true;    //   Reload Tab On Double-Click
   guid_list['{492aa940-beaa-11d8-9669-0800200c9a66}'] = true;    //   Scrollable Tabs
   guid_list['{eb922232-fd76-4eb0-bd5a-c1cba4238343}'] = true;    //   Single Window
   guid_list['{149C6CC6-EC62-4ebd-B719-3C2E867930C7}'] = true;    //   Stack style tabs
   guid_list['supert@studio17.wordpress.com'] = true;             //   superT
   guid_list['tabbin'] = true;                                    //   Tab Bin
   guid_list['{43520b8f-4107-4351-ac64-9bcc5eea24b9}'] = true;    //   Tab Clicking Options
   guid_list['{bea6d1a7-882d-425f-bc75-944e0063ff3b}'] = true;    //   Tab Mix [original one]
   guid_list['tabtowindow@sogame.cat'] = true;                    //   Tab to window
   guid_list['tabx@clav.mozdev.org'] = true;                      //   Tab X
   guid_list['{0b0b0da8-08ba-4bc6-987c-6bc9f4d8a81e}'] = true;    //   Tabbrowser Extensions
   guid_list['{9b9d2aaa-ae26-4447-a7a1-633a32b19ddd}'] = true;    //   Tabbrowser Preferences
   guid_list['tabdrag'] = true;                                   //   tabdrag-for-tablib
   guid_list['tabfx@chaosware.net'] = true;                       //   TabFX
   guid_list['tabsopenrelative@jomel.me.uk'] = true;              //   Tabs open ralative
   guid_list['tablib'] = true;                                    //   tablib
   guid_list['{328bbe91-cb86-40b0-a3fd-2b39969f9faa}'] = true;    //   Undo Close Tab
   guid_list['undoclosetab@dorando'] = true;                      //   Undo Close Tab
   guid_list['{99ec6690-8bb1-11da-a72b-0800200c9a66}'] = true;    //   Unread Tabs

   function prop(elm, str) {
      var arc = RDFService.GetResource("http://www.mozilla.org/2004/em-rdf#" + str);
      var target = extensionDS.GetTarget(elm, arc, true);
      if (target instanceof Components.interfaces.nsIRDFLiteral ||
              target instanceof Components.interfaces.nsIRDFInt)
         return target.Value;
      return null;
   }

   var RDFService = Components.classes["@mozilla.org/rdf/rdf-service;1"]
               .getService(Components.interfaces.nsIRDFService);
   var Container = Components.classes["@mozilla.org/rdf/container;1"]
               .getService(Components.interfaces.nsIRDFContainer);
   var extensionDS = Components.classes["@mozilla.org/extensions/manager;1"]
               .getService(Components.interfaces.nsIExtensionManager).datasource;
   var root = "urn:mozilla:item:";

   try { // in ff 1.0.x we can get error at startup
      Container.Init(extensionDS, RDFService.GetResource(root + "root"));
   } catch (e) {
      tmLog("error in getExtensions " + e);
      return [];
   }

   var elements = Container.GetElements();
   var extensionsArray = [];

   while (elements.hasMoreElements()) {
      var element=elements.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
      var id = element.Value.replace(root, "");
      if (typeof guid_list[id.toLowerCase()] != "undefined") {
         var opType = prop(element, "opType");
         var disabled = prop(element, "userDisabled");
         if ((!disabled && opType != "needs-disable" && opType != "needs-uninstall") ||
             ( disabled && opType == "needs-enable")) {
            var name = prop(element, "name");
            name = name.charAt(0).toUpperCase() + name.substr(1);
            extensionsArray.push({_name: name, _guid: id, _version:prop(element, "version")});
         }
      }
   }
   return extensionsArray;
}

var TMP_eventListener = {
  init: function TMP_EL_init(aTabContainer) {
    window.addEventListener("load", this, false);

   /*
    * Session Manager extesion add tabs too soon for us to check isTabVisible properly
    * we get wrong scrollstatus at startup
    * we add flag to use in tabBrowser.mTabContainer.isTabVisible
    */
    aTabContainer.setAttribute("SM_restart", true);

    // add event for update tab when restoring from nsSessionStore
    aTabContainer.addEventListener("SSTabRestoring", this, true);

    aTabContainer.addEventListener("TabOpen", this, true);

    aTabContainer.addEventListener("TabClose", this, true);

    aTabContainer.addEventListener("TabSelect", this, true);

    // add event for mouse scrolling on tab bar, necessary for linux
    aTabContainer.addEventListener("DOMMouseScroll", this, false);
    if (/^Linux/.test(navigator.platform))
       document.getElementById("navigator-toolbox").addEventListener("DOMMouseScroll", this, false);
  },

  handleEvent: function TMP_EL_handleEvent(aEvent) {
    switch (aEvent.type) {
      case "SSTabRestoring":
        this.onSSTabRestoring(aEvent);
        break;
      case "TabOpen":
        this.onTabOpen(aEvent);
        break;
      case "TabClose":
        this.onTabClose(aEvent);
        break;
      case "TabSelect":
        this.onTabSelect(aEvent);
        break;
      case "DOMMouseScroll":
        this.onTabBarScroll(aEvent);
        break;
      case "load":
        this.onWindowOpen(aEvent);
        break;
      case "unload":
        this.onWindowClose(aEvent);
        break;
    }
  },

  onWindowOpen: function TMP_EL_onWindowOpen() {
    window.removeEventListener("load", this, false);
    window.addEventListener("unload", this, false);

    // don't load tabmix into undock sidebar opened by ezsidebar extension
    var wintype = window.document.documentElement.getAttribute("windowtype");
    if (wintype == "mozilla:sidebar") return;

    // replace old Settings.
    // we must call this befor any other tabmix function
    gTMPprefObserver.updateSettings();

    // init tabmix functions
    tablib.init();
    TM_init();
    TMP_LastTab.init();
    TMP_TBP_init();
    TMP_DragAndDrop_init();

    //this window open form duplicateInWindow or_restoreTab
    if (window.duplicat)
      NW_waitForSessionHistory();

    var tabBar = gBrowser.mTabContainer;

    // fix bug in new tab button on right when we use multi row
    if ("newTabButtons" in window) {
      var newbuttonRight = document.getAnonymousElementByAttribute(tabBar, "id", "tabs-newbutton-right");
      var newbuttonEnd = document.getAnonymousElementByAttribute(tabBar, "id", "tabs-newbutton-end");
      if (newbuttonRight && newbuttonEnd)
         newbuttonEnd.parentNode.insertBefore(newbuttonRight, newbuttonEnd);
    }

   /*
    * Session Manager extesion add tabs too soon for us to check isTabVisible properly
    * we get wrong scrollstatus at startup
    * we add flag to use in tabBrowser.mTabContainer.isTabVisible
    */
    if ("gSessionManager" in window) {
      var ss = Cc["@mozilla.org/browser/sessionstartup;1"].getService(Ci.nsISessionStartup);
      if (ss.doRestore())
        setTimeout(function (_tabBar) { _tabBar.removeAttribute("SM_restart"); }, 0, tabBar);
    }
    else
      tabBar.removeAttribute("SM_restart");

    if (/^Mac/.test(navigator.platform))
      tabBar.setAttribute("Mac", "true");

    var skin = gPref.getCharPref("general.skins.selectedSkin");
    if (skin=="classic/1.0") {
      gFirefox2DefaultTheme = !gIsFirefox3;
      if (/^Mac/.test(navigator.platform))
        tabBar.setAttribute("classic", gIsFirefox3 ? "v3Mac" : "v2Mac");
      else if (/^Linux/.test(navigator.platform)) {
        tabBar.setAttribute("classic", gIsFirefox3 ? "v3Linux" : "v2");
        if (gIsFirefox3)
          tabBar.setAttribute("platform", "linux");
      }
      else {
        tabBar.setAttribute("classic", gIsFirefox3 ? "v3" : "v2");
        tabBar.setAttribute("platform", "xp");
      }
    }

    if (gIsFirefox31)
       tabBar.setAttribute("platform", "v31");

    // for new tab icon on context menu
    TMP_setItem("context_newTab", "platform", tabBar.getAttribute("platform"));

    // adjust attribute when we close 2nd tab (we left with only one) or when we open 2nd tab
    if (numberOfWindows() > 1)
      adjustOn2ndTab.closeButton(1);

    if (gSingleWindowMode)
      gTMPprefObserver.setSingleWindowUI();

    gTMPprefObserver.setMenuIcons();
    gTMPprefObserver.toggleKey("key_tm_slideShow", "extensions.tabmix.disableF8Key");
    gTMPprefObserver.toggleKey("key_tm_toggleFLST", "extensions.tabmix.disableF9Key");
    gTMPprefObserver.createColorRules();
    gTMPprefObserver.tabCloseButton();
    if (!tabxPrefs.getBoolPref("newTabButton.leftside"))
      gTMPprefObserver.changeNewTabButtonSide(false);
    TMP_ClosedTabs.setButtonType(tabxPrefs.getBoolPref("undoCloseButton.menuonly"));

    gHideTabBar = tabxPrefs.getIntPref("hideTabbar");
   /*
    *  In the first time TMP is running we need to match extensions.tabmix.hideTabbar to browser.tabs.autoHide.
    *  extensions.tabmix.hideTabbar default is 1 "Hide tabbar when i have only one tab"
    *  if browser.tabs.autoHide is false we need to make sure extensions.tabmix.hideTabbar is set to 0 "Never Hide tabbar:
    */
    if (!gPref.getBoolPref("browser.tabs.autoHide") && gHideTabBar == 1) {
      gHideTabBar = 0;
      tabxPrefs.setIntPref("hideTabbar", gHideTabBar);
    }
    else
      gTMPprefObserver.setAutoHidePref();

    window.setTimeout(function () {
      // initialize the value of "gTabBarWidth"
      gTabBarWidth = gBrowser.mTabContainer.boxObject.width;
      // only hide the tabbar after we catch the width
      if (gHideTabBar == 2)
        gBrowser.mStrip.collapsed = true;
    }, 100);

    gTabbarPosition = TMP_getIntPref (tabxBranch, "tabBarPosition", 0);

    // In XP default theme alltabs-button is the highest object in the tab strip
    // we need a place-holder for the height in case the user hide alltabs-buttin
    if (gIsFirefox3)
      document.getElementById("alltabs-place-holder").setAttribute("height", tabBar.mAllTabsButton.parentNode.boxObject.height);

    // update icons if needed
    TMupdateSettings(true); // xxx we need diff function that call one on new window(s) and one for pref changed
  },

  onSSTabRestoring: function TMP_EL_onSSTabRestoring(aEvent) {
    var aTab = aEvent.target;
    if (aTab.hasAttribute("_locked")) {
      if (aTab.getAttribute("_locked") == "true")
        aTab.setAttribute("locked", "true");
      else
        aTab.removeAttribute("locked");
    }

    // this function run befor tab load, so onTabReloaded will run when onStateChange get STATE_STOP
    var reloadData = aTab.getAttribute("reload-data");
    if (reloadData) {
      reloadData = reloadData.split(" ");
      setupAutoReload(aTab);
      aTab.autoReloadEnabled = true;
      aTab.autoReloadURI = reloadData[0];
      aTab.autoReloadTime = reloadData[1];
    }
  },

  // Function to catch when new tabs are created and update tab icons if needed
  // In addition clicks and doubleclick events are trapped.
  onTabOpen: function TMP_EL_onTabOpen(aEvent) {
    var aTab = aEvent.target;

    // adjust attribute when we close 2nd tab (we left with only one) or when we open 2nd tab
    adjustOn2ndTab.closeButton(1);

    var showCloseButton = tabxPrefs.getBoolPref("tabXMode.enable");
    if (showCloseButton) {
      var closeButtonOptions = ["no-button","always","showhover","current","current_hover","always"];
      aTab.setAttribute("tabx", closeButtonOptions[addtabx]);
    }
    else
      aTab.removeAttribute("tabx");

    if (tabxleft)
      aTab.setAttribute("tabxleft", "on");
    else
      aTab.removeAttribute("tabxleft");

    if ( alwaysNewTab == 1 )
      aTab.setAttribute("locked", "true");

    //XXX underline the label bleed over the end when tab is to small and we have close button on the tab !!!!????
    if (!gBrowser.mTabContainer.hasAttribute("hideunderline") && !gBrowser.mTabContainer._timeout) {
      gBrowser.mTabContainer._timeout = window.setTimeout( function(tabBar) {
        toggleUderlineTabsLabel();
        if (tabBar._timeout) {
          clearTimeout(tabBar._timeout);
          tabBar._timeout = null;
        }
      }, 50, gBrowser.mTabContainer);
    }

    if (gBrowser.mTabContainer.getAttribute("multibar") != "scrollbar")
      tabBarScrollStatus();
    checkBeforeAndAfter();

    // if the current Browser has SafeBrowsing problem and message is showing we need to
    // repaint the "safebrowsing-dim-area-canvas"
    adjustSafebrowsingDimArea();

    // the hack in TreeStyleTab extension look for our tabxTabAdded function
    // we remove tabxTabAdded function and use TMP_eventListener.onTabOpen from 0.3.7pre.080815
    if ("TreeStyleTabBrowser" in window && gBrowser.treeStyleTab) {
      gBrowser.treeStyleTab.initTabAttributes(aTab);
      gBrowser.treeStyleTab.initTabContentsOrder(aTab);
    }
  },

  onTabClose: function TMP_EL_onTabClose(aEvent) {
    // aTab is the tab we are closing now
    var aTab = aEvent.target;

    var tabs = gBrowser.mTabContainer.childNodes;
    var tabBar = gBrowser.mTabContainer;

    if (aTab.getAttribute("image") != gBrowser.getBrowserForTab(aTab).mIconURL)
      aTab.setAttribute("image", gBrowser.getBrowserForTab(aTab).mIconURL);

    if (aTab.label == gBrowser.mStringBundle.getString("tabs.loading"))
      gBrowser.setTabTitle(aTab);

    // adjust attribute when we close 2nd tab
    adjustOn2ndTab.closeButton(2, aTab);

    // if the current Browser has SafeBrowsing problem and message is showing we need to
    // repaint the "safebrowsing-dim-area-canvas"
    window.setTimeout(adjustSafebrowsingDimArea, 0);

    // Update "last-tab" attribute
    var lastTab = tabBar.lastChild;
    if (aTab == lastTab && lastTab.previousSibling)
      lastTab.previousSibling.setAttribute("last-tab", "true");

    // if we close the 2nd tab and browser.tabs.autoHide is true reset all scroll and multi-row parameter
    // strip already collapsed at this point
    if (tabs.length == 2 && gPref.getBoolPref("browser.tabs.autoHide")) {
      gBrowser.mTabContainer.collapsedTabs = 0;
      setTabBarHeight(false);
      tabBar.removeAttribute("multibar");
    }

    if ( tabscroll != 2 ) {
      var _canScrollTabsLeft = tabBar.canScrollTabsLeft;
      var _canScrollTabsRight = tabBar.canScrollTabsRight;
      tabBar.collapsedTabs--;
      if (!_canScrollTabsLeft)
        tabBar.canScrollTabsLeft = false;
      if (!_canScrollTabsRight)
        tabBar.canScrollTabsRight = false;

      window.setTimeout( function() {
                           tabBar.adjustScrollTabsLeft();
                           tabBar.adjustScrollTabsRight();
                         }, 50 );
    }
    else {
      window.setTimeout( function(removeCollapsedTab) {
        if (removeCollapsedTab)
          tabBar.collapsedTabs--;
        else if ( tabBar.getAttribute("multibar") == "scrollbar" && tabBar.collapsedTabs > 0) {
          if ((tabBar.lastChild.baseY + tabBar.lastChild.boxObject.height/2) < (tabBar.boxObject.y + tabBar.boxObject.height)) {
            tabBar.rowScroll(-1);
          }
        }
        if (tabBar.hasAttribute("multibar"))
          tabBarScrollStatus();
        checkBeforeAndAfter();
      }, 0, aTab._tPos < tabBar.collapsedTabs);
    }

    //XXX underline the label bleed over the end when tab is to small and we have close button on the tab !!!!????
    if (tabBar.hasAttribute("hideunderline"))
      window.setTimeout( function() {toggleUderlineTabsLabel();}, 50);

  },

  onTabSelect: function TMP_EL_TabSelect(aEvent) {
    var tab = aEvent.target;
    var tabBar = gBrowser.mTabContainer;
    // update this functions after new tab select
    tabBar.nextTab = 1;
    tab.setAttribute("flst_id", new Date().getTime());
    TMP_LastTab.OnSelect();
    SessionManager.tabSelected(true);

    var prev = tab.previousSibling, next = tab.nextSibling;
    if ( prev && !inSameRow(prev, tab) )
      prev.removeAttribute("beforeselected");
    if ( next && !inSameRow(next, tab) )
      next.removeAttribute("afterselected");
  },

  onTabBarScroll: function TMP_EL_onTabBarScroll(aEvent) {
    var tabBar = gBrowser.mTabContainer;

    for (var i = 0; i < tabBar.childNodes.length; i++)
      tabBar.childNodes[i].setAttribute("showbutton","off");

    var ScrollDirection = aEvent.detail > 0 ? 1 : -1;
      if (gPref.getBoolPref("extensions.tabmix.reversedScroll"))
        ScrollDirection = -1 * ScrollDirection;

    var shouldMoveFocus = gPref.getBoolPref("extensions.tabmix.enableScrollSwitch");
    if (shouldMoveFocus) {
      tabBar.advanceSelectedTab(ScrollDirection, true);
    }
    else if ("TreeStyleTabBrowser" in window) {
       return;
    }
    else if ( tabscroll != 2 )
      tabBar.collapsedTabs += ScrollDirection;
    else if ( tabscroll == 2 )
      tabBar.rowScroll(ScrollDirection);

    aEvent.stopPropagation();
    aEvent.preventDefault();
  },

  onWindowClose: function TMP_EL_onWindowClose() {
    window.removeEventListener("unload", this, false);

    gBrowser.mTabDropIndicatorBar.removeEventListener('dragover', TMP_TabDragOver, true);
    gBrowser.mTabDropIndicatorBar.removeEventListener('dragdrop', TMP_TabDragDrop, true);

    if (gIsFirefox3)
      document.getElementById("goPopup").removeEventListener("popupshowing", TMP_Places.historyMenuItemsTitle, false);

    // check if we need to sanitize on exit without prompt to user
    var isLastWindow = numberOfWindows() == 0;
    try {
      // if tryToSanitize is false and privacy.sanitize.promptOnSanitize is true
      // we call TMP_Sanitizer.sanitize from Firefox Sanitizer
      var tabmixSanitized = isLastWindow && gPref.getBoolPref("privacy.sanitize.sanitizeOnShutdown") && TMP_Sanitizer.tryToSanitize();
    }
    catch (ex) {
      tabmixSanitized = false;
    }
    if (!tabmixSanitized) {
      SessionManager.deinit(isLastWindow, false);
      SessionManager.windowIsClosing(true, isLastWindow, true, false);
    }

    document.getElementById("contentAreaContextMenu").removeEventListener("popupshowing", TM_checkContentMenu, false);
    var tabContextMenu = gBrowser.mStrip.firstChild.nextSibling;
    tabContextMenu.removeEventListener("popupshowing", Tm_checkTabClick, false);
    tabContextMenu.removeEventListener("popupshown", TMP_tabContextMenuShown, false);

    TMP_LastTab.deinit();

    gBrowser.mTabContainer.removeEventListener("SSTabRestoring", this, true);
    gBrowser.mTabContainer.removeEventListener("TabOpen", this, true);
    gBrowser.mTabContainer.removeEventListener("TabClose", this, true);
    gBrowser.mTabContainer.removeEventListener("TabSelect", this, true);
    gBrowser.mTabContainer.removeEventListener("DOMMouseScroll", this, false);
    if (/^Linux/.test(navigator.platform))
      document.getElementById("navigator-toolbox").removeEventListener("DOMMouseScroll", this, false);

    // TreeStyleTab extension add this to be compatible with old tabmix version
    // we call removeEventListener again here in case user close the window without opening new tabs
    if ("TreeStyleTabBrowser" in window)
      gBrowser.mTabContainer.removeEventListener('DOMNodeInserted', tabxTabAdded, true);

    gTMPprefObserver.removeObserver();
  }

}

/* for treeStyleTab extension look in treeStyleTab hacks.js
   we remove tabxTabAdded function and use TMP_eventListener.onTabOpen from 0.3.7pre.080815
*/
function tabxTabAdded() {
  // remove eventListener added by treeStyleTab on first call to tabxTabAdded
  gBrowser.mTabContainer.removeEventListener('DOMNodeInserted', tabxTabAdded, true);
  return;
}
