function Flagfox_handleClick(event)
{
    if (flagState.country == null) // Local file or unknown site
    {
        if (event.button == 2)  // No menu on right-click; show options instead
            Flagfox_handleAction("Options");
        return;  // No IP, so no links
    }

    switch (event.button)
    {
        case 0:
            if (!event.ctrlKey)
            {
                Flagfox_handleAction("Geotool");
                return;
            } // else fallthrough; ctrl+click == middle-click
        case 1:
            Flagfox_handleAction(FFpreferences.getCharPref("flagfox.middleclick"));
            return;
        // Button 2 shows popup menu via context attribute
    }
}

function Flagfox_handleAction(action)
{
    switch (action)
    {
        case "Geotool":
            // Geotool figures out the locale from the HTTP header
            // We send ip and host in case Geotool resolves to a different server, based on its different location
            Flagfox_openLink("http://geotool.servehttp.com/?ip=" + flagState.ip + "&host=" + flagState.host);
            return;

        case "Wikipedia":
            var wiki;
            switch (flagState.country[0])
            {
                case '-A':  case '-B':  case '-C':
                    wiki = "RFC 1918";
                    break;
                default:  // For 'A1', 'A2', and '-L' flagState.country[1] == translated range description
                    wiki = flagState.country[1];
                    break;
            }
            var language = FFpreferences.getCharPref("general.useragent.locale").substr(0,2);
            // We do a search here, just in case the exact page doesn't exist or there is no localized version
            Flagfox_openLink("http://" + language + ".wikipedia.org/wiki/Special:Search?search=" + wiki + "&go=Go");
            return;

        case "Whois":
            // DomainTools can parse TLD correctly, as well as full domain names
            Flagfox_openLink("http://whois.domaintools.com/" + flagState.host);
            return;

        case "CopyIP":
            const clipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"]
                                              .getService(Components.interfaces.nsIClipboardHelper);
            clipboardHelper.copyString(flagState.ip);
            return;

        case "Options":
            window.openDialog("chrome://flagfox/content/options.xul",
                              "FlagfoxOptions", "chrome,dialog,centerscreen");
            return;

        case "Nothing":
            return;  // Set "flagfox.middleclick" to this to disable that feature

        default:
            alert("Invalid Flagfox action attempted:\n" + action);
            return;
    }
}

function Flagfox_openLink(url)
{
    var tabPrefs = FFpreferences.getCharPref("flagfox.openlinksin");

    if (tabPrefs == "tabBG" || tabPrefs == "tabFG")
    {
        var newTab = window.getBrowser().addTab(url,null,null);
        if (tabPrefs == "tabFG")
            window.getBrowser().selectedTab = newTab;
    }
    else if (tabPrefs == "currentTab")
    {
        window.content.document.location = url;
    }
    else  // "winBG" || "winFG"
    {
        var newWindow = window.open(url,"_blank");
        if (tabPrefs == "winBG")
        {
            newWindow.blur();
            window.focus();
        }
    }
}
