var FFpreferences = null;

var flagfoxstrings = null; // localized strings
var countrynames = null;   // localized country names

var FlagfoxPollLoopID;

function Flagfox_startup()
{
    try
    {
        countrynames = document.getElementById("flagfox-countrynames");
        if (!countrynames || !countrynames.strings.hasMoreElements())
            throw "Could not load country names";

        flagfoxstrings = document.getElementById("flagfox-localizedstrings");
        if (!flagfoxstrings || !flagfoxstrings.strings.hasMoreElements())
            throw "Could not load localized strings";

        flagState.icon = document.getElementById("flagfox-icon");
        if (!flagState.icon)
            throw "Could not find Flagfox icon";

        FFpreferences = Components.classes["@mozilla.org/preferences-service;1"]
                                  .getService(Components.interfaces.nsIPrefBranch);

        Flagfox_loadIPDB();               // Load IPDB from "profileDir/extensionDir/db.dat"
        Flagfox_dnsHandler.init();        // Fetch the services we need for DNS
        Flagfox_cleanupOldPrefs();        // Clear any pref entries from old versions
        Flagfox_setIconPos();             // Place flag icon in the status bar
        Flagfox_prefObserver.register();  // Listen for preferences changes
    }
    catch(e)
    {
        alert("Flagfox failed to load!\n" + e);
        Components.utils.reportError(e);
        Flagfox_shutdown();
        window.removeEventListener("unload", Flagfox_shutdown, false);
        return;
    }

    // Start polling loop
    FlagfoxPollLoopID = setInterval(Flagfox_pollWindowURL, 250);
}

function Flagfox_shutdown()
{
    clearInterval(FlagfoxPollLoopID);
    Flagfox_prefObserver.unregister();
    Flagfox_closeIPDB();
}

var flagState =
{
    url : "init",
    host : "",
    ip : "",
    country : null,
    icon : null,

    newURL : function(newurl)
    {
        this.url = newurl;
        this.host = "";
        this.ip = "";
        this.country = null;
    },

    toString : function()
    {
        var server;
        if (this.host != this.ip)
        {
            switch (textdirection)  // via global.dtd
            {
                default:
                case "ltr":
                    server = this.host + " (" + this.ip + ")";
                    break;
                case "rtl":
                    server = "(" + this.ip + ") " + this.host;  // Can't do "host (ip)" as that turns into "(host (ip"...
                    break;  // This outputs as "host (ip)"; there is no way to output "(ip) host" in RTL locales.
            }
        }
        else
        {
            server = this.ip;  // No hostname; only IP
        }
        return flagfoxstrings.getFormattedString( "tooltip", [server,this.country[1]] );
    }
};

var Flagfox_prefObserver =
{
    branch : null,  // the pref branch we're observing

    register : function()
    {
        var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                                    .getService(Components.interfaces.nsIPrefService);

        this.branch = prefService.getBranch("flagfox.");
        this.branch.QueryInterface(Components.interfaces.nsIPrefBranch2);
        this.branch.addObserver("", this, false);
    },

    unregister : function()
    {
        if (this.branch)
            this.branch.removeObserver("", this);
    },

    observe : function(aSubject, aTopic, aData)
    {
        if  (aTopic != "nsPref:changed") return;
        switch (aData)
        {
            case "usealticons":
                Flagfox_setIconSrc();
                break;
            case "iconposition":
                Flagfox_setIconPos();
                break;
        }
    }
};

function Flagfox_setIconPos()
{
    try
    {
        var statusbar = document.getElementById("status-bar");
        var flagbox = document.getElementById("flagfox-statusbarpanel");
        var element;
        switch (FFpreferences.getCharPref("flagfox.iconposition"))  // Positions reversed in right-to-left locales
        {
            case "L":
                element = document.getElementById("statusbar-display");
                break;
            case "R":
                element = document.getElementById("statusbar-progresspanel").nextSibling;
                break;
            case "RM":
                element = statusbar.lastChild.nextSibling;  // Before after last == after  ;)
                break;
            default:
                throw "Invalid Flagfox icon position";
        }
        statusbar.insertBefore(flagbox,element);  // There is no insertAfter()
    }
    catch(e) { alert("Error setting Flagfox icon position:\n" + e); }
}

function Flagfox_setIconSrc()
{
    if (flagState.country == null)
        return;  // Flag is for local file or unknown site; no alt-style, so just leave as-is

    flagState.icon.src = "chrome://flagfox/content/country"
                         + (FFpreferences.getBoolPref("flagfox.usealticons") ? "_alt/" : "/")
                         + flagState.country[0].toLowerCase()
                         + ".png";
}

function Flagfox_pollWindowURL()
{
    try
    {
        if (flagState.url != window.content.document.URL)
        {
            flagState.newURL(window.content.document.URL);

            switch (window.content.document.location.protocol)
            {
                case "file:":  case "about:":  case "chrome:":  case "resource:":
                    // Don't bother with icon style; exact same file is used for both
                    flagState.icon.src = "chrome://flagfox/content/country/-l.png";
                    flagState.icon.tooltipText = flagfoxstrings.getString("localfile");
                    return;  // Done

                default:
                    flagState.icon.src = "chrome://flagfox/content/unknown.png";
                    flagState.icon.tooltipText = flagfoxstrings.getString("unknownsite");
                    break;  // Consider unknown until we can look it up
            }

            if (Flagfox_proxyCheck())
            {
                flagState.icon.tooltipText += " (" + countrynames.getString("A1") + ")";  // correct in LTR & RTL
                return;  // Proxy in use; can't do a DNS lookup
            }

            flagState.host = window.content.document.location.hostname;
            flagState.host = flagState.host.cropTrailingChar(".");  // Get rid of root dot, if it's there
            if (flagState.host == "")
                return;

            // Idealy just hitting the DNS cache here
            Flagfox_dnsHandler.resolveHost();
        }
    }
    catch (e) { Components.utils.reportError("FLAGFOX ERROR: " + e); }
}

var Flagfox_dnsHandler =
{
    dns : null,     // DNS service
    thread : null,  // this thread; onLookupComplete() must be called in this thread

    init : function()
    {
        this.dns = Components.classes["@mozilla.org/network/dns-service;1"]
                             .getService(Components.interfaces.nsIDNSService);

        var EQS = Components.classes["@mozilla.org/event-queue-service;1"];
        if (EQS)  // Firefox 1.5 - 2.0
        {
            EQS = EQS.getService(Components.interfaces.nsIEventQueueService);
            this.thread = EQS.getSpecialEventQueue(EQS.CURRENT_THREAD_EVENT_QUEUE);
        }
        else      // Firefox 3.0+
        {
            this.thread = Components.classes["@mozilla.org/thread-manager;1"]
                                    .getService().currentThread;
        }
        if (!this.thread)
            throw "Could not fetch current thread for DNS handler";
    },

    resolveHost : function()
    {
        this.dns.asyncResolve(flagState.host, 0, this, this.thread);
    },

    onLookupComplete : function(request, nsrecord, status)
    {
        if (status != 0 || !nsrecord || !nsrecord.hasMore())
            return;  // IP not found in DNS  (status=0x804B001E for DNS resolution fail)

        flagState.ip = nsrecord.getNextAddrAsString();
        flagState.country = Flagfox_lookupIP(flagState.ip);
        if (flagState.country == null)
            return;  // IP is not in DB

        // Set the image
        Flagfox_setIconSrc();
        // Set the tooltip
        flagState.icon.tooltipText = flagState.toString();
    }
};

function Flagfox_proxyCheck()  // Return true to abort DNS hit (false allows local DNS request if not cached)
{
    switch (FFpreferences.getIntPref("flagfox.dnswithproxy"))
    {
        case -1:  // Deny
            return Flagfox_proxyDetect();

        default:  // Error
            FFpreferences.setIntPref("flagfox.dnswithproxy",0);
            // Reset and fallthrough to prompt

        case 0:   // Prompt
            if (Flagfox_proxyDetect())
            {
                const prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                          .getService(Components.interfaces.nsIPromptService);
                const flags = prompts.BUTTON_POS_0 * prompts.BUTTON_TITLE_YES +
                              prompts.BUTTON_POS_1 * prompts.BUTTON_TITLE_NO +
                              prompts.BUTTON_POS_1_DEFAULT +
                              prompts.BUTTON_DELAY_ENABLE;  // Stays greyed out for a moment to force users to think
                var check = {value: false};  // Default the checkbox to false
                var allow = prompts.confirmEx( null,
                                               flagfoxstrings.getString("proxyprompttitle"),
                                               flagfoxstrings.getString("proxypromptmessge"),
                                               flags,
                                               "", "", "",
                                               flagfoxstrings.getString("proxypromptchecklabel"),
                                               check ) == 0;
                if (check.value)
                    FFpreferences.setIntPref( "flagfox.dnswithproxy", allow?1:-1 );
                return !allow;
            }
            // else fallthrough and allow

        case 1:   // Allow
            return false;
    }
}

function Flagfox_proxyDetect()
{
    if (FFpreferences.getIntPref("network.proxy.type") == 0)
        return false;  // No proxy; normal operation; we'll find the IP in the DNS cache

    // There ~is~ a remote DNS over SOCKS feature, but dns.resolve() doesn't use it, it seems...
    if (FFpreferences.getCharPref("network.proxy.socks") != "")
        return true;  // Anything can use a SOCKS proxy

    switch (window.content.document.location.protocol)
    {
        case "http:":
            return (FFpreferences.getCharPref("network.proxy.http") != "");
        case "https:":
            return (FFpreferences.getCharPref("network.proxy.ssl") != "");
        case "ftp:":
            return (FFpreferences.getCharPref("network.proxy.ftp") != "");
        case "gopher:":
            return (FFpreferences.getCharPref("network.proxy.gopher") != "");
        default:
            return false;  // Unknown protocol, nonetheless, there's no proxy
    }
}

function Flagfox_cleanupOldPrefs()
{
    const OLD_PREFS = ["flagsPrefs","posPrefs","linkPrefs","tabPrefs","allowdnslookup"];
    for (var p in OLD_PREFS)
    {
        var entry = "flagfox." + OLD_PREFS[p];
        if (FFpreferences.getPrefType(entry) != 0)
            FFpreferences.clearUserPref(entry);
    }
}

String.prototype.cropTrailingChar = function(character)
{
    return (this.charAt(this.length-1)==character) ? this.slice(0,this.length-1) : this.valueOf();
};
