var FFpreferences = null;

function init()
{
    try
    {
        FFpreferences = Components.classes["@mozilla.org/preferences-service;1"]
                                  .getService(Components.interfaces.nsIPrefBranch);

        if (FFpreferences.getIntPref("flagfox.dnswithproxy") != 0)  // Only show "reset proxy prompt" link when it can be reset
            document.getElementById("resetDNSprefLink").hidden = false;

        document.getElementById("flagSetCheckbox").checked = FFpreferences.getBoolPref("flagfox.usealticons");
        document.getElementById("iconPositionRadiogroup").selectedItem = document.getElementById(FFpreferences.getCharPref("flagfox.iconposition"));
        document.getElementById("middleclickMenulist").selectedItem = document.getElementById(FFpreferences.getCharPref("flagfox.middleclick"));
        document.getElementById("openLinksInMenulist").selectedItem = document.getElementById(FFpreferences.getCharPref("flagfox.openlinksin"));
    }
    catch (e) { alert("Error loading Flagfox options window:\n" + e); }
}

// Flagfox_prefObserver should be listening, so icon appearance changes should apply immediately
function apply()
{
    try
    {
        FFpreferences.setBoolPref("flagfox.usealticons", document.getElementById("flagSetCheckbox").checked);
        FFpreferences.setCharPref("flagfox.iconposition", document.getElementById("iconPositionRadiogroup").selectedItem.id);
        FFpreferences.setCharPref("flagfox.middleclick", document.getElementById("middleclickMenulist").selectedItem.id);
        FFpreferences.setCharPref("flagfox.openlinksin", document.getElementById("openLinksInMenulist").selectedItem.id);
    }
    catch (e) { alert("Error saving Flagfox options:\n" + e); }
}

function resetDNSpref()
{
    try
    {
        FFpreferences.setIntPref("flagfox.dnswithproxy",0);
        document.getElementById("resetDNSprefLink").hidden = true;
    }
    catch (e) { alert("Error resetting Flagfox DNS prompt:\n" + e); }
}

function preview()
{
    window.openDialog("chrome://flagfox/content/preview.xul",
                      "FlagfoxIconsPreview", "chrome,dialog,centerscreen,modal");
}
