/***** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Original Code is "Plain Text To Link".
   -
   - The Initial Developer of the Original Code is Tommaso Beniero.
   - Portions created by the Initial Developer are Copyright (C) 2005 Tommaso Beniero.  
   - All Rights Reserved.
   -
   - Contributor(s): Tommaso Beniero <tommaso DOT beniero AT gmail DOT com>
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - 
***** END LICENSE BLOCK *****/

var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("pttl.");

// this function load the parameters

function pttlPrefLoad() {
	
    var selRadio = prefs.getIntPref("open-type");
   	var radGroup = document.getElementById("openTypeRadioGroup");
    
    try{
     document.getElementById("dir-text").value = prefs.getCharPref("save-directory-default");
    }catch(ex){document.getElementById("dir-text").value = "";}

	document.getElementById("ext-text").value = prefs.getCharPref("save-extension-default");
    document.getElementById("def-open").checked = prefs.getBoolPref("menu-def-open");
    document.getElementById("def-save").checked = prefs.getBoolPref("menu-def-save");
    document.getElementById("save-enc").checked = prefs.getBoolPref("save-with-UTF8");
	document.getElementById("add-bookmark").checked = prefs.getBoolPref("menu-add-bookmark");
   	document.getElementById("send-mail-to").checked = prefs.getBoolPref("menu-send-mail-to");
   	document.getElementById("send-text-to").checked = prefs.getBoolPref("menu-send-text-to");
   	document.getElementById("search-groups-win").checked = prefs.getBoolPref("menu-search-groups-win");
    document.getElementById("search-groups-tab").checked = prefs.getBoolPref("menu-search-groups-tab");
   	document.getElementById("translate").checked = prefs.getBoolPref("menu-translate");
   	document.getElementById("save-in-file").checked = prefs.getBoolPref("menu-save-in-file");
   	document.getElementById("append").checked = prefs.getBoolPref("menu-append");
   	document.getElementById("complete-menu").checked = prefs.getBoolPref("menu-complete-menu");
             
    switch(selRadio){
    	case 1: 	{
     		radGroup.selectedIndex = 1;
               break;
     		}
    	case 2: 	{
     		radGroup.selectedIndex = 2;
               break;
     		}
		case 3: 	{
     		radGroup.selectedIndex = 3;
               break;
     		}               
     default:  {
     		radGroup.selectedIndex = 0;
     		break;     
     		}
    }
        
}

// this function allows to select a default directory for saved file

function pttlSelectDir() {

	var filePick = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
  	var saveDir = null;
  	filePick.init(window, title, Components.interfaces.nsIFilePicker.modeGetFolder);
  	filePick.appendFilters(Components.interfaces.nsIFilePicker.filterAll);
  	if (filePick.show()==Components.interfaces.nsIFilePicker.returnOK) {
    	saveDir=filePick.file.QueryInterface(Components.interfaces.nsILocalFile);
		// set preference for default saves directory
		prefs.setCharPref("save-directory-default", saveDir.path);
    	document.getElementById("dir-text").value=saveDir.path;
  	}
  
} 

// this function save all the preferences in the Preferences window (pttlOptions.xul)

function pttlAcceptPrefs() {
	
   	// set preference for default open action

	prefs.setIntPref("open-type", document.getElementById("openTypeRadioGroup").selectedIndex);
    prefs.setCharPref("save-extension-default", document.getElementById("ext-text").value);
	prefs.setBoolPref("menu-def-open", document.getElementById("def-open").checked);
    prefs.setBoolPref("menu-def-save", document.getElementById("def-save").checked);
    prefs.setBoolPref("save-with-UTF8", document.getElementById("save-enc").checked);
    prefs.setBoolPref("menu-add-bookmark", document.getElementById("add-bookmark").checked);
    prefs.setBoolPref("menu-send-mail-to", document.getElementById("send-mail-to").checked);
    prefs.setBoolPref("menu-send-text-to", document.getElementById("send-text-to").checked);
    prefs.setBoolPref("menu-search-groups-win", document.getElementById("search-groups-win").checked);
    prefs.setBoolPref("menu-search-groups-tab", document.getElementById("search-groups-tab").checked);
    prefs.setBoolPref("menu-translate", document.getElementById("translate").checked);
    prefs.setBoolPref("menu-save-in-file", document.getElementById("save-in-file").checked);
    prefs.setBoolPref("menu-append", document.getElementById("append").checked);
    prefs.setBoolPref("menu-complete-menu", document.getElementById("complete-menu").checked);    
	window.close();
    
}