/***** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Original Code is "Plain Text To Link".
   -
   - The Initial Developer of the Original Code is Tommaso Beniero.
   - Portions created by the Initial Developer are Copyright (C) 2005 Tommaso Beniero.  
   - All Rights Reserved.
   -
   - Contributor(s): Tommaso Beniero <tommaso DOT beniero AT gmail DOT com>
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - 
***** END LICENSE BLOCK *****/

var completeMenu = new Array(
	"divisor",
    "open_with_pttl",
    "save_with_pttl",
    "add_bookmark",
    "send_email_to",
    "send_text_in_email",
    "search_google_groups_window",
    "search_google_groups_tab",
    "translate",
    "save",
    "append",
    "pttl_menu",
    "pttl_menupopup",
    "open_here",
    "open_window",
    "open_tab",
    "add_bookmark2",
    "divisor1",
    "send_email_to2",
    "send_text_in_email2",
    "divisor2",
    "search_google_groups_window2",
    "search_google_groups_tab2",
    "divisor3",
    "translate2",
    "divisor4",
    "save2",
    "append2"
    );
var pttl_prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("pttl.");  
var fileSavedPath;
var menuPrefArray;
var saveUseUTF8;
var strings;

// initialize function

function init() {
	
    var menu = document.getElementById("contentAreaContextMenu");
    strings = document.getElementById("pttlStrings");

    if(!pttl_prefs.prefHasUserValue("open-type")) pttl_prefs.setIntPref("open-type",0);
	if(!pttl_prefs.prefHasUserValue("save-directory-default")) pttl_prefs.setCharPref("save-directory-default","");
    if(!pttl_prefs.prefHasUserValue("save-extension-default")) pttl_prefs.setCharPref("save-extension-default",".txt");
    if(!pttl_prefs.prefHasUserValue("save-with-UTF8")) pttl_prefs.setBoolPref("save-with-UTF8",false);
    if(!pttl_prefs.prefHasUserValue("menu-def-open")) pttl_prefs.setBoolPref("menu-def-open",true);
    if(!pttl_prefs.prefHasUserValue("menu-def-save")) pttl_prefs.setBoolPref("menu-def-save",true);
    if(!pttl_prefs.prefHasUserValue("menu-add-bookmark")) pttl_prefs.setBoolPref("menu-add-bookmark",false);
    if(!pttl_prefs.prefHasUserValue("menu-send-mail-to")) pttl_prefs.setBoolPref("menu-send-mail-to",false);
    if(!pttl_prefs.prefHasUserValue("menu-send-text-to")) pttl_prefs.setBoolPref("menu-send-text-to",false);
    if(!pttl_prefs.prefHasUserValue("menu-search-groups-win")) pttl_prefs.setBoolPref("menu-search-groups-win",false);
    if(!pttl_prefs.prefHasUserValue("menu-search-groups-tab")) pttl_prefs.setBoolPref("menu-search-groups-tab",false);
    if(!pttl_prefs.prefHasUserValue("menu-translate")) pttl_prefs.setBoolPref("menu-translate",false);
    if(!pttl_prefs.prefHasUserValue("menu-save-in-file")) pttl_prefs.setBoolPref("menu-save-in-file",false);
    if(!pttl_prefs.prefHasUserValue("menu-append")) pttl_prefs.setBoolPref("menu-append",false);
    if(!pttl_prefs.prefHasUserValue("menu-complete-menu")) pttl_prefs.setBoolPref("menu-complete-menu",true);
    
    var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
    observerService.addObserver(pttlSliderClickObserver, "alertclickcallback", false);
    menu.addEventListener("popupshowing",verSelText,false);  

}

// Definition of the slider text click observer

var pttlSliderClickObserver = {
	
	observe: function (subject, topic, state){
    	var n = pttl_prefs.getIntPref("open-type");    
    	if (topic == "alertclickcallback"){ 
     	openUrl(n,fileSavedPath);
		}		
    }
}

// show a slider pane with the string msg

function pttlSlider(msg) {
	
	try {
     var alertService = Components.classes["@mozilla.org/alerts-service;1"].getService(Components.interfaces.nsIAlertsService);
		alertService.showAlertNotification("chrome://pttl/skin/pttl.png", "Plain Text To Link", msg, true, "", pttlSliderClickObserver);
	} catch (ex) {}
    
}

// show options in Tools menu

function showPttlOptionDialog() {

	window.openDialog("chrome://pttl/content/pttlOptions.xul", "pttl-dialog", "centerscreen,chrome,modal", "add");
    
}

// show warning for sendTextInEmail() function

function saveWarning() {
	
	if (pttl_prefs.getCharPref("save-directory-default").length == 0) {
    	window.openDialog("chrome://pttl/content/pttlSaveWarning.xul", "pttl-dialog", "centerscreen,chrome,modal", "add");
     return false;
    }
    else return true;
    
}

// it allows to obtain a string representing the selected text on the screen

function getString() {
    
    var hlText = "";

	var focusedWindow = document.commandDispatcher.focusedWindow;
	hlText = focusedWindow.getSelection.call(focusedWindow);
   	hlText = hlText.toString();
	hlText = manipulateString(hlText);
    return hlText;

}

// it checks whether there's selected text or not. If it's true, the menu appears, otherwise it doesn't	

function verSelText() {

	var isTextSelection = false;
    var menuitem;
    menuPrefArray = new Array(
    	pttl_prefs.getBoolPref("menu-def-open"),
    	pttl_prefs.getBoolPref("menu-def-save"),
    	pttl_prefs.getBoolPref("menu-add-bookmark"),
    	pttl_prefs.getBoolPref("menu-send-mail-to"),
    	pttl_prefs.getBoolPref("menu-send-text-to"),
    	pttl_prefs.getBoolPref("menu-search-groups-win"),
    	pttl_prefs.getBoolPref("menu-search-groups-tab"),
    	pttl_prefs.getBoolPref("menu-translate"),
    	pttl_prefs.getBoolPref("menu-save-in-file"),
    	pttl_prefs.getBoolPref("menu-append"),
		pttl_prefs.getBoolPref("menu-complete-menu")
    );
    
	if(gContextMenu) isTextSelection = gContextMenu.isTextSelected;
    document.getElementById(completeMenu[0]).hidden = !isTextSelection;
	for(var i=1; i<12; i++) {
		menuitem = document.getElementById(completeMenu[i]);	
		if(menuitem){
     	if(isTextSelection) {
     		if(menuPrefArray[i-1]) menuitem.hidden = false;
          	else menuitem.hidden = true;
			}
          else menuitem.hidden = true;
		}
	}
    
    for(var i=12; i<completeMenu.length; i++) {
		menuitem = document.getElementById(completeMenu[i]);
		if(menuitem){
     	if(isTextSelection) {
				if(menuPrefArray[10]) menuitem.hidden = false;
          	else menuitem.hidden = true;
			}
       	else menuitem.hidden = true;
		}
	}    
	
}

// default open action

function openDefault(){
	
    var selRadio = pttl_prefs.getIntPref("open-type");
    var URLAddress = getString();
    if (URLAddress == ""){
    	return;
    }
    URLAddress = fixURL(this.unmangleURL(URLAddress));
    openUrl(selRadio, URLAddress);
    
}

// default save action

function saveDefault(){
    
    var text = getString();
   	saveUseUTF8=pttl_prefs.getBoolPref("save-with-UTF8");
    if (text == ""){
    	return;
    }
    else if(saveWarning()) {
     var stream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
     var converter = Components.classes["@mozilla.org/intl/converter-output-stream;1"].createInstance(Components.interfaces.nsIConverterOutputStream);
     var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
     var selDir = pttl_prefs.getCharPref("save-directory-default");
     var selExt = pttl_prefs.getCharPref("save-extension-default");
     var pttlDiv = getPttlDivisor();
     var fileName = getPttlTime() + selExt;
     file.initWithPath(selDir);
     file.append(fileName);
     fileSavedPath = file.path;
     
     stream.init(file, 0x02 | 0x08 | 0x20, 0664, 0);
     if(!saveUseUTF8){
         	stream.write(pttlDiv, pttlDiv.length);
          stream.write(text,text.length);
     }
     else{
          converter.init(stream, "UTF-8", 0, 0x0000);
          converter.writeString(pttlDiv);
          converter.writeString(text);  
          converter.close();
     }
     stream.close();

     pttlSlider(fileName + " - " + strings.getString("statusBarMsg"));
          
    }

    
}

// it allows to add the selected link in Firefox Bookmarks

function addBookmark() {
	
	var docTitle = document.title; 
	var URLAddress = getString();
    if (URLAddress == ""){
    	return;
    }
	var browser = getBrowser();
	URLAddress = fixURL(unmangleURL(URLAddress));		
	openDialog("chrome://browser/content/bookmarks/addBookmark.xul", "", "centerscreen,chrome,dialog=no,resizable=yes", URLAddress, URLAddress);

}

// it allows to send a email to the selected address

function sendEmailTo() {
		
	var EmailAddr=getString();
    if (EmailAddr == ""){
    	return;
    }
	var browser=getBrowser();
	EmailAddr=manipulateEmail(EmailAddr);
	browser.loadURI("mailto:"+EmailAddr);

}

// it allows to send selected text in a email

function sendTextInEmail() {
		
    var text=getString();
    if (text == ""){
    	return;
    }
    text=manipulateText(text);
	var browser=getBrowser();
	browser.loadURI("mailto:?subject=&body="+text);

}

// it allows to translate selected text from English to the locale language

function translateFromEnglish() {

	var UA = navigator.userAgent;
	var text = getString();
    if (text == ""){
    	return;
    }
	var browser=getBrowser();
	if(UA.search("en") != -1) {
		alert("This function is reserved only for non-English users");
	}
	else if(UA.search("it") != -1) {
		browser.addTab("http://babelfish.altavista.com/babelfish/tr?doit=done&urltext="+text+"&lp=en_it");
	}
	else if(UA.search("de") != -1) {
		browser.addTab("http://babelfish.altavista.com/babelfish/tr?doit=done&urltext="+text+"&lp=en_de");
	}
	else if(UA.search("es-ES") != -1) {
		browser.addTab("http://babelfish.altavista.com/babelfish/tr?doit=done&urltext="+text+"&lp=en_es");
	}
	else if(UA.search("fr") != -1) {
		browser.addTab("http://babelfish.altavista.com/babelfish/tr?doit=done&urltext="+text+"&lp=en_fr");
	}
    else if(UA.search("ru") != -1) {
		browser.addTab("http://babelfish.altavista.com/babelfish/tr?doit=done&urltext="+text+"&lp=en_ru");
	}
	else alert("Sorry, but this function is not present in your language yet.\nContact me at tommaso.beniero@gmail.com\nand if you want you can help me translating it in your language");

}

// it allows to open the selected URL

function openUrl(openTypeInt, URLAddress) {
	
	if (URLAddress == "PTTL-no-specified"){
    	URLAddress = getString();
     if (URLAddress == ""){
    		return;
    	}
     URLAddress = fixURL(this.unmangleURL(URLAddress));
    }
    
    switch(openTypeInt) {
		// open the selected URL in the current window
    	case 0:	{
			getBrowser().loadURI(URLAddress);
			break;
			}
		// open the selected URL in a new window
		case 1:	{
			window.open(URLAddress);
			break;
			}
		// open the selected URL in a new unselected tab
		case 2:	{
			getBrowser().addTab(URLAddress);
			break;
			}
     // open the selected URL in a new selected tab
		case 3:	{
			var tab = getBrowser().addTab(URLAddress);
			getBrowser().selectedTab=tab;
			break;
			}
	
	}

}

// it allows to search the selected text in Google Groups

function searchGoogleGroups(n) {

	var searchText = getString();
    if (searchText == ""){
    	return;
    }
	switch(n) {
		case 0:	{
			window.open("http://groups.google.com/groups?q="+searchText);		
			break;
		}
		case 1:	{
			var browser=getBrowser();
			browser.addTab("http://groups.google.com/groups?q="+searchText);
			break;
		}
	}

}

// it allows to save selected text to a file

function pttlSave() {
	 
	var text = getString();
    saveUseUTF8=pttl_prefs.getBoolPref("save-with-UTF8");
    if (text == ""){
    	return;
    }
	var filePick = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
	var stream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
	var converter = Components.classes["@mozilla.org/intl/converter-output-stream;1"].createInstance(Components.interfaces.nsIConverterOutputStream);
    var winTitle = strings.getString("saveWinTitle");
    var pttlDiv = getPttlDivisor();
    
    filePick.init(window, winTitle, filePick.modeSave);
	filePick.appendFilters(filePick.filterText);

	if (filePick.show() != filePick.returnCancel) {
		if (filePick.file.exists()) filePick.file.remove(true);
		filePick.file.create(filePick.file.NORMAL_FILE_TYPE, 0666);
     
     fileSavedPath = filePick.file.path;

     stream.init(filePick.file, 0x02 | 0x08 | 0x20, 0664, 0);
     if(!saveUseUTF8){
         	stream.write(pttlDiv, pttlDiv.length);
          stream.write(text,text.length);
     }
     else{
          converter.init(stream, "UTF-8", 0, 0x0000);
          converter.writeString(pttlDiv);
          converter.writeString(text);  
          converter.close();
     }
		stream.close();
        
		pttlSlider(getPttlFileName(filePick.file.path) + " - " + strings.getString("statusBarMsg"));
    
	}
    
}

// it allows to append selected text to a previous PTTL file saved

function pttlAppend() {
	
    saveUseUTF8=pttl_prefs.getBoolPref("save-with-UTF8");
    var UA = navigator.userAgent;
	var filePick = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
	var stream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
	var converter = Components.classes["@mozilla.org/intl/converter-output-stream;1"].createInstance(Components.interfaces.nsIConverterOutputStream);
    var winTitle = strings.getString("appendWinTitle");
	var text = getString();
    if (text == ""){
    	return;
    }
    var pttlDiv = getPttlDivisor();
	
	filePick.init(window, winTitle, filePick.modeOpen);
	filePick.appendFilters(filePick.filterText);

	if (filePick.show() != filePick.returnCancel) {
     
     fileSavedPath = "file:///" + filePick.file.path;

   	 stream.init(filePick.file, 0x02 | 0x10, 0664, 0);
     if(!saveUseUTF8){
			var preText="\u000D\u000A\u000D\u000A\u000D\u000A"+pttlDiv;
          stream.write(preText,preText.length);         	
          stream.write(text,text.length);
     }
     else{
          converter.init(stream, "UTF-8", 0, 0x0000);
          converter.writeString("\u000D\u000A\u000D\u000A\u000D\u000A"+pttlDiv);
          converter.writeString(text);  
          converter.close();
     }
     stream.close();
     
     pttlSlider(getPttlFileName(filePick.file.path) + " - Append ok");
		
	}
	
}

// it removes the observer at the extension unload

function unloadObserver(){

	var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
	observerService.removeObserver(pttlSliderClickObserver, "alertclickcallback");

}

window.addEventListener("load", init, false);
window.addEventListener("unload",unloadObserver,false);