/***** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Original Code is "Plain Text To Link".
   -
   - The Initial Developer of the Original Code is Tommaso Beniero.
   - Portions created by the Initial Developer are Copyright (C) 2005 Tommaso Beniero.  
   - All Rights Reserved.
   -
   - Contributor(s): Tommaso Beniero <tommaso DOT beniero AT gmail DOT com>
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - 
***** END LICENSE BLOCK *****/

/* Thanks to Ted Mielczarek for the functions unmangleURL and fixURL

/*
 * Copyright (c) 2001-2002  Ted Mielczarek
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// it allows to eliminate all the unuseful charachters from the URL

function unmangleURL(url) {
	
	// eliminate all the white spaces in the URL
	while (url.indexOf(" ") != -1) {
		url = url.replace(" ",""); 		
	}
    // eliminate all the non-alphabetical characters at the beginning of the URL
	// example: [www.example.com --> www.example.com
	url = url.replace(/^[^a-zA-Z]+/, "");
	// eliminate unuseful characters the end of the URL
	// example: www.example.com] --> www.example.com
    url = url.replace(/[\.,\'\"\)\?!>\]]+$/, "");
    return url;
	
}

// it allows to correct the initial part of an URL  	

function fixURL(url) {
    if(url.search(/(^\w+:\/\/)/) == -1) url = "http://" + url;
    if(url.search(/(^h.+p:\/\/)/) != -1) url = url.replace(/(^h.+p:\/\/)/, "http://");
    if(url.search(/(^f.+p:\/\/)/) != -1) url = url.replace(/(^f.+p:\/\/)/, "ftp://");
    return url;
  
}

// it allows to manipulate the email address

function manipulateEmail(addr) {

	if (addr.indexOf("@") == -1) {   
		addr = addr.replace(/^\s*(.*)/, "$1");
		addr = addr.replace(/\s*\ at\ \s*/gi, "@");
		addr = addr.replace(/\s*\ dot\ \s*/gi, ".");
	}
	while (addr.indexOf(" ") != -1) {
		addr = addr.replace(" ","");
	}
	return addr;
	
}

// it allows to remove white spaces before and after the selected text

function manipulateString(text) {
	
	var l = text.length;
    if (l==0) return "";
	while(text[0] == " ") {
		text = text.slice(1,l);
	}
    l = text.length;
	while(text[l-1] == " ") { 
		text = text.slice(0,l-1);
 		l = text.length;
	}
	return text;

}

// it allows to correct some special characters in the selected text that may 
// cause some problems

function manipulateText(text) {
	
	while(text.indexOf("\n") != -1){
     text = text.replace("\n","\%0D\%0A");
    }
    
    while(text.indexOf(" ") != -1){
     text = text.replace(" ","%20");
    }
    
	return text;

}

// it returns the string "[PTTL]+the actual date and time" for saved files names

function getPttlTime() {
	
	var now = new Date();
    var thisYear = now.getFullYear();
    var thisMonth = now.getMonth()+1;
    var thisDate = now.getDate();
    var thisHours = now.getHours();
    var thisMinutes = now.getMinutes();
    var thisSeconds = now.getSeconds();
    var thisMillis = now.getMilliseconds(); 
	var thisTime = new Array(thisYear,thisMonth,thisDate,thisHours,thisMinutes,thisSeconds,thisMillis);
    var pttlTime = "[PTTL]";
    for (var i=0;i<7;i++) {
    	if (thisTime[i]<10) thisTime[i]="0"+thisTime[i];
     pttlTime = pttlTime + thisTime[i];
     if (i==2) pttlTime = pttlTime + "-";
    }
    return pttlTime;
    
}

// it returns a divisor containing date and time

function getPttlDivisor() {
	
	var now = new Date();
    var thisYear = now.getFullYear();
    var thisMonth = now.getMonth()+1;
    var thisDate = now.getDate();
    var thisHours = now.getHours();
    var thisMinutes = now.getMinutes();
    var thisSeconds = now.getSeconds(); 
	var thisTime = new Array(thisYear,thisMonth,thisDate,thisHours,thisMinutes,thisSeconds);
    var webNav = getBrowser().webNavigation;
    var pttlTimeDiv = "";
    var winTitle = webNav.document.title;
    var winURL = webNav.currentURI.spec;
    for (var i=0;i<6;i++) {
    	if (thisTime[i]<10) thisTime[i]="0"+thisTime[i];
    }
    
    pttlTimeDiv = pttlTimeDiv + winTitle + " - (" + winURL + ")";
    
    pttlTimeDiv = pttlTimeDiv + "\u000D\u000A" + thisTime[0] + "/" + thisTime[1] + "/" + thisTime[2] + " " + thisTime[3] + ":" + thisTime[4] + ":" + thisTime[5];
    
    pttlTimeDiv = pttlTimeDiv + "\u000D\u000A" + "----------------------------------\u000D\u000A\u000D\u000A";
    
    return pttlTimeDiv;
    
}

// given a file path, it returns only the last part containing the file name + file extension

function getPttlFileName(filePath){

	var i = filePath.lastIndexOf("\\");
    var end = filePath.length;
    return filePath.slice(i+1,end); 

}